/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxObject;
import com.informix.lang.Decimal;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.JavaToIfxType;
import com.informix.util.TraceFlag;
import java.sql.SQLException;

public class IfxIntervalDF
extends IfxObject {
    private IntervalDF value = null;

    public IfxIntervalDF() throws SQLException {
        this.setIfxType(14);
    }

    IfxIntervalDF(IntervalDF DF) throws SQLException {
        this.setIfxType(14);
        this.value = DF;
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.setEncodedLength(this.value.getQualifier());
        }
    }

    public IntervalDF value() {
        return this.value;
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxInterval(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            return JavaToIfxType.JavaToIfxDecimalNull((short)this.encodedLength);
        }
        byte[] b = JavaToIfxType.JavaToIfxInterval(this.value);
        return Decimal.fromBindToTuple(b, IfxDecimal.decLength(this.encodedLength));
    }

    @Override
    public void fromIfx(byte[] b, short prec) throws SQLException {
        this.fromIfx(b, 0, b.length, prec);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length, short prec) throws SQLException {
        this.value = (IntervalDF)IfxToJavaType.IfxToJavaInterval(b, offset, length, prec);
        if (this.value == null) {
            this.nullify();
        } else {
            this.unnullify();
            this.value.setQualifier((short)this.encodedLength);
        }
    }

    @Override
    public String toString() {
        if (this.isNull() || this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxIntervalDF.fromString(): entered");
        }
        if (str == null) {
            this.nullify();
            this.value = null;
            return;
        }
        if (this.value == null) {
            this.value = new IntervalDF();
            this.value.setQualifier(super.getEncodedLength());
        }
        this.value.fromString(str);
        this.unnullify();
        if (TraceFlag.isTraceEnabled()) {
            this.writeTrace(1, "IfxIntervalDF.fromString(): exited");
        }
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public Interval toInterval() throws SQLException {
        return this.toIntervalDF();
    }

    @Override
    public IntervalDF toIntervalDF() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    @Override
    public void fromIntervalDF(IntervalDF DF) throws SQLException {
        if (DF == null) {
            this.nullify();
        } else {
            this.value = DF;
            this.unnullify();
        }
    }

    @Override
    public short getEncodedLength() {
        if (this.value == null) {
            return (short)this.encodedLength;
        }
        return this.value.getQualifier();
    }

    @Override
    public String toUnloadString() {
        return this.toString();
    }
}

