/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.types.bson;

import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.types.bson.DBBson;
import org.bson.BsonReader;
import org.bson.Document;
import org.bson.RawBsonDocument;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.json.IfxDocumentCodec;
import org.bson.json.IfxJsonReader;

public class BsonBuilder {
    private static final ThreadLocal<DocumentCodec> CODEC = ThreadLocal.withInitial(() -> new IfxDocumentCodec(IfxBSONObject.REGISTRY));

    private BsonBuilder() {
    }

    public static DBBson parse(String json) {
        IfxJsonReader bsonReader = new IfxJsonReader(json);
        return new IfxBSONObject(CODEC.get().decode((BsonReader)bsonReader, DecoderContext.builder().build()));
    }

    public static DBBson fromBytes(byte[] bytes) {
        return new IfxBSONObject(bytes);
    }

    public static DBBson fromDocument(Document d) {
        return new IfxBSONObject(d);
    }

    public static DBBson fromRawDocument(RawBsonDocument rawDoc) {
        return new IfxBSONObject(rawDoc);
    }

    public static DBBson newDocument() {
        return new IfxBSONObject();
    }
}

