/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.udt.timeseries.IfmxCalendarPattern;
import com.informix.jdbc.udt.timeseries.IfmxCalendarUDT;
import com.informix.jdbc.udt.timeseries.IfxCalendar;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;

public class IfmxCalendar
implements IfmxCalendarUDT,
SQLData {
    private static final String SQL_TYPE_NAME = "calendar";
    private String name = null;
    private int length = 0;
    private IfxCalendar startDate = null;
    private IfxCalendar patternStartDate = null;
    private int flags = 0x1000000;
    private int offset = 0;
    private int id = Integer.MIN_VALUE;
    private int referenceCount = 0;
    private IfmxCalendarPattern pattern;
    private static final String TRANSIENT_FIELDS_SQL = "SELECT c_version, c_calendar, c_id, c_refcount FROM calendartable WHERE c_name = ?";
    private static final String CALENDAR_INSERT = "INSERT INTO calendartable(c_name,c_calendar) VALUES (?,?)";
    private static final String CALENDAR_DELETE_BY_ID = "DELETE FROM calendartable WHERE c_id = ?";
    private static final String CALENDAR_DELETE_BY_NAME = "DELETE FROM calendartable WHERE c_name = ?";
    private static final String CALENDAR_QUERY_BY_NAME = "SELECT c_version, c_id, c_refcount, c_calendar FROM calendartable WHERE c_name = ?";
    private static final String CALENDAR_QUERY = "SELECT c_version, c_id, c_name, c_refcount, c_calendar FROM calendartable";

    public IfmxCalendar() {
    }

    public IfmxCalendar(String name, Timestamp calendarStart, Timestamp patternStart, String pattern) throws SQLException {
        this.pattern = new IfmxCalendarPattern(pattern);
        this.initCalendar(name, calendarStart, patternStart);
    }

    public IfmxCalendar(String name, Timestamp calendarStart, Timestamp patternStart, IfmxCalendarPattern pattern) throws SQLException {
        this.pattern = pattern;
        this.initCalendar(name, calendarStart, patternStart);
    }

    public IfmxCalendar(String name, String calendar) throws SQLException {
        int firstComma = calendar.indexOf(44);
        String calendarStartString = calendar.substring(0, firstComma);
        int secondComma = calendar.indexOf(44, firstComma + 1);
        String patternStartString = calendar.substring(firstComma + 1, secondComma);
        String patternString = calendar.substring(secondComma + 1);
        Timestamp calendarStart = IfmxCalendar.getTimestamp(calendarStartString);
        Timestamp patternStart = IfmxCalendar.getTimestamp(patternStartString);
        this.pattern = new IfmxCalendarPattern(IfmxCalendar.getStringBetweenParenthesis(patternString));
        this.initCalendar(name, calendarStart, patternStart);
    }

    private static final String getStringBetweenParenthesis(String input) {
        int startParenthesis = input.indexOf(40);
        int endParenthesis = input.lastIndexOf(41);
        String substring = input.substring(startParenthesis + 1, endParenthesis);
        return substring;
    }

    private static Timestamp getTimestamp(String calendarSubstring) {
        return Timestamp.valueOf(IfmxCalendar.getStringBetweenParenthesis(calendarSubstring));
    }

    IfmxCalendar(IfmxUDTSQLInput stream, int cVarLength) throws SQLException {
        this.readFromStream(stream);
        this.name = stream.readString(cVarLength - this.length - 4);
    }

    public static final Builder builder() {
        return new Builder();
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return SQL_TYPE_NAME;
    }

    public String getName() throws SQLException {
        return this.name;
    }

    public Timestamp getStartDate() throws SQLException {
        if (this.startDate == null) {
            throw new SQLException("Calendar start date not set!");
        }
        return this.startDate.getTimestamp();
    }

    public Timestamp getPatStartDate() throws SQLException {
        if (this.patternStartDate == null) {
            throw new SQLException("Pattern start date not set!");
        }
        return this.patternStartDate.getTimestamp();
    }

    public int getId() {
        return this.id;
    }

    protected void setId(int newId) {
        this.id = newId;
    }

    public void setTransientFields(Connection connection) throws SQLException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(TRANSIENT_FIELDS_SQL);){
            preparedStatement.setString(1, this.name);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    int version = resultSet.getInt(1);
                    if (version != 0) {
                        throw new SQLException("Unable to read a calendar that is not version 0");
                    }
                    IfmxCalendar otherCalendar = (IfmxCalendar)resultSet.getObject(2);
                    if (this.equals(otherCalendar, true, true, true)) {
                        this.id = resultSet.getInt(3);
                        this.referenceCount = resultSet.getInt(4);
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new SQLException(MessageFormat.format("Unable to get calendar {0}", this.name), e);
        }
    }

    public int getReferenceCount() {
        return this.referenceCount;
    }

    protected void setReferenceCount(int newReferenceCount) {
        this.referenceCount = newReferenceCount;
    }

    public IfmxCalendarPattern getPattern() throws SQLException {
        if (this.pattern == null) {
            throw new SQLException("Pattern not set!");
        }
        return this.pattern;
    }

    @Override
    public void readSQL(SQLInput stream, String type) throws SQLException {
        this.readFromStream((IfmxUDTSQLInput)stream);
    }

    @Override
    public void writeSQL(SQLOutput stream) throws SQLException {
        this.writeToStream((IfmxUDTSQLOutput)stream);
    }

    public String toCalendarString() {
        StringBuilder sb = new StringBuilder();
        sb.append("startdate(" + this.startDate.getTimestamp() + "), ");
        sb.append("pattstart(" + this.patternStartDate.getTimestamp() + "), ");
        sb.append("pattern(" + this.pattern.toString() + ")");
        return sb.toString();
    }

    public Timestamp getTimestampFromOffset(int offset, int tsOffset) throws SQLException {
        int onOffCnt;
        int i;
        int adjust;
        int extra;
        IfxCalendar returnVal = new IfxCalendar(this.startDate.getTimestamp());
        if (offset == 0) {
            if (tsOffset == 0) {
                return this.startDate.getTimestamp();
            }
            returnVal.addCalPatInterval(this.pattern.getIntervalTypeId(), tsOffset);
            if (this.pattern.getIntervalTypeId() > 50) {
                Timestamp newStamp = new Timestamp(returnVal.getTimeInMillis());
                return newStamp;
            }
            Timestamp newStamp = this.startDate.get(16) == 0 ? new Timestamp(returnVal.getTimeInMillis() - (long)returnVal.get(16)) : (returnVal.get(16) == 0 ? new Timestamp(returnVal.getTimeInMillis() + (long)this.startDate.get(16)) : new Timestamp(returnVal.getTimeInMillis()));
            return newStamp;
        }
        int calOffset = this.pattern.getTotalDuration() - this.offset;
        if (tsOffset >= calOffset) {
            extra = (tsOffset - calOffset) % this.pattern.getTotalDuration();
            tsOffset -= extra;
            adjust = 0;
        } else {
            extra = (calOffset - tsOffset) % this.pattern.getTotalDuration();
            if (extra != 0) {
                extra = this.pattern.getTotalDuration() - extra;
            }
            adjust = tsOffset < 0 ? tsOffset - extra : calOffset - this.pattern.getTotalDuration();
            tsOffset = 0;
        }
        int non = 0;
        for (i = 0; i < this.pattern.getNumberOfIntervals(); ++i) {
            onOffCnt = this.pattern.getValMask(i);
            if (!this.pattern.isOn(i)) {
                if (onOffCnt >= extra) break;
                extra -= onOffCnt;
                continue;
            }
            if (onOffCnt < extra) {
                non += onOffCnt;
                extra -= onOffCnt;
                continue;
            }
            non += extra;
            break;
        }
        if ((offset += non) >= 0) {
            int intervals = tsOffset + offset / this.pattern.getOnDuration() * this.pattern.getTotalDuration();
            extra = offset % this.pattern.getOnDuration() + 1;
            for (i = 0; i < this.pattern.getNumberOfIntervals(); ++i) {
                onOffCnt = this.pattern.getValMask(i);
                if (!this.pattern.isOn(i)) {
                    intervals += onOffCnt;
                    continue;
                }
                if (onOffCnt < extra) {
                    intervals += onOffCnt;
                    extra -= onOffCnt;
                    continue;
                }
                intervals += extra;
                break;
            }
            int newOffset = intervals - 1 + adjust;
            returnVal.addCalPatInterval(this.pattern.getIntervalTypeId(), newOffset);
        }
        Timestamp newStamp = this.startDate.get(16) == 0 ? new Timestamp(returnVal.getTimeInMillis() - (long)returnVal.get(16)) : (returnVal.get(16) == 0 ? new Timestamp(returnVal.getTimeInMillis() + (long)this.startDate.get(16)) : new Timestamp(returnVal.getTimeInMillis()));
        return newStamp;
    }

    public int getOffsetFromTimestamp(Timestamp timestamp, int tsOrigin) throws SQLException {
        int onOffCnt;
        int i;
        IfxCalendar queryDate = new IfxCalendar(timestamp);
        int calOffset = this.pattern.getTotalDuration() - this.offset;
        int intervalDiff = queryDate.getDifference(this.startDate, this.pattern.getIntervalTypeId());
        if (intervalDiff < tsOrigin) {
            return 0;
        }
        int patLength = this.pattern.getNumberOfIntervals();
        int tsIntervals = tsOrigin > 0 ? (tsOrigin > this.offset ? (tsOrigin - this.offset) % this.pattern.getTotalDuration() : this.pattern.getTotalDuration() - (this.offset - tsOrigin)) : this.pattern.getTotalDuration() - (calOffset - tsOrigin) % this.pattern.getTotalDuration();
        if (tsIntervals == this.pattern.getTotalDuration()) {
            tsIntervals = 0;
        }
        int count = tsIntervals;
        int tsOriginNotOn = 0;
        for (i = 0; i < patLength; ++i) {
            onOffCnt = this.pattern.getValMask(i);
            if (count <= onOffCnt) {
                if (!this.pattern.isOn(i)) break;
                tsOriginNotOn += count;
                break;
            }
            if (this.pattern.isOn(i)) {
                tsOriginNotOn += onOffCnt;
            }
            count -= onOffCnt;
        }
        intervalDiff -= tsOrigin;
        int numOnPeriods = (intervalDiff += tsIntervals) / this.pattern.getTotalDuration() * this.pattern.getOnDuration();
        int extraOnPeriod = intervalDiff % this.pattern.getTotalDuration();
        for (i = 0; i < patLength; ++i) {
            onOffCnt = this.pattern.getValMask(i);
            if (extraOnPeriod + 1 <= onOffCnt) {
                if (!this.pattern.isOn(i)) continue;
                numOnPeriods += extraOnPeriod;
                continue;
            }
            if (this.pattern.isOn(i)) {
                numOnPeriods += onOffCnt;
            }
            extraOnPeriod -= onOffCnt;
        }
        return numOnPeriods - tsOriginNotOn;
    }

    private void readFromStream(IfmxUDTSQLInput stream) throws SQLException {
        this.length = stream.readInt();
        this.startDate = new IfxCalendar(stream.readTimestamp());
        this.flags = stream.readInt();
        this.offset = stream.readInt();
        this.pattern = new IfmxCalendarPattern(stream);
        this.patternStartDate = (IfxCalendar)this.startDate.clone();
    }

    private void writeToStream(IfmxUDTSQLOutput stream) throws SQLException {
        stream.writeInt(this.length);
        stream.writeTimestamp(this.startDate.getTimestamp());
        stream.writeInt(this.flags);
        stream.writeInt(this.offset);
        this.pattern.writeSQL(stream);
    }

    private void initCalendar(String calName, Timestamp calStart, Timestamp patStart) throws SQLException {
        this.startDate = new IfxCalendar(calStart);
        this.patternStartDate = new IfxCalendar(patStart);
        this.length = 36 + this.pattern.getLength();
        this.name = calName;
        this.setId(-1);
        if (this.startDate.after(this.patternStartDate)) {
            throw new SQLException("The calendar pattern start date is before the calendar start date");
        }
        int diff = this.patternStartDate.getDifference(this.startDate, this.pattern.getIntervalTypeId());
        if (diff > this.pattern.getTotalDuration()) {
            throw new SQLException("The calendar pattern start date is too far away from the calendar start");
        }
        this.offset = this.pattern.getTotalDuration() - diff;
    }

    /*
     * Exception decompiling
     */
    public static IfmxCalendar getCalendar(Connection connection, int id) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int create(Connection connection) throws SQLException {
        if (this.name == null) {
            throw new SQLException("The calendar name must not be null");
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(CALENDAR_INSERT);){
            preparedStatement.setString(1, this.name);
            preparedStatement.setObject(2, this);
            preparedStatement.execute();
            int n = this.id = ((IfxPreparedStatement)preparedStatement).getSerial();
            return n;
        }
        catch (SQLException e) {
            throw new SQLException(MessageFormat.format("Unable to create calendar {0} {1}", this.name, this.toString()), e);
        }
    }

    public boolean delete(Connection connection) throws SQLException {
        if (this.name == null || this.name.trim().length() == 0) {
            throw new SQLException("The calendar name must be specified when deleting it from a database");
        }
        return IfmxCalendar.delete(connection, this.name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean delete(Connection connection, int id) throws SQLException {
        if (id <= 0) {
            throw new SQLException("The calendar id must be greater than zero");
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(CALENDAR_DELETE_BY_ID);){
            preparedStatement.setInt(1, id);
            preparedStatement.execute();
            boolean bl = preparedStatement.getUpdateCount() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new SQLException(MessageFormat.format("Unable to delete calendar with id {0}", id), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean delete(Connection connection, String name) throws SQLException {
        if (name == null) {
            throw new SQLException("The calendar name must not be null");
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(CALENDAR_DELETE_BY_NAME);){
            preparedStatement.setString(1, name);
            preparedStatement.execute();
            boolean bl = preparedStatement.getUpdateCount() > 0;
            return bl;
        }
        catch (SQLException e) {
            throw new SQLException(MessageFormat.format("Unable to delete calendar with name {0}", name), e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteAll(Connection connection, boolean ignoreErrorsForReferenced) throws SQLException {
        block30: {
            sql = ignoreErrorsForReferenced != false ? "SELECT * FROM calendartable WHERE c_refcount = 0" : "SELECT * FROM calendartable";
            modified = false;
            try {
                preparedStatement = connection.prepareStatement(sql, 1003, 1008);
                var5_6 = null;
                try {
                    resultSet = preparedStatement.executeQuery();
                    var7_10 = null;
                    ** try [egrp 2[TRYBLOCK] [2, 3 : 45->88)] { 
lbl10:
                    // 1 sources

                    break block30;
lbl11:
                    // 1 sources

                    catch (Throwable var8_14) {
                        var7_10 = var8_14;
                        throw var8_14;
                    }
                }
                catch (Throwable var6_9) {
                    var5_6 = var6_9;
                    throw var6_9;
                }
            }
            catch (SQLException e) {
                throw new SQLException("Unable to delete all calendars", e);
            }
        }
        while (resultSet.next() != false) {
            try {
                resultSet.deleteRow();
                modified |= true;
            }
            catch (SQLException e) {
                if (e.getErrorCode() != -937) throw e;
            }
        }
        return modified;
lbl29:
        // 1 sources

        finally {
            if (resultSet != null) {
                if (var7_10 != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable var8_13) {
                        var7_10.addSuppressed(var8_13);
                    }
                } else {
                    resultSet.close();
                }
            }
        }
        finally {
            if (preparedStatement != null) {
                if (var5_6 != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (Throwable var7_11) {
                        var5_6.addSuppressed(var7_11);
                    }
                } else {
                    preparedStatement.close();
                }
            }
        }
    }

    public boolean exists(Connection connection) throws SQLException {
        try {
            IfmxCalendar other = IfmxCalendar.getCalendar(connection, this.getName());
            if (other == null) {
                other = IfmxCalendar.getCalendar(connection, this.getId());
            }
            return this.equals(other, false, true, false);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -206) {
                return false;
            }
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    public static IfmxCalendar getCalendar(Connection connection, String name) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Set<IfmxCalendar> getCalendars(Connection connection) throws SQLException {
        HashSet<IfmxCalendar> calendars = new HashSet<IfmxCalendar>();
        try (PreparedStatement pstmt = connection.prepareStatement(CALENDAR_QUERY);
             ResultSet resultSet = pstmt.executeQuery();){
            while (resultSet.next()) {
                int version = resultSet.getInt(1);
                if (version != 0) {
                    throw new SQLException("Unable to read a calendar that is not version 0");
                }
                int id = resultSet.getInt(2);
                String name = resultSet.getString(3);
                int referenceCount = resultSet.getInt(4);
                IfmxCalendar calendar = resultSet.getObject(5, IfmxCalendar.class);
                calendar.setId(id);
                calendar.setReferenceCount(referenceCount);
                calendar.name = name;
                calendars.add(calendar);
            }
        }
        catch (SQLException e) {
            throw new SQLException("Unable to get calendars", e);
        }
        return calendars;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.flags;
        result = 31 * result + this.id;
        result = 31 * result + this.length;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + this.offset;
        result = 31 * result + (this.pattern == null ? 0 : this.pattern.hashCode());
        result = 31 * result + (this.patternStartDate == null ? 0 : this.patternStartDate.hashCode());
        result = 31 * result + this.referenceCount;
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return this.equals(obj, false, false, false);
    }

    public boolean equals(Object obj, boolean skipCalendarName, boolean skipPatternName, boolean skipId) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IfmxCalendar other = (IfmxCalendar)obj;
        if (this.flags != other.flags) {
            return false;
        }
        if (!skipId && this.id != other.id) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (!skipCalendarName && (this.name == null ? other.name != null : !this.name.equals(other.name))) {
            return false;
        }
        if (this.offset != other.offset) {
            return false;
        }
        if (this.pattern == null ? other.pattern != null : !this.pattern.equals(other.pattern, skipPatternName)) {
            return false;
        }
        if (this.patternStartDate == null ? other.patternStartDate != null : !this.patternStartDate.equals(other.patternStartDate)) {
            return false;
        }
        if (this.referenceCount != other.referenceCount) {
            return false;
        }
        return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("IfmxCalendar [name=");
        builder2.append(this.name);
        builder2.append(", id=");
        builder2.append(this.id);
        builder2.append(", referenceCount=");
        builder2.append(this.referenceCount);
        builder2.append(", startDate=");
        builder2.append(this.startDate);
        builder2.append(", patternStartDate=");
        builder2.append(this.patternStartDate);
        builder2.append(", pattern=");
        builder2.append(this.pattern);
        builder2.append(", flags=");
        builder2.append(this.flags);
        builder2.append(", length=");
        builder2.append(this.length);
        builder2.append(", offset=");
        builder2.append(this.offset);
        builder2.append(']');
        return builder2.toString();
    }

    public IfxBSONObject toBson() {
        IfxBSONObject bson = new IfxBSONObject("name", this.name);
        if (this.startDate != null) {
            bson.append("startDate", this.startDate.getTime());
        }
        if (this.patternStartDate != null) {
            bson.append("patternStartDate", this.patternStartDate.getTime());
        }
        if (this.pattern != null) {
            bson.append("pattern", this.pattern.toBson());
        }
        return bson;
    }

    public static final class Builder {
        private String name = null;
        private Timestamp calendarStart = null;
        private Timestamp patternStart = null;
        private int id = 0;
        private IfmxCalendarPattern pattern = null;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder calendarStart(Timestamp calendarStart) {
            this.calendarStart = calendarStart;
            return this;
        }

        public Builder patternStart(Timestamp patternStart) {
            this.patternStart = patternStart;
            return this;
        }

        public Builder id(int id) {
            this.id = id;
            return this;
        }

        public Builder pattern(IfmxCalendarPattern pattern) {
            this.pattern = pattern;
            return this;
        }

        public void verify() {
            if (this.name == null) {
                throw new IllegalArgumentException("The calendar name must not be null");
            }
            if (this.calendarStart == null) {
                throw new IllegalArgumentException("The calendar start must not be null");
            }
            if (this.pattern == null) {
                throw new IllegalArgumentException("The calendar pattern must not be null");
            }
        }

        public IfmxCalendar build() throws SQLException {
            this.verify();
            IfmxCalendar result = new IfmxCalendar();
            result.id = this.id;
            result.name = this.name;
            result.pattern = this.pattern;
            if (this.patternStart == null) {
                result.initCalendar(this.name, this.calendarStart, this.calendarStart);
            } else {
                result.initCalendar(this.name, this.calendarStart, this.patternStart);
            }
            return result;
        }
    }
}

