/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries;

import com.informix.jdbc.udt.timeseries.TimeSeriesRowType;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.List;
import java.util.Map;

public class IfxTSGenericRow
implements Struct {
    private final TimeSeriesRowType rowType;
    private final String sqlTypeName;
    private final Object[] attributes;

    public IfxTSGenericRow(String rowTypeName, Object[] values) {
        if (rowTypeName == null) {
            throw new NullPointerException("the row type name must not be null");
        }
        if (values == null) {
            throw new NullPointerException("the row type values must not be null");
        }
        this.rowType = null;
        this.sqlTypeName = rowTypeName;
        this.attributes = new Object[values.length];
        System.arraycopy(values, 0, this.attributes, 0, values.length);
    }

    IfxTSGenericRow(TimeSeriesRowType rowType, Object[] values) {
        this.rowType = rowType;
        this.sqlTypeName = rowType.getName();
        this.attributes = new Object[values.length];
        System.arraycopy(values, 0, this.attributes, 0, values.length);
    }

    IfxTSGenericRow(String rowTypeName, List<Object> values) {
        this.rowType = null;
        this.sqlTypeName = rowTypeName;
        this.attributes = new Object[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            this.attributes[i] = values.get(i);
        }
    }

    IfxTSGenericRow(TimeSeriesRowType rowType, List<Object> values) {
        this.rowType = rowType;
        this.sqlTypeName = rowType.getName();
        this.attributes = new Object[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            this.attributes[i] = values.get(i);
        }
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        return this.attributes;
    }

    @Override
    public String getSQLTypeName() {
        return this.sqlTypeName;
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        return this.attributes;
    }

    public String toString() {
        if (this.rowType != null) {
            return this.rowType.createRowString(this.attributes);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("ROW(");
        boolean first = true;
        for (Object element : this.attributes) {
            if (!first) {
                sb.append(',');
            }
            if (element == null) {
                sb.append("null");
            } else {
                sb.append(element.toString());
            }
            first = false;
        }
        sb.append(")::");
        sb.append(this.getSQLTypeName());
        return sb.toString();
    }
}

