/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.jdbc.types.TypeInfo;
import com.informix.jdbc.udt.timeseries.field.AbstractTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.BigIntTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.BooleanTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.BsonTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.ByteTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.DateTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.DecimalTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.FloatTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.Int8TimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.IntTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.IntervalTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.SmallFloatTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.SmallIntTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.TimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.TimeTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.TimestampTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.VarcharTimeSeriesField;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TimeSeriesRowType {
    public static final TimeSeriesRowType STANDARD_TYPE = new Builder().name("generic_bson_t").timestampFieldName("timestamp").add(new BsonTimeSeriesField("payload")).build();
    private final String name;
    private final String timestampFieldName;
    private final List<TimeSeriesField<?>> fields = new ArrayList();
    private int extendedId = 0;

    private TimeSeriesRowType(String name, String timestampFieldName, List<TimeSeriesField<?>> dataTypes) {
        this.name = name;
        this.timestampFieldName = timestampFieldName;
        this.fields.add(new TimestampTimeSeriesField(timestampFieldName));
        this.fields.addAll(dataTypes);
    }

    public String getName() {
        return this.name;
    }

    public String getTimestampFieldName() {
        return this.timestampFieldName;
    }

    int getExtendedId() {
        return this.extendedId;
    }

    public TimeSeriesField<?> getField(int fieldIndex) {
        if (fieldIndex == 0 || fieldIndex > this.fields.size()) {
            throw new IndexOutOfBoundsException(MessageFormat.format("the field index, {0}, must be in the range [1,{1}]", fieldIndex, this.fields.size()));
        }
        return this.fields.get(fieldIndex - 1);
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public boolean create(Connection connection) throws SQLException {
        String sql = "create row type " + this.toInformixString();
        try (Statement statement = connection.createStatement();){
            boolean bl = statement.executeUpdate(sql) > 0;
            return bl;
        }
    }

    public boolean delete(Connection connection) throws SQLException {
        String sql = "drop row type " + this.getName() + " restrict";
        try (Statement statement = connection.createStatement();){
            boolean bl = statement.executeUpdate(sql) > 0;
            return bl;
        }
    }

    public boolean exists(Connection connection) throws SQLException {
        TimeSeriesRowType other = TimeSeriesRowType.get(connection, this.name);
        return this.equals(other);
    }

    public static TimeSeriesRowType get(Connection connection, String name) throws SQLException {
        IfxConnection ifxConn = TimeSeriesRowType.getIfxConnection(connection);
        IfxUDTInfo udtInfo = ifxConn.getUDTInfo(name, null);
        if (udtInfo == null) {
            return null;
        }
        IfxResultSetMetaData typeInfo = udtInfo.getMetaData();
        IfxResultSetMetaData metaData = (IfxResultSetMetaData)typeInfo.getChild(1);
        return TimeSeriesRowType.createTimeSeriesRowType(name, udtInfo, metaData);
    }

    private static IfxConnection getIfxConnection(Connection conn) throws SQLException {
        if (conn instanceof IfxConnection) {
            return (IfxConnection)conn;
        }
        if (conn.isWrapperFor(IfxConnection.class)) {
            return conn.unwrap(IfxConnection.class);
        }
        throw new IllegalArgumentException(MessageFormat.format("the connection must be an instance of {0}", IfxConnection.class.getName()));
    }

    static TimeSeriesRowType createTimeSeriesRowType(String name, TypeInfo udtInfo, IfxResultSetMetaData metaData) throws SQLException {
        Builder builder = TimeSeriesRowType.builder();
        builder.name(name);
        int realCols = metaData.getColumnCount();
        for (int fieldIndex = 1; fieldIndex <= realCols; ++fieldIndex) {
            TimeSeriesField field = TimeSeriesRowType.getTimeSeriesField(metaData, fieldIndex);
            if (field == null) {
                throw new SQLException(MessageFormat.format("the {0} field of the row type is not a supported type", fieldIndex));
            }
            if (fieldIndex == 1) {
                if (field instanceof TimestampTimeSeriesField) {
                    builder.timestampFieldName(metaData.getColumnLabel(1));
                    continue;
                }
                throw new SQLException("the first field of a row type must be a timestamp for use in a TimeSeries");
            }
            builder.add(field);
        }
        TimeSeriesRowType tsRowType = builder.build();
        if (udtInfo != null) {
            tsRowType.extendedId = udtInfo.getXid();
        }
        return tsRowType;
    }

    static TimeSeriesField getTimeSeriesField(IfxResultSetMetaData metaData, int fieldIndex) throws SQLException {
        AbstractTimeSeriesField field;
        boolean informixType;
        int typeId;
        int type = metaData.getColumnType(fieldIndex);
        switch (type) {
            case 1111: 
            case 2000: 
            case 2001: 
            case 2002: 
            case 2003: {
                typeId = metaData.getIfxColumnType(fieldIndex);
                informixType = true;
                break;
            }
            case 1: {
                if (metaData.getIfxColumnType(fieldIndex) == 14) {
                    typeId = metaData.getIfxColumnType(fieldIndex);
                    informixType = true;
                    break;
                }
                typeId = type;
                informixType = false;
                break;
            }
            default: {
                if (metaData.getIfxColumnType(fieldIndex) == 52) {
                    typeId = metaData.getIfxColumnType(fieldIndex);
                    informixType = true;
                    break;
                }
                typeId = type;
                informixType = false;
            }
        }
        try {
            if (informixType) {
                switch (typeId) {
                    case 45: {
                        field = new BooleanTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case 52: {
                        field = new BigIntTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case 14: {
                        int precision = metaData.getEncodedLength(fieldIndex);
                        byte start = (byte)(precision >> 4 & 0xF);
                        byte end = (byte)(precision & 0xF);
                        field = new IntervalTimeSeriesField(metaData.getColumnLabel(fieldIndex), start, end);
                        break;
                    }
                    case 0: 
                    case 13: 
                    case 43: {
                        field = new VarcharTimeSeriesField(metaData.getColumnLabel(fieldIndex), metaData.getEncodedLength(fieldIndex));
                        break;
                    }
                    case 40: {
                        field = new BsonTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    default: {
                        field = null;
                        break;
                    }
                }
            } else {
                switch (typeId) {
                    case -4: 
                    case -2: {
                        field = new ByteTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case 91: {
                        field = new DateTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case 92: {
                        field = new TimeTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case 8: {
                        field = new FloatTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case 2: 
                    case 3: {
                        field = new DecimalTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case -5: {
                        field = new Int8TimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case 4: {
                        field = new IntTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case 6: 
                    case 7: {
                        field = new SmallFloatTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case 5: {
                        field = new SmallIntTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case -7: 
                    case -1: 
                    case 1: 
                    case 12: {
                        field = new VarcharTimeSeriesField(metaData.getColumnLabel(fieldIndex), metaData.getEncodedLength(fieldIndex));
                        break;
                    }
                    case 93: {
                        field = new TimestampTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    case 16: {
                        field = new BooleanTimeSeriesField(metaData.getColumnLabel(fieldIndex));
                        break;
                    }
                    default: {
                        field = null;
                    }
                }
            }
        }
        catch (Exception e) {
            throw new SQLException("ERROR: No readXXX method found -  " + e.getMessage());
        }
        return field;
    }

    public String toInformixString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append('(');
        boolean afterFirst = false;
        for (TimeSeriesField<?> field : this.fields) {
            if (afterFirst) {
                sb.append(", ");
            }
            sb.append(field.toSqlString());
            afterFirst = true;
        }
        sb.append(')');
        return sb.toString();
    }

    public static Set<TimeSeriesRowType> getAll(Connection connection) throws SQLException {
        IfxConnection ifxConn = TimeSeriesRowType.getIfxConnection(connection);
        HashSet<String> rowTypeNames = new HashSet<String>();
        PreparedStatement pstmt = ifxConn.prepareStatement("SELECT name FROM sysxtdtypes WHERE mode='R'");
        Object object = null;
        try (ResultSet resultSet2 = pstmt.executeQuery();){
            while (resultSet2.next()) {
                rowTypeNames.add(resultSet2.getString(1));
            }
        }
        catch (Throwable resultSet2) {
            object = resultSet2;
            throw resultSet2;
        }
        finally {
            if (pstmt != null) {
                if (object != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Throwable resultSet2) {
                        ((Throwable)object).addSuppressed(resultSet2);
                    }
                } else {
                    pstmt.close();
                }
            }
        }
        HashSet<TimeSeriesRowType> tsRowTypes = new HashSet<TimeSeriesRowType>();
        for (String tsRowTypeName : rowTypeNames) {
            try {
                tsRowTypes.add(TimeSeriesRowType.get(ifxConn, tsRowTypeName));
            }
            catch (SQLException sQLException) {}
        }
        return tsRowTypes;
    }

    public static Set<TimeSeriesRowType> getAllReferenced(Connection connection) throws SQLException {
        Object object;
        Object resultSet;
        int timeseriesType;
        IfxConnection ifxConn;
        block74: {
            ifxConn = TimeSeriesRowType.getIfxConnection(connection);
            timeseriesType = 0;
            try (PreparedStatement pstmt = ifxConn.prepareStatement("SELECT type FROM sysxtdtypes WHERE name=?");){
                pstmt.setString(1, "timeseries");
                resultSet = pstmt.executeQuery();
                object = null;
                try {
                    if (resultSet.next()) {
                        timeseriesType = resultSet.getInt("type");
                        break block74;
                    }
                    throw new SQLException("no timeseries type found");
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (resultSet != null) {
                        if (object != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
        }
        HashSet<Integer> extendedIds = new HashSet<Integer>();
        PreparedStatement pstmt = ifxConn.prepareStatement("SELECT colname,extended_id FROM syscolumns WHERE coltype=?");
        resultSet = null;
        try {
            pstmt.setInt(1, timeseriesType);
            ResultSet resultSet2 = pstmt.executeQuery();
            Object object2 = null;
            try {
                while (resultSet2.next()) {
                    extendedIds.add(resultSet2.getInt(2));
                }
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (resultSet2 != null) {
                    if (object2 != null) {
                        try {
                            resultSet2.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        resultSet2.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            resultSet = throwable;
            throw throwable;
        }
        finally {
            if (pstmt != null) {
                if (resultSet != null) {
                    try {
                        pstmt.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)resultSet).addSuppressed(throwable);
                    }
                } else {
                    pstmt.close();
                }
            }
        }
        HashSet<String> tsRowTypeNames = new HashSet<String>();
        PreparedStatement pstmt2 = ifxConn.prepareStatement("SELECT name FROM sysxtdtypes WHERE mode='R' AND extended_id=?");
        object = null;
        try {
            for (Integer extendedId : extendedIds) {
                pstmt2.setInt(1, extendedId - 2);
                ResultSet resultSet3 = pstmt2.executeQuery();
                Throwable throwable = null;
                try {
                    if (!resultSet3.next()) continue;
                    tsRowTypeNames.add(resultSet3.getString(1));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (resultSet3 == null) continue;
                    if (throwable != null) {
                        try {
                            resultSet3.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    resultSet3.close();
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (pstmt2 != null) {
                if (object != null) {
                    try {
                        pstmt2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    pstmt2.close();
                }
            }
        }
        HashSet<TimeSeriesRowType> tsRowTypes = new HashSet<TimeSeriesRowType>();
        for (String tsRowTypeName : tsRowTypeNames) {
            tsRowTypes.add(TimeSeriesRowType.get(ifxConn, tsRowTypeName));
        }
        return tsRowTypes;
    }

    public String createRowString(Object ... values) {
        StringBuilder sb = new StringBuilder("row(");
        boolean afterFirst = false;
        for (int i = 0; i < this.fields.size(); ++i) {
            try {
                TimeSeriesField<?> field = this.fields.get(i);
                if (afterFirst) {
                    sb.append(", ");
                }
                sb.append(field.getFieldDefinition().convertValueToString(values[i]));
                afterFirst = true;
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(MessageFormat.format("Unable to create the value for field index {0}", i + 1), e);
            }
        }
        sb.append(")::");
        sb.append(this.getName());
        return sb.toString();
    }

    public int putElem(Connection connection, String tableName, String whereClause, Object ... values) throws SQLException {
        try (Statement statement = connection.createStatement();){
            String sql = MessageFormat.format("UPDATE {0} SET {1} WHERE {2}", tableName, this.createPutElemString("ts", values), whereClause);
            int n = statement.executeUpdate(sql);
            return n;
        }
    }

    public String createPutElemString(String timeseriesColumnName, Object ... values) {
        StringBuilder sb = new StringBuilder();
        sb.append(timeseriesColumnName);
        sb.append("=PutElem(");
        sb.append(timeseriesColumnName);
        sb.append(", ");
        sb.append(this.createRowString(values));
        sb.append(')');
        return sb.toString();
    }

    public static final Builder builder() {
        return new Builder();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fields.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeSeriesRowType)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeSeriesRowType other = (TimeSeriesRowType)obj;
        if (!this.fields.equals(other.fields)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("TimeSeriesRowType [name=");
        builder2.append(this.name);
        builder2.append(", fields=");
        builder2.append(this.fields);
        builder2.append(']');
        return builder2.toString();
    }

    public static final class Builder {
        private String name = null;
        private String timestampFieldName = null;
        private final List<TimeSeriesField<?>> builderFields = new ArrayList();

        public Builder clearFields() {
            this.builderFields.clear();
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder timestampFieldName(String name) {
            this.timestampFieldName = name;
            return this;
        }

        public String getTimestampFieldName() {
            return this.timestampFieldName;
        }

        public Builder add(TimeSeriesField<?> field) {
            this.builderFields.add(field);
            return this;
        }

        public List<TimeSeriesField<?>> getNonTimestampFields() {
            return Collections.unmodifiableList(this.builderFields);
        }

        public final TimeSeriesRowType build() {
            if (this.name == null) {
                throw new IllegalArgumentException("the row type name must not be null");
            }
            if (this.name.trim().length() == 0) {
                throw new IllegalArgumentException("the row type name must not be empty");
            }
            if (this.timestampFieldName == null) {
                throw new IllegalArgumentException("the timestamp field name must not be null");
            }
            if (this.timestampFieldName.trim().length() == 0) {
                throw new IllegalArgumentException("the timestamp field name must not be empty");
            }
            return new TimeSeriesRowType(this.name, this.timestampFieldName, this.builderFields);
        }
    }
}

