/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.field;

import com.informix.jdbc.udt.timeseries.field.TimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinition;

public abstract class AbstractTimeSeriesField<T>
implements TimeSeriesField<T> {
    protected final String fieldName;
    protected final TimeSeriesFieldDefinition<T> definition;

    protected AbstractTimeSeriesField(String fieldName, TimeSeriesFieldDefinition<T> dataType) {
        this.fieldName = fieldName;
        this.definition = dataType;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public TimeSeriesFieldDefinition<T> getFieldDefinition() {
        return this.definition;
    }

    @Override
    public String toSqlString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFieldName());
        sb.append(' ');
        sb.append(this.definition.toSqlString());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.fieldName == null ? 0 : this.fieldName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractTimeSeriesField)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTimeSeriesField other = (AbstractTimeSeriesField)obj;
        if (this.definition == null ? other.definition != null : !this.definition.equals(other.definition)) {
            return false;
        }
        return !(this.fieldName == null ? other.fieldName != null : !this.fieldName.equals(other.fieldName));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AbstractTimeSeriesField [fieldName=");
        builder.append(this.fieldName);
        builder.append(", definition=");
        builder.append(this.definition);
        builder.append(']');
        return builder.toString();
    }
}

