/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.field;

import com.informix.jdbc.udt.timeseries.field.BigIntTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.BooleanTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.BsonTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.ByteTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.CharTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.DateTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.DecimalTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.FloatTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.Int8TimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.IntTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.IntervalTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.SmallFloatTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.SmallIntTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.TimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.TimeSeriesFieldFactory;
import com.informix.jdbc.udt.timeseries.field.TimeTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.TimestampTimeSeriesField;
import com.informix.jdbc.udt.timeseries.field.VarcharTimeSeriesField;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public class TimeSeriesFieldRegistry {
    private static final CopyOnWriteArraySet<TimeSeriesFieldFactory<?>> fieldFactories = new CopyOnWriteArraySet();

    private TimeSeriesFieldRegistry() {
    }

    public static void register(TimeSeriesFieldFactory<?> fieldFactory) {
        fieldFactories.add(fieldFactory);
    }

    public static Set<TimeSeriesFieldFactory<?>> getFieldFactories() {
        return fieldFactories;
    }

    public static TimeSeriesField<?> parseField(String s) {
        for (TimeSeriesFieldFactory<?> factory : fieldFactories) {
            try {
                TimeSeriesField<?> fieldDef = factory.parse(s);
                return fieldDef;
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException("no field in the registry is capable of parsing the string representation");
    }

    static {
        TimeSeriesFieldRegistry.register(new BigIntTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new BooleanTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new BsonTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new ByteTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new CharTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new DateTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new DecimalTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new FloatTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new IntTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new Int8TimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new IntervalTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new SmallFloatTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new SmallIntTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new TimestampTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new TimeTimeSeriesField.Factory());
        TimeSeriesFieldRegistry.register(new VarcharTimeSeriesField.Factory());
    }
}

