/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxBSONObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.udt.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.bson.BSONObject;

public class BsonTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<IfxBSONObject>
implements TimeSeriesFieldDefinition<IfxBSONObject> {
    public BsonTimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.BSON);
    }

    @Override
    public IfxBSONObject read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        int length = stream.readInt();
        return new IfxBSONObject(stream.readBytes(length));
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, IfxBSONObject value) throws SQLException {
        byte[] bytes = value.getBytes();
        stream.writeBytes(bytes, bytes.length);
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::bson";
        }
        if (value instanceof IfxBSONObject) {
            return ((IfxBSONObject)value).toJson() + "::json::bson";
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", BSONObject.class, value.getClass()));
    }

    @Override
    public IfxBSONObject convertValueTo(Object value) {
        if (value instanceof IfxBSONObject) {
            return (IfxBSONObject)value;
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", IfxBSONObject.class, value.getClass()));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BsonTimeSeriesFieldDefinition []");
        return builder.toString();
    }

    public static BsonTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.BSON.getInformixTypeName())) {
            return new BsonTimeSeriesFieldDefinition();
        }
        throw new IllegalArgumentException();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<IfxBSONObject> {
        @Override
        public TimeSeriesFieldDefinition<IfxBSONObject> parse(String s) {
            return BsonTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

