/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.loader;

import com.informix.jdbc.udt.timeseries.loader.ISO8601DateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;

public class TimeSeriesLoaderPutBuffer {
    private static final char entryTerminator = '\n';
    private static final char slotTerminator = '|';
    private static final char ymdDelimiter = '-';
    private static final char hmsDelimiter = ':';
    private static final char fractionDelimiter = '.';
    private final List<String> primaryKey;
    private final boolean fullyQualified;
    private final StringBuilder putBuffer = new StringBuilder();
    private boolean isFirstLine = true;

    public TimeSeriesLoaderPutBuffer(List<String> primaryKey) {
        this(primaryKey, true);
    }

    public TimeSeriesLoaderPutBuffer(List<String> primaryKey, boolean isFullyQualified) {
        this.primaryKey = primaryKey;
        this.fullyQualified = isFullyQualified;
    }

    public String createRecord(ISO8601DateTime isoDt, List<Object> values) {
        StringBuilder sb = new StringBuilder();
        this.appendPrimaryKeys(sb);
        this.appendTime(isoDt, sb);
        this.appendValues(values, sb);
        sb.append('\n');
        return sb.toString();
    }

    public void addRecord(String record) {
        this.putBuffer.append(record);
        this.isFirstLine = false;
    }

    private void appendPrimaryKeys(StringBuilder sb) {
        if (this.isFirstLine) {
            this.appendPrimaryKeysFullyQualified(sb);
        } else if (this.fullyQualified) {
            this.appendPrimaryKeysFullyQualified(sb);
        } else {
            this.appendPrimaryKeysFiller(sb);
        }
    }

    private void appendPrimaryKeysFullyQualified(StringBuilder sb) {
        for (String pk : this.primaryKey) {
            sb.append(pk);
            sb.append('|');
        }
    }

    private void appendPrimaryKeysFiller(StringBuilder sb) {
        int size = this.primaryKey.size();
        for (int i = 0; i < size; ++i) {
            sb.append('|');
        }
    }

    private void appendTime(ISO8601DateTime isoDt, StringBuilder sb) {
        this.appendYMD(isoDt, sb);
        sb.append('|');
        this.appendHMS(isoDt, sb);
        sb.append('|');
    }

    private void appendYMD(ISO8601DateTime isoDt, StringBuilder sb) {
        Calendar calendar = isoDt.getCalendar();
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        sb.append(calendar.get(1));
        sb.append('-');
        if (month < 10) {
            sb.append('0');
        }
        sb.append(month);
        sb.append('-');
        if (day < 10) {
            sb.append('0');
        }
        sb.append(day);
    }

    private void appendHMS(ISO8601DateTime isoDt, StringBuilder sb) {
        Calendar calendar = isoDt.getCalendar();
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        if (hour < 10) {
            sb.append('0');
        }
        sb.append(hour);
        sb.append(':');
        if (minute < 10) {
            sb.append('0');
        }
        sb.append(minute);
        sb.append(':');
        if (second < 10) {
            sb.append('0');
        }
        sb.append(second);
        sb.append('.');
        String fraction5 = String.valueOf(isoDt.getNanos() / 10000L);
        for (int i = fraction5.length(); i < 5; ++i) {
            sb.append('0');
        }
        sb.append(fraction5);
    }

    private void appendValues(List<Object> values, StringBuilder sb) {
        for (Object value : values) {
            sb.append(value);
            sb.append('|');
        }
    }

    public List<String> getPrimaryKey() {
        return Collections.unmodifiableList(this.primaryKey);
    }

    List<String> getPrimaryKeyInternal() {
        return this.primaryKey;
    }

    public String toString() {
        return this.putBuffer.toString();
    }

    public int getSize() {
        return this.putBuffer.length();
    }
}

