/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.loader;

import com.informix.jdbc.udt.timeseries.loader.ITimeSeriesLoaderSession;
import com.informix.jdbc.udt.timeseries.loader.RecordWriter;
import com.informix.jdbc.udt.timeseries.loader.TimeSeriesLoaderPutBuffer;
import com.informix.jdbc.udt.timeseries.loader.TimeSeriesRecord;
import com.informix.jdbc.udt.timeseries.loader.TimeSeriesRecordSpecification;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.bson.BSONObject;
import org.bson.types.BasicBSONList;

public class TimeSeriesLoaderRecordWriter
implements RecordWriter {
    private static final String SQL_TSL_FLUSH = "EXECUTE FUNCTION TSL_Flush(?,?,?)";
    private static final String SQL_TSL_PUT = "EXECUTE FUNCTION TSL_Put(?,?)";
    protected final ITimeSeriesLoaderSession tsLoaderSession;
    protected final String handle;
    protected final int maxPutSize;
    protected final TimeSeriesRecordSpecification timeSeriesRecordSpec;
    protected final int flushFlag;
    protected boolean closed = false;
    protected int availibleSpace;
    protected int numPut = 0;
    protected int rowsWritten = 0;
    protected TimeSeriesLoaderPutBuffer currentPutBuffer = null;
    protected final List<TimeSeriesLoaderPutBuffer> putBuffers = new ArrayList<TimeSeriesLoaderPutBuffer>();
    protected long lastWrite = 0L;
    protected long lastCommit = 0L;
    protected long lastFlush = 0L;
    protected final Calendar calendar = GregorianCalendar.getInstance();

    public TimeSeriesLoaderRecordWriter(ITimeSeriesLoaderSession tsLoaderSession) {
        this.tsLoaderSession = tsLoaderSession;
        this.timeSeriesRecordSpec = tsLoaderSession.getTimeSeriesRecordSpecification();
        this.maxPutSize = tsLoaderSession.getPutSizeMaximum();
        try {
            this.handle = tsLoaderSession.getHandle();
        }
        catch (SQLException e) {
            throw new IllegalArgumentException("TimeSeries loader session not valid. Cannot get TSL handle. " + e.getMessage(), e);
        }
        this.flushFlag = tsLoaderSession.allowDuplicatePuts() ? 257 : 261;
        this.lastCommit = System.currentTimeMillis();
        this.lastFlush = System.currentTimeMillis();
    }

    @Override
    public ITimeSeriesLoaderSession getSession() {
        return this.tsLoaderSession;
    }

    @Override
    public void write(BSONObject document) throws SQLException {
        if (document instanceof BasicBSONList) {
            BasicBSONList list = (BasicBSONList)document;
            for (Object o : list) {
                if (o instanceof BSONObject) {
                    TimeSeriesRecord tsRecord = this.timeSeriesRecordSpec.create((BSONObject)o);
                    this.write(tsRecord);
                    continue;
                }
                throw new IllegalArgumentException("Attempt to insert a list element that was not a document: " + o);
            }
        } else {
            TimeSeriesRecord tsRecord = this.timeSeriesRecordSpec.create(document);
            this.write(tsRecord);
        }
    }

    public synchronized void write(TimeSeriesRecord tsRecord) throws SQLException {
        Object data;
        if (this.closed) {
            throw new IllegalArgumentException("record writer is closed");
        }
        if (!this.equalsPrimaryKey(tsRecord.getPrimaryKey())) {
            this.setPrimaryKey(tsRecord.getPrimaryKey());
        }
        List<Object> values = (data = tsRecord.getData()) instanceof List ? (List<Object>)data : Arrays.asList(data);
        String toAdd = this.currentPutBuffer.createRecord(tsRecord.getTimestamp(), values);
        int size = toAdd.length() + this.currentPutBuffer.getSize();
        boolean shouldCommit = size >= this.availibleSpace;
        this.lastWrite = System.currentTimeMillis();
        if (!shouldCommit && this.lastCommit <= this.lastWrite - 2000L) {
            shouldCommit = true;
        }
        if (shouldCommit) {
            this.commit();
            this.lastCommit = this.lastWrite;
        }
        this.currentPutBuffer.addRecord(toAdd);
        ++this.rowsWritten;
    }

    private boolean equalsPrimaryKey(String primaryKey) {
        List<String> newPkColumns = Arrays.asList(primaryKey);
        if (this.currentPutBuffer != null) {
            List<String> currentPkColumns = this.currentPutBuffer.getPrimaryKeyInternal();
            if (currentPkColumns.size() != newPkColumns.size()) {
                return false;
            }
            int size = currentPkColumns.size();
            for (int i = 0; i < size; ++i) {
                String currPkColumn = currentPkColumns.get(i);
                String newPkColumn = newPkColumns.get(i);
                if (newPkColumn != null && newPkColumn.equals(currPkColumn)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void setPrimaryKey(String primaryKey) throws SQLException {
        if (this.currentPutBuffer != null) {
            if (this.getSize() + this.currentPutBuffer.getSize() > this.maxPutSize) {
                this.commit();
            } else {
                this.putBuffers.add(this.currentPutBuffer);
            }
        }
        this.currentPutBuffer = new TimeSeriesLoaderPutBuffer(Arrays.asList(primaryKey), false);
        this.availibleSpace = this.maxPutSize - this.getSize();
    }

    private void commit() throws SQLException {
        if (this.currentPutBuffer != null) {
            this.putBuffers.add(this.currentPutBuffer);
            this.putToDatabase();
            this.putBuffers.clear();
            List<String> pks = this.currentPutBuffer.getPrimaryKeyInternal();
            this.currentPutBuffer = new TimeSeriesLoaderPutBuffer(pks, false);
            this.availibleSpace = this.maxPutSize;
        }
    }

    private void putToDatabase() throws SQLException {
        String data = this.getRecordsInFormat();
        if (data.length() == 0) {
            return;
        }
        try (PreparedStatement pstmt = this.tsLoaderSession.getConnection().prepareStatement(SQL_TSL_PUT);){
            pstmt.setString(1, this.handle);
            pstmt.setString(2, data);
            pstmt.execute();
        }
        ++this.numPut;
        if (this.numPut >= this.tsLoaderSession.getPutsPerFlush()) {
            this.flushInternal();
            this.numPut = 0;
        }
    }

    private String getRecordsInFormat() {
        StringBuilder sb = new StringBuilder();
        for (TimeSeriesLoaderPutBuffer record : this.putBuffers) {
            sb.append(record.toString());
        }
        return sb.toString();
    }

    private int getSize() {
        int size = 0;
        for (TimeSeriesLoaderPutBuffer record : this.putBuffers) {
            size += record.getSize();
        }
        return size;
    }

    @Override
    public synchronized void flush() throws SQLException {
        this.commit();
        this.flushInternal();
    }

    private void flushInternal() throws SQLException {
        Connection conn = this.tsLoaderSession.getConnection();
        try {
            conn.setAutoCommit(false);
            try (PreparedStatement pstmt = this.tsLoaderSession.getConnection().prepareStatement(SQL_TSL_FLUSH);){
                pstmt.setString(1, this.handle);
                pstmt.setString(2, null);
                pstmt.setInt(3, this.flushFlag);
                pstmt.execute();
            }
            conn.commit();
        }
        catch (SQLException e) {
            conn.rollback();
            throw e;
        }
        finally {
            conn.setAutoCommit(true);
        }
        this.lastFlush = System.currentTimeMillis();
    }

    @Override
    public long getLastWriteTime() {
        return this.lastWrite;
    }

    @Override
    public long getLastFlushTime() {
        return this.lastFlush;
    }

    @Override
    public synchronized void close() throws SQLException {
        this.closed = true;
    }
}

