/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.loader;

import com.informix.jdbc.udt.timeseries.IfmxCalendar;
import com.informix.jdbc.udt.timeseries.TimeSeriesRowType;
import com.informix.jdbc.udt.timeseries.TimeSeriesTable;
import com.informix.jdbc.udt.timeseries.loader.ITimeSeriesLoaderSession;
import com.informix.jdbc.udt.timeseries.loader.TSLoadIdentifierType;
import com.informix.jdbc.udt.timeseries.loader.TSLoadLogLevel;
import com.informix.jdbc.udt.timeseries.loader.TSLoadLogType;
import com.informix.jdbc.udt.timeseries.loader.TimeSeriesRecordSpecification;
import com.informix.util.JdbcLogger;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;

public class TimeSeriesLoaderSession
implements ITimeSeriesLoaderSession {
    private static final JdbcLogger logger = JdbcLogger.getLogger(TimeSeriesLoaderSession.class);
    private static final String SQL_ARG_DELIMITER = ", ";
    private static final char SQL_STRING_DELIMITER = '\'';
    private static final String YMD_HMS_FORMAT = "%Y-%m-%d|%H:%M:%S.%F5";
    private static final String IFX_ALLOW_NEWLINE = "EXECUTE PROCEDURE ifx_allow_newline('t')";
    private static final String IFX_SET_DIRTY_READ = "SET ISOLATION TO DIRTY READ";
    private static final TSLoadIdentifierType LOADER_ID_TYPE = TSLoadIdentifierType.PRIMARY_KEY;
    private final Connection connection;
    private final String tableName;
    private final String tsColumnName;
    private final TimeSeriesRecordSpecification timeSeriesRecordSpecification;
    private String handle = null;
    private IfmxCalendar calendar = null;
    private String calendarName = "ts_1min";
    private boolean createMissingRowsEnabled = true;
    private boolean createMissingRowsAsRegularTS = false;
    private boolean allowDuplicatePuts = true;
    private int putsPerFlush = 4;
    private int putSizeMaximum = 3840;
    private TSLoadLogLevel loaderLogLevel = TSLoadLogLevel.WARNING;
    private TSLoadLogType loaderLogType = TSLoadLogType.SYSTEMLOG;

    public TimeSeriesLoaderSession(Connection connection, String tableName, String timeseriesColumnName, String primaryKeyFieldName) throws SQLException {
        this.connection = connection;
        this.tableName = tableName;
        this.tsColumnName = timeseriesColumnName;
        TimeSeriesRowType rowType = TimeSeriesTable.getTimeseriesRowType(connection, tableName, timeseriesColumnName);
        if (rowType == null) {
            throw new IllegalArgumentException(MessageFormat.format("Timeseries row type not found for column {0}", timeseriesColumnName));
        }
        this.timeSeriesRecordSpecification = new TimeSeriesRecordSpecification(primaryKeyFieldName, rowType);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getTimeSeriesColumnName() {
        return this.tsColumnName;
    }

    @Override
    public TimeSeriesRecordSpecification getTimeSeriesRecordSpecification() {
        return this.timeSeriesRecordSpecification;
    }

    @Override
    public String getCalendarName() {
        return this.calendarName;
    }

    @Override
    public void setCalendarName(String calendarName) {
        this.calendarName = calendarName;
    }

    @Override
    public IfmxCalendar getTimeSeriesCalendar() throws SQLException {
        if (this.calendar == null) {
            this.calendar = IfmxCalendar.getCalendar(this.connection, this.calendarName);
        }
        return this.calendar;
    }

    @Override
    public boolean isCreateMissingRowsEnabled() {
        return this.createMissingRowsEnabled;
    }

    @Override
    public void setCreateMissingRowsEnabled(boolean createMissingRowsEnabled) {
        this.createMissingRowsEnabled = createMissingRowsEnabled;
    }

    @Override
    public boolean createMissingRowsAsRegularTimeSeries() {
        return this.createMissingRowsAsRegularTS;
    }

    @Override
    public void createMissingRowsAsRegularTimeSeries(boolean createMissingRowsAsRegularTimeSeries) {
        this.createMissingRowsAsRegularTS = createMissingRowsAsRegularTimeSeries;
    }

    @Override
    public boolean allowDuplicatePuts() {
        return this.allowDuplicatePuts;
    }

    @Override
    public void setAllowDuplicatePuts(boolean allowDuplicatePuts) {
        this.allowDuplicatePuts = allowDuplicatePuts;
    }

    @Override
    public int getPutsPerFlush() {
        return this.putsPerFlush;
    }

    @Override
    public void setPutsPerFlush(int putsPerFlush) {
        this.putsPerFlush = putsPerFlush;
    }

    @Override
    public int getPutSizeMaximum() {
        return this.putSizeMaximum;
    }

    @Override
    public void setPutSizeMaximum(int putSizeMaximum) {
        this.putSizeMaximum = putSizeMaximum;
    }

    @Override
    public TSLoadLogLevel getLoaderLogLevel() {
        return this.loaderLogLevel;
    }

    @Override
    public void setLoaderLogLevel(TSLoadLogLevel loaderLogLevel) {
        this.loaderLogLevel = loaderLogLevel;
    }

    @Override
    public TSLoadLogType getLoaderLogType() {
        return this.loaderLogType;
    }

    @Override
    public void setLoaderLogType(TSLoadLogType loaderLogType) {
        this.loaderLogType = loaderLogType;
    }

    @Override
    public String getHandle() throws SQLException {
        if (this.handle == null) {
            this.initialize();
        }
        return this.handle;
    }

    @Override
    public final void initialize() throws SQLException {
        try {
            this.runTSLAttach();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -937) {
                this.runTSLInit();
            }
            throw e;
        }
        if (this.handle == null) {
            throw new RuntimeException("Unable to intialize/attach to a timeseries loader session. No TSL handle returned.");
        }
        if (this.isCreateMissingRowsEnabled()) {
            this.runTSLSetNewTS();
        }
    }

    private final void runTSLInit() throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            try (ResultSet rs = stmt.executeQuery(this.buildInitSql());){
                if (rs.next()) {
                    this.handle = rs.getString(1);
                }
            }
            stmt.execute(IFX_ALLOW_NEWLINE);
            stmt.execute(IFX_SET_DIRTY_READ);
        }
    }

    private final void runTSLAttach() throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            try (ResultSet rs = stmt.executeQuery(this.buildAttachSql());){
                if (rs.next()) {
                    this.handle = rs.getString(1);
                }
            }
            stmt.execute(IFX_ALLOW_NEWLINE);
            stmt.execute(IFX_SET_DIRTY_READ);
        }
    }

    private final void runTSLSetNewTS() throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            stmt.executeQuery(this.buildSetNewTSSql());
        }
    }

    @Override
    public final void flush() throws SQLException {
        try (Statement stmt = this.connection.createStatement();){
            this.connection.setAutoCommit(false);
            stmt.execute(this.buildFlushAllSql());
            this.connection.commit();
        }
        catch (SQLException e) {
            this.connection.rollback();
            throw e;
        }
        finally {
            this.connection.setAutoCommit(true);
        }
    }

    @Override
    public void close() {
        try {
            this.close(true);
        }
        catch (SQLException e) {
            logger.debug("Unable to shutdown time series loader session on database: {}", (Object)e.getMessage());
        }
    }

    @Override
    public void close(boolean shutdownOnDatabase) throws SQLException {
        this.flush();
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute(this.buildCloseSessionSql());
            if (shutdownOnDatabase) {
                stmt.execute(this.buildShutdownSql());
            }
        }
    }

    private final String buildAttachSql() {
        StringBuilder sb = new StringBuilder("EXECUTE FUNCTION TSL_Attach(");
        sb.append('\'');
        sb.append(this.tableName);
        sb.append('\'');
        sb.append(SQL_ARG_DELIMITER);
        sb.append('\'');
        sb.append(this.tsColumnName);
        sb.append('\'');
        sb.append(")");
        return sb.toString();
    }

    private final String buildInitSql() {
        StringBuilder sb = new StringBuilder("EXECUTE FUNCTION TSL_Init(");
        sb.append('\'');
        sb.append(this.tableName);
        sb.append('\'');
        sb.append(SQL_ARG_DELIMITER);
        sb.append('\'');
        sb.append(this.tsColumnName);
        sb.append('\'');
        sb.append(SQL_ARG_DELIMITER);
        sb.append(LOADER_ID_TYPE.getValue());
        sb.append(SQL_ARG_DELIMITER);
        sb.append(this.loaderLogType.getId());
        sb.append(SQL_ARG_DELIMITER);
        sb.append(this.loaderLogLevel.getId());
        sb.append(SQL_ARG_DELIMITER);
        sb.append("NULL");
        sb.append(SQL_ARG_DELIMITER);
        sb.append('\'');
        sb.append(YMD_HMS_FORMAT);
        sb.append('\'');
        sb.append(SQL_ARG_DELIMITER);
        sb.append("NULL");
        sb.append(SQL_ARG_DELIMITER);
        sb.append("NULL");
        sb.append(")");
        return sb.toString();
    }

    private final String buildSetNewTSSql() {
        StringBuilder sb = new StringBuilder("EXECUTE FUNCTION TSL_SetNewTS(");
        sb.append('\'');
        sb.append(this.handle);
        sb.append('\'');
        sb.append(SQL_ARG_DELIMITER);
        sb.append('\'');
        sb.append(this.buildNewTSString());
        sb.append('\'');
        sb.append(SQL_ARG_DELIMITER);
        sb.append(1);
        sb.append(")");
        return sb.toString();
    }

    private final String buildNewTSString() {
        StringBuilder sb = new StringBuilder();
        if (this.createMissingRowsAsRegularTS) {
            sb.append("regular");
        } else {
            sb.append("irregular");
        }
        sb.append(", calendar(");
        sb.append(this.calendarName);
        sb.append("), threshold(0)");
        return sb.toString();
    }

    private String buildFlushAllSql() {
        StringBuilder sb = new StringBuilder("EXECUTE FUNCTION TSL_FlushAll(");
        sb.append('\'');
        sb.append(this.handle);
        sb.append('\'');
        sb.append(SQL_ARG_DELIMITER);
        sb.append(this.allowDuplicatePuts ? 1 : 5);
        sb.append(")");
        return sb.toString();
    }

    private String buildShutdownSql() {
        StringBuilder sb = new StringBuilder("EXECUTE PROCEDURE TSL_Shutdown('");
        sb.append(this.handle);
        sb.append("')");
        return sb.toString();
    }

    private String buildCloseSessionSql() {
        StringBuilder sb = new StringBuilder("EXECUTE FUNCTION TSL_SessionClose('");
        sb.append(this.handle);
        sb.append("')");
        return sb.toString();
    }
}

