/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbcx.IfxCoreDataSource;
import com.informix.jdbcx.IfxXADataSourceFactory;
import com.informix.jdbcx.IfxXAPooledConnection;
import com.informix.lang.Messages;
import java.io.ByteArrayOutputStream;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class IfxXADataSource
extends IfxCoreDataSource
implements XADataSource,
Referenceable {
    private static final long serialVersionUID = 1L;

    @Override
    public XAConnection getXAConnection() throws SQLException {
        String user = this.getUser();
        String password = this.getPassword();
        if (user == null || password == null) {
            throw Messages.getLocSQLException(-79811, this.getIfxCLIENT_LOCALE());
        }
        this.DSProperties.put("PROTOCOLCLASS", "com.informix.jdbcx.IfxXASqli");
        IfxXAPooledConnection pooledConn = new IfxXAPooledConnection(this, user, password);
        return pooledConn;
    }

    @Override
    public XAConnection getXAConnection(String uid, String passwd) throws SQLException {
        this.DSProperties.put("PROTOCOLCLASS", "com.informix.jdbcx.IfxXASqli");
        IfxXAPooledConnection pooledConn = new IfxXAPooledConnection(this, uid, passwd);
        return pooledConn;
    }

    @Override
    public Reference getReference() throws NamingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeProperties(out);
            return new Reference(IfxXADataSource.class.getName(), new StringRefAddr("XADSProperties", ((Object)out).toString()), IfxXADataSourceFactory.class.getName(), null);
        }
        catch (Exception e) {
            System.err.println("getReference(): " + e.toString());
            return null;
        }
    }

    public void setIfxIFX_XASPEC(String XASPEC_Flag) {
        this.DSProperties.setProperty("IFX_XASPEC", XASPEC_Flag);
    }

    public String getIfxIFX_XASPEC() {
        String propValue = this.DSProperties.getProperty("IFX_XASPEC");
        if (propValue == null || !propValue.equalsIgnoreCase("y") && !propValue.equalsIgnoreCase("n")) {
            propValue = defProp.getProperty("IFX_XASPEC");
        }
        if (propValue != null && propValue.equalsIgnoreCase("y")) {
            return "y";
        }
        return "n";
    }

    public void setIfxIFX_XASTDCOMPLIANCE_XAEND(int flag) {
        this.DSProperties.setProperty("IFX_XASTDCOMPLIANCE_XAEND", flag == 1 ? "1" : "0");
    }

    public int getIfxIFX_XASTDCOMPLIANCE_XAEND() {
        int retValue = -1;
        String propValue = this.DSProperties.getProperty("IFX_XASTDCOMPLIANCE_XAEND");
        if (propValue != null && propValue.length() != 0) {
            retValue = propValue.equals("1") ? 1 : 0;
        }
        return retValue;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }
}

