/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxPooledConnection;
import com.informix.jdbcx.IfxXAPooledConnection;
import com.informix.jdbcx.IfxXASqli;
import com.informix.lang.Messages;
import com.informix.util.Trace;
import java.sql.SQLException;
import java.util.Properties;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class IfxXAReusableConnection
extends IfxSqliConnect {
    private static final Object logger = Trace.getLoggerForClass(IfxXAReusableConnection.class);
    IfxPooledConnection parentPooledConn;
    private Properties dsProps;
    private boolean xaOpened = false;
    boolean startXA = false;
    boolean inXATXN = false;
    Xid currentXid = null;

    public IfxXAReusableConnection(String luser, String lpasswd, IfxPooledConnection pooledConn, String url, Properties props) throws SQLException {
        super(IfxSqliConnect.convertLegacyConstructorToDataSource(luser, lpasswd, url, props));
        if (this.externalVersion.startsWith("8")) {
            throw Messages.getSQLException(-79834, this);
        }
        this.parentPooledConn = pooledConn;
        this.dsProps = props;
        this.startXA = false;
        this.inXATXN = false;
        this.currentXid = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.dbName != null) {
            try {
                this.closeAllResultSets();
                this.clearTransactions(false);
                this.closeAllStatements();
            }
            catch (SQLException ex) {
                if (this.parentPooledConn != null) {
                    this.parentPooledConn.notifyListenersOfErrors(ex);
                }
                throw ex;
            }
        }
        this.parentPooledConn.notifyListeners();
    }

    void hardClose() throws SQLException {
        try {
            this.clearTransactions(false);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.dbName != null) {
            ((IfxXAPooledConnection)this.parentPooledConn).closeDBforXA();
            super.markStatementAsReleased();
            super.markCursorsToClosed(false);
        }
        super.close();
    }

    @Override
    public void commit() throws SQLException {
        if (this.startXA) {
            throw Messages.getSQLException(-700, this);
        }
        super.commit();
    }

    @Override
    public void rollback() throws SQLException {
        if (this.startXA) {
            throw Messages.getSQLException(-700, this);
        }
        super.rollback();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        if (this.startXA) {
            return false;
        }
        return super.getAutoCommit();
    }

    @Override
    public void setAutoCommit(boolean newAC) throws SQLException {
        if (this.startXA) {
            if (!newAC) {
                return;
            }
            throw Messages.getSQLException(-700, this);
        }
        super.setAutoCommit(newAC);
    }

    String getServerName() {
        return this.dsProps.getProperty("INFORMIXSERVER");
    }

    @Override
    public boolean isXAConnection() {
        return true;
    }

    @Override
    public boolean inXATransaction() {
        return this.startXA;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void clearTransactions(boolean rollbackXids) throws SQLException {
        xid = null;
        xaRes = ((IfxXAPooledConnection)this.parentPooledConn).xaRes;
        if (this.inXATransaction()) {
            if (xaRes.xidList != null && xaRes.xidList.size() > 0) {
                xid = xaRes.xidList.lastElement();
                try {
                    if (!rollbackXids) ** GOTO lbl29
                    xaRes.end(xid, 0x4000000);
                    xaRes.rollback(xid);
                }
                catch (XAException xe) {
                    throw new SQLException(xe.errorCode + ": " + xe.toString());
                }
            }
        } else if (this.isInUserTransaction()) {
            this.rollback();
        } else if (rollbackXids && xaRes != null && xaRes.xidList != null) {
            while (xaRes.xidList.size() > 0) {
                xid = xaRes.xidList.elementAt(0);
                try {
                    xaRes.rollback(xid);
                }
                catch (XAException xe) {
                    try {
                        xaRes.forget(xid);
                    }
                    catch (XAException xae) {
                        throw new SQLException(xe.errorCode + ": " + xe.toString());
                    }
                }
            }
        }
lbl29:
        // 7 sources

        if (xaRes != null) {
            xaRes.removeXidList();
        }
    }

    @Override
    protected boolean isCommitNeeded() {
        if (this.inXATransaction()) {
            return false;
        }
        return super.isCommitNeeded();
    }

    public Xid getCurrentXid() {
        return this.currentXid;
    }

    @Override
    public IfxProtocol createProto() {
        return new IfxXASqli(this);
    }
}

