/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

public class PatternClassMap
implements Cloneable,
Map<String, Class<?>> {
    private final Map<Pattern, Class<?>> map;
    private final int patternFlags;

    public PatternClassMap() {
        this(new HashMap(), 0);
    }

    public PatternClassMap(int initialCapacity, int patternFlags) {
        this(new HashMap(initialCapacity), patternFlags);
    }

    public PatternClassMap(int initialCapacity, float loadFactor, int patternFlags) {
        this(new HashMap(initialCapacity, loadFactor), patternFlags);
    }

    protected PatternClassMap(Map<Pattern, Class<?>> underlyingMap, int patternFlags) {
        this.map = underlyingMap;
        this.patternFlags = patternFlags;
    }

    public static PatternClassMap wrap(Map<Pattern, Class<?>> mapToWrap, int patternFlags) {
        for (Map.Entry<Pattern, Class<?>> entry : mapToWrap.entrySet()) {
            if (entry.getKey() == null) {
                throw new NullPointerException("the map contained an entry with a null key");
            }
            if (!(entry.getKey() instanceof Pattern)) {
                throw new IllegalArgumentException(MessageFormat.format("the map contained an entry with a key of {0} that was of type {1} and not of {2}", entry.getKey(), entry.getKey().getClass(), Pattern.class));
            }
            if (entry.getValue() == null) {
                throw new NullPointerException("the map contained an entry with a null value");
            }
            if (entry.getValue() instanceof Class) continue;
            throw new IllegalArgumentException(MessageFormat.format("the map contained an entry with a value of {0} that was of type {1} and not of {2}", entry.getValue(), entry.getValue().getClass(), Class.class));
        }
        return new PatternClassMap(mapToWrap, patternFlags);
    }

    public int getPatternFlags() {
        return this.patternFlags;
    }

    @Override
    public synchronized int size() {
        return this.map.size();
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (key instanceof CharSequence) {
            for (Map.Entry<Pattern, Class<?>> entry : this.map.entrySet()) {
                if (!entry.getKey().matcher((CharSequence)key).matches()) continue;
                return true;
            }
            return false;
        }
        if (key instanceof Pattern) {
            return this.map.containsKey(key);
        }
        return false;
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Object clone() {
        Map<Pattern, Class<?>> newMap = this.cloneMap();
        if (newMap == null) {
            newMap = this.copyMap();
        }
        return new PatternClassMap(newMap, this.patternFlags);
    }

    private Map<Pattern, Class<?>> cloneMap() {
        Map result = null;
        try {
            Method cloneMethod = this.map.getClass().getMethod("clone", new Class[0]);
            if (cloneMethod == null || !cloneMethod.isAccessible()) {
                return result;
            }
            Object clonedObject = cloneMethod.invoke(this.map, new Object[0]);
            if (clonedObject instanceof Map) {
                result = (Map)clonedObject;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private Map<Pattern, Class<?>> copyMap() {
        HashMap mapCopy = new HashMap();
        for (Map.Entry<Pattern, Class<?>> entry : this.map.entrySet()) {
            mapCopy.put(entry.getKey(), entry.getValue());
        }
        return mapCopy;
    }

    @Override
    public synchronized Class<?> get(Object key) {
        if (key instanceof CharSequence) {
            for (Map.Entry<Pattern, Class<?>> entry : this.map.entrySet()) {
                if (!entry.getKey().matcher((CharSequence)key).matches()) continue;
                return entry.getValue();
            }
            return null;
        }
        if (key instanceof Pattern) {
            return this.map.get(key);
        }
        return null;
    }

    protected synchronized Pattern findKey(Object key) {
        if (key instanceof CharSequence) {
            for (Pattern pattern : this.map.keySet()) {
                if (!pattern.pattern().equals(key)) continue;
                return pattern;
            }
            return null;
        }
        if (key instanceof Pattern) {
            Pattern patternToFind = (Pattern)key;
            for (Pattern pattern : this.map.keySet()) {
                if (!pattern.pattern().equals(patternToFind.pattern()) || pattern.flags() != patternToFind.flags()) continue;
                return pattern;
            }
            return null;
        }
        return null;
    }

    @Override
    public synchronized Class<?> put(Pattern key, Class<?> value) {
        return this.map.put(key, value);
    }

    @Override
    public synchronized Class<?> put(String regex, Class<?> value) {
        return this.map.put(Pattern.compile(regex, this.patternFlags), value);
    }

    @Override
    public synchronized Class<?> remove(Object key) {
        Pattern mapKey = this.findKey(key);
        if (mapKey != null) {
            return this.map.remove(mapKey);
        }
        return null;
    }

    @Override
    public synchronized void putAll(Map<? extends String, ? extends Class<?>> m) {
        for (Map.Entry<String, Class<?>> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public synchronized void patternPutAll(Map<? extends Pattern, ? extends Class<?>> m) {
        this.map.putAll(m);
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
    }

    @Override
    public synchronized Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        for (Pattern pattern : this.map.keySet()) {
            keySet.add(pattern.pattern());
        }
        return keySet;
    }

    public synchronized Set<Pattern> patternKeySet() {
        return this.map.keySet();
    }

    @Override
    public synchronized Collection<Class<?>> values() {
        return this.map.values();
    }

    @Override
    public synchronized Set<Map.Entry<String, Class<?>>> entrySet() {
        HashSet entrySet = new HashSet();
        for (Map.Entry<Pattern, Class<?>> entry : this.map.entrySet()) {
            entrySet.add(new StringClassEntry(entry.getKey().pattern(), entry.getValue()));
        }
        return entrySet;
    }

    public synchronized Set<Map.Entry<Pattern, Class<?>>> patternEntrySet() {
        return this.map.entrySet();
    }

    @Override
    public synchronized int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        result = 31 * result + this.patternFlags;
        return result;
    }

    @Override
    public synchronized boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatternClassMap)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PatternClassMap other = (PatternClassMap)obj;
        if (this.map == null ? other.map != null : !this.map.equals(other.map)) {
            return false;
        }
        return this.patternFlags == other.patternFlags;
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PatternClassMap [patternFlags=");
        builder.append(this.patternFlags);
        builder.append(", map=");
        builder.append(this.map);
        builder.append(']');
        return builder.toString();
    }

    private static final class StringClassEntry
    implements Map.Entry<String, Class<?>> {
        private final String key;
        private final Class<?> value;

        public StringClassEntry(String key, Class<?> value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public Class<?> getValue() {
            return this.value;
        }

        @Override
        public Class<?> setValue(Class<?> value) {
            throw new UnsupportedOperationException();
        }
    }
}

