/*
 * Decompiled with CFR 0.152.
 */
package com.informix.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class AdvancedUppercaseProperties
extends Properties {
    private static final long serialVersionUID = 1L;
    public static final String FALSE = "false";
    public static final String TRUE = "true";

    public AdvancedUppercaseProperties() {
    }

    public AdvancedUppercaseProperties(File fileLocation) throws IOException {
        this(fileLocation, null);
    }

    public AdvancedUppercaseProperties(File fileLocation, Properties prop) throws IOException {
        super(prop);
        try (FileInputStream fs = new FileInputStream(fileLocation);){
            this.load(fs);
        }
    }

    public AdvancedUppercaseProperties(Properties prop) {
        super(AdvancedUppercaseProperties.uppercaseEntries(prop));
    }

    private static Properties uppercaseEntries(Map<? extends Object, ? extends Object> p) {
        if (p == null) {
            return new Properties();
        }
        Properties upperCased = new Properties();
        for (Map.Entry<? extends Object, ? extends Object> entry : p.entrySet()) {
            upperCased.setProperty(entry.getKey().toString().toUpperCase(), entry.getValue().toString());
        }
        return upperCased;
    }

    public int asInt(String key) {
        return Integer.parseInt(this.getProperty(key));
    }

    public int asInt(String key, int defaultValue) {
        return Integer.parseInt(this.getProperty(key, Integer.toString(defaultValue)));
    }

    public int asInt(String key, String defaultValue) {
        return Integer.parseInt(this.getProperty(key, defaultValue));
    }

    public long asLong(String key) {
        return Long.parseLong(this.getProperty(key));
    }

    public long asLong(String key, long defaultValue) {
        return Long.parseLong(this.getProperty(key, Long.toString(defaultValue)));
    }

    public long asLong(String key, String defaultValue) {
        return Long.parseLong(this.getProperty(key, defaultValue));
    }

    public String asString(String key) {
        return this.getProperty(key);
    }

    public String asString(String key, String defaultValue) {
        return this.getProperty(key, defaultValue);
    }

    public boolean asBool(String key) {
        String value = this.getProperty(key);
        return value.equals("1") || value.equalsIgnoreCase(TRUE);
    }

    public boolean asBool(String key, boolean defaultValue) {
        return this.asBool(key, Boolean.toString(defaultValue));
    }

    public boolean asBool(String key, String defaultValue) {
        String value = this.getProperty(key, defaultValue);
        return value.equals("1") || value.equalsIgnoreCase(TRUE);
    }

    public double asDouble(String key) {
        return Double.parseDouble(this.getProperty(key));
    }

    @Override
    public String getProperty(String key) {
        return super.getProperty(key.toUpperCase());
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String prop = super.getProperty(key.toUpperCase(), defaultValue);
        return prop == null ? null : prop.trim();
    }

    @Override
    public synchronized void putAll(Map<? extends Object, ? extends Object> t) {
        for (Map.Entry<? extends Object, ? extends Object> e : t.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public synchronized Object put(Object key, Object value) {
        return super.put(key.toString().toUpperCase(), value);
    }

    @Override
    public synchronized Object setProperty(String key, String value) {
        return super.setProperty(key.toUpperCase(), value);
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return super.containsKey(key.toString().toUpperCase());
    }

    @Override
    public synchronized Object remove(Object key) {
        return super.remove(key.toString().toUpperCase());
    }

    public void setParent(Properties p) {
        this.defaults = p;
    }
}

