/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.ASFException;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.Interval;
import com.informix.lang.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;

public class IfxDataInputStream
extends InputStream {
    private InputStream is;
    private final int one = 1;
    private boolean usestrenc = false;
    private final byte[] smint_buf = new byte[2];
    private final byte[] int_buf = new byte[4];
    private final byte[] lgint_buf = new byte[10];
    private final byte[] long_buf = new byte[8];
    private int bytesRead;
    private int totalBytesRead;

    public IfxDataInputStream(InputStream i) {
        this.is = i;
    }

    public IfxDataInputStream(InputStream i, boolean encoption) {
        this.is = i;
        this.usestrenc = encoption;
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.is.read(b);
    }

    public byte readByte() throws IOException {
        int ch = this.is.read();
        return (byte)ch;
    }

    public int readFully(byte[] b) throws IOException {
        return this.readFully(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        return this.is.read(b, offset, length);
    }

    public int readFully(byte[] b, int offset, int length) throws IOException {
        this.totalBytesRead = 0;
        while (this.totalBytesRead < length) {
            this.bytesRead = this.is.read(b, offset + this.totalBytesRead, length - this.totalBytesRead);
            if (this.bytesRead < 0) {
                throw new IOException();
            }
            this.totalBytesRead += this.bytesRead;
        }
        return this.totalBytesRead;
    }

    public int readPadded(byte[] b, int offset, int length) throws IOException {
        int bytesRead = 0;
        bytesRead = this.readFully(b, offset, length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return bytesRead;
    }

    public int readPadded(byte[] b) throws IOException {
        int bytesRead = this.readFully(b, 0, b.length);
        if ((b.length & 1) >= 1) {
            this.read();
        }
        return bytesRead;
    }

    public int skipBytes(int n) throws IOException {
        int i = 0;
        while ((i += (int)this.is.skip(n - i)) < n) {
        }
        return n;
    }

    public int readInt() throws IOException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaInt(this.int_buf);
    }

    public String readChar() throws IOException, ASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw Messages.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((b1.length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaChar(b1, this.usestrenc);
    }

    public String readChar(String dbEnc) throws IOException, ASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw Messages.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((b1.length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaChar(b1, dbEnc, this.usestrenc);
    }

    public Date readDate() throws IOException, ASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaDate(this.int_buf);
    }

    public Timestamp readDateTime(short prec) throws IOException, ASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw Messages.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaDateTime(b1, prec);
    }

    public byte[] readRawDateTime(short prec) throws IOException, ASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw Messages.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return b1;
    }

    public Interval readInterval(short prec) throws IOException, ASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw Messages.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaInterval(b1, prec);
    }

    public BigDecimal readDecimal(short prec) throws IOException, ASFException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        short length = IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
        if (length < 0) {
            throw Messages.getAsfException(-408);
        }
        byte[] b1 = new byte[length];
        this.readFully(b1, 0, b1.length);
        if ((length & 1) >= 1) {
            this.read();
        }
        return IfxToJavaType.IfxToJavaDecimal(b1, prec);
    }

    public double readDouble(short prec) throws IOException, ASFException {
        this.readFully(this.long_buf, 0, this.long_buf.length);
        return IfxToJavaType.IfxToJavaDouble(this.long_buf);
    }

    public float readReal(short prec) throws IOException, ASFException {
        this.readFully(this.int_buf, 0, this.int_buf.length);
        return IfxToJavaType.IfxToJavaReal(this.int_buf);
    }

    public short readSmallInt() throws IOException {
        this.readFully(this.smint_buf, 0, this.smint_buf.length);
        return IfxToJavaType.IfxToJavaSmallInt(this.smint_buf);
    }

    public short readShort() throws IOException {
        return this.readSmallInt();
    }

    public long readLongInt() throws IOException {
        this.readFully(this.lgint_buf, 0, this.lgint_buf.length);
        return IfxToJavaType.IfxToJavaLongInt(this.lgint_buf);
    }

    public long readLong() throws IOException {
        return this.readLongInt();
    }

    public long readLongBigint() throws IOException {
        this.readFully(this.long_buf, 0, this.long_buf.length);
        return IfxToJavaType.IfxToJavaLongBigInt(this.long_buf);
    }
}

