/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSavepoint;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxResultSet;
import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class IfxSavepoint
implements IfmxSavepoint {
    public static final String SAVEPOINT_PREFIX = "JDBC_GENERATED_SAVEPOINT_";
    private final int savepointId;
    private final String savepointName;
    final IfxConnection connection;
    private final ArrayList<WeakReference<ResultSet>> resultSetList = new ArrayList();

    IfxSavepoint(IfxConnection conn, String savepointName, int savepointID) {
        this.connection = conn;
        this.savepointName = savepointName;
        this.savepointId = savepointID;
    }

    IfxSavepoint(IfxConnection conn, int savepointId) {
        this.connection = conn;
        this.savepointId = savepointId;
        this.savepointName = SAVEPOINT_PREFIX + savepointId;
    }

    @Override
    public int getSavepointId() {
        return this.savepointId;
    }

    @Override
    public String getSavepointName() {
        return this.savepointName;
    }

    protected synchronized void addResultSet(ResultSet rs) {
        this.resultSetList.add(new WeakReference<ResultSet>(rs));
    }

    protected synchronized void closeResultSet() throws SQLException {
        ResultSet rs = null;
        for (WeakReference<ResultSet> weakRs : this.resultSetList) {
            rs = (ResultSet)weakRs.get();
            if (rs == null) continue;
            try {
                ((IfxResultSet)rs).isClosed = true;
                rs.close();
            }
            catch (SQLException e) {
                if (e.getErrorCode() != -259) continue;
                ((IfxResultSet)rs).stmt.cursorOpen = true;
            }
        }
    }
}

