/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxObject;
import com.informix.lang.IfxToJavaType;
import com.informix.lang.JavaToIfxType;
import com.informix.lang.Messages;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;

public class IfxSmallFloat
extends IfxObject {
    private float value;

    IfxSmallFloat() throws SQLException {
        this.setIfxType(4);
    }

    @Override
    public byte[] toIfx() {
        return JavaToIfxType.JavaToIfxReal(this.value);
    }

    @Override
    public byte[] toIfxTuple() {
        if (this.isNull()) {
            byte[] b = new byte[4];
            Arrays.fill(b, (byte)-1);
            return b;
        }
        return JavaToIfxType.JavaToIfxReal(this.value);
    }

    @Override
    public void fromIfx(byte[] b) {
        this.fromIfx(b, 0, b.length);
    }

    @Override
    public void fromIfx(byte[] b, int offset, int length) {
        boolean null_flg = true;
        null_flg = IfxSmallFloat.isIfxNull(b, offset, length);
        if (!null_flg) {
            this.unnullify();
            this.value = IfxToJavaType.IfxToJavaReal(b, offset);
        } else {
            this.nullify();
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this.isNull() || other == null) {
            return false;
        }
        if (other instanceof IfxSmallFloat) {
            IfxSmallFloat floatOther = (IfxSmallFloat)other;
            if (floatOther.isNull()) {
                return false;
            }
            return this.value == floatOther.value;
        }
        return false;
    }

    @Override
    public Object toObject() {
        if (this.isNull()) {
            return null;
        }
        return Float.valueOf(this.value);
    }

    @Override
    public byte toByte() throws SQLException {
        this.clearWarning();
        byte b = this.isNull() ? (byte)0 : (byte)this.value;
        return b;
    }

    @Override
    public void fromByte(Byte b) throws SQLException {
        if (b == null) {
            this.nullify();
        } else {
            this.fromByte((byte)b);
        }
    }

    @Override
    public void fromByte(byte b) throws SQLException {
        this.value = b;
        this.unnullify();
    }

    @Override
    public short toShort() throws SQLException {
        this.clearWarning();
        short s = this.isNull() ? (short)0 : (short)this.value;
        return s;
    }

    @Override
    public void fromShort(Short s) throws SQLException {
        if (s == null) {
            this.nullify();
        } else {
            this.fromShort((short)s);
        }
    }

    @Override
    public void fromShort(short s) throws SQLException {
        this.value = s;
        this.unnullify();
    }

    @Override
    public int toInt() throws SQLException {
        int i;
        this.clearWarning();
        if (this.isNull()) {
            i = 0;
        } else {
            i = (int)this.value;
            if (i <= Integer.MIN_VALUE) {
                i = -2147483647;
            }
        }
        return i;
    }

    @Override
    public void fromInt(Integer i) throws SQLException {
        if (i == null) {
            this.nullify();
        } else {
            this.fromInt((int)i);
        }
    }

    @Override
    public void fromInt(int i) throws SQLException {
        this.value = i;
        this.unnullify();
    }

    @Override
    public long toLong() throws SQLException {
        this.clearWarning();
        long l = this.isNull() ? 0L : (long)this.value;
        return l;
    }

    @Override
    public void fromLong(Long l) throws SQLException {
        if (l == null) {
            this.nullify();
        } else {
            this.fromLong((long)l);
        }
    }

    @Override
    public void fromLong(long l) throws SQLException {
        this.value = l;
        this.unnullify();
    }

    @Override
    public double toDouble() throws SQLException {
        double d = this.isNull() ? 0.0 : (double)this.value;
        return d;
    }

    @Override
    public void fromDouble(Double d) throws SQLException {
        if (d == null) {
            this.nullify();
        } else {
            this.fromDouble((double)d);
        }
    }

    @Override
    public void fromDouble(double d) throws SQLException {
        this.value = (float)d;
        this.unnullify();
    }

    @Override
    public float toFloat() {
        if (this.isNull()) {
            return 0.0f;
        }
        return this.value;
    }

    @Override
    public void fromFloat(Float f) throws SQLException {
        if (f == null) {
            this.nullify();
        } else {
            this.fromFloat(f.floatValue());
        }
    }

    @Override
    public void fromFloat(float f) throws SQLException {
        this.value = f;
        this.unnullify();
    }

    @Override
    public BigDecimal toDecimal() throws SQLException {
        if (this.isNull()) {
            return null;
        }
        return new BigDecimal(this.value);
    }

    @Override
    public void fromDecimal(BigDecimal bigdec) throws SQLException {
        if (bigdec == null) {
            this.nullify();
        } else {
            this.value = bigdec.floatValue();
            this.unnullify();
        }
    }

    @Override
    public boolean toBoolean() throws SQLException {
        boolean b = this.isNull() ? false : this.value != 0.0f;
        return b;
    }

    @Override
    public void fromBoolean(Boolean b) throws SQLException {
        if (b == null) {
            this.nullify();
        } else {
            this.fromBoolean((boolean)b);
            this.unnullify();
        }
    }

    @Override
    public void fromBoolean(boolean b) throws SQLException {
        this.value = b ? 1 : 0;
        this.unnullify();
    }

    @Override
    public String toString() {
        String s = this.isNull() ? null : Float.toString(this.value);
        return s;
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (str == null) {
            this.nullify();
        } else {
            try {
                this.value = Float.valueOf(str.trim()).floatValue();
                this.unnullify();
            }
            catch (Exception e) {
                this.nullify();
                throw Messages.getSQLException(-79716, e.toString(), this.conn);
            }
        }
    }

    static boolean isIfxNull(float f) {
        byte[] b = JavaToIfxType.JavaToIfxReal(f);
        return IfxSmallFloat.isIfxNull(b);
    }

    static boolean isIfxNull(byte[] b) {
        return IfxSmallFloat.isIfxNull(b, 0, b.length);
    }

    static boolean isIfxNull(byte[] b, int offset, int length) {
        for (int i = 0; i < 4; ++i) {
            if (b[i + offset] == -1) continue;
            return false;
        }
        return true;
    }

    static float getIfxNull() {
        byte[] b = new byte[4];
        float f = 0.0f;
        for (int i = 0; i < 4; ++i) {
            b[i] = -1;
            f = IfxToJavaType.IfxToJavaReal(b);
        }
        return f;
    }
}

