/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.ASFException;
import com.informix.asf.ConnectionHeaders;
import com.informix.asf.IfxDataInputStream;
import com.informix.asf.IfxDataOutputStream;
import com.informix.asf.SqliConnectionProperties;
import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCallableStatement;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDatabaseMetaData;
import com.informix.jdbc.IfxDriver;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxLocales;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSavepoint;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxStatement;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.jdbc.NativeSQL;
import com.informix.jdbc.PreparedStatementCache;
import com.informix.jdbc.Version;
import com.informix.jdbc.types.TypeInfo;
import com.informix.jdbcx.AbstractDataSource;
import com.informix.jdbcx.IfxDataSource;
import com.informix.jdbcx.InformixDataSource;
import com.informix.jdbcx.TypeMapFactory;
import com.informix.lang.IfxTypes;
import com.informix.lang.Messages;
import com.informix.lang.WarningMessages;
import com.informix.util.AdvancedUppercaseProperties;
import com.informix.util.CaseMap;
import com.informix.util.DelayedWeakReference;
import com.informix.util.JdbcLogger;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.SocketException;
import java.nio.file.Files;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;

public class IfxSqliConnect
implements IfxConnection {
    private static final JdbcLogger lg = JdbcLogger.getLogger(IfxSqliConnect.class);
    private static final Object logger = lg;
    private final long id;
    private static final AtomicLong CONNECTION_COUNTER = new AtomicLong();
    private boolean isBigIntType;
    private boolean isBigSerialType;
    private boolean useUpperCaseMetadataLabels;
    protected final List<File> fileList;
    public static final String JDBCExtVer = "9.280";
    public static final int JDBCIntVer = 316;
    private static final int NEW_HANDSHAKE_VERSION = 316;
    private Trace trace;
    protected final PreparedStatementCache implicitCache;
    private final byte[] clientProtocols;
    public static final short HASLOG = 1;
    protected static final short ANSIMODE = 2;
    private static final short FLT2DEC = 8;
    private static final short CHGLOC = 64;
    public static final short ANSIWARN = 16;
    private static final int XPS8_40 = 18;
    private static final int USVER9_0324 = 44;
    private static final int USVER9_0332 = 52;
    private static final int USVER9_0334 = 54;
    private static final int USVER9_0336 = 56;
    private static final int USVER9_0339 = 59;
    private static final int USVER9_0341 = 61;
    private static final int USVER9_0342 = 62;
    private static final int USVER9_0343 = 63;
    private static final int USVER9_0349 = 69;
    private static final int USVER9_0350 = 70;
    private static final int MAXFEATURE = 70;
    static final short NOXACT = 0;
    static final short SXACT = 1;
    static final short XACT = 2;
    private static final int DRSECOND = 32;
    private static final String PREFIX = "_ifxc";
    private static final String ZEROSTRING = "0000000000000";
    private final AtomicLong nextID;
    private SQLWarning connwarn;
    private boolean isOpen;
    protected boolean softCloseDone;
    private final BitSet dbVersion;
    private int internalVersion;
    protected String externalVersion;
    protected String productName;
    private boolean floatToDec;
    protected com.informix.asf.Connection asfconn;
    protected boolean encoption;
    protected IfxProtocol proto;
    protected AdvancedUppercaseProperties connInfo;
    protected final String userName;
    private String org_url;
    private boolean ifCommit;
    protected String dbName;
    private String dbLocale;
    protected boolean freeclobwithrs;
    private String dbEncoding;
    private String clLocale;
    private String clEncoding;
    private String dbDate;
    private String glDate;
    private boolean useDtenv;
    private boolean noLogAutoCommit;
    private String dbTime;
    private String glDateTime;
    private boolean is_client_loc_set;
    private boolean is_db_loc_set;
    private long dbTodayDate;
    private long dbTodayStart;
    private boolean loreadonly;
    private int codesetLobSize;
    Hashtable<String, String> IfxToJdkEncodingTable;
    Hashtable<String, String> IfxNoToJdkEncodingTable;
    Hashtable<String, String> IfxToJdkLocaleTable;
    Hashtable<String, String[]> NLSToJDK;
    protected boolean Noansiwarn;
    protected boolean delimIdent;
    private int retryCount;
    String servername;
    int fetchBufSize;
    private int lobCacheSize;
    protected boolean ifxAllowOut;
    protected boolean useCaseCapName;
    private AdvancedUppercaseProperties PrimEnvVars;
    private Properties SecEnvVars;
    Hashtable<String, FPCacheInfo> fpCache;
    private IfxDataInputStream InputStream;
    private IfxDataOutputStream OutputStream;
    protected final Trace traceObj;
    protected final Trace protoTraceObj;
    boolean autoCommit;
    private int transactionLevel;
    short TxState;
    boolean SendCommit;
    private boolean isDatabaseOpen;
    boolean db_use_log;
    boolean AnsiDb;
    private boolean chgLocale;
    private short SerWarn;
    private boolean TrimTrailingSpaces;
    boolean readOnly;
    boolean hdrEnabled;
    private int sqllogicalchar;
    int CapList;
    int TypeList;
    private boolean autoFree;
    protected boolean usePut;
    private boolean ifxPADVARCHAR;
    boolean appendIsam;
    boolean optofc;
    private final ReentrantLock sessionLock;
    private boolean lockModeWaitChanged;
    private boolean isolationLevelChanged;
    private String newLockModeWaitStr;
    private String newIsolationLevelStr;
    private int newTxLevel;
    private Map<String, IfxUDTInfo> udtMap;
    private Map<Integer, IfxUDTInfo> xidMap;
    private Map<String, Class<?>> userMap;
    private boolean useTypeCache;
    private int internalQuery;
    private static final int IQstart = 1;
    private static final int IQsendCommit = 2;
    private boolean autoCommitModeChanged;
    boolean resultSetHoldability;
    private String tempdir;
    protected final Vector<StmtList> stmtList;
    private String databaseProductVersion;
    private final AtomicInteger savePointCounter;
    protected final ReferenceQueue<IfxStatement> stmtReferenceQueue;
    protected static final BlockingQueue<DelayedWeakReference<IfxSqliConnect>> queueOfConnections = new DelayQueue<DelayedWeakReference<IfxSqliConnect>>();
    protected static ExecutorService cleaner = null;
    protected final long cleanerDelay;
    private int stmtErrorOffset;
    protected boolean replCheck;
    private Hashtable<Integer, WeakReference<IfxSmartBlob>> blobTable;
    protected ArrayList<WeakReference<Savepoint>> svptList;
    private final FinalizedBlobsTable finalizedBlobs;
    private boolean autoCaseSchema;
    private Timer statementTimer;
    private boolean processTableNameForResultSet;

    synchronized void ensureConnectionMonitorThreadIsRunning() {
        queueOfConnections.offer(new DelayedWeakReference<IfxSqliConnect>(this, this.cleanerDelay));
        if (cleaner == null && this.cleanerDelay > 0L) {
            cleaner = Executors.newFixedThreadPool(1, new IfxSqliConnectCleanerThreadFactory());
            cleaner.execute(new IfxSqliConnectCleaner());
        }
    }

    public void removeFromBlobTable(Integer hashKey) {
        if (this.blobTable != null) {
            this.blobTable.remove(hashKey);
        }
    }

    void addLoFdToFinalizedBlobQueue(int loFd, IfxLocator locator) {
        this.finalizedBlobs.add(new FinalizedBlobInfo(loFd, locator));
    }

    public boolean doesBlobNeedPurge() {
        return this.finalizedBlobs.needPurge();
    }

    void closeFinalizedBlobsOnServer() {
        block8: {
            if (!this.finalizedBlobs.needPurge()) {
                return;
            }
            boolean needCommit = false;
            boolean foundSome = false;
            lg.debug("Releasing left open LOB descriptors");
            needCommit = !this.inXATransaction() && !this.isInUserTransaction() && this.db_use_log && !this.autoCommit;
            IfxSmartBlob smb = new IfxSmartBlob(this);
            boolean bailout = false;
            while (this.finalizedBlobs.hasElements() && !bailout) {
                FinalizedBlobInfo el = this.finalizedBlobs.remove();
                if (el == null) continue;
                foundSome = true;
                try {
                    lg.debug("Releasing LOB file descriptor: {}", el.getLoFd());
                    smb.IfxLoClose(el.getLoFd());
                    smb.IfxLoRelease(el.getLocator());
                }
                catch (SQLException e) {
                    if (e.getErrorCode() != -9810) {
                        bailout = true;
                    }
                    if (!TraceFlag.isTraceEnabled()) continue;
                    this.traceObj.writeTrace(logger, 2, "closeFinalizedBlobsOnServer:     exception. lofd=" + el + ";bailout=" + bailout);
                }
            }
            if (foundSome && needCommit) {
                try {
                    this.commit();
                }
                catch (Exception e) {
                    if (!lg.isTraceEnabled()) break block8;
                    lg.error("Exception committing LOB file descriptor release", e);
                }
            }
        }
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    public static String logConnectionProperties(Properties p) {
        boolean isFirst = true;
        StringBuilder sb = new StringBuilder("Connection Properties: {");
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            if (entry.getKey().toString().equalsIgnoreCase("PASSWORD")) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey().toString()).append('=').append(entry.getValue().toString());
        }
        sb.append('}');
        return sb.toString();
    }

    public IfxSqliConnect() throws SQLException {
        this.id = CONNECTION_COUNTER.incrementAndGet();
        this.isBigIntType = false;
        this.isBigSerialType = false;
        this.useUpperCaseMetadataLabels = false;
        this.fileList = new ArrayList<File>(10);
        this.trace = new Trace();
        this.clientProtocols = new byte[]{-1, -4, 127, -4, 60, -116, -86, -105, 6};
        this.nextID = new AtomicLong(0L);
        this.connwarn = null;
        this.isOpen = false;
        this.softCloseDone = false;
        this.dbVersion = new BitSet(70);
        this.internalVersion = 0;
        this.externalVersion = null;
        this.productName = null;
        this.floatToDec = false;
        this.asfconn = null;
        this.encoption = false;
        this.proto = null;
        this.connInfo = null;
        this.org_url = null;
        this.ifCommit = true;
        this.dbName = null;
        this.dbLocale = null;
        this.freeclobwithrs = false;
        this.dbEncoding = null;
        this.clLocale = null;
        this.clEncoding = null;
        this.dbDate = null;
        this.glDate = null;
        this.useDtenv = false;
        this.noLogAutoCommit = true;
        this.dbTime = null;
        this.glDateTime = null;
        this.is_client_loc_set = false;
        this.is_db_loc_set = false;
        this.dbTodayDate = -1L;
        this.dbTodayStart = -1L;
        this.loreadonly = false;
        this.codesetLobSize = -1;
        this.IfxToJdkEncodingTable = null;
        this.IfxNoToJdkEncodingTable = null;
        this.IfxToJdkLocaleTable = null;
        this.NLSToJDK = null;
        this.Noansiwarn = true;
        this.delimIdent = false;
        this.retryCount = 0;
        this.servername = "";
        this.fetchBufSize = -1;
        this.lobCacheSize = 16384;
        this.ifxAllowOut = false;
        this.useCaseCapName = false;
        this.fpCache = null;
        this.InputStream = null;
        this.OutputStream = null;
        this.traceObj = new Trace();
        this.protoTraceObj = new Trace();
        this.autoCommit = true;
        this.transactionLevel = 0;
        this.TxState = 0;
        this.SendCommit = false;
        this.isDatabaseOpen = false;
        this.db_use_log = false;
        this.AnsiDb = false;
        this.chgLocale = false;
        this.TrimTrailingSpaces = false;
        this.readOnly = false;
        this.hdrEnabled = false;
        this.sqllogicalchar = -1;
        this.CapList = 0;
        this.TypeList = 0;
        this.autoFree = false;
        this.usePut = false;
        this.ifxPADVARCHAR = false;
        this.appendIsam = false;
        this.optofc = false;
        this.sessionLock = new ReentrantLock();
        this.newTxLevel = 0;
        this.udtMap = null;
        this.xidMap = null;
        this.userMap = null;
        this.useTypeCache = false;
        this.internalQuery = 0;
        this.autoCommitModeChanged = false;
        this.resultSetHoldability = false;
        this.tempdir = null;
        this.stmtList = new Vector(20);
        this.databaseProductVersion = null;
        this.savePointCounter = new AtomicInteger(0);
        this.stmtReferenceQueue = new ReferenceQueue();
        this.stmtErrorOffset = 0;
        this.replCheck = true;
        this.blobTable = null;
        this.svptList = null;
        this.finalizedBlobs = new FinalizedBlobsTable();
        this.autoCaseSchema = true;
        this.statementTimer = null;
        this.processTableNameForResultSet = true;
        this.implicitCache = new PreparedStatementCache(this, 0);
        this.cleanerDelay = 0L;
        this.userMap = TypeMapFactory.createMap(false);
        this.autoCaseSchema = true;
        this.userName = null;
    }

    public IfxSqliConnect(AbstractDataSource ds) throws SQLException {
        block45: {
            String[] localeInfo;
            this.id = CONNECTION_COUNTER.incrementAndGet();
            this.isBigIntType = false;
            this.isBigSerialType = false;
            this.useUpperCaseMetadataLabels = false;
            this.fileList = new ArrayList<File>(10);
            this.trace = new Trace();
            this.clientProtocols = new byte[]{-1, -4, 127, -4, 60, -116, -86, -105, 6};
            this.nextID = new AtomicLong(0L);
            this.connwarn = null;
            this.isOpen = false;
            this.softCloseDone = false;
            this.dbVersion = new BitSet(70);
            this.internalVersion = 0;
            this.externalVersion = null;
            this.productName = null;
            this.floatToDec = false;
            this.asfconn = null;
            this.encoption = false;
            this.proto = null;
            this.connInfo = null;
            this.org_url = null;
            this.ifCommit = true;
            this.dbName = null;
            this.dbLocale = null;
            this.freeclobwithrs = false;
            this.dbEncoding = null;
            this.clLocale = null;
            this.clEncoding = null;
            this.dbDate = null;
            this.glDate = null;
            this.useDtenv = false;
            this.noLogAutoCommit = true;
            this.dbTime = null;
            this.glDateTime = null;
            this.is_client_loc_set = false;
            this.is_db_loc_set = false;
            this.dbTodayDate = -1L;
            this.dbTodayStart = -1L;
            this.loreadonly = false;
            this.codesetLobSize = -1;
            this.IfxToJdkEncodingTable = null;
            this.IfxNoToJdkEncodingTable = null;
            this.IfxToJdkLocaleTable = null;
            this.NLSToJDK = null;
            this.Noansiwarn = true;
            this.delimIdent = false;
            this.retryCount = 0;
            this.servername = "";
            this.fetchBufSize = -1;
            this.lobCacheSize = 16384;
            this.ifxAllowOut = false;
            this.useCaseCapName = false;
            this.fpCache = null;
            this.InputStream = null;
            this.OutputStream = null;
            this.traceObj = new Trace();
            this.protoTraceObj = new Trace();
            this.autoCommit = true;
            this.transactionLevel = 0;
            this.TxState = 0;
            this.SendCommit = false;
            this.isDatabaseOpen = false;
            this.db_use_log = false;
            this.AnsiDb = false;
            this.chgLocale = false;
            this.TrimTrailingSpaces = false;
            this.readOnly = false;
            this.hdrEnabled = false;
            this.sqllogicalchar = -1;
            this.CapList = 0;
            this.TypeList = 0;
            this.autoFree = false;
            this.usePut = false;
            this.ifxPADVARCHAR = false;
            this.appendIsam = false;
            this.optofc = false;
            this.sessionLock = new ReentrantLock();
            this.newTxLevel = 0;
            this.udtMap = null;
            this.xidMap = null;
            this.userMap = null;
            this.useTypeCache = false;
            this.internalQuery = 0;
            this.autoCommitModeChanged = false;
            this.resultSetHoldability = false;
            this.tempdir = null;
            this.stmtList = new Vector(20);
            this.databaseProductVersion = null;
            this.savePointCounter = new AtomicInteger(0);
            this.stmtReferenceQueue = new ReferenceQueue();
            this.stmtErrorOffset = 0;
            this.replCheck = true;
            this.blobTable = null;
            this.svptList = null;
            this.finalizedBlobs = new FinalizedBlobsTable();
            this.autoCaseSchema = true;
            this.statementTimer = null;
            this.processTableNameForResultSet = true;
            if (lg.isDebugEnabled()) {
                lg.debug("{}", (Object)Version.getVersionAsString());
                lg.debug("Creating Connection #{}. Properties: {}", this.id, (Object)IfxSqliConnect.logConnectionProperties(ds));
            }
            this.connInfo = ds;
            this.cleanerDelay = ds.asLong("connectionCleanerDelay");
            this.ensureConnectionMonitorThreadIsRunning();
            this.implicitCache = new PreparedStatementCache(this, ds.asInt("preparedStatementCacheSize"));
            this.userName = ds.asString("user").trim();
            this.useUpperCaseMetadataLabels = ds.asBool("metadataUppercaseValues");
            this.setHoldability(ds.asInt("defaultCursorHoldability"));
            this.autoCaseSchema = ds.asBool("autoCaseSchema");
            this.Noansiwarn = !ds.asBool("DBANSIWARN", false);
            this.fetchBufSize = ds.asInt("resultsBufferSize");
            this.lobCacheSize = ds.asInt("lobBufferSize");
            this.retryCount = ds.asInt("loginRetries");
            this.delimIdent = ds.asBool("delimident");
            this.userMap = TypeMapFactory.createMap(this.delimIdent);
            this.servername = ds.asString("serverName", "");
            this.tempdir = ds.asString("tempDir");
            this.useTypeCache = ds.asBool("udtCache");
            this.useDtenv = ds.asBool("USE_DTENV", "false");
            this.processTableNameForResultSet = ds.asBool("processTableNameInResultSets", "true");
            this.PrimEnvVars = this.SetPrimEVars();
            if (ds.containsKey("DB_LOCALE")) {
                localeInfo = this.parseLocale(ds.asString("DB_LOCALE"));
                this.dbEncoding = localeInfo[1];
                this.dbLocale = localeInfo[0];
                ds.put("DBENC", this.dbEncoding);
            }
            if (ds.containsKey("CLIENT_LOCALE")) {
                localeInfo = this.parseLocale(ds.asString("CLIENT_LOCALE"));
                this.clEncoding = localeInfo[1];
                this.clLocale = localeInfo[0];
            }
            this.encoption = ds.asBool("replaceUnmappableCharacterSequences");
            this.replCheck = ds.asBool("metadataReplicationColumn");
            this.noLogAutoCommit = ds.asBool("invalidAutoCommitThrowError");
            this.ifCommit = ds.asBool("commitBeforeIsolationChange");
            this.appendIsam = ds.asBool("appendIsamCodeToSqlException");
            this.autoFree = ds.asBool("autoFreeCursors");
            this.optofc = ds.asBool("optOFC");
            this.usePut = ds.asBool("batchInsertPreprocessing");
            this.TrimTrailingSpaces = ds.asBool("trimTrailingSpaces");
            this.ifxPADVARCHAR = ds.asBool("padVarchar");
            this.loreadonly = ds.asBool("lobReadonly");
            this.codesetLobSize = ds.asInt("lobCodesetConversionMemory");
            this.dbTime = ds.asString("DBTIME");
            this.freeclobwithrs = ds.asBool("removeLobTempFilesOnRSClose");
            this.useCaseCapName = ds.asBool("uppercaseMetaDataRSColumnNames");
            this.glDateTime = ds.asString("GL_DATETIME");
            this.setupCustomEncoders(ds.getProperty("customLocale"), ds.getProperty("customCodeSet"), ds.getProperty("customNLSMap"));
            ConnectionHeaders.ConnectionTarget ct = new ConnectionHeaders.ConnectionTarget(ds.asString("host"), ds.asString("port"), this.servername);
            try {
                this.asfconn = new com.informix.asf.Connection(ct, this.dbName, this.PrimEnvVars, this.retryCount, ds);
            }
            catch (SQLException e2) {
                String errtxt = e2.toString();
                int sqlcode = e2.getErrorCode();
                if (sqlcode == -79998) {
                    ct = new ConnectionHeaders.ConnectionTarget(errtxt);
                    try {
                        this.asfconn = new com.informix.asf.Connection(ct, this.dbName, this.PrimEnvVars, this.retryCount, ds);
                    }
                    catch (SQLException ree2) {
                        throw ree2;
                    }
                    catch (Exception ree) {
                        SQLException rsqle = Messages.getSQLException(-79999, ree.toString(), (IfxConnection)this);
                        throw Messages.setSQLExceptionCause(rsqle, ree);
                    }
                }
                if (ds.asBool("secondarySwitch") && (sqlcode == -908 || sqlcode == -27002)) {
                    try {
                        ct = new ConnectionHeaders.ConnectionTarget(ds.asString("secondaryHost"), ds.asString("secondaryPort"), ds.asString("secondaryServerName"));
                        this.asfconn = new com.informix.asf.Connection(ct, this.dbName, this.PrimEnvVars, this.retryCount, ds);
                    }
                    catch (SQLException ee2) {
                        String text = ee2.toString();
                        int sqlCode = ee2.getErrorCode();
                        if (sqlCode == -79998) {
                            ct = new ConnectionHeaders.ConnectionTarget(errtxt);
                            try {
                                this.asfconn = new com.informix.asf.Connection(ct, this.dbName, this.PrimEnvVars, this.retryCount, ds);
                                break block45;
                            }
                            catch (SQLException ree2) {
                                throw ree2;
                            }
                            catch (Exception ree) {
                                SQLException rsqle = Messages.getSQLException(-79999, ree.getMessage(), (IfxConnection)this);
                                throw Messages.setSQLExceptionCause(rsqle, ree);
                            }
                        }
                        if (text != null && text.length() > 0) {
                            SQLException sqle = new SQLException(ee2.getMessage(), Messages.getSQLSTATE(sqlCode), sqlCode);
                            throw Messages.setSQLExceptionCause(sqle, ee2);
                        }
                        SQLException sqle = Messages.getSQLException(sqlCode);
                        throw Messages.setSQLExceptionCause(sqle, ee2);
                    }
                    catch (Exception ee) {
                        SQLException sqle = Messages.getSQLException(-79999, ee.getMessage(), (IfxConnection)this);
                        throw Messages.setSQLExceptionCause(sqle, ee);
                    }
                }
                throw e2;
            }
            catch (Exception e) {
                throw Messages.getSQLException(e, -79716);
            }
        }
        this.internalVersion = this.asfconn.Cap_1;
        try {
            int split = this.asfconn.VersionNumber.indexOf("Version");
            this.productName = this.asfconn.VersionNumber.substring(0, split - 1).trim();
            this.externalVersion = this.asfconn.VersionNumber.substring(split + 7).trim();
        }
        catch (Exception e) {
            this.productName = "Informix Dynamic Server";
        }
        this.SerWarn = this.asfconn.Warnings;
        this.setWarnings();
        if ((this.SerWarn & 0x20) != 0) {
            this.readOnly = true;
        }
        if ((this.SerWarn & 8) != 0) {
            this.floatToDec = true;
        }
        this.isOpen = true;
        this.InputStream = this.asfconn.getIfxDataInputStream();
        this.OutputStream = this.asfconn.getIfxDataOutputStream();
        this.proto = this.createProto();
        try {
            this.getServerVer();
            if (this.isPAMAuthentication()) {
                this.proto.handlePAMAuthentication(this.connInfo.getProperty("IFX_PAM_CLASS"));
            }
            if (this.isPrivateServerEnabled()) {
                boolean isCorrect = this.proto.handlePrivateServerExchange();
                if (TraceFlag.isTraceEnabled()) {
                    this.traceObj.writeTrace(logger, 99, "Exiting IfxSqliConnect.isPrivateServerEnabled()");
                    if (isCorrect) {
                        this.traceObj.writeTrace(logger, 99, "PrivateServer Exchange Successfully authenticated.");
                    } else {
                        this.traceObj.writeTrace(logger, 99, "PrivateServer Exchange authentication failed.");
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                this.close();
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
        this.SecEnvVars = IfxSqliConnect.createSecondaryEnvironmentList(this.connInfo);
        try {
            this.proto.executeEnv(this.SecEnvVars);
        }
        catch (SQLException e) {
            try {
                this.close();
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw Messages.getSQLException(-79716, this);
        }
        this.fpCache = new Hashtable();
        String dbtoday = this.SecEnvVars.getProperty("DBTODAY");
        if (dbtoday != null) {
            try {
                this.dbTodayDate = Timestamp.valueOf(dbtoday).getTime();
                this.dbTodayStart = System.currentTimeMillis();
            }
            catch (Exception e) {
                this.dbTodayDate = -1L;
                this.dbTodayStart = -1L;
            }
        }
        try {
            this.dbName = this.connInfo.getProperty("database");
            if (this.dbName != null) {
                this.dbName = this.dbName.trim().toLowerCase();
                this.proto.executeOpenDatabase(this.dbName, 0);
                this.proto.clear();
            }
            this.setLockModeWait(this.connInfo.asInt("lockTimeout", "0"));
            if (this.connInfo.containsKey("transactionIsolationLevel")) {
                this.setIsolationLevel(this.connInfo.asString("transactionIsolationLevel"));
            }
        }
        catch (SQLException e) {
            try {
                this.close();
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
        this.setSessionVariables();
    }

    public static InformixDataSource convertLegacyConstructorToDataSource(String luser, String lpasswd, String url, Properties prop) {
        IfxDataSource ds = new IfxDataSource();
        ds.setUser(luser);
        ds.setPassword(lpasswd);
        String ipAddr = null;
        String portNo = null;
        if (prop.containsKey("HOST") || prop.containsKey("IFXHOST")) {
            ipAddr = prop.getProperty("HOST", prop.getProperty("IFXHOST"));
            portNo = prop.getProperty("PORT", prop.getProperty("PORTNO"));
        } else if (url != null) {
            int last = url.lastIndexOf(58);
            ipAddr = url.substring(0, last);
            portNo = url.substring(last + 1);
        }
        ds.setIfxIFXHOST(ipAddr);
        ds.setPortNumber(Integer.parseInt(portNo));
        for (Map.Entry<Object, Object> e : prop.entrySet()) {
            ds.addProp(e.getKey().toString().toUpperCase(), e.getValue().toString());
        }
        return ds.toInformixDataSource();
    }

    public void abortConnection() throws SQLException {
        lg.debug("Aborting Connection #{}", this.id);
        this.setOpen(false);
        try {
            this.asfconn.disconnectAbortive();
        }
        finally {
            this.deleteAllFiles();
        }
    }

    @Override
    public void close() throws SQLException {
        block9: {
            block8: {
                if (!this.isOpen) {
                    return;
                }
                lg.debug("Closing connection# {}", this.id);
                this.isOpen = false;
                if (this.statementTimer != null) {
                    this.statementTimer.cancel();
                }
                if (this.isDatabaseOpen) {
                    this.CloseDbReset();
                }
                try {
                    this.closeAllStatements();
                }
                catch (SQLException e) {
                    if (!lg.isTraceEnabled()) break block8;
                    lg.error("Error closing statements", e);
                }
            }
            this.clearWarnings();
            this.dbName = null;
            this.floatToDec = false;
            this.dbVersion.clear();
            this.internalVersion = 0;
            this.externalVersion = null;
            this.databaseProductVersion = null;
            this.InputStream = null;
            this.OutputStream = null;
            this.deleteAllFiles();
            if (this.asfconn != null) {
                try {
                    this.asfconn.disconnectOrderly();
                }
                catch (ASFException e) {
                    if (!lg.isTraceEnabled()) break block9;
                    lg.error("Error disconnecting socket", e);
                }
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return !this.isOpen;
    }

    public void scrubConnection() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "IfxSqliConnect: scrubConnection() called");
        }
        if (!this.isOpen || this.softCloseDone) {
            throw Messages.getSQLException(-79730);
        }
        if (this.dbName != null) {
            this.closeAllResultSets();
            this.clearTransactions(true);
            this.resetDatabaseProperties();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "IfxSqliConnect: scrubConnection() exit");
        }
    }

    protected void clearTransactions(boolean rollbackXids) throws SQLException {
        if (this.TxState == 2) {
            this.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllResultSets() throws SQLException {
        Vector<StmtList> vector = this.stmtList;
        synchronized (vector) {
            WeakReference<IfxStatement> weakStmt = null;
            IfxStatement stmt = null;
            for (int count = 0; count < this.stmtList.size(); ++count) {
                weakStmt = this.stmtList.get((int)count).weakReferenceStmt;
                stmt = (IfxStatement)weakStmt.get();
                if (stmt == null || stmt.Closed || stmt.currentResult == null) continue;
                try {
                    stmt.currentResult.close();
                    continue;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        this.releaseBlob();
    }

    protected void resetDatabaseProperties() throws SQLException {
        Statement stmt = this.createStatement();
        String defIsoLevel = null;
        String sqlstmt = null;
        this.setHoldability(2);
        this.setAutoCommit(true);
        this.transactionLevel = 0;
        if (this.AnsiDb) {
            defIsoLevel = "Repeatable Read";
            this.transactionLevel = 8;
        } else if (this.db_use_log) {
            defIsoLevel = "Committed Read";
            this.transactionLevel = 2;
        }
        if (this.isolationLevelChanged) {
            sqlstmt = this.newIsolationLevelStr + ";";
            this.transactionLevel = this.newTxLevel;
        } else {
            sqlstmt = defIsoLevel != null ? "set isolation to " + defIsoLevel + ";" : "";
        }
        sqlstmt = sqlstmt + "set dataskip default;set explain off;set optimization high;set pdqpriority default;set role null;";
        sqlstmt = this.lockModeWaitChanged ? sqlstmt + this.newLockModeWaitStr + ";" : sqlstmt + "set lock mode to not wait;";
        try {
            stmt.execute(sqlstmt);
        }
        catch (SQLException e) {
            stmt.close();
            throw e;
        }
        stmt.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeAllStatements() throws SQLException {
        Vector<StmtList> vector = this.stmtList;
        synchronized (vector) {
            WeakReference<IfxStatement> weakStmt = null;
            IfxStatement stmt = null;
            while (!this.stmtList.isEmpty()) {
                StmtList stmtNode = this.stmtList.get(0);
                weakStmt = stmtNode.weakReferenceStmt;
                stmt = (IfxStatement)weakStmt.get();
                if (stmt != null && !stmt.Closed) {
                    stmt.setPoolable(false);
                    try {
                        stmt.close();
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() == -267) {
                            lg.error("An error occurred closing statement #{}. Statement was already closed.", (Object)stmt.getId(), e);
                        }
                        throw e;
                    }
                } else {
                    this.proto.executeRelease(stmtNode.stmtId);
                    stmtNode.stmtId = -1;
                }
                this.stmtList.removeElement(stmtNode);
            }
            if (!this.stmtList.isEmpty()) {
                this.stmtList.clear();
            }
        }
    }

    public boolean scrubConnectionReleasesAllStatements() {
        return false;
    }

    @Override
    public void commit() throws SQLException {
        lg.debug("Committing data on connection #{}", this.id);
        if (!this.isOpen) {
            throw Messages.getSQLException(-79730, this);
        }
        if (!this.db_use_log) {
            throw Messages.getSQLException(-79744, this);
        }
        this.clearPending();
        if (!this.autoCommit && this.TxState != 2) {
            return;
        }
        if (this.svptList != null) {
            this.svptList = null;
        }
        try {
            this.releaseBlob();
            this.proto.executeCommit();
        }
        catch (SQLException e) {
            this.setTxEndState();
            throw e;
        }
        catch (Exception e1) {
            this.setTxEndState();
            throw Messages.getSQLException(-79716, e1.toString(), (IfxConnection)this);
        }
        this.setTxEndState();
    }

    @Override
    public void rollback() throws SQLException {
        lg.debug("Rolling back data on connection #{}", this.id);
        if (!this.isOpen) {
            throw Messages.getSQLException(-79730, this);
        }
        if (!this.db_use_log) {
            throw Messages.getSQLException(-79744, this);
        }
        this.clearPending();
        if (!this.autoCommit && this.TxState != 2) {
            return;
        }
        if (this.svptList != null) {
            this.svptList = null;
        }
        try {
            this.releaseBlob();
            this.proto.executeRollback();
        }
        catch (SQLException e) {
            this.setTxEndState();
            throw e;
        }
        catch (Exception e1) {
            this.setTxEndState();
            throw Messages.getSQLException(-79747, e1.toString(), (IfxConnection)this);
        }
        this.setTxEndState();
    }

    @Override
    public void setAutoCommit(boolean newAC) throws SQLException {
        lg.debug("SetAutoCommit start: TxState: {}, AutoCommit: {}", this.TxState, (Object)newAC);
        if (!this.isOpen) {
            throw Messages.getSQLException(-79730, this);
        }
        this.autoCommit = newAC;
        if (this.autoCommit) {
            if (this.TxState == 2) {
                try {
                    this.clearPending();
                    this.proto.executeCommit();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.setTxEndState();
            } else if (this.TxState == 1 && this.AnsiDb) {
                this.SendCommit = true;
            }
        } else {
            if (!this.db_use_log) {
                this.autoCommit = true;
                if (this.noLogAutoCommit) {
                    throw Messages.getSQLException(-79744, this);
                }
            }
            if (this.TxState == 1 && this.AnsiDb) {
                this.SendCommit = false;
            }
        }
        lg.debug("SetAutoCommit end: {}, TxState: {}, SendCommit: {}", this.autoCommit, (Object)this.TxState, (Object)this.SendCommit);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.connwarn = null;
    }

    public String returnEnc() {
        try {
            String dbEnc = this.getdbEncoding();
            String clEnc = this.getclEncoding();
            if (clEnc == null) {
                String clLcl = this.getclLocale();
                int index = clLcl.indexOf(46);
                clEnc = clLcl.substring(index + 1, clLcl.length());
            }
            if (dbEnc == (clEnc = this.getJDKEncoding(clEnc)) || clEnc == null) {
                return dbEnc;
            }
            return clEnc;
        }
        catch (Exception e) {
            System.out.println("EXCEPTION:" + e);
            return null;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        SQLWarning protoWarn;
        if (this.proto != null && (protoWarn = this.proto.getWarnings()) != null) {
            this.addWarning(protoWarn, null);
            this.proto.clearWarnings();
        }
        return this.connwarn;
    }

    void addWarning(SQLWarning excp, String sqlstate) {
        if (excp == null) {
            excp = WarningMessages.getSQLWarning(sqlstate, null);
        }
        if (this.connwarn == null) {
            this.connwarn = excp;
        } else {
            this.connwarn.setNextWarning(excp);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        IfxStatement stmt = new IfxStatement(this);
        this.addToStmtList(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement getStatementWithKey(String key) throws SQLException {
        return this.getCachedPreparedStatement(IfxPreparedStatement.class, key, 1003, 1007, this.getHoldability());
    }

    @Override
    public CallableStatement getCallWithKey(String key) throws SQLException {
        return (CallableStatement)((Object)this.getCachedPreparedStatement(IfxCallableStatement.class, key, 1003, 1007, this.getHoldability()));
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public IfxPreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.getHoldability());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IfxPreparedStatement getCachedPreparedStatement(Class<?> statementClass, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        IfxPreparedStatement preparedStatement;
        PreparedStatementCache preparedStatementCache = this.implicitCache;
        synchronized (preparedStatementCache) {
            preparedStatement = (IfxPreparedStatement)this.implicitCache.remove(sql);
        }
        if (preparedStatement != null) {
            if (preparedStatement.Closed) {
                return null;
            }
            try {
                if (preparedStatement.getResultSetConcurrency() != resultSetConcurrency || preparedStatement.getResultSetType() != resultSetType || preparedStatement.getResultSetHoldability() != resultSetHoldability || preparedStatement.currentResult != null && !preparedStatement.currentResult.isClosed || preparedStatement.getClass() != statementClass) {
                    preparedStatement.setPoolable(false);
                    preparedStatement.close();
                    return null;
                }
            }
            catch (Exception e) {
                return null;
            }
            lg.debug("Reusing {}", preparedStatement);
        }
        return preparedStatement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (autoGeneratedKeys == 2) {
            return this.prepareStatement(sql);
        }
        if (!this.isOpen) {
            throw Messages.getSQLException(-79730, this);
        }
        IfxPreparedStatement stmt = new IfxPreparedStatement((IfxConnection)this, sql, autoGeneratedKeys);
        this.addToStmtList(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (!this.isOpen) {
            throw Messages.getSQLException(-79730);
        }
        IfxPreparedStatement stmt = new IfxPreparedStatement((IfxConnection)this, sql, columnIndexes);
        this.addToStmtList(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (!this.isOpen) {
            throw Messages.getSQLException(-79730);
        }
        IfxPreparedStatement stmt = new IfxPreparedStatement((IfxConnection)this, sql, columnNames);
        this.addToStmtList(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.prepareCall(sql, 1003, 1007, this.getHoldability());
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareCall(sql, resultSetType, resultSetConcurrency, this.getHoldability());
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.userMap;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        if (map == null) {
            throw new NullPointerException("Type map cannot be null");
        }
        this.userMap = map;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return NativeSQL.parseSQLString(this, sql);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (!this.isOpen) {
            throw Messages.getSQLException(-79730);
        }
        return new IfxDatabaseMetaData(this);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.getDbName();
    }

    @Override
    public void setReadOnly(boolean mode) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        if (this.hdrEnabled) {
            String type = this.getHDRType();
            this.readOnly = type != null && type.equalsIgnoreCase("Secondary");
        }
        return this.readOnly;
    }

    @Override
    public int getLOMode() {
        if (this.readOnly || this.loreadonly) {
            return 4;
        }
        return 8;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getHDRType() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isHDREnabled() throws SQLException {
        this.startMetaDataQuery();
        try (Statement stmt = this.createStatement();
             ResultSet rs = stmt.executeQuery("select state from sysmaster:informix.sysdri");){
            if (rs.next()) {
                String state = rs.getString(1);
                this.hdrEnabled = !state.trim().equalsIgnoreCase("off");
            }
        }
        finally {
            this.endMetaDataQuery();
        }
        return this.hdrEnabled;
    }

    @Override
    public int getMaxLvarcharSize() throws SQLException {
        IfxDatabaseMetaData dm = new IfxDatabaseMetaData(this);
        return dm.getMaxLvarcharSize();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        if (level == this.transactionLevel) {
            lg.debug("Transaction Isolation level already set to {}", this.transactionLevel);
            return;
        }
        if (this.getProperties().containsKey("LOCK_ISOLATION")) {
            lg.warn("Transaction Isolation level pre-locked to {}", this.transactionLevel);
            return;
        }
        try (Statement stmt = this.createStatement();){
            this.setTransactionIsolation(level, stmt);
        }
    }

    public void setTransactionIsolation(int level, Statement stmt) throws SQLException {
        String TxLevel = null;
        if (!this.isOpen) {
            throw Messages.getSQLException(-79730);
        }
        if (!this.isDatabaseOpen) {
            throw Messages.getSQLException(-349);
        }
        if (!this.db_use_log) {
            throw Messages.getSQLException(-79746);
        }
        if (!(level == 1 || level == 2 || level == 4 || level == 8 || level == 5 && this.IsLastCommittedSupported())) {
            throw Messages.getSQLException(-79747);
        }
        if (this.TxState == 1) {
            if (level == this.transactionLevel) {
                return;
            }
        } else if (this.TxState == 2 && this.ifCommit) {
            this.commit();
        }
        switch (level) {
            case 1: {
                TxLevel = "dirty read";
                break;
            }
            case 2: {
                TxLevel = "committed read";
                break;
            }
            case 4: 
            case 8: {
                TxLevel = "repeatable read";
                break;
            }
            case 5: {
                TxLevel = "committed read last committed";
            }
        }
        stmt.executeUpdate("set isolation to " + TxLevel);
        if (this.TxState == 2 && this.ifCommit) {
            this.commit();
        }
        this.transactionLevel = level;
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionLevel;
    }

    @Override
    public int getDatabaseType() {
        if (!this.isDatabaseOpen) {
            return 0;
        }
        if (this.AnsiDb) {
            return 1;
        }
        if (this.db_use_log) {
            return 2;
        }
        return 3;
    }

    void setCapList(int CapList) {
        this.CapList = CapList;
    }

    void setTypeList(int TypeList) {
        this.TypeList = TypeList;
    }

    @Override
    public boolean isDbOpen() {
        return this.isDatabaseOpen;
    }

    public String getConnectionDbName() {
        return this.dbName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDbName() throws SQLException {
        if (this.dbName != null) {
            return this.dbName;
        }
        try (Statement stmt = this.createStatement();
             ResultSet rs = stmt.executeQuery("select scs_currdb from sysmaster:informix.syssqlcurses");){
            if (!rs.next()) return null;
            String currDb = rs.getString(1);
            if (currDb != null) {
                currDb = currDb.trim();
            }
            String string = currDb;
            return string;
        }
        catch (SQLException e) {
            return null;
        }
    }

    void setDatabaseOpen(boolean val, short stmtWarn) throws SQLException {
        if (val) {
            this.SerWarn = stmtWarn;
            this.OpenDbInit();
            if (this.dbName != null && (this.chgLocale || this.dbEncoding == null)) {
                this.setDatabaseLocale();
            }
        } else {
            this.CloseDbReset();
        }
    }

    @Override
    public String getURL() throws SQLException {
        return this.org_url;
    }

    @Override
    public String getUserName() throws SQLException {
        return this.userName;
    }

    @Override
    public String getJDBCVersion() throws SQLException {
        return IfxDriver.getJDBCVersion();
    }

    @Override
    public String getDbProductName() throws SQLException {
        return this.connInfo.asBool("emulateInformixServer", false) ? "Informix Dynamic Server" : this.connInfo.asString("overrideDatabaseProductName", this.productName);
    }

    @Override
    public String getDbVersion() throws SQLException {
        return this.externalVersion == null ? "unknown" : this.externalVersion;
    }

    private void OpenDbInit() throws SQLException {
        this.CloseDbReset();
        this.isDatabaseOpen = true;
        if ((this.SerWarn & 1) != 0) {
            this.db_use_log = true;
            this.transactionLevel = 2;
        }
        if ((this.SerWarn & 2) != 0) {
            this.AnsiDb = true;
            this.transactionLevel = 8;
        }
        if ((this.SerWarn & 0x40) != 0) {
            this.chgLocale = true;
        }
        this.TxState = !this.db_use_log ? (short)0 : 1;
        if (this.AnsiDb) {
            this.SendCommit = true;
        }
        this.clearWarnings();
        this.setWarnings();
    }

    private void CloseDbReset() {
        this.AnsiDb = false;
        this.chgLocale = false;
        this.transactionLevel = 0;
        this.autoCommit = true;
        this.db_use_log = false;
        this.isDatabaseOpen = false;
        this.TxState = 0;
        this.SendCommit = false;
        this.sqllogicalchar = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDatabaseLocale() throws SQLException {
        block25: {
            if (TraceFlag.isTraceEnabled()) {
                this.traceObj.writeTrace(logger, 1, "IfxSqliConnect: setDatabaseLocale() called");
            }
            boolean changedTX = false;
            int svTX = 0;
            Statement stmt = this.createStatement();
            ((IfxStatement)stmt).setAutoFree(false);
            if (this.db_use_log && (this.getDbVersion().charAt(0) == '8' || this.getDbVersion().charAt(0) == '9' || this.isANSI()) && (svTX = this.getTransactionIsolation()) != 1) {
                this.setTransactionIsolation(1, stmt);
                changedTX = true;
            }
            try {
                String query_stm = "select FIRST 1 site from informix.systables where tabname = ' GL_COLLATE'";
                String site = null;
                try (ResultSet rs = stmt.executeQuery("select FIRST 1 site from informix.systables where tabname = ' GL_COLLATE'");){
                    if (!rs.next()) {
                        return;
                    }
                    site = rs.getString(1);
                }
                String[] locale = this.parseLocale(site);
                this.dbEncoding = locale[1];
                this.dbLocale = locale[0];
                if (this.clLocale != null) break block25;
                this.clEncoding = this.dbEncoding;
                String tempLoc = this.getLocale(this.dbLocale);
                if (tempLoc != null) {
                    this.clLocale = this.dbLocale;
                    break block25;
                }
                throw Messages.getSQLException(-79784, this);
            }
            finally {
                if (changedTX) {
                    this.setTransactionIsolation(svTX, stmt);
                }
                stmt.close();
            }
        }
    }

    protected AdvancedUppercaseProperties SetPrimEVars() throws SQLException {
        AdvancedUppercaseProperties pList = new AdvancedUppercaseProperties();
        pList.put("NODEFDAC", "no");
        Object evar = null;
        for (int i = 0; i < SqliConnectionProperties.PRIMARY_ENVIRONMENT_LIST.length; ++i) {
            if (!this.connInfo.containsKey(SqliConnectionProperties.PRIMARY_ENVIRONMENT_LIST[i])) continue;
            pList.put(SqliConnectionProperties.PRIMARY_ENVIRONMENT_LIST[i], this.connInfo.get(SqliConnectionProperties.PRIMARY_ENVIRONMENT_LIST[i]));
        }
        String tmpdbLocale = pList.getProperty("DB_LOCALE");
        if (tmpdbLocale != null) {
            String[] localeInfo = this.parseLocale(tmpdbLocale);
            this.dbEncoding = localeInfo[1];
            this.dbLocale = localeInfo[0];
        } else {
            this.dbLocale = null;
            this.dbEncoding = null;
        }
        this.dbDate = pList.getProperty("DBDATE");
        this.glDate = pList.getProperty("GL_DATE");
        String tmpclLocale = pList.getProperty("CLIENT_LOCALE");
        if (tmpclLocale != null) {
            String[] localeInfo = this.parseLocale(tmpclLocale);
            this.clEncoding = localeInfo[1];
            this.clLocale = localeInfo[0];
        } else if (this.dbLocale != null && this.dbEncoding != null) {
            this.clEncoding = this.dbEncoding;
            this.clLocale = this.dbLocale;
        } else {
            Locale currLocale = Locale.getDefault();
            String lang = currLocale.getLanguage();
            String country = currLocale.getCountry();
            if (lang.equals("en") && (country.equals("") || country.equals("US"))) {
                this.clLocale = File.separator.equals("/") ? "en_US.8859-1" : "en_US.CP1252";
                pList.put("CLIENT_LOCALE", this.clLocale);
                if (this.dbDate == null && this.glDate == null) {
                    this.dbDate = "Y4MD-";
                    pList.put("DBDATE", "Y4MD-");
                }
            } else {
                this.clLocale = null;
            }
            this.clEncoding = null;
        }
        if (this.dbDate == null && this.glDate == null && pList.getProperty("CLIENT_LOCALE") == null && pList.getProperty("DB_LOCALE") == null) {
            this.dbDate = "Y4MD-";
            pList.put("DBDATE", "Y4MD-");
        }
        if (pList.getProperty("CLIENT_LOCALE") != null) {
            this.is_client_loc_set = true;
            if (pList.asString("CLIENT_LOCALE").toLowerCase().endsWith("utf-8")) {
                pList.setProperty("CLIENT_LOCALE", this.clLocale + ".UTF8");
            }
        }
        if (pList.getProperty("DB_LOCALE") != null) {
            this.is_db_loc_set = true;
        }
        pList.put("DBPATH", ".");
        pList.put("IFX_UPDDESC", "1");
        pList.put("CLNT_PAM_CAPABLE", "1");
        return pList;
    }

    public String[] parseLocale(String glsOrNLSLocale) throws SQLException {
        String tmpValue = glsOrNLSLocale.trim();
        String[] retVal = new String[2];
        String tLocale = null;
        String tEncoding = null;
        StringTokenizer itok = new StringTokenizer(tmpValue, "@");
        tmpValue = itok.nextToken();
        itok = new StringTokenizer(tmpValue, ".");
        tLocale = itok.nextToken();
        if (itok.hasMoreTokens()) {
            tEncoding = itok.nextToken();
        }
        if (tLocale != null) {
            retVal[0] = this.getLocale(tLocale);
        }
        if (tEncoding != null) {
            retVal[1] = this.getJDKEncoding(tEncoding);
        }
        if (retVal[1] == null || retVal[0] == null) {
            retVal = this.getNLSMap(glsOrNLSLocale);
        }
        if (retVal[0] == null || retVal[1] == null) {
            throw Messages.getSQLException(-79784);
        }
        return retVal;
    }

    static Properties createSecondaryEnvironmentList(AdvancedUppercaseProperties ds) {
        Properties sList = new Properties();
        sList.put("DBTEMP", "/tmp");
        sList.put("SUBQCACHESZ", "10");
        String evar = null;
        Arrays.stream(SqliConnectionProperties.SECONDARY_ENVIRONMENT_LIST).filter(k -> ds.containsKey(k)).forEach(k -> sList.put(k, ds.getProperty((String)k)));
        if (ds.asBool("padVarchar")) {
            sList.put("IFX_PAD_VARCHAR", "1");
        }
        if ((evar = ds.getProperty("DBTODAY")) != null) {
            sList.put("DBTODAY", evar);
        }
        if (ds.containsKey("resultsBufferSize")) {
            sList.put("FET_BUF_SIZE", ds.asString("resultsBufferSize"));
        }
        if (ds.asBool("optOFC")) {
            sList.put("OPTOFC", "1");
        }
        if (lg.isDebugEnabled()) {
            lg.debug("Secondary environment list: {}", sList);
        }
        return sList;
    }

    private void getServerVer() throws SQLException {
        if (this.internalVersion != 316) {
            throw Messages.getSQLException(-80507);
        }
        this.enhancedProtocolMechanism();
    }

    IfxDataOutputStream Ifxproto_send() {
        return this.OutputStream;
    }

    IfxDataInputStream Ifxproto_receive() {
        return this.InputStream;
    }

    void setTxEndState() {
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "IfxSqliConnect: setTxEndState() called");
            this.traceObj.writeTrace(logger, 3, "Current TxState is ", this.TxState);
            this.traceObj.writeTrace(logger, 3, "Current SendCommit is " + this.SendCommit);
        }
        if (!this.db_use_log) {
            return;
        }
        if (this.TxState == 2) {
            if (TraceFlag.isTraceEnabled()) {
                this.traceObj.writeTrace(logger, 3, "autoCommit: " + this.autoCommit);
                this.traceObj.writeTrace(logger, 3, "AnsiDb: " + this.AnsiDb);
            }
            this.TxState = 1;
            if (this.autoCommit && this.AnsiDb) {
                this.SendCommit = true;
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 3, "TxState is changed to ", this.TxState);
            this.traceObj.writeTrace(logger, 3, "SendCommit is changed to " + this.SendCommit);
            this.traceObj.writeTrace(logger, 1, "IfxSqliConnect: setTxEndState() exited");
        }
    }

    void setTxBeginState() {
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "IfxSqliConnect: setTxBeginState() called");
            this.traceObj.writeTrace(logger, 3, "Current TxState is ", this.TxState);
            this.traceObj.writeTrace(logger, 3, "Current SendCommit is " + this.SendCommit);
        }
        if (!this.db_use_log) {
            return;
        }
        if (this.TxState == 1) {
            this.TxState = (short)2;
            this.SendCommit = false;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 3, "TxState is changed to ", this.TxState);
            this.traceObj.writeTrace(logger, 3, "SendCommit is changed to " + this.SendCommit);
            this.traceObj.writeTrace(logger, 1, "IfxSqliConnect: setTxBeginState() exited");
        }
    }

    @Override
    public boolean isDelimIdentSet() {
        return this.delimIdent;
    }

    public boolean isNamedParametersSupported() {
        return this.dbVersion.get(52);
    }

    public boolean isSavepointSupported() {
        return this.dbVersion.get(56);
    }

    public boolean isSQBatchSupported() {
        return this.dbVersion.get(61);
    }

    public boolean isRemove64KLimitSupported() {
        return this.dbVersion.get(62);
    }

    @Override
    public boolean isIEEEM() {
        return !this.floatToDec;
    }

    public boolean isPrivateServerEnabled() {
        return this.dbVersion.get(59);
    }

    boolean isVarcharVarLenSupported() {
        return !this.ifxPADVARCHAR;
    }

    public boolean isPAMAuthentication() {
        return this.dbVersion.get(44);
    }

    @Override
    public Trace getTrace() {
        return this.traceObj;
    }

    @Override
    public Trace getProtoTrace() {
        return this.protoTraceObj;
    }

    public boolean lockSession() {
        this.sessionLock.lock();
        return true;
    }

    public void unlockSession() {
        this.sessionLock.unlock();
    }

    public void unlockIfOwner() {
        if (this.sessionLock.isHeldByCurrentThread()) {
            this.sessionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGeneratedCursor() {
        AtomicLong atomicLong = this.nextID;
        synchronized (atomicLong) {
            String cursorName = Long.toString(this.nextID.getAndIncrement(), 36);
            if (this.nextID.get() >= Long.MAX_VALUE) {
                this.nextID.set(0L);
            }
            return PREFIX + ZEROSTRING.substring(0, ZEROSTRING.length() - cursorName.length()) + cursorName;
        }
    }

    private void setWarnings() {
        int set = 0;
        if (this.SerWarn == 0) {
            return;
        }
        short w = this.SerWarn;
        for (int i = 1; i <= 6; i = (int)((short)(i + 1))) {
            set = w & 1;
            if (set == 1) {
                switch (i) {
                    case 1: {
                        this.addWarning(null, "01I01");
                        break;
                    }
                    case 2: {
                        this.addWarning(null, "01I03");
                        break;
                    }
                    case 3: {
                        this.addWarning(null, "01I04");
                        break;
                    }
                    case 4: {
                        this.addWarning(null, "01I05");
                        break;
                    }
                    case 5: {
                        this.addWarning(null, "01I06");
                        break;
                    }
                    case 6: {
                        this.addWarning(null, "01I10");
                    }
                }
            }
            w = (short)(w >> 1);
        }
    }

    private void setInternalQuery(boolean start) {
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "setInternalQuery() called");
            this.traceObj.writeTrace(logger, 3, "start " + start);
            this.traceObj.writeTrace(logger, 3, "autoCommit currently " + this.autoCommit);
            this.traceObj.writeTrace(logger, 3, "TxState currently " + this.TxState);
            this.traceObj.writeTrace(logger, 3, "SendCommit currently " + this.SendCommit);
        }
        if (!this.AnsiDb || !this.autoCommit && this.internalQuery == 0) {
            return;
        }
        if (this.TxState == 0) {
            return;
        }
        if (start) {
            this.autoCommit = false;
            if (this.SendCommit) {
                this.internalQuery |= 2;
                this.SendCommit = false;
            }
            this.internalQuery |= 1;
        } else if ((this.internalQuery & 1) > 0) {
            this.autoCommit = true;
            if ((this.internalQuery & 2) > 0) {
                this.SendCommit = true;
            }
            this.internalQuery = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IfxUDTInfo addUDTInfo(String udtOwner, String udtName) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "Connection.addUDTInfo() entered");
            this.traceObj.writeTrace(logger, 3, "  addUDTInfo owner: " + udtOwner + "  addUDTInfo udtName: " + udtName);
        }
        if (udtName == null) {
            return null;
        }
        ResultSet rs = null;
        IfxPreparedStatement pstmt = null;
        Statement pstmt2 = null;
        IfxUDTInfo udtInfo = null;
        boolean ownedByConnUser = false;
        int numOtherUserWithUsage = 0;
        int numOtherUserNoUsage = 0;
        boolean CONN_USER = false;
        boolean OTHER_USER_WITH_USAGE = true;
        int OTHER_USER_NO_USAGE = 2;
        IfxUDTInfo[] keepUdtInfo = new IfxUDTInfo[]{null, null, null};
        if (!this.isDbOpen()) {
            return null;
        }
        if (this.udtMap == null) {
            this.udtMap = Collections.synchronizedMap(new CaseMap(this.isDelimIdentSet()));
        }
        this.setInternalQuery(true);
        if (udtOwner == null) {
            udtOwner = "%";
        }
        try {
            pstmt = this.prepareStatement("select extended_id, mode, owner, name, type, source, length from informix.sysxtdtypes where mode in ('R','B','D','C','T') and name like ? order by extended_id");
            if (udtName.startsWith("timeseries(")) {
                udtName = this.strip(udtName);
            }
            pstmt.setString(1, udtName);
            rs = pstmt.executeQuery();
            String mode = null;
            String owner = null;
            String name = null;
            while (rs.next()) {
                int xid = rs.getInt(1);
                mode = rs.getString(2);
                owner = rs.getString(3);
                name = rs.getString(4);
                short IfxType = rs.getShort(5);
                int source = rs.getInt(6);
                int sourceLength = rs.getInt(7);
                udtInfo = this.loadUDT(xid, mode, name, owner, IfxType, source, sourceLength);
                String trimOwner = owner.trim();
                if (IfxTypes.isComplexType(IfxType = (short)(IfxType & 0xFF))) {
                    Vector<IfxColumnInfo> v = null;
                    v = mode.equals("D") ? this.loadStructInfo(source, owner, name, source) : this.loadStructInfo(xid, owner, name, source);
                    udtInfo.structInfo = new IfxResultSetMetaData(this, v);
                    if (IfxType == 22 && name != null) {
                        IfxColumnInfo colInfo = v.get(0);
                        colInfo.ExtendedName = name.trim();
                        colInfo.ExtendedOwner = trimOwner;
                    }
                }
                if (this.useTypeCache) {
                    if (this.getDatabaseType() == 1) {
                        this.udtMap.put(trimOwner + "." + name, udtInfo);
                    } else {
                        this.udtMap.put(name, udtInfo);
                    }
                }
                String connUser = this.getUserName();
                if (TraceFlag.isTraceEnabled()) {
                    this.traceObj.writeTrace(logger, 3, "addUDTInfo(): connUser='" + connUser + "', trimOwner='" + trimOwner + "'");
                }
                if (trimOwner.equals(connUser)) {
                    ownedByConnUser = true;
                    keepUdtInfo[0] = udtInfo;
                    if (this.useTypeCache) continue;
                    break;
                }
                pstmt2 = this.prepareStatement("select count(*) from informix.sysxtdtypeauth t where t.type = ? and (t.grantee in ('public', ?) or exists (select rolename from informix.sysroleauth r where t.grantee = r.rolename and r.grantee = ?) ) and t.auth in ('-u', '-U')");
                pstmt2.setInt(1, xid);
                pstmt2.setString(2, connUser);
                pstmt2.setString(3, connUser);
                ResultSet rs2 = pstmt2.executeQuery();
                Throwable throwable = null;
                try {
                    if (!rs2.next()) continue;
                    int cnt = rs2.getInt(1);
                    if (cnt > 0) {
                        if (numOtherUserWithUsage == 0) {
                            keepUdtInfo[1] = udtInfo;
                        }
                        ++numOtherUserWithUsage;
                        continue;
                    }
                    if (numOtherUserNoUsage == 0) {
                        keepUdtInfo[2] = udtInfo;
                    }
                    ++numOtherUserNoUsage;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs2 == null) continue;
                    if (throwable != null) {
                        try {
                            rs2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    rs2.close();
                }
            }
        }
        finally {
            this.setInternalQuery(false);
            if (rs != null) {
                rs.close();
            }
            if (pstmt != null) {
                pstmt.close();
            }
            if (pstmt2 != null) {
                pstmt2.close();
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 3, "ownedByConnUser=" + ownedByConnUser + ", keepUdtInfo[CONN_USER]=\n" + keepUdtInfo[0]);
            this.traceObj.writeTrace(logger, 3, "numOtherUserWithUsage=" + numOtherUserWithUsage + ", keepUdtInfo[OTHER_USER_WITH_USAGE]=\n" + keepUdtInfo[1]);
            this.traceObj.writeTrace(logger, 3, "numOtherUserNoUsage=" + numOtherUserNoUsage + ", keepUdtInfo[OTHER_USER_NO_USAGE]=\n" + keepUdtInfo[2]);
            this.traceObj.writeTrace(logger, 1, "Connection.addUDTInfo() exited");
        }
        if (udtName.equals("%")) {
            return null;
        }
        if (!ownedByConnUser && numOtherUserWithUsage == 0 && numOtherUserNoUsage == 0) {
            return null;
        }
        if (ownedByConnUser) {
            return keepUdtInfo[0];
        }
        if (numOtherUserWithUsage == 1) {
            return keepUdtInfo[1];
        }
        if (numOtherUserNoUsage == 1) {
            return keepUdtInfo[2];
        }
        throw Messages.getSQLException(-79770, this);
    }

    public Object loadUDTba(int xid, byte[] modeba, byte[] nameba, byte[] ownerba, short IfxType, int source, int sourceLength) throws SQLException {
        String mode = new String(modeba, 0, 129);
        String typename = new String(nameba, 0, 129);
        String owner = new String(ownerba, 0, 129);
        Vector<IfxColumnInfo> infoVector = new Vector<IfxColumnInfo>();
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 99, "loadUDTba: mode " + mode + " typename " + typename + " owner " + owner + " xid " + xid + " IfxType " + IfxType + " source " + source + " sourceLength " + sourceLength);
        }
        IfxUDTInfo udtInfo = this.loadUDT(xid, mode, typename, owner, IfxType, source, sourceLength);
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 99, "loadUDTba: udtInfo is " + udtInfo);
        }
        udtInfo.structInfo = new IfxResultSetMetaData(this, infoVector);
        return udtInfo;
    }

    private IfxUDTInfo loadUDT(int xid, String mode, String name, String owner, short IfxType, int source, int sourceLength) {
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "Connection.loadUDT() entered");
        }
        IfxUDTInfo udtInfo = new IfxUDTInfo();
        udtInfo.SQLtype = IfxType & 0xFF;
        udtInfo.xid = xid;
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 99, "loadUDT called: type is " + udtInfo.SQLtype + " xid is " + xid);
        }
        udtInfo.JDBCtype = mode.equals("B") || mode.equals("T") ? (short)2000 : (mode.equals("D") ? (short)2001 : (short)2002);
        udtInfo.name = name;
        udtInfo.owner = owner.trim();
        udtInfo.source = source;
        if (mode.equals("D") && udtInfo.source == 0) {
            udtInfo.source = IfxType & 0xFF;
        }
        udtInfo.sourceLength = sourceLength;
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 99, "loadUDT exits");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "Connection.loadUDT() exited");
        }
        return udtInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector<IfxColumnInfo> loadStructInfo(int xid, String owner, String name, int source) throws SQLException {
        IfxPreparedStatement pstmt1 = null;
        ResultSet rs1 = null;
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "Connection.loadStructInfo() entered");
        }
        Vector<IfxColumnInfo> parentInfoVector = new Vector<IfxColumnInfo>();
        Vector<IfxColumnInfo> childInfoVector = new Vector<IfxColumnInfo>();
        try {
            pstmt1 = this.prepareStatement("select extended_id, seqno, levelno, parent_no, fieldname, fieldno, type, length, xtd_type_id from informix.sysattrtypes where extended_id = ? order by seqno");
            pstmt1.setInt(1, xid);
            rs1 = pstmt1.executeQuery();
            while (rs1.next()) {
                IfxColumnInfo type = new IfxColumnInfo();
                type.Seqno = rs1.getShort(2);
                type.Levelno = rs1.getShort(3);
                type.Parentno = rs1.getShort(4);
                type.ColName = rs1.getString(5);
                type.Fieldno = rs1.getShort(6);
                type.SQLtype = rs1.getShort(7);
                type.ColLength = rs1.getShort(8);
                type.ExtendedId = rs1.getInt(9);
                if (TraceFlag.isTraceEnabled()) {
                    this.traceObj.writeTrace(logger, 3, "SeqNo: " + type.Seqno);
                    this.traceObj.writeTrace(logger, 3, "ColName: " + type.ColName);
                    this.traceObj.writeTrace(logger, 3, "SQLtype: " + type.SQLtype);
                    this.traceObj.writeTrace(logger, 3, "ExtendedId: " + type.ExtendedId);
                }
                IfxResultSetMetaData.setTypeBooleanFields(type, type.SQLtype);
                type.SQLtype &= 0xFF;
                if (type.ExtendedId != 0) {
                    if (type.ExtendedId == 1) {
                        type.SQLtype = 43;
                    } else if (type.ExtendedId == 5) {
                        type.SQLtype = 45;
                    } else if (type.ExtendedId == 10) {
                        type.SQLtype = 102;
                    } else if (type.ExtendedId == 11) {
                        type.SQLtype = 101;
                    } else {
                        type.ExtendedOwner = owner == null ? "" : owner.trim();
                        String string = type.ExtendedName = name == null ? "" : name.trim();
                        if (type.IsDistinct) {
                            type.SourceType = source;
                            if (type.SourceType == 0) {
                                type.SourceType = type.SQLtype;
                            } else if (type.SourceType == 1) {
                                type.SQLtype = 43;
                            } else if (type.SourceType == 5) {
                                type.SQLtype = 45;
                            } else if (type.SourceType == 10) {
                                type.SQLtype = 102;
                            } else if (type.SourceType == 11) {
                                type.SQLtype = 101;
                            }
                        }
                        if (type.ExtendedOwner == null) {
                            type.ExtendedOwner = "";
                        }
                        if (type.ExtendedName == null) {
                            type.ExtendedName = "";
                        }
                        if (IfxTypes.isComplexType(type.SQLtype)) {
                            Vector<IfxColumnInfo> v = this.loadStructInfo(type.ExtendedId, owner, name, source);
                            type.child = ((IfxColumnInfo)v.get((int)0)).child;
                        }
                    }
                } else {
                    type.ExtendedOwner = "";
                    type.ExtendedName = "";
                }
                type.Alignment = 0;
                type.SourceType = 0;
                if (type.Seqno == 1) {
                    parentInfoVector.addElement(type);
                    if (type.child != null) continue;
                    type.child = childInfoVector;
                    continue;
                }
                childInfoVector.addElement(type);
            }
            if (TraceFlag.isTraceEnabled()) {
                this.traceObj.writeTrace(logger, 1, "Connection.loadStructInfo() exited");
            }
        }
        finally {
            if (rs1 != null) {
                rs1.close();
            }
            if (pstmt1 != null) {
                pstmt1.close();
            }
        }
        return parentInfoVector;
    }

    public void setStructInfo(Object obj_udtInfo, short seqno, short levelno, short parentno, byte[] fieldnameba, short fieldno, short type, short length, int xid, byte[] xidOwnerba, byte[] xidNameba) throws SQLException {
        IfxUDTInfo udtInfo = (IfxUDTInfo)obj_udtInfo;
        IfxColumnInfo typeInfo = new IfxColumnInfo();
        IfxResultSetMetaData rsmd = udtInfo.structInfo;
        Vector<IfxColumnInfo> infoVector = rsmd.getColumnInfoVector();
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 99, "SqliConnect:setStructInfo enter");
            this.traceObj.writeTrace(logger, 99, "    seqno " + seqno + " levelno " + levelno + " parentno " + parentno + " fieldno " + fieldno + " type " + type + " length " + length + " xid " + xid);
        }
        typeInfo.Seqno = seqno;
        typeInfo.Levelno = levelno;
        typeInfo.Parentno = parentno;
        typeInfo.ColName = fieldnameba == null ? null : new String(fieldnameba, 0, 129);
        typeInfo.Fieldno = fieldno;
        typeInfo.SQLtype = type;
        typeInfo.ColLength = length;
        typeInfo.ExtendedId = xid;
        IfxResultSetMetaData.setTypeBooleanFields(typeInfo, typeInfo.SQLtype);
        typeInfo.SQLtype &= 0xFF;
        if (typeInfo.ExtendedId != 0) {
            if (typeInfo.ExtendedId == 1) {
                typeInfo.SQLtype = 43;
            } else if (typeInfo.ExtendedId == 5) {
                typeInfo.SQLtype = 45;
            } else if (typeInfo.ExtendedId == 10) {
                typeInfo.SQLtype = 102;
            } else if (typeInfo.ExtendedId == 11) {
                typeInfo.SQLtype = 101;
            } else {
                typeInfo.ExtendedOwner = xidOwnerba == null ? null : new String(xidOwnerba, 0, 129);
                typeInfo.ExtendedName = xidNameba == null ? null : new String(xidNameba, 0, 129);
                if (IfxTypes.isComplexType(typeInfo.SQLtype)) {
                    IfxUDTInfo tmp_udtInfo = this.getUDTInfo(typeInfo.ExtendedName, typeInfo.ExtendedOwner);
                    IfxResultSetMetaData tmp_rsmd = tmp_udtInfo.structInfo;
                    Vector<IfxColumnInfo> tmp_cinfovector = tmp_rsmd.getColumnInfoVector();
                    typeInfo.child = tmp_cinfovector.get((int)0).child;
                }
            }
        }
        typeInfo.Alignment = 0;
        typeInfo.SourceType = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 99, "SqliConnect:setStructInfo exit " + typeInfo.toString());
        }
        infoVector.addElement(typeInfo);
    }

    public TypeInfo getUDTInfo(IfxColumnInfo colinfo) throws SQLException {
        return null;
    }

    @Override
    public IfxUDTInfo getUDTInfo(IfxColumnInfo colinfo, String name) throws SQLException {
        String owner = colinfo == null || colinfo.ExtendedOwner == null ? "%" : colinfo.ExtendedOwner.trim();
        return this.getUDTInfo(name.trim(), owner);
    }

    @Override
    public TypeInfo getUDTInfo(int xid) throws SQLException {
        return this.getUDTInfo(xid, false);
    }

    @Override
    public IfxUDTInfo getUDTInfo(int xid, boolean metaDataQuery) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "Connection.getUDTInfo(xid=" + xid + ") entered");
        }
        IfxUDTInfo udtInfo = null;
        if (this.useTypeCache && this.xidMap != null && (udtInfo = this.xidMap.get(xid)) != null) {
            if (TraceFlag.isTraceEnabled()) {
                this.traceObj.writeTrace(logger, 2, "Connection.getUDTInfo(xid) - xid found in xidMap");
            }
            if (TraceFlag.isTraceEnabled()) {
                this.traceObj.writeTrace(logger, 1, "Connection.getUDTInfo(xid=" + xid + ") exited");
            }
            return udtInfo;
        }
        if (!this.isDbOpen()) {
            return null;
        }
        if (this.xidMap == null) {
            this.xidMap = Collections.synchronizedMap(new HashMap());
        }
        if (!metaDataQuery) {
            this.setInternalQuery(true);
        }
        try {
            IfxPreparedStatement pstmt = this.prepareStatement("select mode, owner, name, type, source, length from informix.sysxtdtypes where extended_id = ?");
            pstmt.setInt(1, xid);
            ResultSet rs = pstmt.executeQuery();
            String mode = null;
            String owner = null;
            String name = null;
            if (rs.next()) {
                mode = rs.getString(1);
                owner = rs.getString(2);
                name = rs.getString(3);
                short IfxType = rs.getShort(4);
                int source = rs.getInt(5);
                int sourceLength = rs.getInt(6);
                udtInfo = this.loadUDT(xid, mode, name, owner, IfxType, source, sourceLength);
                if (mode.equals("R") || mode.equals("C")) {
                    Vector<IfxColumnInfo> v = this.loadStructInfo(xid, owner, name, source);
                    udtInfo.structInfo = new IfxResultSetMetaData(this, v);
                } else if (mode.equals("S")) {
                    IfxPreparedStatement pstmt1 = this.prepareStatement("select name from informix.sysxtdtypes where extended_id = (select xtd_type_id from informix.sysattrtypes where extended_id = ? and type = ?)");
                    pstmt1.setInt(1, xid);
                    pstmt1.setInt(2, IfxType);
                    try (ResultSet rs1 = pstmt1.executeQuery();){
                        while (rs1.next()) {
                            udtInfo.name = rs1.getString(1).trim();
                        }
                    }
                    pstmt1.close();
                }
                if (this.useTypeCache) {
                    this.xidMap.put(xid, udtInfo);
                }
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException ex) {
            this.setInternalQuery(false);
            throw ex;
        }
        if (!metaDataQuery) {
            this.setInternalQuery(false);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "Connection.getUDTInfo(xid=" + xid + ") exited");
        }
        return udtInfo;
    }

    @Override
    public IfxUDTInfo getUDTInfo(String name, String owner) throws SQLException {
        IfxUDTInfo udtInfo = null;
        if (!this.isDelimIdentSet()) {
            name = name.toLowerCase();
        }
        if (this.useTypeCache && this.udtMap != null && (udtInfo = this.udtMap.get(name.trim())) == null && this.getDatabaseType() == 1) {
            String tmpOwner = owner.trim();
            if (tmpOwner.equals("%")) {
                tmpOwner = this.getUserName();
                udtInfo = this.udtMap.get(tmpOwner + "." + name);
                if (udtInfo == null) {
                    udtInfo = this.udtMap.get("informix." + name);
                }
            } else {
                udtInfo = this.udtMap.get(tmpOwner + "." + name);
            }
        }
        if (udtInfo == null) {
            udtInfo = this.addUDTInfo(owner, name.trim());
        }
        return udtInfo;
    }

    public boolean getAutoFree() {
        return this.autoFree;
    }

    public boolean getOPTOFC() {
        return this.optofc;
    }

    public boolean getUsePut() {
        return this.usePut;
    }

    @Override
    public boolean getIFX_USEPUT() {
        return this.getUsePut();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIFX_USEPUT(boolean enable) throws SQLException {
        Vector<StmtList> vector = this.stmtList;
        synchronized (vector) {
            if (!this.stmtList.isEmpty()) {
                throw Messages.getSQLException(-79716, this);
            }
            this.usePut = enable;
        }
    }

    @Override
    public boolean getTrimTrailingSpaces() {
        return this.TrimTrailingSpaces;
    }

    @Override
    public int getBlobCacheSize() {
        return this.lobCacheSize;
    }

    int getCodesetLobSize() {
        return this.codesetLobSize;
    }

    boolean isLOReadOnly() {
        return this.loreadonly;
    }

    boolean isConvText() {
        return this.codesetLobSize > -1;
    }

    @Override
    public String getdbDate() {
        return this.dbDate;
    }

    @Override
    public String getglDate() {
        return this.glDate;
    }

    @Override
    public String getdbTime() {
        return this.dbTime;
    }

    @Override
    public String getglDateTime() {
        return this.glDateTime;
    }

    @Override
    public boolean getclLocaleProp() {
        return this.is_client_loc_set;
    }

    @Override
    public boolean getdbLocaleProp() {
        return this.is_db_loc_set;
    }

    @Override
    public boolean getuseDtenv() {
        return this.useDtenv;
    }

    @Override
    public String getdbCentury() {
        return this.connInfo.asString("DBCENTURY");
    }

    @Override
    public String getdbLocale() {
        return this.dbLocale;
    }

    @Override
    public String getdbEncoding() {
        return this.dbEncoding;
    }

    @Override
    public String getclLocale() {
        return this.clLocale;
    }

    protected void setLocale(String cl) {
        this.clLocale = cl;
        if (this.dbLocale == null) {
            this.dbLocale = this.clLocale;
        }
    }

    public String getclEncoding() {
        return this.clEncoding;
    }

    @Override
    public String getJDBCTempDir() {
        if (this.tempdir == null) {
            this.tempdir = "";
        }
        return this.tempdir;
    }

    @Override
    public boolean isANSI() {
        return this.AnsiDb;
    }

    /*
     * Exception decompiling
     */
    @Override
    public String getXnameByXid(int xid) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addNLSMap(String nls, String jdkLocale, String jdkEncoding) {
        this.NLSToJDK.put(nls, new String[]{jdkLocale, jdkEncoding});
    }

    private void addLocale(String ifxLoc, String jdkLoc) {
        this.IfxToJdkLocaleTable.put(ifxLoc, jdkLoc);
    }

    private void addEncName(String ifxName, String jdkName) {
        this.IfxToJdkEncodingTable.put(ifxName, jdkName);
    }

    private void addEncNumber(String ifxNumber, String jdkName) {
        this.IfxNoToJdkEncodingTable.put(ifxNumber, jdkName);
    }

    private String getEncName(String encoding) {
        String jdkEnc = null;
        if (this.IfxToJdkEncodingTable != null) {
            jdkEnc = this.IfxToJdkEncodingTable.get(encoding);
        }
        if (jdkEnc == null) {
            jdkEnc = IfxLocales.FromIfxNameToJdkName(encoding);
        }
        return jdkEnc;
    }

    private String getEncNo(String encoding) {
        String jdkEnc = null;
        if (this.IfxNoToJdkEncodingTable != null) {
            jdkEnc = this.IfxNoToJdkEncodingTable.get(encoding);
        }
        if (jdkEnc == null) {
            jdkEnc = IfxLocales.FromIfxNoToJdkName(encoding);
        }
        return jdkEnc;
    }

    private String getLocale(String local) {
        String tmpLoc = null;
        if (this.IfxToJdkLocaleTable != null) {
            tmpLoc = this.IfxToJdkLocaleTable.get(local.toLowerCase());
        }
        if (tmpLoc == null) {
            tmpLoc = IfxLocales.FromIfxToJdkLocale(local);
        }
        return tmpLoc;
    }

    private String getJDKEncoding(String encoding) {
        String retVal = null;
        if (encoding.equalsIgnoreCase("UTF8") || encoding.equalsIgnoreCase("UTF-8")) {
            return "UTF8";
        }
        retVal = this.getEncName(encoding);
        if (retVal == null) {
            retVal = this.getEncNo(encoding);
        }
        return retVal;
    }

    private String[] getNLSMap(String nls) {
        String[] retVal = null;
        if (nls == null) {
            return new String[2];
        }
        if (this.NLSToJDK != null) {
            retVal = this.NLSToJDK.get(nls);
        }
        if (retVal == null) {
            retVal = IfxLocales.FromNLSToJDK(nls);
        }
        return retVal;
    }

    @Override
    public int getSqlLogicalChar() throws SQLException {
        int flags = 0;
        if (!this.isDatabaseOpen) {
            this.sqllogicalchar = 1;
        }
        if (this.sqllogicalchar == -1) {
            this.startMetaDataQuery();
            try (Statement stmt = this.createStatement();){
                String sql = "SELECT flags FROM informix.systables WHERE tabname = ' VERSION';";
                try (ResultSet rs = stmt.executeQuery(sql);){
                    if (rs.next()) {
                        flags = rs.getInt(1);
                    }
                }
            }
            catch (SQLException ex) {
                this.endMetaDataQuery();
            }
            this.endMetaDataQuery();
            this.sqllogicalchar = (flags & 3) + 1;
        }
        return this.sqllogicalchar;
    }

    public void xaSetSerWarnFlags(short flags, String name) throws SQLException {
        this.dbName = name;
        int isAnsi = 0;
        int isLogging = 0;
        Statement stmt = null;
        ResultSet rs = null;
        this.startMetaDataQuery();
        try {
            stmt = this.createStatement();
            String sql = "select is_ansi, is_logging from sysmaster:informix.sysdatabases where name=";
            sql = sql + "'" + this.dbName + "'";
            rs = stmt.executeQuery(sql);
            if (rs.next()) {
                isAnsi = rs.getInt(1);
                isLogging = rs.getInt(2);
            }
        }
        catch (SQLException ex) {
            this.endMetaDataQuery();
            throw ex;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        this.endMetaDataQuery();
        if (isAnsi == 1) {
            flags = (short)(flags | 2);
        }
        if (isLogging == 1) {
            flags = (short)(flags | 1);
        }
        this.SerWarn = (short)(this.SerWarn | flags);
        this.OpenDbInit();
    }

    @Override
    public IfxProtocol getProto() {
        return this.proto;
    }

    @Override
    public IfxProtocol createProto() {
        return new IfxSqli(this);
    }

    int getCorrectedFetchBufSize() {
        return Math.min(this.getMaxFetchBufSize(), this.fetchBufSize);
    }

    int getMaxFetchBufSize() {
        return Integer.MAX_VALUE;
    }

    @Override
    public long getdbTodayDate() {
        return this.dbTodayDate;
    }

    @Override
    public long getdbTodayStart() {
        return this.dbTodayStart;
    }

    void setDbName(String dbname) {
        this.dbName = dbname;
    }

    void databaseClosed() {
        this.setDbName(null);
    }

    @Override
    public PreparedStatementCache getPreparedStatementCache() {
        return this.implicitCache;
    }

    @Override
    public boolean isXAConnection() {
        return false;
    }

    @Override
    public boolean inXATransaction() {
        return false;
    }

    @Override
    public int getFPCacheRoutineId(String signature) {
        FPCacheInfo cacheInfo = this.fpCache.get(signature);
        if (cacheInfo != null) {
            return cacheInfo.routineId;
        }
        return -1;
    }

    @Override
    public IfxFParam getFPCacheFParam(String signature) {
        FPCacheInfo cacheInfo = this.fpCache.get(signature);
        if (cacheInfo != null) {
            return cacheInfo.fparam;
        }
        return null;
    }

    @Override
    public void setFPCacheInfo(int routineId, String signature, IfxFParam fparam) {
        this.fpCache.put(signature, new FPCacheInfo(routineId, fparam));
    }

    private String strip(String name) {
        int start = name.indexOf(40);
        int end = name.indexOf(41);
        if (start != 0 && end != 0) {
            return name.substring(0, start);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeStmtId(IfxStatement stmt, int id) {
        WeakReference<IfxStatement> weakStmt = null;
        IfxStatement stm = null;
        Vector<StmtList> vector = this.stmtList;
        synchronized (vector) {
            for (int i = 0; i < this.stmtList.size(); ++i) {
                weakStmt = this.stmtList.get((int)i).weakReferenceStmt;
                stm = (IfxStatement)weakStmt.get();
                if (stmt != stm) continue;
                this.stmtList.get((int)i).stmtId = id;
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToStmtList(IfxStatement stmt) {
        Vector<StmtList> vector = this.stmtList;
        synchronized (vector) {
            WeakReference<IfxStatement> weakStmt = new WeakReference<IfxStatement>(stmt, this.stmtReferenceQueue);
            this.stmtList.addElement(new StmtList(weakStmt, stmt.prot.getStatementID()));
        }
    }

    private void addToSvptList(Savepoint svpt) {
        if (this.svptList == null) {
            this.svptList = new ArrayList(10);
        }
        this.svptList.add(new WeakReference<Savepoint>(svpt));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markStatementAsReleased() {
        IfxStatement stmt = null;
        WeakReference<IfxStatement> weakStmt = null;
        Vector<StmtList> vector = this.stmtList;
        synchronized (vector) {
            for (int i = 0; i < this.stmtList.size(); ++i) {
                weakStmt = this.stmtList.get((int)i).weakReferenceStmt;
                stmt = (IfxStatement)weakStmt.get();
                if (stmt == null) continue;
                stmt.setIsReleased(true);
                this.stmtList.get((int)i).stmtId = Integer.valueOf("-1");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markCursorsToClosed(boolean checkStmtType) {
        IfxStatement stmt = null;
        WeakReference<IfxStatement> weakStmt = null;
        Vector<StmtList> vector = this.stmtList;
        synchronized (vector) {
            for (int i = 0; i < this.stmtList.size(); ++i) {
                weakStmt = this.stmtList.get((int)i).weakReferenceStmt;
                stmt = (IfxStatement)weakStmt.get();
                if (stmt == null) continue;
                if (checkStmtType) {
                    int isRsetHoldable = stmt.getResultSetHoldability();
                    if (stmt.getStatementType() == 56 || isRsetHoldable == 1) continue;
                    stmt.cursorOpen = false;
                    continue;
                }
                stmt.cursorOpen = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromStmtList(IfxStatement stmt) {
        Vector<StmtList> vector = this.stmtList;
        synchronized (vector) {
            WeakReference<IfxStatement> weakStmt = null;
            int count = this.stmtList.size();
            for (int i = 0; i < count; ++i) {
                StmtList stmtNode = this.stmtList.get(i);
                weakStmt = stmtNode.weakReferenceStmt;
                if (stmt != weakStmt.get()) continue;
                this.stmtList.remove(stmtNode);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void freeStatementWeakReferences() {
        try {
            Vector<StmtList> vector = this.stmtList;
            synchronized (vector) {
                WeakReference<IfxStatement> weakStmt = null;
                IfxStatement stmt = null;
                for (int index = 0; index < this.stmtList.size(); ++index) {
                    StmtList stmtNode = this.stmtList.get(index);
                    weakStmt = stmtNode.weakReferenceStmt;
                    if (!weakStmt.isEnqueued() || !this.isOpen) continue;
                    stmt = (IfxStatement)weakStmt.get();
                    if (stmt != null && !stmt.Closed) {
                        try {
                            lg.debug("Closing Statement #{}", stmt.getId());
                            stmt.close();
                            continue;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        finally {
                            --index;
                        }
                    }
                    try {
                        lg.debug("Releasing Statement #{}", stmtNode.stmtId);
                        this.proto.executeRelease(stmtNode.stmtId);
                        continue;
                    }
                    catch (Exception e) {
                        lg.warn("Exception attempting to free Statement #{}", stmtNode.stmtId, e);
                        continue;
                    }
                    finally {
                        stmtNode.stmtId = -1;
                        this.stmtList.remove(index);
                        --index;
                    }
                }
                try {
                    while (this.stmtReferenceQueue.remove(1L) != null) {
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.unlockSession();
        }
    }

    public synchronized void addToBlobList(IfxSmartBlob x) {
        if (this.blobTable == null) {
            this.blobTable = new Hashtable(100);
        }
        if (x != null) {
            WeakReference<IfxSmartBlob> weakBlob = new WeakReference<IfxSmartBlob>(x);
            this.blobTable.put(((IfxSmartBlob)weakBlob.get()).hashCode(), weakBlob);
        }
    }

    public synchronized void releaseBlob() {
        if (this.blobTable != null) {
            WeakReference<IfxSmartBlob> WeakBlob = null;
            Enumeration<Integer> en = this.blobTable.keys();
            while (en.hasMoreElements()) {
                Integer hashKey = en.nextElement();
                WeakBlob = this.blobTable.get(hashKey);
                IfxSmartBlob b = (IfxSmartBlob)WeakBlob.get();
                this.blobTable.remove(hashKey);
                if (b == null || b.getHandle() == -1) continue;
                try {
                    b.IfxLoClose(b.getHandle());
                    b.IfxLoRelease();
                }
                catch (SQLException e) {
                    System.out.println("error " + e.getMessage());
                }
            }
        }
        this.closeFinalizedBlobsOnServer();
    }

    public boolean isInUserTransaction() {
        return this.TxState == 2;
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.resultSetHoldability = this.validateAndMapRsHoldability(holdability);
    }

    boolean validateAndMapRsHoldability(int holdability) throws SQLException {
        if (holdability != 2 && holdability != 1) {
            throw Messages.getSQLException(-79773, this);
        }
        return holdability == 1;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.isHoldable() ? 1 : 2;
    }

    boolean isHoldable() {
        return this.resultSetHoldability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepointX(new IfxSavepoint(this, this.savePointCounter.incrementAndGet()), false);
    }

    private Savepoint setSavepointX(Savepoint savepoint, boolean uniqFlag) throws SQLException {
        if (!this.isSavepointSupported()) {
            throw Messages.getSQLException(-79700, ": IfxSqliConnection:setSavepoint()");
        }
        if (!this.isOpen) {
            throw Messages.getSQLException(-79730);
        }
        if (this.autoCommit) {
            throw Messages.getSQLException(-79889);
        }
        if (!this.db_use_log) {
            throw Messages.getSQLException(-79744, this);
        }
        if (this.inXATransaction()) {
            throw Messages.getSQLException(-79890);
        }
        this.proto.executeSavepoint(savepoint.getSavepointName(), uniqFlag);
        this.addToSvptList(savepoint);
        return savepoint;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.setSavepointX(new IfxSavepoint(this, name, this.savePointCounter.incrementAndGet()), false);
    }

    @Override
    public Savepoint setSavepointUnique(String name) throws SQLException {
        return this.setSavepointX(new IfxSavepoint(this, name, this.savePointCounter.incrementAndGet()), true);
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (!this.isSavepointSupported()) {
            throw Messages.getSQLException(-79700, ": IfxSqliConnection:setSavepoint()", Locale.getDefault());
        }
        if (!this.isOpen) {
            throw Messages.getSQLException(-79730);
        }
        if (savepoint == null) {
            throw Messages.getSQLException(-79892);
        }
        if (this.autoCommit) {
            throw Messages.getSQLException(-79889);
        }
        if (!this.db_use_log) {
            throw Messages.getSQLException(-79744);
        }
        if (this.inXATransaction()) {
            throw Messages.getSQLException(-79890);
        }
        try {
            if (this != ((IfxSavepoint)savepoint).connection) {
                throw Messages.getSQLException(-79893);
            }
        }
        catch (ClassCastException e) {
            throw Messages.getSQLException(-79893);
        }
        this.proto.executeRollbackSavepoint(savepoint.getSavepointName());
        ((IfxSavepoint)savepoint).closeResultSet();
        this.removeSavepointFromList(savepoint);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!this.isSavepointSupported()) {
            throw Messages.getSQLException(-79700, ": IfxSqliConnection:setSavepoint()", Locale.getDefault());
        }
        if (!this.isOpen) {
            throw Messages.getSQLException(-79730);
        }
        if (savepoint == null) {
            throw Messages.getSQLException(-79892);
        }
        if (this.autoCommit) {
            throw Messages.getSQLException(-79889);
        }
        if (!this.db_use_log) {
            throw Messages.getSQLException(-79744);
        }
        if (this.inXATransaction()) {
            throw Messages.getSQLException(-79890);
        }
        try {
            if (this != ((IfxSavepoint)savepoint).connection) {
                throw Messages.getSQLException(-79893);
            }
        }
        catch (ClassCastException e) {
            throw Messages.getSQLException(-79893);
        }
        this.proto.executeReleaseSavepoint(savepoint.getSavepointName());
        this.removeSavepointFromList(savepoint);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        IfxStatement stmt = new IfxStatement(this);
        this.processNewStatement(stmt, resultSetType, resultSetConcurrency, resultSetHoldability);
        return stmt;
    }

    public void processNewStatement(IfxStatement s, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        s.setResultSetType(resultSetType);
        s.setResultSetConcurrency(resultSetConcurrency);
        s.setResultSetHoldability(this.validateAndMapRsHoldability(resultSetHoldability));
        this.addToStmtList(s);
    }

    @Override
    public IfxPreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        IfxPreparedStatement preparedStatement = this.getCachedPreparedStatement(IfxPreparedStatement.class, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (preparedStatement == null) {
            preparedStatement = new IfxPreparedStatement(this, sql);
            this.processNewStatement(preparedStatement, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        return preparedStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        IfxPreparedStatement pstmt;
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 99, "IfxSqliConnect.CallableStatement(,,,) called");
        }
        if ((pstmt = this.getCachedPreparedStatement(IfxCallableStatement.class, sql, resultSetType, resultSetConcurrency, resultSetHoldability)) == null) {
            IfxCallableStatement stmt = new IfxCallableStatement((Connection)this, sql);
            this.processNewStatement(stmt, resultSetType, resultSetConcurrency, resultSetHoldability);
            return stmt;
        }
        return (CallableStatement)((Object)pstmt);
    }

    void setSQLStatementOffset(int errorOffset) {
        this.stmtErrorOffset = errorOffset;
    }

    @Override
    public int getSQLStatementOffset() {
        return this.stmtErrorOffset;
    }

    protected void startMetaDataQuery() throws SQLException {
        if (!(this.inXATransaction() || this.isInUserTransaction() || this.autoCommit)) {
            this.setAutoCommit(true);
            this.autoCommitModeChanged = true;
        }
        lg.debug("MetaDataQuery Started. AutoCommit changed: {}, AutoCommit Enabled: {}", this.autoCommitModeChanged, (Object)this.autoCommit);
    }

    protected void endMetaDataQuery() throws SQLException {
        if (this.autoCommitModeChanged) {
            this.setAutoCommit(false);
            this.autoCommitModeChanged = false;
        }
        lg.debug("MetaDataQuery Ended. TxState: {}, AutoCommit Enabled: {}", this.TxState, (Object)this.autoCommit);
    }

    private void setLockModeWait(int lockTime) throws SQLException {
        String sql;
        if (lockTime == 0) {
            return;
        }
        switch (lockTime) {
            case -1: {
                sql = "set lock mode to wait ";
                break;
            }
            case 0: {
                sql = "set lock mode to not wait ";
                break;
            }
            default: {
                sql = "set lock mode to wait " + Integer.toString(lockTime);
            }
        }
        lg.debug("Lock timeout: {}", (Object)sql);
        try (Statement stmt = this.createStatement();){
            stmt.executeUpdate(sql);
            this.lockModeWaitChanged = true;
            this.newLockModeWaitStr = sql;
        }
    }

    private void setIsolationLevel(String iso_level) throws SQLException {
        int level;
        if (TraceFlag.isTraceEnabled()) {
            this.traceObj.writeTrace(logger, 1, "Connection.setIsolationLevel() called");
        }
        try {
            level = Integer.parseInt(iso_level.substring(0, 1));
        }
        catch (NumberFormatException e) {
            level = 1;
        }
        if (level == 1 && !this.db_use_log) {
            return;
        }
        String sql = null;
        String sqlExt = "";
        this.transactionLevel = 0;
        if (!this.IsLastCommittedSupported() && level == 5) {
            level = 6;
        }
        if (iso_level.length() > 1 && iso_level.charAt(1) == 'U') {
            sqlExt = " retain update locks";
        }
        switch (level) {
            case 1: {
                sql = "set isolation to Dirty Read" + sqlExt;
                this.transactionLevel = 1;
                break;
            }
            case 2: {
                sql = "set isolation to Committed Read" + sqlExt;
                this.transactionLevel = 2;
                break;
            }
            case 3: {
                sql = "set isolation to Cursor Stability" + sqlExt;
                this.transactionLevel = 2;
                break;
            }
            case 4: {
                sql = "set isolation to Repeatable Read" + sqlExt;
                this.transactionLevel = 4;
                break;
            }
            case 5: {
                sql = "set isolation to committed read last committed" + sqlExt;
                this.transactionLevel = 5;
                break;
            }
            default: {
                if (this.AnsiDb) {
                    sql = "set isolation to Repeatable Read" + sqlExt;
                    this.transactionLevel = 8;
                    break;
                }
                if (this.db_use_log) {
                    sql = "set isolation to Committed Read" + sqlExt;
                    this.transactionLevel = 2;
                    break;
                }
                return;
            }
        }
        this.isolationLevelChanged = true;
        this.newIsolationLevelStr = sql;
        this.setServerIsolationLevel();
    }

    public void setServerIsolationLevel() throws SQLException {
        if (this.isDatabaseOpen && this.isolationLevelChanged) {
            Statement stmt = this.createStatement();
            stmt.execute(this.newIsolationLevelStr);
            this.newTxLevel = this.transactionLevel;
            stmt.close();
        }
    }

    private void enhancedProtocolMechanism() throws SQLException {
        long startTime = System.currentTimeMillis();
        this.proto.executeProtocols(this.clientProtocols);
        byte[] b = this.proto.getProtocols();
        if (lg.isDebugEnabled()) {
            lg.debug("Connection latency: {} ms", System.currentTimeMillis() - startTime);
        }
        block6: for (int i = 5; i < b.length; ++i) {
            switch (i) {
                case 5: {
                    this.handleProtocolByte_6(b[i]);
                    continue block6;
                }
                case 6: {
                    this.handleProtocolByte_7(b[i]);
                    continue block6;
                }
                case 7: {
                    this.handleProtocolByte_8(b[i]);
                    continue block6;
                }
                case 8: {
                    this.handleProtocolByte9(b[i]);
                    continue block6;
                }
            }
        }
    }

    private void handleProtocolByte_3(byte b) {
        if ((b & 0x20) > 0) {
            this.dbVersion.set(18);
        }
    }

    private void handleProtocolByte_6(byte b) {
        if ((b & 8) > 0) {
            this.dbVersion.set(44);
        }
    }

    private void handleProtocolByte_7(byte b) {
        if ((b & 8) > 0) {
            this.dbVersion.set(52);
        }
        if ((b & 2) > 0) {
            this.dbVersion.set(54);
        }
    }

    private void handleProtocolByte_8(byte b) {
        int for64kLimit;
        int forPrivate;
        if ((b & 0x80) > 0) {
            this.dbVersion.set(56);
        }
        if ((b & (forPrivate = 16)) > 0) {
            this.dbVersion.set(59);
        }
        if ((b & 4) > 0) {
            this.dbVersion.set(61);
        }
        if ((b & (for64kLimit = 2)) > 0) {
            this.dbVersion.set(62);
        }
        if ((b & 1) > 0) {
            this.dbVersion.set(63);
        }
    }

    private void handleProtocolByte9(byte b) {
        if ((b & 4) > 0) {
            this.dbVersion.set(69);
        }
        if ((b & 2) > 0) {
            this.dbVersion.set(70);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPending() {
        Vector<StmtList> vector = this.stmtList;
        synchronized (vector) {
            IfxStatement stmt = null;
            WeakReference<IfxStatement> weakStmt = null;
            for (int i = 0; i < this.stmtList.size(); ++i) {
                IfxResultSet resultSet;
                weakStmt = this.stmtList.get((int)i).weakReferenceStmt;
                stmt = (IfxStatement)weakStmt.get();
                if (stmt == null || stmt.Closed || (resultSet = stmt.currentResult) == null || !resultSet.isPending()) continue;
                if (!resultSet.isClosed() && !resultSet.withHold) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        lg.warn("Exception clearing statement list", e);
                    }
                }
                resultSet.setPending(false);
            }
        }
    }

    protected boolean isCommitNeeded() {
        return this.SendCommit;
    }

    @Override
    public boolean IsLastCommittedSupported() {
        String temp = null;
        try {
            temp = this.getDbVersion();
            int pos = temp.indexOf(46);
            temp = temp.substring(0, pos) + temp.substring(pos + 1, pos + 3);
            if (Integer.parseInt(temp) > 950 && Integer.parseInt(temp) < 1000 || Integer.parseInt(temp) >= 1100) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    protected void setTxnIsolationLvl(String sql) {
        String sqlStr = "";
        StringTokenizer st = new StringTokenizer(sql);
        while (st.hasMoreTokens()) {
            sqlStr = sqlStr + st.nextToken() + " ";
        }
        if (sqlStr != "") {
            if ((sqlStr = sqlStr.substring(0, sqlStr.length() - 1)).equalsIgnoreCase("set isolation to dirty read") || sqlStr.equalsIgnoreCase("set isolation dirty read")) {
                this.transactionLevel = 1;
            } else if (sqlStr.equalsIgnoreCase("set isolation to committed read") || sqlStr.equalsIgnoreCase("set isolation committed read")) {
                this.transactionLevel = 2;
            } else if (sqlStr.equalsIgnoreCase("set isolation to repeatable read") || sqlStr.equalsIgnoreCase("set isolation repeatable read")) {
                this.transactionLevel = 4;
            } else if (sqlStr.equalsIgnoreCase("set isolation to committed read last committed") || sqlStr.equalsIgnoreCase("set isolation committed read last committed")) {
                this.transactionLevel = 5;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromFileList(File ifxTmp) {
        List<File> list = this.fileList;
        synchronized (list) {
            this.fileList.remove(ifxTmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToFileList(File ifxTmp) {
        List<File> list = this.fileList;
        synchronized (list) {
            if (ifxTmp != null) {
                this.fileList.add(ifxTmp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteAllFiles() {
        List<File> list = this.fileList;
        synchronized (list) {
            for (File f : this.fileList) {
                try {
                    if (!f.exists()) continue;
                    Files.delete(f.toPath());
                }
                catch (Exception e) {
                    lg.warn("Unable to delete file: {}", f, e);
                }
            }
            this.fileList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSavepointFromList(Savepoint savepoint) {
        ArrayList<WeakReference<Savepoint>> arrayList = this.svptList;
        synchronized (arrayList) {
            WeakReference<Savepoint> weakSvpt = null;
            IfxSavepoint svpt = null;
            boolean remove = false;
            Iterator<WeakReference<Savepoint>> it = this.svptList.iterator();
            while (it.hasNext()) {
                if (remove) {
                    it.next();
                    it.remove();
                    continue;
                }
                weakSvpt = it.next();
                svpt = (IfxSavepoint)weakSvpt.get();
                if (svpt != savepoint) continue;
                remove = true;
                it.remove();
            }
        }
    }

    @Override
    public boolean isBigintSupported() {
        return this.dbVersion.get(54);
    }

    @Override
    public void setIsBigInt(boolean flag) {
        this.isBigIntType = flag;
    }

    @Override
    public boolean getIsBigInt() {
        return this.isBigIntType;
    }

    @Override
    public void setIsBigSerial(boolean flag) {
        this.isBigSerialType = flag;
    }

    @Override
    public boolean getIsBigSerial() {
        return this.isBigSerialType;
    }

    public boolean isLargeTupleSize() {
        return this.dbVersion.get(69);
    }

    @Override
    public boolean isLongRowId() {
        return this.dbVersion.get(70);
    }

    public boolean isReplCheckColumnEnabled() {
        return this.replCheck;
    }

    public void setReplCheckColumnEnabled(boolean flag) {
        this.replCheck = flag;
    }

    public boolean isCommitEnabled() {
        return this.ifCommit;
    }

    public void setCommitEnabled(boolean flag) {
        this.ifCommit = flag;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxSqliConnect.createArrayOf(String, Object[])", (IfxConnection)this);
    }

    @Override
    public Blob createBlob() throws SQLException {
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 2, "IfxSqliConnect:createBlob()");
        }
        return new IfxBblob(this);
    }

    @Override
    public Clob createClob() throws SQLException {
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 2, "IfxSqliConnect:createClob()");
        }
        return new IfxCblob(this);
    }

    @Override
    public NClob createNClob() throws SQLException {
        return new IfxCblob(this);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxSqliConnect.createSQLXML(String, Object[])", (IfxConnection)this);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw Messages.getSQLException(-79700, ": IfxSqliConnect.createStruct(String, Object[])", (IfxConnection)this);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return new Properties();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (!this.isOpen) {
            return false;
        }
        if (timeout < 0) {
            throw Messages.getSQLException(-79869);
        }
        if (timeout == 0) {
            return this.checkIfValid();
        }
        CompletableFuture<Boolean> f = CompletableFuture.supplyAsync(this::checkIfValid);
        try {
            boolean bl = f.get(timeout, TimeUnit.SECONDS);
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            f.cancel(true);
        }
    }

    private boolean checkIfValid() {
        try {
            this.getProto().executeVersion();
            return true;
        }
        catch (SQLException e) {
            lg.debug("Connection #{} no longer valid.", this.id);
            return false;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxSqliConnect:setClientInfo(Properties)not supported");
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxDatabaseMetaData:setClientInfo(String, String)not supported");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw Messages.getSQLException(-80053, this, this.getClass().getCanonicalName(), iface.getClass().getCanonicalName());
    }

    @Override
    public String retCapName(String capName) {
        if (this.useCaseCapName) {
            return capName.toUpperCase();
        }
        return capName.toLowerCase();
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    public void setDatabaseProductVersion(String dbVersion) {
        this.databaseProductVersion = dbVersion;
    }

    @Override
    public void setSchema(String schema) {
    }

    @Override
    public String getSchema() {
        return this.userName;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        executor.execute(() -> {
            block2: {
                try {
                    this.abortConnection();
                }
                catch (SQLException e) {
                    if (!TraceFlag.isTraceEnabled() || this.trace == null) break block2;
                    this.trace.writeTrace(logger, 2, e.getMessage());
                }
            }
        });
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            this.asfconn.setNetworkTimeout(milliseconds);
        }
        catch (SocketException e) {
            SQLException e1 = Messages.getSQLException(-908, this);
            e1.initCause(e);
            throw e1;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            return this.asfconn.getNetworkTimeout();
        }
        catch (SocketException e) {
            SQLException e1 = Messages.getSQLException(-908, this);
            e1.initCause(e);
            throw e1;
        }
    }

    @Override
    public boolean getAutoCaseSchema() {
        return this.autoCaseSchema;
    }

    @Override
    public void setAutoCaseSchema(boolean autoCase) {
        this.autoCaseSchema = autoCase;
    }

    @Override
    public boolean isUpperCaseMetaDataLabels() {
        return this.useUpperCaseMetadataLabels;
    }

    @Override
    public void setUpperCaseMetaDataLabels(boolean uppercaseMetaDataLabels) {
        this.useUpperCaseMetadataLabels = uppercaseMetaDataLabels;
    }

    @Override
    public synchronized Timer getStatementTimer() {
        if (this.statementTimer == null) {
            this.statementTimer = new Timer("ifx-jdbc-querytimer", true);
        }
        return this.statementTimer;
    }

    private void setupCustomEncoders(String newLocale, String newCodeSet, String newNlsMap) throws SQLException {
        int i;
        int numPairs;
        StringTokenizer pair_tok;
        if (newLocale != null) {
            pair_tok = new StringTokenizer(newLocale, ":");
            numPairs = pair_tok.countTokens();
            this.IfxToJdkLocaleTable = new Hashtable();
            for (i = 0; i < numPairs; ++i) {
                String new_locale = pair_tok.nextToken();
                StringTokenizer loc_tok = new StringTokenizer(new_locale, ",");
                String ifx_loc = loc_tok.nextToken(",");
                if (!loc_tok.hasMoreTokens()) {
                    throw Messages.getSQLException(-79784);
                }
                String jdk_loc = loc_tok.nextToken();
                this.addLocale(ifx_loc, jdk_loc);
            }
        }
        if (newCodeSet != null) {
            pair_tok = new StringTokenizer(newCodeSet, ":");
            numPairs = pair_tok.countTokens();
            this.IfxToJdkEncodingTable = new Hashtable();
            this.IfxNoToJdkEncodingTable = new Hashtable();
            for (i = 0; i < numPairs; ++i) {
                String new_codeset = pair_tok.nextToken();
                StringTokenizer enc_tok = new StringTokenizer(new_codeset, ",");
                String jdkEnc = enc_tok.nextToken();
                if (!enc_tok.hasMoreTokens()) {
                    throw Messages.getSQLException(-79783);
                }
                String ifxEncName = enc_tok.nextToken();
                this.addEncName(ifxEncName, jdkEnc);
                if (!enc_tok.hasMoreTokens()) {
                    throw Messages.getSQLException(-79783);
                }
                String ifxEncNumber = enc_tok.nextToken();
                this.addEncNumber(ifxEncNumber, jdkEnc);
            }
        }
        if (newNlsMap != null) {
            String nls = null;
            String jdkLocale = null;
            String jdkCodeset = null;
            StringTokenizer pair_tok2 = new StringTokenizer(newNlsMap, ":");
            int numMaps = pair_tok2.countTokens();
            if (this.NLSToJDK == null) {
                this.NLSToJDK = new Hashtable();
            }
            for (int i2 = 0; i2 < numMaps; ++i2) {
                String new_NLSMap = pair_tok2.nextToken();
                StringTokenizer nls_tok = new StringTokenizer(new_NLSMap, ",");
                if (nls_tok.hasMoreTokens()) {
                    nls = nls_tok.nextToken();
                }
                if (nls_tok.hasMoreTokens()) {
                    jdkLocale = nls_tok.nextToken();
                }
                if (nls_tok.hasMoreTokens()) {
                    jdkCodeset = nls_tok.nextToken();
                }
                if (nls == null || jdkLocale == null || jdkCodeset == null) {
                    throw Messages.getSQLException(-79783, this);
                }
                this.addNLSMap(nls.trim(), jdkLocale.trim(), jdkCodeset.trim());
                nls = null;
                jdkLocale = null;
                jdkCodeset = null;
            }
        }
    }

    public boolean getEncoption() {
        return this.encoption;
    }

    public AdvancedUppercaseProperties getProperties() {
        return this.connInfo;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public boolean processTableNameForResultSet() {
        return this.processTableNameForResultSet;
    }

    private void setSessionVariables() throws SQLException {
        if (this.connInfo.containsKey("sessionVariables")) {
            try (Statement s = this.createStatement();){
                for (String pair : this.connInfo.asString("sessionVariables").split(",")) {
                    if ((pair = pair.trim()).isEmpty()) continue;
                    if (pair.contains("=")) {
                        String[] keyValue = pair.split("=");
                        if (keyValue.length != 2) {
                            throw new IllegalArgumentException("sessionVariables parameter incorrect: " + pair);
                        }
                        keyValue[1] = keyValue[1].trim();
                        if (!keyValue[1].startsWith("'") && !keyValue[1].endsWith("'")) {
                            keyValue[1] = "'" + keyValue[1] + "'";
                        } else if (!keyValue[1].startsWith("'") || !keyValue[1].endsWith("'")) {
                            throw new IllegalArgumentException("sessionVariables parameter must have enclosing single quotes: " + pair);
                        }
                        String sql = "SET ENVIRONMENT " + keyValue[0].trim() + " " + keyValue[1];
                        lg.debug("Setting session variable: {}", keyValue);
                        s.execute(sql);
                        continue;
                    }
                    throw new IllegalArgumentException("sessionVariables parameter incorrect: " + pair);
                }
            }
        }
    }

    public String toString() {
        return "JDBC Connection #" + this.id;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean isOpen) {
        lg.debug("Connection #{} has been set to {}.", this.id, (Object)isOpen);
        this.isOpen = isOpen;
    }

    private class FPCacheInfo {
        int routineId = -1;
        IfxFParam fparam = null;

        FPCacheInfo(int routineId, IfxFParam fparam) {
            this.routineId = routineId;
            this.fparam = fparam;
        }

        public String toString() {
            return "Fast Path Cache Info: Routine # " + this.routineId + "\n" + this.fparam;
        }
    }

    private class FinalizedBlobsTable {
        private final List<FinalizedBlobInfo> table = Collections.synchronizedList(new LinkedList());

        private FinalizedBlobsTable() {
        }

        FinalizedBlobInfo remove() {
            FinalizedBlobInfo retval;
            try {
                retval = this.table.remove(0);
            }
            catch (Exception e) {
                retval = null;
            }
            return retval;
        }

        void add(FinalizedBlobInfo inVal) {
            this.table.add(inVal);
        }

        boolean hasElements() {
            return !this.table.isEmpty();
        }

        boolean needPurge() {
            return !this.table.isEmpty();
        }
    }

    private class FinalizedBlobInfo {
        private final int loFd;
        private final IfxLocator locator;

        FinalizedBlobInfo(int inLoFd, IfxLocator inLocator) {
            this.loFd = inLoFd;
            this.locator = inLocator;
        }

        int getLoFd() {
            return this.loFd;
        }

        IfxLocator getLocator() {
            return this.locator;
        }
    }

    static class IfxSqliConnectCleaner
    implements Runnable {
        IfxSqliConnectCleaner() {
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            wrConn = null;
            conn = null;
            while (true) {
                try {
                    block10: while (true) {
                        if ((wrConn = IfxSqliConnect.queueOfConnections.poll(15L, TimeUnit.SECONDS)) == null || (conn = (IfxSqliConnect)wrConn.get()) == null) {
                            continue;
                        }
                        try {
                            conn.freeStatementWeakReferences();
                        }
                        catch (Exception var3_3) {
                            // empty catch block
                        }
                        delay = conn.cleanerDelay;
                        enqueued = false;
                        while (true) {
                            if (!enqueued) ** break;
                            continue block10;
                            try {
                                enqueued = IfxSqliConnect.queueOfConnections.offer(new DelayedWeakReference<IfxSqliConnect>(conn, delay));
                            }
                            catch (OutOfMemoryError oome) {
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException var7_9) {}
                            }
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception var3_6) {
                    continue;
                }
                break;
            }
        }
    }

    private static class IfxSqliConnectCleanerThreadFactory
    implements ThreadFactory {
        private static final AtomicLong id = new AtomicLong();
        private static final String THREAD_NAME_PREFIX = "IfxCleaner-Thread-";
        private static final String THREAD_GROUP_NAME = "IfxCleaners";
        private final ThreadGroup threadGroup = new ThreadGroup("IfxCleaners");

        private IfxSqliConnectCleanerThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            String threadName = THREAD_NAME_PREFIX + id.incrementAndGet();
            Thread thread = new Thread(this.threadGroup, r, threadName);
            thread.setDaemon(true);
            return thread;
        }
    }

    class StmtList {
        final WeakReference<IfxStatement> weakReferenceStmt;
        int stmtId;

        StmtList(WeakReference<IfxStatement> weakRef, int id) {
            this.weakReferenceStmt = weakRef;
            this.stmtId = id;
        }
    }
}

