/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBaseType;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxUDTInput;
import com.informix.jdbc.UDTSQLData;
import com.informix.jdbc.types.lob.ImmutableClob;
import com.informix.lang.JavaToIfxType;
import com.informix.lang.Messages;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.Map;

public class IfxUDT
extends IfxBaseType {
    private SQLData udtClass;

    public IfxUDT() {
        this.setIfxType(44);
    }

    IfxUDT(byte[] b) throws SQLException {
        this.setIfxType(44);
        this.fromBytes(b);
    }

    IfxUDT(InputStream x, int length) throws SQLException {
        this.setIfxType(44);
        this.fromInputStream(x, length);
    }

    @Override
    public void fromObject(Object data) throws SQLException {
        if (data == null) {
            this.nullify();
            this.udtClass = null;
        } else {
            String ename;
            if (!(data instanceof SQLData)) {
                throw Messages.getSQLException(-79728);
            }
            this.udtClass = (SQLData)data;
            if (!this.conn.isDirect()) {
                this.outputStream.reset();
                this.udtClass.writeSQL(this.outputStream);
            }
            if ((ename = this.udtClass.getSQLTypeName()) != null) {
                this.setExtendedTypeName(ename);
            }
            this.unnullify();
        }
    }

    @Override
    public Object toObject() throws SQLException {
        return this.toObject(false);
    }

    @Override
    public Object toObject(boolean fromComplexType) throws SQLException {
        if (this.isNull) {
            return null;
        }
        if (!fromComplexType && this.conn.isDirect() && this.udtClass != null) {
            return this.udtClass;
        }
        if (this.typeMap == null && (this.typeMap = this.conn.getTypeMap()) == null) {
            throw Messages.getSQLException(-79769);
        }
        Class cls = (Class)this.typeMap.getOrDefault("*", this.typeMap.get(this.extendedName));
        if (cls == null) {
            String lowerCaseName = this.extendedName.toLowerCase();
            for (Map.Entry entry : this.typeMap.entrySet()) {
                if (!lowerCaseName.startsWith(((String)entry.getKey()).toLowerCase())) continue;
                cls = (Class)entry.getValue();
                break;
            }
            if (cls == null) {
                throw Messages.getSQLException(-79769, this.extendedName);
            }
        }
        try {
            this.udtClass = (SQLData)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (this.udtClass instanceof IfxUDT) {
                ((IfxUDT)IfxUDT.class.cast(this.udtClass)).setConnection(this.conn);
            }
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79716);
        }
        if (this.inputStream == null && this.outputStream.length() > 0) {
            this.inputStream = new IfxUDTInput(this.conn, this.outputStream.toByteArray(), 0, this.outputStream.length());
        }
        this.udtClass.readSQL(this.inputStream, this.extendedName);
        if (this.udtClass instanceof UDTSQLData) {
            return ((UDTSQLData)this.udtClass).getSQLDataObject();
        }
        return this.udtClass;
    }

    @Override
    public void fromBytes(byte[] b) throws SQLException {
        this.outputStream.reset();
        this.outputStream.writeBytes(b, b.length);
        this.inputStream = new IfxUDTInput(this.conn, b, 0, b.length);
        this.unnullify();
    }

    @Override
    public void fromString(String str) throws SQLException {
        if (this.conn == null) {
            this.fromBytes(str.getBytes());
        } else {
            this.fromBytes(JavaToIfxType.JavaToIfxLvarchar(str, this.conn.getdbEncoding(), ((IfxSqliConnect)this.conn).encoption));
        }
    }

    @Override
    public byte[] toBytes() throws SQLException {
        if (this.isNull() || this.inputStream == null) {
            return null;
        }
        return this.inputStream.toByteArray();
    }

    @Override
    public void fromInputStream(InputStream x, int length) throws SQLException {
        byte[] b = new byte[length];
        int offset = 0;
        try {
            int readLen;
            do {
                readLen = x.read(b, offset, length);
                offset += readLen;
            } while ((length -= readLen) > 0);
            this.outputStream.reset();
            this.outputStream.writeBytes(b, length);
            this.inputStream = new IfxUDTInput(this.conn, b, 0, length);
            this.unnullify();
        }
        catch (Exception e) {
            throw Messages.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public InputStream toBinaryStream() throws SQLException {
        if (this.isNull() || this.inputStream == null) {
            return null;
        }
        return new ByteArrayInputStream(this.inputStream.toByteArray());
    }

    @Override
    public void clear() {
        this.udtClass = null;
        this.nullify();
    }

    @Override
    public String toString() {
        if (this.isNull) {
            return "";
        }
        if (this.conn.isDirect()) {
            if (this.udtClass != null) {
                return this.udtClass.toString();
            }
            return "null";
        }
        try {
            return this.toObject().toString();
        }
        catch (SQLException e) {
            throw new RuntimeException("Cannot get string value for UDT [" + this.extendedName + "]", e);
        }
    }

    @Override
    public Clob toClob() {
        return new ImmutableClob(this.toString());
    }
}

