/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.lang.Messages;
import com.informix.util.dateUtil;
import com.informix.util.stringUtil;
import java.security.SecureRandom;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class NativeSQL {
    public static final char LBRACE = '{';
    public static final char RBRACE = '}';
    public static final String SLBRACE = "{";
    public static final String SRBRACE = "}";
    public static final String SLPAREN = "(";
    public static final String SRPAREN = ")";
    public static final char LPAREN = '(';
    public static final char RPAREN = ')';
    public static final String SBPAREN = "()";
    public static final char DQUOTE = '\"';
    public static final String SDQUOTE = "\"";
    public static final String SQUOTE = "'";
    public static final char QUOTE = '\'';
    public static final char LBRACK = '[';
    public static final char RBRACK = ']';
    public static final String SLBRACK = "[";
    public static final String SRBRACK = "]";
    public static final char COMMA = ',';
    public static final String SCOMMA = ",";
    public static final char SEMICOLON = ';';
    public static final String SSEMICOLON = ";";
    public static final char SPACE = ' ';
    public static final String SSPACE = " ";
    public static final String STAB = "\t";
    private static final HashMap<String, String> funcTable = new HashMap();

    private NativeSQL() {
    }

    public static String parseSQLString(IfxConnection conn, String sql) throws SQLException {
        if (sql.indexOf(123) == -1 || sql.indexOf(125) == -1) {
            return sql;
        }
        String searchCond = "";
        boolean ansiJoinSupp = true;
        String resStr = "";
        int isAStoredProcCall = 0;
        boolean validSequence = true;
        int startQuote = -1;
        String markers = "{} \t";
        StringTokenizer strT = new StringTokenizer(sql, markers, true);
        String oldToken = "";
        String token = "";
        while (strT.hasMoreTokens()) {
            String lastChar;
            String firstChar;
            String f;
            if (token.trim().length() > 0) {
                oldToken = token.toLowerCase();
            }
            token = strT.nextToken();
            String nativeString = "";
            startQuote = NativeSQL.trackQuotes(token, startQuote);
            if (!token.equals(SLBRACE)) {
                if (!ansiJoinSupp && token.equalsIgnoreCase("WHERE")) {
                    if (searchCond.length() > 0) {
                        resStr = resStr + "and";
                        continue;
                    }
                    resStr = resStr + token;
                    continue;
                }
                resStr = resStr + token;
                continue;
            }
            if (NativeSQL.isWithinQuotes(startQuote)) {
                resStr = resStr + token;
                continue;
            }
            if (NativeSQL.using9xSyntax(oldToken)) {
                resStr = resStr + token;
                continue;
            }
            int nsrbraces = 0;
            for (int i = 0; i < sql.length(); ++i) {
                char c = sql.charAt(i);
                if (c != SRBRACE.charAt(0)) continue;
                ++nsrbraces;
            }
            int nsrbracefound = 0;
            boolean isproccall = false;
            while (strT.hasMoreTokens() && (!token.equals(SRBRACE) || nsrbracefound < nsrbraces && isproccall)) {
                oldToken = token;
                token = strT.nextToken();
                if (token.equalsIgnoreCase("call")) {
                    isproccall = true;
                }
                if (token.equals(SRBRACE)) {
                    ++nsrbracefound;
                }
                if (token.equals(SRBRACE) && (nsrbracefound >= nsrbraces || !isproccall)) continue;
                nativeString = nativeString + token;
            }
            StringTokenizer str = new StringTokenizer(nativeString);
            String kw = str.hasMoreTokens() ? str.nextToken() : "";
            if (kw.equalsIgnoreCase("call")) {
                isAStoredProcCall = 1;
            } else {
                StringTokenizer checkT = new StringTokenizer(nativeString);
                if (checkT.countTokens() < 4) {
                    isAStoredProcCall = 0;
                } else {
                    checkT.nextToken();
                    isAStoredProcCall = !checkT.nextToken().equals("=") ? 0 : (!checkT.nextToken().equalsIgnoreCase("call") ? 0 : 2);
                }
            }
            if (isAStoredProcCall > 0) {
                String splname;
                if (!str.hasMoreTokens()) {
                    throw Messages.getSQLException(-79710, SLBRACE + nativeString + SRBRACE, conn);
                }
                String exe = "execute procedure ";
                if (isAStoredProcCall > 1) {
                    exe = "execute function ";
                }
                if (isAStoredProcCall > 1) {
                    str.nextToken();
                    str.nextToken();
                }
                if ((splname = str.nextToken()).indexOf(40) > 0) {
                    splname = splname.substring(0, splname.indexOf(40));
                }
                int lstring = nativeString.indexOf(40);
                int rstring = nativeString.lastIndexOf(41) + 1;
                f = lstring != -1 && rstring != -1 ? splname + nativeString.substring(nativeString.indexOf(40), nativeString.lastIndexOf(41) + 1) : splname;
                resStr = resStr + exe + f;
                if (f.indexOf(40) != -1) continue;
                resStr = resStr + SBPAREN;
                continue;
            }
            if (kw.equals("d") && str.hasMoreTokens()) {
                String d = str.nextToken(SRBRACE).trim();
                String locdateStr = null;
                firstChar = d.substring(0, 1);
                lastChar = d.substring(d.length() - 1, d.length());
                String nativedateStr = d.substring(1, d.length() - 1);
                if (!firstChar.equals(SQUOTE) || !lastChar.equals(SQUOTE)) {
                    throw Messages.getSQLMinorException(-79710, SDQUOTE + sql + SDQUOTE, -80004, "''' ");
                }
                locdateStr = dateUtil.convertNativeSQLDate(nativedateStr, conn);
                resStr = resStr + SQUOTE + locdateStr + SQUOTE;
                continue;
            }
            if (kw.equals("t") && str.hasMoreTokens()) {
                String t = str.nextToken(SRBRACE).trim();
                String loctimeStr = null;
                boolean isTime = true;
                firstChar = t.substring(0, 1);
                lastChar = t.substring(t.length() - 1, t.length());
                String nativetimeStr = t.substring(1, t.length() - 1);
                if (!firstChar.equals(SQUOTE) || !lastChar.equals(SQUOTE)) {
                    throw Messages.getSQLMinorException(-79710, SDQUOTE + sql + SDQUOTE, -80004, "''' ");
                }
                loctimeStr = dateUtil.convertNativeSQLDateTime(nativetimeStr, conn, isTime);
                resStr = resStr + SQUOTE + loctimeStr + SQUOTE;
                continue;
            }
            if (kw.equals("ts") && str.hasMoreTokens()) {
                String ts = str.nextToken(SRBRACE).trim();
                String locdatetimeStr = null;
                boolean isTime = false;
                firstChar = ts.substring(0, 1);
                lastChar = ts.substring(ts.length() - 1, ts.length());
                String nativedatetimeStr = ts.substring(1, ts.length() - 1);
                if (!firstChar.equals(SQUOTE) || !lastChar.equals(SQUOTE)) {
                    throw Messages.getSQLMinorException(-79710, SDQUOTE + sql + SDQUOTE, -80004, "''' ");
                }
                locdatetimeStr = dateUtil.convertNativeSQLDateTime(nativedatetimeStr, conn, isTime);
                resStr = resStr + SQUOTE + locdatetimeStr + SQUOTE;
                continue;
            }
            if (kw.equals("fn") && str.hasMoreTokens()) {
                StringTokenizer argsT;
                f = str.nextToken(SRBRACE);
                StringTokenizer fT = new StringTokenizer(f, SBPAREN);
                if (!fT.hasMoreTokens()) {
                    throw Messages.getSQLException(-79710, SDQUOTE + str + SDQUOTE, conn);
                }
                String func = fT.nextToken().trim();
                String args = fT.hasMoreTokens() ? fT.nextToken(SBPAREN) : "";
                String ifxFunc = funcTable.get(func.toLowerCase());
                String ifxFuncNA = funcTable.get(func.toUpperCase());
                if (ifxFunc != null) {
                    resStr = resStr + ifxFunc + SLPAREN + args + SRPAREN;
                    continue;
                }
                if (ifxFuncNA != null) {
                    resStr = resStr + ifxFuncNA;
                    continue;
                }
                if (func.equalsIgnoreCase("cot")) {
                    resStr = resStr + SLPAREN + "cos" + SLPAREN + args + SRPAREN + "/sin" + SLPAREN + args + SRPAREN + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("degrees")) {
                    resStr = resStr + SLPAREN + args + " * 180 / " + Math.PI + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("pi")) {
                    resStr = resStr + Math.PI;
                    continue;
                }
                if (func.equalsIgnoreCase("radians")) {
                    resStr = resStr + SLPAREN + args + " * " + Math.PI + " / 180" + SRPAREN + SSPACE;
                    continue;
                }
                if (func.equalsIgnoreCase("rand")) {
                    resStr = resStr + new SecureRandom(args.getBytes()).nextFloat();
                    continue;
                }
                if (func.equalsIgnoreCase("concat")) {
                    argsT = new StringTokenizer(args, SCOMMA);
                    String arglist = "";
                    while (argsT.hasMoreTokens()) {
                        arglist = arglist + argsT.nextToken();
                        if (!argsT.hasMoreTokens()) continue;
                        arglist = arglist + " || ";
                    }
                    resStr = resStr + arglist;
                    continue;
                }
                if (func.equalsIgnoreCase("left")) {
                    StringTokenizer leftT = new StringTokenizer(args, SCOMMA);
                    if (leftT.countTokens() != 2) continue;
                    String arg1 = leftT.nextToken().trim();
                    String countStr = leftT.nextToken().trim();
                    int cnt = stringUtil.stringToInt(countStr) + 1;
                    resStr = resStr + ' ' + arg1 + '[' + "1, " + cnt + ']';
                    continue;
                }
                if (func.equalsIgnoreCase("ltrim")) {
                    resStr = resStr + "trim " + SLPAREN + "LEADING FROM " + args + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("rtrim")) {
                    resStr = resStr + "trim " + SLPAREN + "TRAILING FROM " + args + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("dayofweek")) {
                    resStr = resStr + SLPAREN + "weekday" + SLPAREN + args + SRPAREN + "+1" + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("hour")) {
                    resStr = resStr + "extend" + SLPAREN + args + ", hour to hour" + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("minute")) {
                    resStr = resStr + "extend" + SLPAREN + args + ", minute to minute" + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("second")) {
                    resStr = resStr + "extend" + SLPAREN + args + ", second to second" + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("database")) {
                    String db = conn.getCatalog();
                    if (db == null) continue;
                    resStr = resStr + db;
                    continue;
                }
                if (func.equalsIgnoreCase("ifnull")) {
                    argsT = new StringTokenizer(args, SCOMMA);
                    if (argsT.countTokens() != 2) {
                        throw Messages.getSQLException(-79713, SDQUOTE + f + SDQUOTE, conn);
                    }
                    String expr = argsT.nextToken().trim();
                    String value = argsT.nextToken().trim();
                    resStr = resStr + "ifnull('" + expr + "', " + value + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("convert")) {
                    argsT = new StringTokenizer(args, SCOMMA);
                    if (argsT.countTokens() != 2) {
                        throw Messages.getSQLException(-79713, SDQUOTE + f + SDQUOTE, conn);
                    }
                    String val = argsT.nextToken().trim();
                    String type = argsT.nextToken().trim();
                    if (type.equalsIgnoreCase("BINARY") || type.equalsIgnoreCase("BIT") || type.equalsIgnoreCase("LONGVARBINARY") || type.equalsIgnoreCase("VARBINARY")) {
                        throw Messages.getSQLException(-79714, ": " + type, conn);
                    }
                    resStr = resStr + val;
                    continue;
                }
                resStr = resStr + func + SLPAREN + args + SRPAREN;
                continue;
            }
            if (kw.equals("escape") && str.hasMoreTokens()) {
                String f2 = str.nextToken(SRBRACE);
                StringTokenizer fT = new StringTokenizer(f2, SSPACE);
                if (!fT.hasMoreTokens()) continue;
                resStr = resStr + "escape " + fT.nextToken();
                continue;
            }
            if (kw.equals("limit") && str.hasMoreTokens()) {
                f = str.nextToken(SRBRACE);
                StringTokenizer fT = new StringTokenizer(f, SSPACE);
                String limit = fT.nextToken();
                String skip = "";
                if (fT.hasMoreTokens()) {
                    skip = fT.nextToken();
                }
                resStr = resStr + "LIMIT " + limit;
                if (skip.isEmpty()) continue;
                resStr = "SELECT SKIP " + skip + resStr.substring(6);
                continue;
            }
            if (kw.equals("oj") && str.hasMoreTokens()) {
                String ojS = str.nextToken(SRBRACE);
                StringTokenizer ojT = new StringTokenizer(ojS, SSPACE, true);
                Vector<String> tabList = new Vector<String>();
                String tmp = "";
                String tab = "";
                while (ojT.hasMoreTokens()) {
                    tmp = ojT.nextToken();
                    tab = "";
                    if (tmp.equalsIgnoreCase("ON") || tmp.equalsIgnoreCase("LEFT") || tmp.equalsIgnoreCase("RIGHT") || tmp.equalsIgnoreCase("FULL")) {
                        throw Messages.getSQLMinorException(-79715, -80005, SDQUOTE + ojS + SDQUOTE);
                    }
                    while (!(!ojT.hasMoreTokens() || tmp.equalsIgnoreCase("LEFT") || tmp.equalsIgnoreCase("RIGHT") || tmp.equalsIgnoreCase("FULL") || tmp.equalsIgnoreCase("OUTER") || tmp.equalsIgnoreCase("JOIN") || tmp.equalsIgnoreCase("ON"))) {
                        tab = tab + tmp;
                        tmp = ojT.nextToken();
                    }
                    if (ansiJoinSupp) {
                        resStr = resStr + tab.trim();
                    } else {
                        tabList.add(tab.trim());
                    }
                    if (!ojT.hasMoreTokens()) {
                        throw Messages.getSQLMinorException(-79715, -80005, SDQUOTE + ojS + SDQUOTE);
                    }
                    String tok = tmp;
                    if (tok.equalsIgnoreCase("ON")) {
                        String tempCond = "";
                        while (ojT.hasMoreTokens()) {
                            tok = ojT.nextToken();
                            if (ansiJoinSupp) {
                                tempCond = tempCond + tok;
                                continue;
                            }
                            if (tok.equalsIgnoreCase("ON")) {
                                tempCond = tempCond + " and ";
                                continue;
                            }
                            tempCond = tempCond + tok;
                        }
                        if (ansiJoinSupp) {
                            searchCond = " on" + tempCond;
                            continue;
                        }
                        searchCond = " where " + tempCond;
                        continue;
                    }
                    if (tok.equalsIgnoreCase("LEFT") || tok.equalsIgnoreCase("RIGHT") || tok.equalsIgnoreCase("FULL")) {
                        if (ojT.countTokens() < 3) {
                            throw Messages.getSQLMinorException(-79715, -80005, SDQUOTE + ojS + SDQUOTE);
                        }
                        if (!(ojT.nextToken().equals(SSPACE) && ojT.nextToken().equalsIgnoreCase("OUTER") && ojT.nextToken().equals(SSPACE) && ojT.nextToken().equalsIgnoreCase("JOIN"))) {
                            throw Messages.getSQLMinorException(-79715, -80005, SDQUOTE + ojS + SDQUOTE);
                        }
                        if (!ansiJoinSupp) continue;
                        resStr = resStr + SSPACE + tok + " outer join ";
                        continue;
                    }
                    throw Messages.getSQLMinorException(-79715, -80005, SDQUOTE + ojS + SDQUOTE);
                }
                if (!ansiJoinSupp) {
                    String newJoin = "";
                    int i = 0;
                    int listSize = tabList.size();
                    for (i = 0; i < listSize; ++i) {
                        newJoin = i > 0 ? newJoin + ", outer(" + (String)tabList.elementAt(i) : newJoin + (String)tabList.elementAt(i);
                    }
                    for (i = 1; i <= listSize - 1; ++i) {
                        newJoin = newJoin + SRPAREN;
                    }
                    resStr = resStr + newJoin;
                }
                if (searchCond.length() <= 0) continue;
                resStr = resStr + searchCond;
                continue;
            }
            validSequence = false;
        }
        if (validSequence) {
            return resStr;
        }
        return sql;
    }

    private static boolean using9xSyntax(String s) {
        if (s == null) {
            return false;
        }
        boolean returnValue = false;
        String workingString = s.trim();
        if (workingString.length() == 0 || !workingString.endsWith("t")) {
            return returnValue;
        }
        int len = workingString.length();
        String[] compStrings = new String[]{"multiset", "list", "set"};
        for (int loop = 0; loop < compStrings.length && !returnValue; ++loop) {
            int compLen = compStrings[loop].length();
            if (compLen > len || !workingString.substring(len - compLen, len).equals(compStrings[loop])) continue;
            returnValue = true;
        }
        return returnValue;
    }

    private static int trackQuotes(String token, int currentStartQuoteVal) {
        int retVal = currentStartQuoteVal;
        block4: for (int i = 0; i < token.length(); ++i) {
            char ch = token.charAt(i);
            switch (ch) {
                case '\'': {
                    if (retVal == -1) {
                        retVal = ch;
                        continue block4;
                    }
                    if (retVal != ch) continue block4;
                    if (i + 1 < token.length() && token.charAt(i + 1) == '\'') {
                        ++i;
                        continue block4;
                    }
                    retVal = -1;
                    continue block4;
                }
                case '\"': {
                    if (retVal == -1) {
                        retVal = ch;
                        continue block4;
                    }
                    if (retVal != ch) continue block4;
                    if (i + 1 < token.length() && token.charAt(i + 1) == '\"') {
                        ++i;
                        continue block4;
                    }
                    retVal = -1;
                    continue block4;
                }
            }
        }
        return retVal;
    }

    private static boolean isWithinQuotes(int currStartQuoteStatus) {
        return currStartQuoteStatus != -1;
    }

    static {
        funcTable.put("abs", "abs");
        funcTable.put("acos", "acos");
        funcTable.put("asin", "asin");
        funcTable.put("atan", "atan");
        funcTable.put("atan2", "atan2");
        funcTable.put("ceiling", "round");
        funcTable.put("exp", "exp");
        funcTable.put("floor", "trunc");
        funcTable.put("log", "logn");
        funcTable.put("log10", "log10");
        funcTable.put("mod", "mod");
        funcTable.put("power", "pow");
        funcTable.put("round", "round");
        funcTable.put("sin", "sin");
        funcTable.put("sign", "sign");
        funcTable.put("sqrt", "sqrt");
        funcTable.put("tan", "tan");
        funcTable.put("truncate", "trunc");
        funcTable.put("length", "length");
        funcTable.put("dayofmonth", "day");
        funcTable.put("month", "month");
        funcTable.put("year", "year");
        funcTable.put("CURDATE", "today");
        funcTable.put("CURTIME", "current");
        funcTable.put("NOW", "current");
        funcTable.put("USER", "user");
    }
}

