/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.stream.cdc;

import com.informix.jdbc.ComplexTypeParser;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.stream.api.StreamRecord;
import com.informix.jdbc.stream.api.StreamRecordType;
import com.informix.jdbc.stream.cdc.records.CDCBeginTransactionRecord;
import com.informix.jdbc.stream.cdc.records.CDCCommitTransactionRecord;
import com.informix.jdbc.stream.cdc.records.CDCDiscardRecord;
import com.informix.jdbc.stream.cdc.records.CDCErrorRecord;
import com.informix.jdbc.stream.cdc.records.CDCMetaDataRecord;
import com.informix.jdbc.stream.cdc.records.CDCOperationRecord;
import com.informix.jdbc.stream.cdc.records.CDCRollbackTransactionRecord;
import com.informix.jdbc.stream.cdc.records.CDCTimeoutRecord;
import com.informix.jdbc.stream.cdc.records.CDCTruncateRecord;
import com.informix.jdbc.stream.impl.StreamException;
import com.informix.util.JdbcLogger;
import java.nio.ByteBuffer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class CDCRecordBuilder
implements AutoCloseable {
    private final JdbcLogger logger = JdbcLogger.getLogger(CDCRecordBuilder.class);
    private final Connection con;
    private final Map<String, List<IfxColumnInfo>> columnMap = new HashMap<String, List<IfxColumnInfo>>();

    public CDCRecordBuilder(Connection c) {
        this.con = c;
    }

    public StreamRecord buildRecord(byte[] bytes) throws SQLException, StreamException {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int headerSize = buffer.getInt() - 16;
        int payloadSize = buffer.getInt();
        buffer.getInt();
        int recordType = buffer.getInt();
        byte[] header = new byte[headerSize];
        byte[] payload = new byte[payloadSize];
        buffer.get(header);
        buffer.get(payload);
        this.logger.trace("Record type [{}]", recordType);
        switch (recordType) {
            case 200: {
                ArrayList<IfxColumnInfo> columns = new ArrayList<IfxColumnInfo>();
                ComplexTypeParser parser = new ComplexTypeParser((IfxConnection)this.con);
                Vector<IfxColumnInfo> c = parser.parseTypeInfo("row(" + new String(payload).trim() + ")");
                IfxColumnInfo info = (IfxColumnInfo)c.get(0);
                columns.addAll(info.getChildren());
                CDCMetaDataRecord record = new CDCMetaDataRecord(columns, header);
                this.columnMap.put(record.getLabel(), columns);
                return record;
            }
            case 40: {
                return new CDCOperationRecord(StreamRecordType.INSERT, header, payload, this.columnMap, this.con);
            }
            case 43: {
                return new CDCOperationRecord(StreamRecordType.AFTER_UPDATE, header, payload, this.columnMap, this.con);
            }
            case 42: {
                return new CDCOperationRecord(StreamRecordType.BEFORE_UPDATE, header, payload, this.columnMap, this.con);
            }
            case 41: {
                return new CDCOperationRecord(StreamRecordType.DELETE, header, payload, this.columnMap, this.con);
            }
            case 1: {
                return new CDCBeginTransactionRecord(header);
            }
            case 2: {
                return new CDCCommitTransactionRecord(header);
            }
            case 3: {
                return new CDCRollbackTransactionRecord(header);
            }
            case 62: {
                return new CDCDiscardRecord(header);
            }
            case 201: {
                return new CDCTimeoutRecord(header);
            }
            case 119: {
                return new CDCTruncateRecord(header);
            }
            case 202: {
                return new CDCErrorRecord(header);
            }
        }
        throw new StreamException("Record type:" + recordType + " not defined.");
    }

    @Override
    public void close() throws SQLException {
        this.con.close();
    }
}

