/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.stream.transactions;

import com.informix.jdbc.stream.api.StreamEngine;
import com.informix.jdbc.stream.api.StreamOperationRecord;
import com.informix.jdbc.stream.api.StreamRecord;
import com.informix.jdbc.stream.api.StreamRecordType;
import com.informix.jdbc.stream.cdc.records.CDCBeginTransactionRecord;
import com.informix.jdbc.stream.impl.StreamException;
import com.informix.jdbc.stream.transactions.StreamTransactionRecord;
import com.informix.util.JdbcLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TransactionEngine
implements com.informix.jdbc.stream.api.TransactionEngine {
    private final JdbcLogger logger = JdbcLogger.getLogger(TransactionEngine.class);
    protected static final Set<StreamRecordType> ALLOWED_DATA_FILTERS = EnumSet.of(StreamRecordType.INSERT, StreamRecordType.DELETE, StreamRecordType.BEFORE_UPDATE, StreamRecordType.AFTER_UPDATE);
    protected static final Set<StreamRecordType> ALLOWED_TRANSACTION_FILTERS = EnumSet.of(StreamRecordType.COMMIT, StreamRecordType.ROLLBACK);
    protected EnumSet<StreamRecordType> dataFilterSet = EnumSet.of(StreamRecordType.INSERT, StreamRecordType.DELETE, StreamRecordType.BEFORE_UPDATE, StreamRecordType.AFTER_UPDATE);
    protected EnumSet<StreamRecordType> transactionFilterSet = EnumSet.of(StreamRecordType.COMMIT);
    protected final Map<Integer, TransactionHolder> transactionMap = new ConcurrentHashMap<Integer, TransactionHolder>();
    protected boolean sendEmptyTransactions = false;
    protected final StreamEngine engine;

    public TransactionEngine(StreamEngine engine) {
        this.engine = engine;
    }

    @Override
    public StreamTransactionRecord getTransaction() throws SQLException, StreamException {
        StreamRecord r;
        while ((r = this.engine.getRecord()) != null) {
            TransactionHolder h;
            if (r.getType() == StreamRecordType.BEGIN) {
                h = new TransactionHolder();
                h.beginRecord = (CDCBeginTransactionRecord)r;
                this.transactionMap.put(r.getTransactionId(), h);
                this.logger.debug("Watching trasaction id: {}", r.getTransactionId());
                continue;
            }
            if (this.transactionMap.containsKey(r.getTransactionId())) {
                h = this.transactionMap.get(r.getTransactionId());
                this.processRecord(r, h);
                if (h.closingRecord == null) continue;
                this.transactionMap.remove(r.getTransactionId());
                return new StreamTransactionRecord(h.beginRecord, h.closingRecord, h.records);
            }
            if (r.getType() == StreamRecordType.METADATA || r.getType() == StreamRecordType.TIMEOUT) continue;
            this.logger.warn("Missing transaction start for record: {}", r);
        }
        return null;
    }

    private void processRecord(StreamRecord r, TransactionHolder h) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Processing [{}] record for transaction id: {}", (Object)r.getType(), (Object)r.getTransactionId());
        }
        if (r.hasOperationData() && this.dataFilterSet.contains((Object)r.getType())) {
            h.records.add((StreamOperationRecord)r);
        } else if (r.getType() == StreamRecordType.COMMIT || r.getType() == StreamRecordType.ROLLBACK) {
            if (this.transactionFilterSet.contains((Object)r.getType()) && (!h.records.isEmpty() || h.records.isEmpty() && this.sendEmptyTransactions)) {
                h.closingRecord = r;
            } else {
                this.transactionMap.remove(r.getTransactionId());
            }
        } else if (r.getType() == StreamRecordType.DISCARD) {
            this.logger.debug("Processing DISCARD record");
            Iterator<StreamOperationRecord> i = h.records.iterator();
            while (i.hasNext()) {
                StreamOperationRecord record = i.next();
                if (record.getSequenceId() < r.getSequenceId()) continue;
                this.logger.debug("Discarding record with sequence [{}]", record.getSequenceId());
                i.remove();
            }
        }
    }

    @Override
    public com.informix.jdbc.stream.api.TransactionEngine setOperationFilters(StreamRecordType ... types) {
        for (StreamRecordType t : types) {
            if (ALLOWED_DATA_FILTERS.contains((Object)t)) continue;
            throw new IllegalArgumentException("Type [" + (Object)((Object)t) + "] cannot be filtered. Correct options are: " + ALLOWED_DATA_FILTERS);
        }
        this.dataFilterSet = EnumSet.copyOf(Arrays.asList(types));
        return this;
    }

    @Override
    public com.informix.jdbc.stream.api.TransactionEngine setTransactionFilters(StreamRecordType ... types) {
        for (StreamRecordType t : types) {
            if (ALLOWED_TRANSACTION_FILTERS.contains((Object)t)) continue;
            throw new IllegalArgumentException("Type [" + (Object)((Object)t) + "] cannot be filtered. Correct options are: " + ALLOWED_TRANSACTION_FILTERS);
        }
        this.transactionFilterSet = EnumSet.copyOf(Arrays.asList(types));
        return this;
    }

    @Override
    public com.informix.jdbc.stream.api.TransactionEngine returnEmptyTransactions(boolean returnEmpty) {
        this.sendEmptyTransactions = returnEmpty;
        return this;
    }

    @Override
    public void close() throws StreamException {
        this.engine.close();
    }

    @Override
    public void init() throws SQLException, StreamException {
        this.engine.init();
    }

    public int mapSize() {
        return this.transactionMap.size();
    }

    @Override
    public StreamRecord getRecord() throws SQLException, StreamException {
        return this.getTransaction();
    }

    public static class TransactionHolder {
        public CDCBeginTransactionRecord beginRecord;
        public StreamRecord closingRecord;
        public final List<StreamOperationRecord> records = new ArrayList<StreamOperationRecord>();
    }
}

