/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries;

import com.informix.jdbc.udt.timeseries.TimeSeriesRowType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;

public class TimeSeriesTable {
    private TimeSeriesTable() {
    }

    public static boolean create(Connection connection, String tabname) throws SQLException {
        return TimeSeriesTable.create(connection, tabname, null);
    }

    public static boolean create(Connection connection, String tabname, String dbspace) throws SQLException {
        if (!TimeSeriesRowType.STANDARD_TYPE.exists(connection)) {
            TimeSeriesRowType.STANDARD_TYPE.create(connection);
        }
        String sql = MessageFormat.format("CREATE TABLE {0} (id bigserial not null primary key, data timeseries(generic_bson_t), properties bson)", tabname);
        if (dbspace != null) {
            sql = sql + " IN " + dbspace;
        }
        try (Statement statement = connection.createStatement();){
            boolean bl = statement.executeUpdate(sql) > 0;
            return bl;
        }
    }

    public static boolean create(Connection connection, String tabname, String rowTypeName, String dbspace) throws SQLException {
        String sql = MessageFormat.format("CREATE TABLE {0} (id bigserial not null primary key, data timeseries({1}), properties bson)", tabname, rowTypeName);
        if (dbspace != null) {
            sql = sql + " IN " + dbspace;
        }
        try (Statement statement = connection.createStatement();){
            boolean bl = statement.executeUpdate(sql) > 0;
            return bl;
        }
    }

    public static boolean drop(Connection connection, String tabname) throws SQLException {
        String sql = "drop table if exists " + tabname;
        try (Statement statement = connection.createStatement();){
            boolean bl = statement.executeUpdate(sql) > 0;
            return bl;
        }
    }

    public static TimeSeriesRowType getTimeseriesRowType(Connection connection, String tabname, String colname) throws SQLException {
        String tsTypeName;
        block32: {
            tsTypeName = null;
            try (PreparedStatement pstmt = connection.prepareStatement("select trim(description) as description from systables t, syscolumns c, sysxtddesc x where t.tabname = ? and t.tabid = c.tabid and c.colname = ? and x.extended_id = c.extended_id");){
                pstmt.setString(1, tabname);
                pstmt.setString(2, colname);
                try (ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        tsTypeName = rs.getString(1);
                        break block32;
                    }
                    TimeSeriesRowType timeSeriesRowType = null;
                    return timeSeriesRowType;
                }
            }
        }
        if (tsTypeName != null) {
            if (tsTypeName.startsWith("timeseries(") && tsTypeName.endsWith(")")) {
                tsTypeName = tsTypeName.substring(11, tsTypeName.length() - 1);
            }
            return TimeSeriesRowType.get(connection, tsTypeName);
        }
        return null;
    }
}

