/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.udt.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldType;
import com.informix.lang.Interval;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Date;

public class CharTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<String>
implements TimeSeriesFieldDefinition<String> {
    private static final int DEFAULT_LENGTH = 1;
    private final int length;

    public CharTimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.CHAR);
        this.length = 1;
    }

    public CharTimeSeriesFieldDefinition(int length) {
        super(TimeSeriesFieldType.CHAR);
        this.length = length;
    }

    public static CharTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.startsWith(TimeSeriesFieldType.CHAR.getInformixTypeName())) {
            if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.CHAR.getInformixTypeName())) {
                return new CharTimeSeriesFieldDefinition();
            }
            int startParenIndex = trimmed.indexOf(40);
            int endParenIndex = trimmed.lastIndexOf(41);
            try {
                String CharLengthArg = trimmed.substring(startParenIndex + 1, endParenIndex).trim();
                int length = Integer.parseInt(CharLengthArg);
                return new CharTimeSeriesFieldDefinition(length);
            }
            catch (IndexOutOfBoundsException e) {
                throw new IllegalArgumentException("the parenthesis are missing or out of order", e);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("the length could not be parsed as an int", e);
            }
        }
        throw new IllegalArgumentException(MessageFormat.format("the field definition must begin with ''{0}''", TimeSeriesFieldType.CHAR.getInformixTypeName()));
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public String toSqlString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFieldType().getInformixTypeName());
        sb.append('(');
        sb.append(this.length);
        sb.append(')');
        return sb.toString();
    }

    @Override
    public String read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        int length = stream.readInt();
        return stream.readString(length);
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, String value) throws SQLException {
        if (!(value instanceof String)) {
            throw new SQLException(MessageFormat.format("the value must be of type {0} (was {1})", String.class.getName(), value.getClass().getName()));
        }
        String string = value;
        int length = string.length();
        stream.writeInt(length);
        stream.writeString(string, length);
    }

    @Override
    public String convertValueToString(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String convertValueTo(Object value) throws IllegalArgumentException {
        if (value == null || value instanceof String) {
            return (String)value;
        }
        if (value instanceof byte[]) {
            return new String((byte[])value);
        }
        if (value instanceof Number) {
            return ((Number)value).toString();
        }
        if (value instanceof Boolean) {
            return ((Boolean)value).toString();
        }
        if (value instanceof Date) {
            return ((Date)value).toString();
        }
        if (value instanceof Interval) {
            return ((Interval)value).toString();
        }
        throw new IllegalArgumentException(MessageFormat.format("could not convert a value of type {0} to {1}", value.getClass().getName(), String.class.getName()));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.length;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof CharTimeSeriesFieldDefinition)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CharTimeSeriesFieldDefinition other = (CharTimeSeriesFieldDefinition)obj;
        return this.length == other.length;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CharTimeSeriesFieldDefinition [length=");
        builder.append(this.length);
        builder.append(']');
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<String> {
        @Override
        public TimeSeriesFieldDefinition<String> parse(String s) {
            return CharTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

