/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.field.definition;

import com.informix.jdbc.IfmxUDTSQLInput;
import com.informix.jdbc.IfmxUDTSQLOutput;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.udt.timeseries.field.definition.AbstractInformixFieldDefinition;
import com.informix.jdbc.udt.timeseries.field.definition.ObjectConversionUtilities;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinition;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldDefinitionFactory;
import com.informix.jdbc.udt.timeseries.field.definition.TimeSeriesFieldType;
import java.sql.SQLException;
import java.text.MessageFormat;

public class IntTimeSeriesFieldDefinition
extends AbstractInformixFieldDefinition<Integer>
implements TimeSeriesFieldDefinition<Integer> {
    public IntTimeSeriesFieldDefinition() {
        super(TimeSeriesFieldType.INT);
    }

    public static IntTimeSeriesFieldDefinition parseFieldDefinition(String s) {
        String trimmed = s.trim();
        if (trimmed.equalsIgnoreCase(TimeSeriesFieldType.INT.getInformixTypeName())) {
            return new IntTimeSeriesFieldDefinition();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Integer read(IfmxUDTSQLInput stream, IfxResultSetMetaData metaData, Integer index) throws SQLException {
        return stream.readInt();
    }

    @Override
    public void write(IfmxUDTSQLOutput stream, Integer value) throws SQLException {
        stream.writeInt(value);
    }

    @Override
    public String convertValueToString(Object value) {
        if (value == null) {
            return "null::int";
        }
        if (value instanceof Integer) {
            return ((Integer)value).toString() + "::" + this.toSqlString();
        }
        throw new IllegalArgumentException(MessageFormat.format("the value must be of type {0} (was {1})", Integer.class, value.getClass()));
    }

    @Override
    public Integer convertValueTo(Object value) throws IllegalArgumentException {
        return ObjectConversionUtilities.convertObjectToInteger(value);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IntTimeSeriesFieldDefinition []");
        return builder.toString();
    }

    public static class Factory
    implements TimeSeriesFieldDefinitionFactory<Integer> {
        @Override
        public TimeSeriesFieldDefinition<Integer> parse(String s) {
            return IntTimeSeriesFieldDefinition.parseFieldDefinition(s);
        }
    }
}

