/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.loader;

import java.util.Calendar;
import java.util.GregorianCalendar;

public class ISO8601DateTime {
    private Calendar calendar;
    private int nanosecond;

    public ISO8601DateTime() {
        this.nanosecond = 0;
    }

    public ISO8601DateTime(Calendar calendar) {
        this.calendar = calendar;
        this.nanosecond = (int)(calendar.getTimeInMillis() % 1000L * 1000000L);
    }

    public ISO8601DateTime(Calendar calendar, int nanosecond) {
        this.calendar = calendar;
        this.nanosecond = nanosecond;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public long getNanos() {
        return this.nanosecond;
    }

    public void setNanos(int nanos) {
        if (nanos > 999999999 || nanos < 0) {
            throw new IllegalArgumentException("nanos > 999999999 or < 0");
        }
        this.nanosecond = nanos;
    }

    public final ISO8601DateTime parseDateTime(String input) {
        Parser parser = new Parser();
        ISO8601DateTime dt = parser.parse(input);
        if (dt != null) {
            return dt;
        }
        parser.setDateTimeDelimiter(" ");
        return parser.parse(input);
    }

    public static final class Parser {
        private String dateTimeDelimiter = "T";
        private boolean zeroPaddingRequire = true;
        private boolean dateParserEnable = true;
        private boolean timeParserEnable = true;

        public String getDateTimeDelimiter() {
            return this.dateTimeDelimiter;
        }

        public Parser setDateTimeDelimiter(String delimiter) {
            this.dateTimeDelimiter = delimiter;
            return this;
        }

        public boolean isZeroPaddingRequired() {
            return this.zeroPaddingRequire;
        }

        public Parser setZeroPaddingRequire(boolean required) {
            this.zeroPaddingRequire = required;
            return this;
        }

        public boolean isDateParserEnabled() {
            return this.dateParserEnable;
        }

        public Parser setDateParserEnable(boolean enable) {
            this.dateParserEnable = enable;
            return this;
        }

        public boolean isTimeParserEnabled() {
            return this.timeParserEnable;
        }

        public Parser setTimeParserEnable(boolean enable) {
            this.timeParserEnable = enable;
            return this;
        }

        public final ISO8601DateTime parse(String input) {
            GregorianCalendar calendar = new GregorianCalendar();
            return this.parse(input, calendar);
        }

        public final ISO8601DateTime parse(String input, Calendar calendar) {
            if (input == null || input.length() == 0) {
                return null;
            }
            if (this.isDateParserEnabled() && this.isTimeParserEnabled() && input.contains(this.dateTimeDelimiter)) {
                int index = input.indexOf(this.getDateTimeDelimiter());
                String dateString = input.substring(0, index);
                String timeString = input.substring(index + 1);
                Calendar date = this.parseDate(dateString, calendar);
                TimeComponents time = this.extractTimeComponents(timeString);
                date.set(11, time.hour);
                date.set(12, time.minute);
                date.set(13, time.second);
                date.set(14, 0);
                return new ISO8601DateTime(date, time.nanosecond);
            }
            Calendar date = this.isDateParserEnabled() ? this.parseDate(input, calendar) : null;
            TimeComponents time = this.isTimeParserEnabled() ? this.extractTimeComponents(input) : null;
            if (date != null && time == null) {
                return new ISO8601DateTime(date);
            }
            if (time != null) {
                calendar.clear();
                calendar.set(11, time.hour);
                calendar.set(12, time.minute);
                calendar.set(13, time.second);
                return new ISO8601DateTime(calendar, time.nanosecond);
            }
            return null;
        }

        protected Calendar parseDate(String input, Calendar calendar) {
            if (input == null || input.length() == 0) {
                return null;
            }
            if (input.matches("^(\\+|-)?\\d+L$")) {
                int end = input.length();
                long millis = Long.parseLong(input.substring(0, end - 1));
                calendar.clear();
                calendar.setTimeInMillis(millis);
                return calendar;
            }
            if (input.matches("^(\\+|-)?\\d{4}$")) {
                String cleanedInput;
                boolean hasNegativeSign = false;
                if (input.startsWith("+")) {
                    cleanedInput = input.substring(1);
                } else if (input.startsWith("-")) {
                    hasNegativeSign = true;
                    cleanedInput = input.substring(1);
                } else {
                    cleanedInput = input;
                }
                int year = Integer.parseInt(cleanedInput);
                if (hasNegativeSign) {
                    year *= -1;
                }
                calendar.clear();
                calendar.set(1, year);
                return calendar;
            }
            if (input.matches("^\\d{4}-\\d{1,2}$")) {
                String[] ym = input.split("-");
                int year = Integer.parseInt(ym[0]);
                int month = Integer.parseInt(ym[1]);
                calendar.clear();
                calendar.set(1, year);
                calendar.set(2, month - 1);
                return calendar;
            }
            if (input.matches("^\\d{4}-\\d{1,2}-\\d{1,2}$")) {
                String[] ymd = input.split("-");
                int year = Integer.parseInt(ymd[0]);
                int month = Integer.parseInt(ymd[1]);
                int dayOfMonth = Integer.parseInt(ymd[2]);
                calendar.clear();
                calendar.set(1, year);
                calendar.set(2, month - 1);
                calendar.set(5, dayOfMonth);
                return calendar;
            }
            if (input.matches("^\\d{8}$")) {
                int year = Integer.parseInt(input.substring(0, 4));
                int month = Integer.parseInt(input.substring(4, 6));
                int dayOfMonth = Integer.parseInt(input.substring(6, 8));
                calendar.clear();
                calendar.set(1, year);
                calendar.set(2, month - 1);
                calendar.set(5, dayOfMonth);
                return calendar;
            }
            if (input.matches("^\\d{4}-W\\d{2}$")) {
                String[] yw = input.split("-W");
                int year = Integer.parseInt(yw[0]);
                int weekOfYear = Integer.parseInt(yw[1]);
                calendar.clear();
                calendar.set(1, year);
                calendar.set(3, weekOfYear);
                return calendar;
            }
            if (input.matches("^\\d{4}-W\\d{2}-\\d{1}$")) {
                String[] ywd = input.split("-");
                int year = Integer.parseInt(ywd[0]);
                int weekOfYear = Integer.parseInt(ywd[1].substring(1));
                int dayOfWeek = Integer.parseInt(ywd[2]);
                calendar.clear();
                calendar.set(1, year);
                calendar.set(3, weekOfYear);
                calendar.set(7, dayOfWeek);
                return calendar;
            }
            if (input.matches("^\\d{4}W\\d{2}$")) {
                int year = Integer.parseInt(input.substring(0, 4));
                int weekOfYear = Integer.parseInt(input.substring(5, 7));
                calendar.clear();
                calendar.set(1, year);
                calendar.set(3, weekOfYear);
                return calendar;
            }
            if (input.matches("^\\d{4}W\\d{3}$")) {
                int year = Integer.parseInt(input.substring(0, 4));
                int weekOfYear = Integer.parseInt(input.substring(5, 7));
                int dayOfWeek = Integer.parseInt(input.substring(7));
                calendar.clear();
                calendar.set(1, year);
                calendar.set(3, weekOfYear);
                calendar.set(7, dayOfWeek);
                return calendar;
            }
            if (input.matches("^\\d{4}-\\d{3}$")) {
                String[] yd = input.split("-");
                int year = Integer.parseInt(yd[0]);
                int dayOfYear = Integer.parseInt(yd[1]);
                calendar.clear();
                calendar.set(1, year);
                calendar.set(6, dayOfYear);
                return calendar;
            }
            if (input.matches("^\\d{7}$")) {
                int year = Integer.parseInt(input.substring(0, 4));
                int dayOfYear = Integer.parseInt(input.substring(4));
                calendar.clear();
                calendar.set(1, year);
                calendar.set(6, dayOfYear);
                return calendar;
            }
            return null;
        }

        protected ISO8601DateTime parseTime(String input, Calendar calendar) {
            TimeComponents tc = this.extractTimeComponents(input);
            calendar.clear();
            calendar.set(10, tc.hour);
            calendar.set(12, tc.minute);
            calendar.set(13, tc.second);
            ISO8601DateTime result = new ISO8601DateTime(calendar);
            result.setNanos(tc.nanosecond);
            return result;
        }

        private TimeComponents extractTimeComponents(String input) {
            if (input == null || input.length() == 0) {
                return null;
            }
            if (input.matches("^\\d{2}$")) {
                int hour = Integer.parseInt(input);
                return new TimeComponents(hour);
            }
            if (input.matches("^\\d{4}$")) {
                int hour = Integer.parseInt(input.substring(0, 2));
                int minute = Integer.parseInt(input.substring(2, 4));
                return new TimeComponents(hour, minute);
            }
            if (input.matches("^\\d{6}$")) {
                int hour = Integer.parseInt(input.substring(0, 2));
                int minute = Integer.parseInt(input.substring(2, 4));
                int second = Integer.parseInt(input.substring(4, 6));
                return new TimeComponents(hour, minute, second);
            }
            if (this.isZeroPaddingRequired() && input.matches("^\\d{2}:\\d{2}$") || input.matches("^\\d{1,2}:\\d{1,2}$")) {
                String[] hm = input.split(":");
                int hour = Integer.parseInt(hm[0]);
                int minute = Integer.parseInt(hm[1]);
                return new TimeComponents(hour, minute);
            }
            if (this.isZeroPaddingRequired() && input.matches("^\\d{2}:\\d{2}:\\d{2}$") || input.matches("^\\d{1,2}:\\d{1,2}:\\d{1,2}$")) {
                String[] hms = input.split(":");
                int hour = Integer.parseInt(hms[0]);
                int minute = Integer.parseInt(hms[1]);
                int second = Integer.parseInt(hms[2]);
                return new TimeComponents(hour, minute, second);
            }
            if (this.isZeroPaddingRequired() && input.matches("^\\d{2}:\\d{2}:\\d{2}.\\d{1,9}$") || input.matches("^\\d{1,2}:\\d{1,2}:\\d{1,2}.\\d{1,9}$")) {
                String[] hms = input.split(":");
                int hour = Integer.parseInt(hms[0]);
                int minute = Integer.parseInt(hms[1]);
                String[] SSsss = hms[2].split("\\.");
                int second = Integer.parseInt(SSsss[0]);
                int nanosecond = Integer.parseInt(SSsss[1]);
                for (int i = 9; i > SSsss[1].length(); --i) {
                    nanosecond *= 10;
                }
                return new TimeComponents(hour, minute, second, nanosecond);
            }
            return null;
        }

        protected static class TimeComponents {
            public final int hour;
            public final int minute;
            public final int second;
            public final int nanosecond;

            protected TimeComponents(int hour) {
                this(hour, 0, 0, 0);
            }

            protected TimeComponents(int hour, int minute) {
                this(hour, minute, 0, 0);
            }

            protected TimeComponents(int hour, int minute, int second) {
                this(hour, minute, second, 0);
            }

            protected TimeComponents(int hour, int minute, int second, int nanosecond) {
                this.hour = hour;
                this.minute = minute;
                this.second = second;
                this.nanosecond = nanosecond;
            }

            public String toString() {
                StringBuilder builder = new StringBuilder();
                builder.append("TimeComponents [hour=");
                builder.append(this.hour);
                builder.append(", minute=");
                builder.append(this.minute);
                builder.append(", second=");
                builder.append(this.second);
                builder.append(", nanosecond=");
                builder.append(this.nanosecond);
                builder.append("]");
                return builder.toString();
            }
        }
    }
}

