/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc.udt.timeseries.loader;

import com.informix.jdbc.udt.timeseries.TimeSeriesRowType;
import com.informix.jdbc.udt.timeseries.field.BsonTimeSeriesField;
import com.informix.jdbc.udt.timeseries.loader.ISO8601DateTime;
import com.informix.jdbc.udt.timeseries.loader.TimeSeriesRecord;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.bson.BSONObject;
import org.bson.Document;

public class TimeSeriesRecordSpecification {
    private final String primaryKeyFieldName;
    private final String timestampFieldName;
    private final List<String> rowTypeFieldNames;

    public TimeSeriesRecordSpecification(String primaryKeyFieldName, TimeSeriesRowType rowType) {
        this.primaryKeyFieldName = primaryKeyFieldName;
        if (rowType == null) {
            throw new IllegalArgumentException("row type cannot be null");
        }
        this.timestampFieldName = rowType.getTimestampFieldName();
        ArrayList<String> fieldNames = null;
        if (!(rowType.equals(TimeSeriesRowType.STANDARD_TYPE) || rowType.getFieldCount() == 2 && rowType.getField(2) instanceof BsonTimeSeriesField)) {
            fieldNames = new ArrayList<String>();
            for (int i = 2; i <= rowType.getFieldCount(); ++i) {
                fieldNames.add(rowType.getField(i).getFieldName());
            }
        }
        this.rowTypeFieldNames = fieldNames;
    }

    public String getPrimaryKeyFieldName() {
        return this.primaryKeyFieldName;
    }

    public String getTimestampFieldName() {
        return this.timestampFieldName;
    }

    public List<String> getRowTypeFieldNames() {
        return this.rowTypeFieldNames;
    }

    public TimeSeriesRecord create(BSONObject document) {
        String primaryKey = this.extractPrimaryKeyValue(document);
        ISO8601DateTime timestamp = this.extractTimestamp(document);
        Object data = this.extractData(document);
        return new TimeSeriesRecord(primaryKey, timestamp, data);
    }

    protected String extractPrimaryKeyValue(BSONObject document) {
        Object value = document.get(this.primaryKeyFieldName);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    protected ISO8601DateTime extractTimestamp(BSONObject doc) {
        try {
            Object timestampObject = doc.get(this.timestampFieldName);
            if (timestampObject instanceof String) {
                return new ISO8601DateTime().parseDateTime((String)timestampObject);
            }
            if (timestampObject instanceof Date) {
                GregorianCalendar gc = new GregorianCalendar(1979, 0, 1, 0, 0, 0);
                gc.setTimeInMillis(((Date)timestampObject).getTime());
                return new ISO8601DateTime(gc);
            }
            if (timestampObject instanceof Calendar) {
                return new ISO8601DateTime((Calendar)timestampObject);
            }
            throw new IllegalArgumentException(MessageFormat.format("Unsupported object of type {0}", timestampObject.getClass().getName()));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to extract timestamp from document", e);
        }
    }

    protected Object extractData(BSONObject bsonObject) {
        if (this.rowTypeFieldNames == null) {
            bsonObject.removeField(this.primaryKeyFieldName);
            bsonObject.removeField(this.timestampFieldName);
            return new Document(bsonObject.toMap()).toJson();
        }
        ArrayList<Object> data = new ArrayList<Object>();
        for (String fieldName : this.rowTypeFieldNames) {
            Object value = bsonObject.get(fieldName);
            if (value instanceof BSONObject) {
                value = new Document(((BSONObject)value).toMap()).toJson();
            }
            data.add(value);
        }
        return data;
    }
}

