/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxSqliConnect;
import com.informix.lang.Messages;
import com.informix.util.AdvancedUppercaseProperties;
import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;

public abstract class AbstractDataSource
extends AdvancedUppercaseProperties
implements DataSource {
    private static final long serialVersionUID = 1L;
    private static final Properties DEFAULT_PROPERTIES = new Properties();

    protected AbstractDataSource() {
        super(DEFAULT_PROPERTIES);
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw Messages.getSQLException(-80053, this.getClass().getCanonicalName(), iface.getClass().getCanonicalName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return new IfxSqliConnect(this);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        this.setProperty("user", username);
        this.setProperty("password", password);
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() {
        return null;
    }

    @Override
    public void setLogWriter(PrintWriter out) {
    }

    public void setAutoCaseSchema(boolean value) {
        this.setProperty("autoCaseSchema", Boolean.toString(value));
    }

    public boolean getAutoCaseSchema() {
        return this.asBool("autoCaseSchema");
    }

    public void setAutoFreeCursors(boolean value) {
        this.setProperty("autoFreeCursors", Boolean.toString(value));
    }

    public boolean getAutoFreeCursors() {
        return this.asBool("autoFreeCursors");
    }

    public void setCertificateVerfication(boolean value) {
        this.setProperty("certificateVerification", Boolean.toString(value));
    }

    public boolean getCertificateVerification() {
        return this.asBool("certificateVerification");
    }

    public void setCommitBeforeIsolationChange(boolean value) {
        this.setProperty("commitBeforeIsolationChange", Boolean.toString(value));
    }

    public boolean getCommitBeforeIsolationChange() {
        return this.asBool("commitBeforeIsolationChange");
    }

    public void setConnectionCleanerDelay(int value) {
        this.setProperty("connectionCleanerDelay", Integer.toString(value));
    }

    public int getConnectionCleanerDelay() {
        return this.asInt("connectionCleanerDelay");
    }

    public void setCustomCodeSet(String value) {
        this.setProperty("customCodeSet", value);
    }

    public String getCustomCodeSet() {
        return this.asString("customCodeSet");
    }

    public void setCustomLocale(String value) {
        this.setProperty("customLocale", value);
    }

    public String getCustomLocale() {
        return this.asString("customLocale");
    }

    public void setCustomNLSMap(String value) {
        this.setProperty("customNLSMap", value);
    }

    public String getCustomNLSMap() {
        return this.asString("customNLSMap");
    }

    public void setDatabase(String value) {
        this.setProperty("database", value);
    }

    public String getDatabase() {
        return this.asString("database");
    }

    public void setDefaultCursorHoldability(int value) {
        this.setProperty("defaultCursorHoldability", Integer.toString(value));
    }

    public int getDefaultCursorHoldability() {
        return this.asInt("defaultCursorHoldability");
    }

    public void setDelimident(boolean value) {
        this.setProperty("delimident", Boolean.toString(value));
    }

    public boolean getDelimident() {
        return this.asBool("delimident");
    }

    public void setEmulateInformixServer(boolean value) {
        this.setProperty("emulateInformixServer", Boolean.toString(value));
    }

    public boolean getEmulateInformixServer() {
        return this.asBool("emulateInformixServer");
    }

    public void setEncrypt(boolean value) {
        this.setProperty("encrypt", Boolean.toString(value));
    }

    public boolean getEncrypt() {
        return this.asBool("encrypt");
    }

    public void setHost(String value) {
        this.setProperty("host", value);
    }

    public String getHost() {
        return this.asString("host");
    }

    public void setInvalidAutoCommitThrowError(boolean value) {
        this.setProperty("invalidAutoCommitThrowError", Boolean.toString(value));
    }

    public boolean getInvalidAutoCommitThrowError() {
        return this.asBool("invalidAutoCommitThrowError");
    }

    public void setLobBufferSize(int value) {
        this.setProperty("lobBufferSize", Integer.toString(value));
    }

    public int getLobBufferSize() {
        return this.asInt("lobBufferSize");
    }

    public void setLobCodesetConversionMemory(int value) {
        this.setProperty("lobCodesetConversionMemory", Integer.toString(value));
    }

    public int getLobCodesetConversionMemory() {
        return this.asInt("lobCodesetConversionMemory");
    }

    public void setLobReadonly(boolean value) {
        this.setProperty("lobReadonly", Boolean.toString(value));
    }

    public boolean getLobReadonly() {
        return this.asBool("lobReadonly");
    }

    public void setLockTimeout(int value) {
        this.setProperty("lockTimeout", Integer.toString(value));
    }

    public int getLockTimeout() {
        return this.asInt("lockTimeout");
    }

    public void setLoginRetries(int value) {
        this.setProperty("loginRetries", Integer.toString(value));
    }

    public int getLoginRetries() {
        return this.asInt("loginRetries");
    }

    @Override
    public void setLoginTimeout(int seconds) {
        if (seconds == 0) {
            this.setProperty("loginTimeout", DEFAULT_PROPERTIES.getProperty("loginTimeout"));
        } else {
            this.setProperty("loginTimeout", Integer.toString(seconds));
        }
    }

    @Override
    public int getLoginTimeout() {
        return this.asInt("loginTimeout");
    }

    public void setMetadataReplicationColumn(boolean value) {
        this.setProperty("metadataReplicationColumn", Boolean.toString(value));
    }

    public boolean getMetadataReplicationColumn() {
        return this.asBool("metadataReplicationColumn");
    }

    public void setMetadataUppercaseValues(boolean value) {
        this.setProperty("metadataUppercaseValues", Boolean.toString(value));
    }

    public boolean getMetadataUppercaseValues() {
        return this.asBool("metadataUppercaseValues");
    }

    public void setOptimizeOpenFetchClose(boolean value) {
        this.setProperty("optOFC", Boolean.toString(value));
    }

    public boolean getOptimizeOpenFetchClose() {
        return this.asBool("optOFC");
    }

    public void setOverrideDatabaseProductName(String value) {
        this.setProperty("overrideDatabaseProductName", value);
    }

    public String getOverrideDatabaseProductName() {
        return this.asString("overrideDatabaseProductName");
    }

    public void setPassword(String value) {
        this.setProperty("password", value);
    }

    public String getPassword() {
        return this.asString("password");
    }

    public void setPort(int value) {
        this.setProperty("port", Integer.toString(value));
    }

    public int getPort() {
        return this.asInt("port");
    }

    public void setPreparedStatementCacheSize(int value) {
        this.setProperty("preparedStatementCacheSize", Integer.toString(value));
    }

    public int getPreparedStatementCacheSize() {
        return this.asInt("preparedStatementCacheSize");
    }

    public void setProcessTableNameInResultSets(boolean value) {
        this.setProperty("processTableNameInResultSets", Boolean.toString(value));
    }

    public boolean getProcessTableNameInResultSets() {
        return this.asBool("processTableNameInResultSets");
    }

    public void setQueryBufferSize(int value) {
        this.setProperty("resultsBufferSize", Integer.toString(value));
    }

    public int getQueryBufferSize() {
        return this.asInt("resultsBufferSize");
    }

    public void setRemoveLobTempFilesOnRSClose(boolean value) {
        this.setProperty("removeLobTempFilesOnRSClose", Boolean.toString(value));
    }

    public boolean getRemoveLobTempFilesOnRSClose() {
        return this.asBool("removeLobTempFilesOnRSClose");
    }

    public void setSecondarySwitch(boolean value) {
        this.setProperty("secondarySwitch", Boolean.toString(value));
    }

    public boolean getSecondarySwitch() {
        return this.asBool("secondarySwitch");
    }

    public void setServerName(String value) {
        this.setProperty("serverName", value);
    }

    public String getServerName() {
        return this.asString("serverName");
    }

    public void setSessionVariables(String value) {
        this.setProperty("sessionVariables", value);
    }

    public String getSessionVariables() {
        return this.asString("sessionVariables");
    }

    public void setTransactionIsolationLevel(String value) {
        this.setProperty("transactionIsolationLevel", value);
    }

    public String getTransactionIsolationLevel() {
        return this.asString("transactionIsolationLevel");
    }

    public String getTrustStore() {
        return this.asString("trustStore");
    }

    public void setTrustStore(String value) {
        this.setProperty("trustStore", value);
    }

    public String getTrustStorePassword() {
        return this.asString("trustStorePassword");
    }

    public void setTrustStorePassword(String value) {
        this.setProperty("trustStorePassword", value);
    }

    public void setUppercaseMetaDataRSColumnNames(boolean value) {
        this.setProperty("uppercaseMetaDataRSColumnNames", Boolean.toString(value));
    }

    public boolean getUppercaseMetaDataRSColumnNames() {
        return this.asBool("uppercaseMetaDataRSColumnNames");
    }

    public void setUser(String value) {
        this.setProperty("user", value);
    }

    public String getUser() {
        return this.asString("user");
    }

    static {
        DEFAULT_PROPERTIES.put("autoCaseSchema", "true");
        DEFAULT_PROPERTIES.put("autoFreeCursors", "false");
        DEFAULT_PROPERTIES.put("appendIsamCodeToSqlException", "false");
        DEFAULT_PROPERTIES.put("certificateVerification", "true");
        DEFAULT_PROPERTIES.put("connectionCleanerDelay", "0");
        DEFAULT_PROPERTIES.put("commitBeforeIsolationChange", "true");
        DEFAULT_PROPERTIES.put("loginTimeout", "15000");
        DEFAULT_PROPERTIES.put("defaultCursorHoldability", "2");
        DEFAULT_PROPERTIES.put("delimident", "false");
        DEFAULT_PROPERTIES.put("emulateInformixServer", "false");
        DEFAULT_PROPERTIES.put("secondarySwitch", "false");
        DEFAULT_PROPERTIES.put("udtCache", "true");
        DEFAULT_PROPERTIES.put("resultsBufferSize", "4096");
        DEFAULT_PROPERTIES.put("removeLobTempFilesOnRSClose", "false");
        DEFAULT_PROPERTIES.put("host", "localhost");
        DEFAULT_PROPERTIES.put("lobCodesetConversionMemory", "-1");
        DEFAULT_PROPERTIES.put("lobReadonly", "false");
        DEFAULT_PROPERTIES.put("lockTimeout", "0");
        DEFAULT_PROPERTIES.put("padVarchar", "false");
        DEFAULT_PROPERTIES.put("processTableNameInResultSets", "true");
        DEFAULT_PROPERTIES.put("metadataReplicationColumn", "true");
        DEFAULT_PROPERTIES.put("serverName", "");
        DEFAULT_PROPERTIES.put("socketKeepalive", "false");
        DEFAULT_PROPERTIES.put("socketTimeout", "0");
        DEFAULT_PROPERTIES.put("trimTrailingSpaces", "false");
        DEFAULT_PROPERTIES.put("replaceUnmappableCharacterSequences", "false");
        DEFAULT_PROPERTIES.put("loginRetries", "0");
        DEFAULT_PROPERTIES.put("lobBufferSize", "16384");
        DEFAULT_PROPERTIES.put("metadataUppercaseValues", "false");
        DEFAULT_PROPERTIES.put("invalidAutoCommitThrowError", "true");
        DEFAULT_PROPERTIES.put("optOFC", "false");
        DEFAULT_PROPERTIES.put("port", "9088");
        DEFAULT_PROPERTIES.put("preparedStatementCacheSize", "0");
        DEFAULT_PROPERTIES.put("encrypt", "false");
        DEFAULT_PROPERTIES.put("encryptionProtocols", "TLSv1.2,TLSv1.1,TLSv1");
        DEFAULT_PROPERTIES.put("certificateVerification", "true");
        DEFAULT_PROPERTIES.put("trustedContext", "false");
        DEFAULT_PROPERTIES.put("batchInsertPreprocessing", "false");
        DEFAULT_PROPERTIES.put("user", System.getProperty("user.name", "no-user"));
        DEFAULT_PROPERTIES.put("uppercaseMetaDataRSColumnNames", "false");
        Locale currLocale = Locale.getDefault();
        String lang = currLocale.getLanguage();
        String country = currLocale.getCountry();
        if (lang.equals("en") && (country.equals("") || country.equals("US"))) {
            if (File.separator.equals("/")) {
                DEFAULT_PROPERTIES.put("CLIENT_LOCALE", "en_US.8859-1");
            } else {
                DEFAULT_PROPERTIES.put("CLIENT_LOCALE", "en_US.CP1252");
            }
            DEFAULT_PROPERTIES.put("DBDATE", "Y4MD-");
        }
    }
}

