/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.InformixDriver;
import com.informix.jdbcx.IfxConnectionPoolDataSource;
import com.informix.jdbcx.IfxConnectionPoolManager;
import com.informix.jdbcx.IfxCoreDataSource;
import com.informix.jdbcx.IfxDataSourceFactory;
import com.informix.lang.Messages;
import com.informix.util.InformixUrl;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;

public class IfxDataSource
extends IfxCoreDataSource
implements DataSource,
Referenceable {
    private static final long serialVersionUID = 1L;
    private IfxConnectionPoolManager cpm = null;
    String cpdsName = null;
    private Constructor<?> cons = null;

    public IfxDataSource() {
    }

    public IfxDataSource(String url) throws SQLException {
        if (url.startsWith("jdbc:informix-sqli")) {
            this.DSProperties.putAll(new InformixUrl(url, null).getProperties());
        } else {
            InformixDriver.addPropertiesFromURL(url, this.DSProperties);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this.cpm == null) {
            String user = this.getUser();
            String password = this.getPassword();
            if (user == null && password == null || user != null && password != null) {
                return this.getSqliConnection(user, password);
            }
            throw Messages.getSQLException(-79811);
        }
        return this.cpm.getConnection();
    }

    @Override
    public Connection getConnection(String luser, String lpassword) throws SQLException {
        if (this.cpm == null) {
            return this.getSqliConnection(luser, lpassword);
        }
        return this.cpm.getConnection(luser, lpassword);
    }

    private Connection getSqliConnection(String luser, String lpasswd) throws SQLException {
        String urlString = "";
        String host = null;
        String port = null;
        String connType = null;
        Properties prop = this.getDsProperties();
        host = prop.getProperty("IFXHOST");
        port = prop.getProperty("PORTNO");
        connType = prop.getProperty("CONNECTIONCLASS", "com.informix.jdbc.IfxSqliConnect");
        urlString = host != null && port != null ? host + ":" + port : null;
        if (!this.directConnection) {
            return this.toInformixDataSource().getConnection(luser, lpasswd);
        }
        try {
            if (this.cons == null) {
                Class<?> clsRef = Class.forName(connType);
                this.cons = clsRef.getConstructor(String.class, Properties.class);
            }
            return (IfxConnection)this.cons.newInstance(urlString, prop);
        }
        catch (InvocationTargetException te) {
            if (te.getTargetException() instanceof SQLException) {
                throw (SQLException)te.getTargetException();
            }
            throw new SQLException("Encountered non-SQLException", te.getTargetException());
        }
        catch (Exception e) {
            throw Messages.getSQLException(e, -79704);
        }
    }

    void getCPM() throws SQLException {
        try {
            this.cpdsName = this.getDataSourceName();
            if (this.cpdsName != null) {
                this.cpm = new IfxConnectionPoolManager(this.cpdsName);
                this.cpm.startPoolService();
            } else {
                this.cpm = null;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.getLocSQLException(-79716, e.toString(), this.getIfxCLIENT_LOCALE());
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeProperties(out);
            return new Reference(IfxDataSource.class.getName(), new StringRefAddr("DSProperties", new String(out.toByteArray())), IfxDataSourceFactory.class.getName(), null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getCPMFreeCount() {
        if (this.cpm != null) {
            return this.cpm.getFreeCount();
        }
        return 0;
    }

    public IfxConnectionPoolDataSource getCPDS() {
        if (this.cpm != null) {
            return this.cpm.getCPDS();
        }
        return null;
    }

    public void activateHDRPool_Primary() {
        if (this.cpm != null) {
            this.cpm.switchActivePool("PRIMARY");
        }
    }

    public void activateHDRPool_Secondary() {
        if (this.cpm != null) {
            this.cpm.switchActivePool("SECONDARY");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw Messages.getSQLException(-80053, this.getClass().getCanonicalName(), iface.getClass().getCanonicalName());
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("com.informix.jdbc");
    }
}

