/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxXMessageTypes;
import com.informix.jdbcx.IfxXid;
import com.informix.lang.Messages;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.sql.SQLException;
import javax.transaction.xa.Xid;

public class IfxXASqli
extends IfxSqli {
    private static final Object logger = Trace.getLoggerForClass(IfxXASqli.class);
    private int XAError;
    private IfxXid[] xidArray;
    private int XACommand;

    public IfxXASqli(IfxSqliConnect conn_arg) {
        super(conn_arg);
    }

    Object[] getXidArray() {
        return this.xidArray;
    }

    @Override
    public void clear() {
        super.clear();
        this.XAError = 0;
        this.xidArray = null;
    }

    @Override
    public void receiveMessage() throws SQLException {
        short msg = 0;
        super.clearExceptions();
        try {
            this.flip();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "");
                this.protoTrace.writeTrace(logger, 1, "S->C");
            }
            try {
                do {
                    if (73 == (msg = this.is.readSmallInt())) {
                        if (TraceFlag.isTraceEnabled()) {
                            this.protoTrace.writeTrace(logger, 1, "\tSQ_XERR");
                        }
                        this.receiveXAError();
                        continue;
                    }
                    if (msg == 56 && this.conn != null) {
                        this.conn.unlockSession();
                    }
                    if (this.dispatchMsg(msg)) continue;
                    break;
                } while (msg != 12 && msg != 56);
            }
            finally {
                if (this.sqliTrace != null) {
                    this.sqliTrace.recordS2C();
                }
            }
        }
        catch (SQLException e) {
            this.addException(e);
        }
        catch (Exception e) {
            this.addException(Messages.getSQLException(-79716, this.conn));
        }
        if (super.getExceptions() != null) {
            throw super.getExceptions();
        }
    }

    public int executeXAOpen(String dbName, int rmid, int flags) throws SQLException {
        if (dbName == null) {
            throw Messages.getSQLException(-79760, this.conn);
        }
        this.XAError = 0;
        this.XACommand = 82;
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendXAOpen(dbName, rmid, flags);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw Messages.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        this.conn.xaSetSerWarnFlags((short)1, dbName);
        return this.XAError;
    }

    private void sendXAOpen(String dbName, int rmid, int flags) throws SQLException {
        try {
            byte[] dbNameBytes = this.os.getJavaToIfxChar(dbName);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\nC->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_XOPEN");
            }
            this.os.writeSmallInt((short)82);
            this.os.writeChar(dbNameBytes);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tDatabase Name: " + dbName);
            }
            this.os.writeInt(rmid);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tRmid: " + rmid);
            }
            this.os.writeInt(flags);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tFlags: " + flags);
            }
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw Messages.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
    }

    public int executeXACommand(short command, Xid xid, int rmid, int flags) throws SQLException {
        this.XAError = 0;
        this.XACommand = command;
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendXACommand(command, xid, rmid, flags);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw Messages.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        return this.XAError;
    }

    private void sendXACommand(short command, Xid xid, int rmid, int flags) throws SQLException {
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        byte[] data = new byte[128];
        System.arraycopy(gtrid, 0, data, 0, gtrid.length);
        System.arraycopy(bqual, 0, data, gtrid.length, bqual.length);
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\nC->S");
                this.protoTrace.writeTrace(logger, 1, "\t" + IfxXMessageTypes.XAMessageNameTable.get(new Integer(command)));
            }
            this.os.writeSmallInt(command);
            this.os.writeInt(xid.getFormatId());
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tFormat ID: " + xid.getFormatId());
            }
            this.os.writeInt(gtrid.length);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tGtrid.length: " + gtrid.length);
            }
            this.os.writeInt(bqual.length);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tBqual.length: " + bqual.length);
            }
            this.os.writePadded(data);
            this.os.writeInt(rmid);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\trmid: " + rmid);
            }
            this.os.writeInt(flags);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tflags: " + flags);
            }
        }
        catch (Exception e) {
            throw Messages.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
    }

    public int executeXAClose(String dbName, int rmid, int flags) throws SQLException {
        this.XAError = 0;
        this.XACommand = 66;
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendXAClose(dbName, rmid, flags);
            this.receiveMessage();
        }
        catch (Exception e) {
            this.conn.unlockSession();
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw Messages.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        return this.XAError;
    }

    private void sendXAClose(String dbName, int rmid, int flags) throws SQLException {
        try {
            byte[] dbNameBytes = this.os.getJavaToIfxChar(dbName);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\nC->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_XCLOSE");
            }
            this.os.writeSmallInt((short)66);
            this.os.writeChar(dbNameBytes);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tName: " + dbName);
            }
            this.os.writeInt(rmid);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\trmid: " + rmid);
            }
            this.os.writeInt(flags);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tFlags: " + flags);
            }
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw Messages.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
    }

    public int executeXARecover(int count, int end, int flags) throws SQLException {
        this.XAError = 0;
        this.XACommand = 71;
        if (!this.conn.lockSession()) {
            throw Messages.getSQLMinorException(-79748, -80033, this.conn);
        }
        try {
            this.sendXARecover(count, end, flags);
            this.receiveMessage();
        }
        catch (SQLException e) {
            this.conn.unlockSession();
            throw e;
        }
        catch (Exception e) {
            this.conn.unlockSession();
            throw Messages.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
        this.conn.unlockSession();
        return this.XAError;
    }

    private void sendXARecover(int count, int end, int flags) throws SQLException {
        try {
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 1, "\nC->S");
                this.protoTrace.writeTrace(logger, 1, "\tSQ_XRECOVER");
            }
            this.os.writeSmallInt((short)71);
            this.os.writeInt(count);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tCount: " + count);
            }
            this.os.writeInt(end);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tend: " + end);
            }
            this.os.writeInt(flags);
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tFlags: " + flags);
            }
        }
        catch (Exception e) {
            throw Messages.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
    }

    private void receiveXAError() throws SQLException {
        try {
            this.xidArray = null;
            this.XAError = this.is.readSmallInt();
            if (TraceFlag.isTraceEnabled()) {
                this.protoTrace.writeTrace(logger, 2, "\t\tXAError: " + this.XAError);
            }
            if (this.XACommand == 71) {
                int xcnt = this.XAError;
                if (TraceFlag.isTraceEnabled()) {
                    this.protoTrace.writeTrace(logger, 2, "\t\tXid count: " + xcnt);
                }
                if (xcnt <= 0) {
                    return;
                }
                this.xidArray = new IfxXid[xcnt];
                byte[] gtrid = null;
                byte[] bqual = null;
                byte[] data = new byte[128];
                int len = 0;
                for (int i = 0; i < xcnt; ++i) {
                    int formatId = this.is.readInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tformatId: " + formatId);
                    }
                    len = this.is.readInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tgtrid length: " + len);
                    }
                    gtrid = new byte[len];
                    len = this.is.readInt();
                    if (TraceFlag.isTraceEnabled()) {
                        this.protoTrace.writeTrace(logger, 2, "\t\t\tbqual length: " + len);
                    }
                    bqual = new byte[len];
                    this.is.readPadded(data);
                    System.arraycopy(data, 0, gtrid, 0, gtrid.length);
                    System.arraycopy(data, gtrid.length, bqual, 0, bqual.length);
                    this.xidArray[i] = new IfxXid(formatId, gtrid, bqual);
                }
            }
        }
        catch (Exception e) {
            throw Messages.getSQLException(-79716, e.toString(), (IfxConnection)this.conn);
        }
    }
}

