/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxComplexSQLOutput;
import com.informix.jdbc.IfxArray;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxComplex;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxDecimal;
import com.informix.jdbc.IfxDistinctOutput;
import com.informix.jdbc.IfxFloat;
import com.informix.jdbc.IfxIntervalDF;
import com.informix.jdbc.IfxIntervalYM;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSQLOutput;
import com.informix.jdbc.IfxSmBlob;
import com.informix.jdbc.IfxSmallFloat;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.jdbc.IfxUDTOutput;
import com.informix.jdbc.IfxValue;
import com.informix.lang.IfxTypes;
import com.informix.lang.Interval;
import com.informix.lang.IntervalDF;
import com.informix.lang.IntervalYM;
import com.informix.lang.JavaToIfxType;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import com.informix.util.stringUtil;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxComplexOutput
extends IfxSQLOutput
implements IfmxComplexSQLOutput {
    private static final Object logger = Trace.getLoggerForClass(IfxComplexOutput.class);
    private Map<String, Class<?>> typeMap = null;
    private boolean isRow = false;
    private boolean isNested = false;
    private Vector<IfxColumnInfo> typeInfoVector = null;
    private Vector<IfxColumnInfo> parentTypeInfoVector = null;
    private Vector<Integer> elementOffsetVector = new Vector();
    private int typeInfoCount = 0;
    private String extendedName = "";
    private boolean isNull = true;
    private short identsize = 0;
    private int currentIfxType = 49;
    private int currentIfxLength = 0;
    private int currentExtendedId = 0;
    private int typeIndex = -1;
    private int typeChildIndex = 0;
    private boolean isTyped = false;
    private boolean atNextType = false;
    private static final short COLL_ALIGN = 8;
    private static final short COLL_FLAGHASH_SIZE = 8;
    private static final String T_COMMA = ",";
    private static String T_LPAREN = "(";
    private static String T_RPAREN = ")";
    private static String T_SPACE = " ";
    private static final int CT_TYPE = 1;
    private static final int TYPE = 2;
    private static final int LENGTH = 3;
    private static final int NEXTELEMENT = 4;
    private static final int LPAREN = 5;
    private static final int RPAREN = 6;
    private static final int FIELDNAME = 7;
    private static final int NOTNULL = 8;
    private static final int CTEND = 9;
    private String currentToken = null;
    private boolean advanceToken = true;
    private int previousState = -1;

    IfxComplexOutput(boolean isRow, boolean isNested) throws SQLException {
        super.setRandomAccess(false);
        this.isRow = isRow;
        this.isNested = isNested;
        this.typeInfoVector = new Vector();
    }

    IfxComplexOutput(boolean isRow, boolean isNested, IfxConnection conn) throws SQLException {
        super(conn);
        super.setRandomAccess(false);
        this.isRow = isRow;
        this.isNested = isNested;
        this.typeInfoVector = new Vector();
    }

    IfxComplexOutput(boolean isRow, boolean isNested, Object typeInfo, IfxConnection conn) throws SQLException {
        super(conn);
        super.setRandomAccess(false);
        this.isRow = isRow;
        this.isNested = isNested;
        if (typeInfo == null || !(typeInfo instanceof IfxColumnInfo)) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxComplexOutput(boolean, boolean, Vector, Connection)", conn);
        }
        Vector<IfxColumnInfo> v = new Vector<IfxColumnInfo>();
        v.add((IfxColumnInfo)typeInfo);
        this.setTypeInfoVector(v);
    }

    IfxComplexOutput(boolean isRow, boolean isNested, String rowType, IfxConnection conn) throws SQLException {
        super(conn);
        super.setRandomAccess(false);
        this.isRow = isRow;
        this.isNested = isNested;
        if (rowType == null) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxComplexOutput(boolean, boolean, String, Connection)", conn);
        }
        Vector<IfxColumnInfo> v = this.getTypeInfoVector(rowType);
        this.setTypeInfoVector(v);
    }

    IfxComplexOutput(boolean isRow, String rowType, IfxConnection conn) throws SQLException {
        super(conn);
        super.setRandomAccess(false);
        this.isRow = isRow;
        this.isNested = false;
        if (rowType == null) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxComplexOutput(boolean, boolean, String, Connection)", conn);
        }
        Vector<IfxColumnInfo> v = this.getTypeInfoVector(rowType);
        this.setTypeInfoVector(v);
    }

    boolean isNull() {
        return this.isNull;
    }

    void clear() {
        this.elementOffsetVector = new Vector();
        this.extendedName = "";
        this.isNull = true;
        this.reset();
    }

    private void clearTypeInfo() {
        this.parentTypeInfoVector = null;
        this.typeInfoVector = null;
        this.typeInfoCount = 0;
    }

    void setTypeMap(Map<String, Class<?>> map) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): setTypeMap called");
        }
        this.typeMap = map;
    }

    @Override
    void setConnection(IfxConnection conn) throws SQLException {
        super.setConnection(conn);
        this.identsize = conn.isLongID() ? (short)128 : (short)18;
    }

    private void addTypeAndOffsetInfo(int ifxType, int length, String extendedName) throws SQLException {
        IfxColumnInfo colInfo = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): addTypeAndOffsetInfo() entered");
            this.trace.writeTrace(logger, 2, "    addTypeAndOffsetInfo() isTyped: " + this.isTyped);
        }
        this.isNull = false;
        if (this.isTyped) {
            this.getNextType(ifxType, length, extendedName, 0);
            ifxType = this.currentIfxType;
        } else {
            if (this.isRow) {
                throw IfxErrMsg.getSQLException(-79716, ": addTypeAndOffsetInfo() it's a row", this.conn);
            }
            if (this.typeInfoVector.size() == 0) {
                colInfo = new IfxColumnInfo();
                colInfo.SQLtype = ifxType;
                colInfo.Nullable = 0;
                colInfo.ColLength = (short)length;
                if (extendedName != null) {
                    colInfo.ExtendedName = extendedName;
                    if (ifxType == 22) {
                        colInfo.IsNamedRow = true;
                    } else if (ifxType == 40) {
                        if (extendedName.compareToIgnoreCase("blob") == 0) {
                            colInfo.ExtendedId = 10;
                        } else if (extendedName.compareToIgnoreCase("clob") == 0) {
                            colInfo.ExtendedId = 11;
                        }
                    }
                }
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "    Added ifxType: " + ifxType);
                    this.trace.writeTrace(logger, 2, "    Added name: " + extendedName);
                    this.trace.writeTrace(logger, 2, "    Added colLength: " + colInfo.ColLength);
                }
                this.typeInfoVector.addElement(colInfo);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "    typeInfo has # elements: " + this.typeInfoVector.size());
                }
            } else if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, " dump from addTypeAndOffsetInfo(): ");
                this.trace.writeTrace(logger, 2, " ****** begin typeInfoVector information *****");
                IfxComplex.dumpTypeInfoVector(this.typeInfoVector, this.trace, 4);
                this.trace.writeTrace(logger, 2, " ****** end typeInfoVector information *****");
            }
        }
        this.addElementOffset(ifxType);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): addTypeAndOffsetInfo() exited");
        }
    }

    private void addElementOffset(int ifxType) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): addElementOffset(int) entered");
            this.trace.writeTrace(logger, 2, "    addElementOffset(int) ifxType:" + ifxType);
            this.trace.writeTrace(logger, 2, "    addElementOffset(int) isNested:" + this.isNested);
            this.trace.writeTrace(logger, 2, "    addElementOffset(int) isRow:" + this.isRow);
            this.trace.writeTrace(logger, 2, "    addElementOffset(int) bStream.size():" + this.bStream.size());
        }
        int position = this.bStream.size();
        if (this.isRow || IfxTypes.isUDT(ifxType) || IfxTypes.isComplexType(ifxType)) {
            Integer intObj = position;
            Integer lastIntObject = null;
            boolean addElement = true;
            if (this.elementOffsetVector.size() > 0) {
                lastIntObject = this.elementOffsetVector.lastElement();
            }
            if (lastIntObject != null && lastIntObject.intValue() == intObj.intValue()) {
                addElement = false;
            }
            if (addElement) {
                this.elementOffsetVector.addElement(intObj);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "    Added offset: " + position);
                    this.trace.writeTrace(logger, 2, "    offset has # elements: " + this.elementOffsetVector.size());
                }
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): addElementOffset(int) exited");
        }
    }

    @Override
    public void writeInt(int x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeInt() entered");
            this.trace.writeTrace(logger, 2, "    writeInt() x = " + x);
        }
        if (!this.isRow && x == Integer.MIN_VALUE) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(2, 4, null);
        try {
            this.os.writeInt(x);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeInt() exited");
        }
    }

    @Override
    public void writeString(String x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeString() entered");
            this.trace.writeTrace(logger, 2, "    writeString(String) x = " + x);
        }
        if (!this.isRow && x == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        try {
            if (this.isTyped) {
                this.writeStringWithLength(x);
            } else {
                this.addTypeAndOffsetInfo(43, this.conn.getMaxLvarcharSize(), null);
                if (x == null) {
                    int bNull = 1;
                    this.os.write(bNull);
                } else {
                    int bNull = 0;
                    this.os.write(bNull);
                    byte[] b = JavaToIfxType.JavaToIfxInt(x.length());
                    this.os.write(b, 0, b.length);
                    b = stringUtil.getBytes(x, this.conn);
                    this.os.write(b, 0, b.length);
                }
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeString() exited");
        }
    }

    private void writeStringWithLength(String x) throws SQLException {
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeStringWithLength(String) entered");
            this.trace.writeTrace(logger, 2, "    x = " + x);
            this.trace.writeTrace(logger, 2, "    bStream.size() = " + this.bStream.size());
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        this.isNull = false;
        this.getNextType(49, 0, null, 0);
        if (!IfxTypes.isString(this.currentIfxType)) {
            IfxComplex.badTypeException(this.currentIfxType, (short)0, this.trace, locale);
        }
        this.addElementOffset(this.currentIfxType);
        int len = this.currentIfxLength;
        try {
            if (this.currentIfxType == 13 || this.currentIfxType == 16) {
                if (x == null && len < 2) {
                    len = 0;
                    x = "";
                }
                if (x == null) {
                    byte[] b = new byte[]{1, 0};
                    this.os.write(b, 0, b.length);
                    String s = stringUtil.fixLength(x, len - 2, ' ');
                    b = stringUtil.getBytes(s, this.conn);
                    this.os.write(b, 0, b.length);
                } else if (len == 0) {
                    byte[] b = new byte[]{0};
                    this.os.write(b, 0, b.length);
                } else {
                    if (x.length() > 255) {
                        len = 255;
                    }
                    this.os.write((byte)len);
                    String s = stringUtil.fixLength(x, len, ' ');
                    byte[] b = stringUtil.getBytes(s, this.conn);
                    this.os.write(b, 0, b.length);
                }
            } else if (this.currentIfxType == 0 || this.currentIfxType == 15) {
                String s = stringUtil.fixLength(x, len, ' ');
                byte[] b = stringUtil.getBytes(s, this.conn);
                if (x == null) {
                    b[0] = 0;
                }
                this.os.write(b, 0, b.length);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "    string written: = " + s);
                    this.trace.writeTrace(logger, 2, "    s.length = " + s.length());
                }
            } else if (x == null) {
                int bNull = 1;
                this.os.write(bNull);
            } else {
                int bNull = 0;
                this.os.write(bNull);
                byte[] b = JavaToIfxType.JavaToIfxInt(x.length());
                this.os.write(b, 0, b.length);
                b = stringUtil.getBytes(x, this.conn);
                this.os.write(b, 0, b.length);
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeStringWitLength() exited");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeObject(SQLData x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeObject(SQLData) entered");
        }
        if (!this.isRow && x == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        IfxColumnInfo colInfo = null;
        colInfo = this.isTyped ? this.typeInfoVector.get(this.typeIndex + 1) : this.typeInfoVector.get(this.typeIndex);
        if (colInfo.SQLtype == 40 || colInfo.SQLtype == 41) {
            this.writeUDT(x);
        } else if (colInfo.IsDistinct) {
            this.writeDistinct(x);
        } else if (colInfo.SQLtype == 22) {
            if (x == null || x instanceof Struct) {
                this.writeStruct((Struct)((Object)x));
            } else {
                if (!(x instanceof SQLData)) throw IfxErrMsg.getSQLException(-79777, this.conn);
                this.writeNestedRow(x);
            }
        } else {
            if (x != null) throw IfxErrMsg.getSQLException(-79777, this.conn);
            this.writeElement(x, colInfo.SQLtype);
        }
        if (!TraceFlag.isTraceEnabled()) return;
        this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeObject(SQLData) exited");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeObject(Object x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeObject(Object) entered");
        }
        if (!this.isRow && x == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        IfxColumnInfo colInfo = null;
        colInfo = this.isTyped ? this.typeInfoVector.get(this.typeIndex + 1) : this.typeInfoVector.get(this.typeIndex);
        if (IfxTypes.isCollection(colInfo.SQLtype)) {
            if (x == null || x instanceof Collection) {
                this.writeNestedCollection((Collection)x);
            } else {
                if (!(x instanceof Array)) throw IfxErrMsg.getSQLException(-79777, this.conn);
                this.writeArray((Array)x);
            }
        } else {
            if (colInfo.SQLtype != 14) throw IfxErrMsg.getSQLException(-79777, this.conn);
            if (x == null || x instanceof IntervalDF) {
                this.writeIntervalDF((IntervalDF)x);
            }
            if (!(x instanceof IntervalYM)) throw IfxErrMsg.getSQLException(-79777, this.conn);
            this.writeIntervalYM((IntervalYM)x);
        }
        if (!TraceFlag.isTraceEnabled()) return;
        this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeObject(Object) exited");
    }

    @Override
    public void writeStruct(Struct s) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeStruct(Struct) entered");
            this.trace.writeTrace(logger, 1, "    writeStruct(Struct) isTyped: " + this.isTyped);
            this.trace.writeTrace(logger, 1, "    writeStruct(Struct) typeIndex: " + this.typeIndex);
        }
        IfxComplexOutput nestedOutput = null;
        if (this.isTyped) {
            this.getNextType(22, 0, null, 0);
        }
        this.addElementOffset(22);
        if (s == null && !this.isRow) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (s != null) {
            Map<String, Class<?>> map = this.conn.getTypeMap();
            Object[] objArray = s.getAttributes(map);
            String rowType = s.getSQLTypeName();
            if (rowType == null) {
                throw IfxErrMsg.getSQLException(-79770, this.conn);
            }
            if (objArray.length == 0) {
                throw IfxErrMsg.getSQLException(-79792, this.conn);
            }
            nestedOutput = this.isTyped ? new IfxComplexOutput(true, true, this.typeInfoVector.get(this.typeIndex), this.conn) : new IfxComplexOutput(true, true, rowType, this.conn);
            if (!this.isTyped && this.typeInfoVector.size() == 0) {
                IfxColumnInfo colInfo = nestedOutput.getTypeInfoVector().get(0);
                colInfo.Nullable = 0;
                this.typeInfoVector.add(colInfo);
            }
            for (int i = 0; i < objArray.length; ++i) {
                int ifxType;
                this.isNull = false;
                if (objArray[i] == null) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, "  writeStruct() obj[" + i + "] is null");
                    }
                    this.atNextType = this.getNextType(49, 0, null, i);
                    ifxType = this.currentIfxType;
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, "  writeStruct() type of null: " + ifxType);
                    }
                } else {
                    ifxType = this.getIfxType(objArray[i], nestedOutput.getIsTyped());
                }
                nestedOutput.writeElement(objArray[i], ifxType);
            }
        } else {
            nestedOutput = new IfxComplexOutput(true, true, this.conn);
            if (!this.isTyped && this.typeInfoVector.size() == 0) {
                IfxColumnInfo colInfo = nestedOutput.getTypeInfoVector().get(0);
                colInfo.Nullable = 0;
                this.typeInfoVector.add(colInfo);
            }
        }
        nestedOutput.writeElementOffset();
        this.writeNestedData(nestedOutput);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "    writeStruct(Struct) isTyped: " + this.isTyped);
            this.trace.writeTrace(logger, 3, "    writeStruct(Struct) typeIndex: " + this.typeIndex);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "    writeStruct(Struct) isNull: " + this.isNull);
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeStruct(Struct) exited");
        }
    }

    private void writeNestedRow(SQLData x) throws SQLException {
        IfxComplexOutput nestedOutput = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeNestedRow(SQLData) entered");
            this.trace.writeTrace(logger, 2, "  writeNestedRow(SQLData) isTyped: " + this.isTyped);
        }
        if (this.isTyped) {
            this.getNextType(22, 0, null, 0);
        }
        this.addElementOffset(this.currentIfxType);
        if (x == null) {
            if (!this.isRow) {
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
            this.isNull = true;
            return;
        }
        if (this.isTyped) {
            nestedOutput = new IfxComplexOutput(true, true, this.typeInfoVector.get(this.typeIndex), this.conn);
        } else {
            String rowType = x.getSQLTypeName();
            if (rowType == null) {
                throw IfxErrMsg.getSQLException(-79770, this.conn);
            }
            nestedOutput = new IfxComplexOutput(true, true, rowType, this.conn);
        }
        this.addElementOffset(22);
        this.isNull = false;
        nestedOutput.writeRow(x);
        this.writeNestedData(nestedOutput);
        if (!this.isTyped && this.typeInfoVector.size() == 0) {
            IfxColumnInfo colInfo = nestedOutput.getTypeInfoVector().get(0);
            colInfo.Nullable = 0;
            this.typeInfoVector.add(colInfo);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, " dump from writeNestedRow(SQLData): ");
            this.trace.writeTrace(logger, 2, " ****** begin typeInfoVector information *****");
            IfxComplex.dumpTypeInfoVector(this.typeInfoVector, this.trace, 4);
            this.trace.writeTrace(logger, 2, " ****** end typeInfoVector information *****");
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeNestedRow(SQLData) exited");
        }
    }

    private void writeNestedCollection(Collection<Object> x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeNestedCollection(Collection) entered");
            this.trace.writeTrace(logger, 2, "    writeNestedCollection() class: " + x.getClass().getName());
        }
        if (!this.isRow && x == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (x == null) {
            this.addTypeAndOffsetInfo(20, 0, null);
        } else {
            this.addTypeAndOffsetInfo(this.getOverrideIfxType(x), 0, null);
        }
        IfxComplexOutput nestedOutput = null;
        nestedOutput = this.isTyped ? new IfxComplexOutput(false, true, this.typeInfoVector.get(this.typeIndex), this.conn) : new IfxComplexOutput(false, true, this.conn);
        if (x == null) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "************ NULL COLLECTION **********");
            }
            this.addElementOffset(this.currentIfxType);
            this.writeNestedData(nestedOutput);
            return;
        }
        this.isNull = false;
        Iterator<Object> it = x.iterator();
        if (!it.hasNext()) {
            nestedOutput.isNull = false;
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    writeNestedCollection(Collection x)EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(49, 0, null);
        } else {
            Object obj = it.next();
            int ifxType = this.getIfxType(obj, nestedOutput.getIsTyped());
            while (true) {
                this.addElementOffset(ifxType);
                nestedOutput.writeElement(obj, ifxType);
                if (!it.hasNext()) break;
                obj = it.next();
            }
        }
        nestedOutput.writeElementOffset();
        this.writeNestedData(nestedOutput);
        if (!this.isTyped) {
            IfxColumnInfo colInfo = this.typeInfoVector.lastElement();
            if (colInfo.child != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 1, "   writeNestedCollection(Collection) last element already has a child element");
                }
                if (this.isUnknownType(colInfo.child.get(0))) {
                    colInfo.child = nestedOutput.getTypeInfoVector();
                }
            } else {
                colInfo.child = nestedOutput.getTypeInfoVector();
            }
            IfxColumnInfo childColInfo = colInfo.child.get(0);
            childColInfo.Nullable = 0;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeNestedCollection(Collection) exited");
        }
    }

    private void writeUDT(Object x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeUDT(Object) entered");
        }
        if (x == null) {
            if (!this.isRow) {
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
            IfxColumnInfo colInfo = this.typeInfoVector.get(this.typeIndex);
            this.addTypeAndOffsetInfo(40, 0, colInfo.ExtendedName);
            IfxObject obj = IfxValue.makeInstance(this.conn, colInfo);
            byte[] b = obj.toIfx();
            try {
                this.os.write(b);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
        if (!(x instanceof SQLData)) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        SQLData data = (SQLData)x;
        IfxUDTOutput UDToutput = new IfxUDTOutput(this.conn);
        data.writeSQL(UDToutput);
        String udtName = ((SQLData)x).getSQLTypeName();
        if (udtName == null || udtName == "") {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        this.addTypeAndOffsetInfo(40, UDToutput.length(), udtName);
        try {
            this.os.writeByte(0);
            byte[] b = JavaToIfxType.JavaToIfxInt(UDToutput.length());
            this.os.write(b);
            b = UDToutput.toByteArray();
            this.os.write(b);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        UDToutput.reset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeUDT(Object) exited");
        }
    }

    private void writeDistinct(Object x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeDistinct(Object) entered");
        }
        if (!this.isRow && x == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (!(x instanceof SQLData)) {
            throw IfxErrMsg.getSQLException(-79728, this.conn);
        }
        IfxDistinctOutput distinctOutput = new IfxDistinctOutput(null, this.conn);
        SQLData data = (SQLData)x;
        String name = data.getSQLTypeName();
        if (name == null || name == "") {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        this.addTypeAndOffsetInfo(40, 0, name);
        data.writeSQL(distinctOutput);
        try {
            byte[] bZero = new byte[]{0};
            this.os.write(bZero, 0, 1);
            byte[] b = JavaToIfxType.JavaToIfxInt(distinctOutput.length());
            this.os.write(b, 0, b.length);
            b = distinctOutput.toByteArray();
            this.os.write(b, 0, b.length);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        distinctOutput.reset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeDistinct(Object) exited");
        }
    }

    void writeRow(SQLData x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeRow(SQLData) entered");
        }
        this.extendedName = x.getSQLTypeName();
        if (this.extendedName == null || this.extendedName == "") {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        if (!this.isTyped) {
            Vector<IfxColumnInfo> v = this.getTypeInfoVector(this.extendedName);
            this.setTypeInfoVector(v);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    writeRow(SQLData) typeInfo dump");
            this.trace.writeTrace(logger, 2, " ****** begin typeInfoVector information *****");
            IfxComplex.dumpTypeInfoVector(this.typeInfoVector, this.trace, 4);
            this.trace.writeTrace(logger, 2, " ****** end typeInfoVector information *****");
        }
        x.writeSQL(this);
        this.writeElementOffset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeRow(SQLData) exited");
        }
    }

    void writeRow(Struct x) throws SQLException {
        Object[] obj;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeRow(Struct) entered");
        }
        this.isNull = false;
        String rowType = x.getSQLTypeName();
        if (rowType == null) {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        if (!this.isTyped) {
            Vector<IfxColumnInfo> v = this.getTypeInfoVector(rowType);
            this.setTypeInfoVector(v);
        }
        if ((obj = x.getAttributes()).length == 0) {
            throw IfxErrMsg.getSQLException(-79792, this.conn);
        }
        for (int i = 0; i < obj.length; ++i) {
            int ifxType;
            if (obj[i] == null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 1, "  writeRow() obj[" + i + "] is null");
                }
                this.atNextType = this.getNextType(49, 0, null, i);
                ifxType = this.currentIfxType;
            } else {
                ifxType = this.getIfxType(obj[i], this.isTyped);
            }
            this.writeElement(obj[i], ifxType);
        }
        this.writeElementOffset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, " dump from writeRow(Struct): ");
            this.trace.writeTrace(logger, 2, " ****** begin parentTypeInfoVector information *****");
            IfxComplex.dumpTypeInfoVector(this.parentTypeInfoVector, this.trace, 4);
            this.trace.writeTrace(logger, 2, " ****** end parentTypeInfoVector information *****");
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeRow(Struct) exited");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void writeCollection(Collection<Object> x) throws SQLException {
        int collType;
        block10: {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeCollection(Collection) entered");
                if (x != null) {
                    this.trace.writeTrace(logger, 2, "    writeCollection(Collection) class: " + x.getClass().getName());
                }
            }
            if (x == null) {
                this.addParentTypeInfoHeader(20, "");
                this.isNull = true;
                return;
            }
            collType = this.getOverrideIfxType(x);
            this.isNull = false;
            Iterator<Object> it = x.iterator();
            if (!it.hasNext()) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "    writeCollection(Collection) EMPTY COLLECTION");
                }
                this.addTypeAndOffsetInfo(49, 0, null);
            } else {
                Object obj = it.next();
                if (obj == null) {
                    throw IfxErrMsg.getSQLException(-1225, this.conn);
                }
                Class<?> objClass = obj.getClass();
                int ifxType = this.getIfxType(obj, this.isTyped);
                do {
                    if (obj.getClass() != objClass) {
                        throw IfxErrMsg.getSQLException(-79780, this.conn);
                    }
                    this.writeElement(obj, ifxType);
                    if (!it.hasNext()) break block10;
                } while ((obj = it.next()) != null);
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
        }
        this.addParentTypeInfoHeader(collType, "");
        this.writeElementOffset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, " dump from writeCollection(Collection): ");
            this.trace.writeTrace(logger, 2, " ****** begin dump parentTypeInfoVector information *****");
            IfxComplex.dumpTypeInfoVector(this.parentTypeInfoVector, this.trace, 4);
            this.trace.writeTrace(logger, 2, " ****** end dump parentTypeInfoVector information *****");
            this.trace.writeTrace(logger, 2, "");
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeCollection(Collection) exited");
        }
    }

    void writeCollection(Array x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeCollection(Array) entered");
        }
        if (x == null) {
            this.addParentTypeInfoHeader(20, "");
            this.isNull = true;
            return;
        }
        Object obj = x.getArray(this.typeMap);
        if (obj != null) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "  baseType: " + x.getBaseType());
                this.trace.writeTrace(logger, 2, "  baseTypeName: " + x.getBaseTypeName());
            }
            Class<?> objClass = obj.getClass().getComponentType();
            int JDBCType = x.getBaseType();
            switch (JDBCType) {
                case 16: 
                case 1111: {
                    if (objClass.equals(Boolean.TYPE)) {
                        this.writePrimitiveArray((boolean[])obj);
                        break;
                    }
                    this.writeArray((Object[])obj, JDBCType);
                    break;
                }
                case 4: {
                    if (!objClass.equals(Integer.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((int[])obj);
                    break;
                }
                case 5: {
                    if (!objClass.equals(Short.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((short[])obj);
                    break;
                }
                case -5: {
                    if (!objClass.equals(Long.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((long[])obj);
                    break;
                }
                case 6: {
                    if (!objClass.equals(Float.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((float[])obj);
                    break;
                }
                case 8: {
                    if (!objClass.equals(Double.TYPE)) {
                        throw IfxErrMsg.getSQLException(-79793, this.conn);
                    }
                    this.writePrimitiveArray((double[])obj);
                    break;
                }
                default: {
                    this.writeArray((Object[])obj, JDBCType);
                    break;
                }
            }
        } else {
            this.isNull = true;
        }
        this.addParentTypeInfoHeader(this.getOverrideIfxType(x), "");
        this.writeElementOffset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, " dump from writeCollection(Array): ");
            this.trace.writeTrace(logger, 2, " ****** begin dump parentTypeInfoVector information *****");
            IfxComplex.dumpTypeInfoVector(this.parentTypeInfoVector, this.trace, 4);
            this.trace.writeTrace(logger, 2, " ****** end dump parentTypeInfoVector information *****");
            this.trace.writeTrace(logger, 2, "");
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeCollection(Array) exited");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeArray(Array arr) throws SQLException {
        IfxComplexOutput nestedOutput;
        block22: {
            Object obj;
            block21: {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeArray(Array) entered");
                }
                if (!this.isRow && arr == null) {
                    throw IfxErrMsg.getSQLException(-1225, this.conn);
                }
                if (arr != null) {
                    this.addTypeAndOffsetInfo(this.getOverrideIfxType(arr), 0, null);
                } else {
                    this.addTypeAndOffsetInfo(20, 0, null);
                }
                nestedOutput = null;
                nestedOutput = this.isTyped ? new IfxComplexOutput(false, true, this.typeInfoVector.get(this.typeIndex), this.conn) : new IfxComplexOutput(false, true, this.conn);
                Map<String, Class<?>> map = this.conn.getTypeMap();
                obj = arr.getArray(map);
                if (obj == null) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 2, "************ NULL COLLECTION **********");
                    }
                    this.addElementOffset(this.currentIfxType);
                    this.writeNestedData(nestedOutput);
                    return;
                }
                this.isNull = false;
                Class<?> componentClass = obj.getClass().getComponentType();
                if (!componentClass.isPrimitive()) break block21;
                switch (arr.getBaseType()) {
                    case 16: 
                    case 1111: {
                        if (!componentClass.equals(Boolean.TYPE)) throw IfxErrMsg.getSQLException(-79728, this.conn);
                        nestedOutput.writePrimitiveArray((boolean[])obj);
                        break block22;
                    }
                    case 5: {
                        nestedOutput.writePrimitiveArray((short[])obj);
                        break block22;
                    }
                    case 4: {
                        nestedOutput.writePrimitiveArray((int[])obj);
                        break block22;
                    }
                    case -5: {
                        nestedOutput.writePrimitiveArray((long[])obj);
                        break block22;
                    }
                    case 6: {
                        nestedOutput.writePrimitiveArray((float[])obj);
                        break block22;
                    }
                    case 8: {
                        nestedOutput.writePrimitiveArray((double[])obj);
                        break block22;
                    }
                    default: {
                        throw IfxErrMsg.getSQLException(-79728, this.conn);
                    }
                }
            }
            Object[] objArray = (Object[])obj;
            Class<?> objClass = objArray[0].getClass();
            int ifxType = this.getIfxType(objArray[0], nestedOutput.getIsTyped());
            for (int i = 0; i < objArray.length; ++i) {
                if (objClass != objArray[i].getClass()) {
                    throw IfxErrMsg.getSQLException(-79780, this.conn);
                }
                this.addElementOffset(ifxType);
                nestedOutput.writeElement(objArray[i], ifxType);
            }
        }
        nestedOutput.writeElementOffset();
        this.writeNestedData(nestedOutput);
        if (!this.isTyped) {
            IfxColumnInfo colInfo = this.typeInfoVector.lastElement();
            if (colInfo.child != null) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 1, "   writeNestedCollection(Collection) last element already has a child element");
                }
                if (this.isUnknownType(colInfo.child.get(0))) {
                    colInfo.child = nestedOutput.getTypeInfoVector();
                }
            } else {
                colInfo.child = nestedOutput.getTypeInfoVector();
            }
            IfxColumnInfo childColInfo = colInfo.child.get(0);
            childColInfo.Nullable = 0;
        }
        if (!TraceFlag.isTraceEnabled()) return;
        this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeArray(Array) exited");
    }

    private void writeArray(Object[] x, int baseType) throws SQLException {
        int size = 0;
        int ifxType = 49;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeArray(Object[], int) entered");
            this.trace.writeTrace(logger, 2, "    baseType: " + baseType);
        }
        if (x == null) {
            return;
        }
        size = x.length;
        if (size == 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    writeArray(Object [] x) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(0, 1, null);
            return;
        }
        if (x[0] == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    size = " + size);
        }
        Class<?> objClass = x[0].getClass();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    writeArray() class[0]: " + objClass.getName());
        }
        ifxType = this.getIfxType(x[0], this.isTyped);
        for (int i = 0; i < size; ++i) {
            if (x[i] == null) {
                throw IfxErrMsg.getSQLException(-1225, this.conn);
            }
            if (x[i].getClass() != objClass) {
                throw IfxErrMsg.getSQLException(-79780, this.conn);
            }
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    writeArray() x[i].class: " + x[i].getClass().getName());
                this.trace.writeTrace(logger, 2, "    writeArray() ifxType: " + ifxType);
            }
            this.writeElement(x[i], ifxType);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeArray(Object[], int) exited");
        }
    }

    private void writeElement(Object x, int ifxType) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeElement(Object, int) entered");
            if (x != null) {
                this.trace.writeTrace(logger, 1, "  writeElement(): Class: " + x.getClass());
            }
            this.trace.writeTrace(logger, 1, "  writeElement(): ifxType: " + ifxType);
        }
        switch (ifxType) {
            case 0: 
            case 13: 
            case 15: 
            case 16: 
            case 43: {
                this.writeString((String)x);
                break;
            }
            case 1: {
                if (x == null) {
                    this.writeShort((short)Short.MIN_VALUE);
                    break;
                }
                this.writeShort((Short)x);
                break;
            }
            case 2: 
            case 6: {
                if (x == null) {
                    this.writeInt(Integer.MIN_VALUE);
                    break;
                }
                this.writeInt((Integer)x);
                break;
            }
            case 3: {
                if (x == null) {
                    this.writeDoubleNull();
                    break;
                }
                this.writeDouble((Double)x);
                break;
            }
            case 4: {
                if (x == null) {
                    this.writeFloat(IfxSmallFloat.getIfxNull());
                    break;
                }
                this.writeFloat(((Float)x).floatValue());
                break;
            }
            case 5: 
            case 8: {
                this.writeBigDecimal((BigDecimal)x);
                break;
            }
            case 7: {
                this.writeDate((Date)x);
                break;
            }
            case 10: {
                if (x instanceof Time) {
                    this.writeTime((Time)x);
                    break;
                }
                this.writeTimestamp((Timestamp)x);
                break;
            }
            case 14: {
                if (x instanceof String) {
                    this.writeString((String)x);
                    break;
                }
                if (x == null || x instanceof IntervalDF) {
                    this.writeIntervalDF((IntervalDF)x);
                    break;
                }
                this.writeIntervalYM((IntervalYM)x);
                break;
            }
            case 17: 
            case 18: {
                if (x == null) {
                    this.writeLong(Long.MIN_VALUE);
                    break;
                }
                this.writeLong((Long)x);
                break;
            }
            case 52: {
                if (x == null) {
                    this.writeLongBigint(Long.MIN_VALUE, 52);
                    break;
                }
                this.writeLongBigint((Long)x, 52);
                break;
            }
            case 53: {
                if (x == null) {
                    this.writeLongBigint(Long.MIN_VALUE, 53);
                } else {
                    this.writeLongBigint((Long)x, 53);
                }
            }
            case 102: {
                this.writeBlob((Blob)x);
                break;
            }
            case 101: {
                this.writeClob((Clob)x);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                if (x == null || x instanceof Collection) {
                    this.writeNestedCollection((Collection)x);
                    break;
                }
                Array arr = null;
                arr = x.getClass().isArray() ? new IfxArray(x, this.conn) : (Array)x;
                this.writeArray(arr);
                break;
            }
            case 22: {
                if (x == null || x instanceof Struct) {
                    this.writeStruct((Struct)x);
                    break;
                }
                if (!(x instanceof SQLData)) break;
                this.writeNestedRow((SQLData)x);
                break;
            }
            case 40: 
            case 41: 
            case 44: {
                this.writeUDT(x);
                break;
            }
            case 45: {
                if (x == null) {
                    this.writeBoolean((byte)-1);
                    break;
                }
                this.writeBoolean((Boolean)x);
                break;
            }
            default: {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "writeElement() bad type in switch");
                }
                throw IfxErrMsg.getSQLException(-79777, this.conn);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeElement() exited");
        }
    }

    private int getIfxType(Object x, boolean isTyped) throws SQLException {
        int ifxType = 49;
        Class<?> classObj = x.getClass();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): getIfxType(Object) entered");
            this.trace.writeTrace(logger, 1, "    getIfxType() isTyped: " + isTyped);
        }
        if (x instanceof Clob) {
            ifxType = 101;
        } else if (x instanceof Blob) {
            ifxType = 102;
        } else if (x instanceof Struct) {
            ifxType = 22;
        } else if (x instanceof Array) {
            ifxType = this.getOverrideIfxType(x);
        } else {
            try {
                ifxType = IfxTypes.FromJavaToIfxType(classObj.getName());
                if (ifxType == 49 && classObj.isArray()) {
                    ifxType = 20;
                }
                if (IfxTypes.isCollection(ifxType)) {
                    int ifxTypeSave = ifxType;
                    ifxType = this.getOverrideIfxType(x);
                    if (ifxType == 49) {
                        ifxType = ifxTypeSave;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    getIfxType(Object, boolean) ifxType: " + ifxType);
        }
        if (ifxType == 49) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    getIfxType(Object, boolean) type is unknown");
            }
            if (x instanceof SQLData) {
                String name = ((SQLData)x).getSQLTypeName();
                if (name == null || name == "") {
                    throw IfxErrMsg.getSQLException(-79770, this.conn);
                }
                IfxUDTInfo udtInfo = this.conn.getUDTInfo((IfxColumnInfo)null, name);
                if (udtInfo == null) {
                    throw IfxErrMsg.getSQLException(-79770, this.conn);
                }
                if (udtInfo.JDBCtype == 2002) {
                    IfxResultSetMetaData rsmd;
                    ifxType = 22;
                    if (!isTyped && (rsmd = udtInfo.structInfo) != null) {
                        this.typeInfoVector = rsmd.getColumnInfoVector();
                    }
                } else {
                    ifxType = 40;
                }
            } else {
                throw IfxErrMsg.getSQLException(-79728, this.conn);
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    IfxType = " + ifxType);
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): getIfxType(Object, boolean) exited");
        }
        return ifxType;
    }

    void writePrimitiveArray(boolean[] arr) throws SQLException {
        int size = arr.length;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(boolean[]) entered");
        }
        if (size == 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    writePrimitiveArray(boolean [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(45, 1, null);
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.writeBoolean(arr[i]);
        }
        this.writeElementOffset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(boolean[]) exited");
        }
    }

    void writePrimitiveArray(int[] arr) throws SQLException {
        int size = arr.length;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(int[]) entered");
        }
        if (size == 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    writePrimitiveArray(int [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(2, 4, null);
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.writeInt(arr[i]);
        }
        this.writeElementOffset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(int[]) exited");
        }
    }

    void writePrimitiveArray(short[] arr) throws SQLException {
        int size = arr.length;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(short[]) entered");
        }
        if (size == 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    writePrimitiveArray(short [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(1, 2, null);
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.writeShort(arr[i]);
        }
        this.writeElementOffset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(short[]) exited");
        }
    }

    void writePrimitiveArray(long[] arr) throws SQLException {
        int size = arr.length;
        int type = 0;
        int len = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(long[]) entered");
        }
        if (!this.conn.getIsBigInt() && !this.conn.getIsBigSerial()) {
            type = 17;
            len = 10;
        } else if (this.conn.getIsBigInt() && !this.conn.getIsBigSerial()) {
            type = 52;
            len = 8;
        } else if (!this.conn.getIsBigInt() && this.conn.getIsBigSerial()) {
            type = 53;
            len = 8;
        }
        if (size == 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    writePrimitiveArray(long [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(type, len, null);
            return;
        }
        for (int i = 0; i < size; ++i) {
            if (type == 17) {
                this.writeLong(arr[i]);
                continue;
            }
            this.writeLongBigint(arr[i], type);
        }
        this.writeElementOffset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(long[]) exited");
        }
    }

    void writePrimitiveArray(float[] arr) throws SQLException {
        int size = arr.length;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(float[]) entered");
        }
        if (size == 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    writePrimitiveArray(float [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(4, 4, null);
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.writeFloat(arr[i]);
        }
        this.writeElementOffset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(float[]) exited");
        }
    }

    void writePrimitiveArray(double[] arr) throws SQLException {
        int size = arr.length;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(double[]) entered");
        }
        if (size == 0) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    writePrimitiveArray(double [] arr) EMPTY COLLECTION");
            }
            this.addTypeAndOffsetInfo(3, 8, null);
            return;
        }
        for (int i = 0; i < size; ++i) {
            this.writeDouble(arr[i]);
        }
        this.writeElementOffset();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writePrimitiveArray(double[]) exited");
        }
    }

    byte[] getSerializedTypeInfo() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): getSerializedTypeInfo() entered");
        }
        ByteArrayOutputStream bTypeStream = new ByteArrayOutputStream();
        if (this.parentTypeInfoVector == null) {
            throw IfxErrMsg.getSQLException(-79716, "getSerializedTypeInfo())", this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "");
            this.trace.writeTrace(logger, 99, "***** begin serialized type info *****");
        }
        this.typeInfoCount = 0;
        this.serializeTypeInfo(bTypeStream, this.parentTypeInfoVector, (short)0, (short)0, false);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "***** end serialized type info *****");
            this.trace.writeTrace(logger, 99, "");
            this.trace.writeTrace(logger, 99, "    bTypeStream.size(): " + bTypeStream.size());
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): getSerializedTypeInfo() exited");
        }
        return bTypeStream.toByteArray();
    }

    private short serializeTypeInfo(ByteArrayOutputStream bTypeStream, Vector<IfxColumnInfo> typeInfo, short seqno, short levelno, boolean isRow) throws SQLException {
        short parentno = seqno;
        int typeCount = typeInfo.size();
        IfxColumnInfo colInfo = typeInfo.get(0);
        seqno = (short)(seqno + 1);
        short fieldno = isRow ? (short)1 : 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 99, "");
            this.trace.writeTrace(logger, 99, "    serializeTypeInfo isRow: " + isRow);
        }
        for (int i = 0; i < typeCount; ++i) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "");
                this.trace.writeTrace(logger, 99, "    serializeTypeInfo(). i = " + i);
            }
            ++this.typeInfoCount;
            colInfo = typeInfo.get(i);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    seqno: " + seqno);
            }
            byte[] b = JavaToIfxType.JavaToIfxSmallInt(seqno);
            bTypeStream.write(b, 0, b.length);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    levelno:  " + levelno);
            }
            b = JavaToIfxType.JavaToIfxSmallInt(levelno);
            bTypeStream.write(b, 0, b.length);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    parentno: " + parentno);
            }
            b = JavaToIfxType.JavaToIfxSmallInt(parentno);
            bTypeStream.write(b, 0, b.length);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    ColName: " + colInfo.ColName);
            }
            this.serializeString(colInfo.ColName, this.identsize, bTypeStream);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    fieldno: " + fieldno);
            }
            b = JavaToIfxType.JavaToIfxSmallInt(fieldno);
            bTypeStream.write(b, 0, b.length);
            short type = (short)colInfo.SQLtype;
            if (colInfo.Nullable == 0) {
                type = (short)(type | 0x100);
            }
            if (colInfo.IsNamedRow) {
                type = (short)(type | 0x1000);
            }
            if (colInfo.IsDistinct) {
                type = (short)(type | 0x800);
            }
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    SQLtype: " + type + "  name: " + IfxTypes.IfxTypeToName(colInfo.SQLtype));
            }
            b = JavaToIfxType.JavaToIfxSmallInt(type);
            bTypeStream.write(b, 0, b.length);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    ColLength: " + colInfo.ColLength);
            }
            b = JavaToIfxType.JavaToIfxSmallInt((short)colInfo.ColLength);
            bTypeStream.write(b, 0, b.length);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    ExtendedId: " + colInfo.ExtendedId);
            }
            b = JavaToIfxType.JavaToIfxInt(colInfo.ExtendedId);
            bTypeStream.write(b, 0, b.length);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    Flags: 0");
            }
            b = JavaToIfxType.JavaToIfxSmallInt((short)0);
            bTypeStream.write(b, 0, b.length);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    ExtendedName: " + colInfo.ExtendedName);
            }
            this.serializeString(colInfo.ExtendedName, this.identsize, bTypeStream);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    ExtendedOwner: " + colInfo.ExtendedOwner);
            }
            this.serializeString(colInfo.ExtendedOwner, this.identsize, bTypeStream);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    Alignment: " + colInfo.Alignment);
            }
            b = JavaToIfxType.JavaToIfxSmallInt(colInfo.Alignment);
            bTypeStream.write(b, 0, b.length);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 99, "    SourceType: " + colInfo.SourceType);
            }
            b = JavaToIfxType.JavaToIfxInt(colInfo.SourceType);
            bTypeStream.write(b, 0, b.length);
            if (colInfo.child != null) {
                seqno = this.serializeTypeInfo(bTypeStream, colInfo.child, seqno, (short)(levelno + 1), (colInfo.SQLtype & 0xFF) == 22);
            }
            if (i + 1 != typeCount) {
                seqno = (short)(seqno + 1);
            }
            if (!isRow) continue;
            fieldno = (short)(fieldno + 1);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): serializeTypeInfo() exited");
        }
        return seqno;
    }

    private void serializeString(String x, short lengthNeeded, ByteArrayOutputStream stream) throws SQLException {
        short strLength = 0;
        strLength = x == null ? (short)0 : (short)x.length();
        byte[] b = JavaToIfxType.JavaToIfxSmallInt(strLength);
        stream.write(b, 0, b.length);
        String s = stringUtil.fixLength(x, lengthNeeded, ' ');
        try {
            b = stringUtil.getBytes(s, this.conn);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        stream.write(b, 0, b.length);
    }

    int getTypeCount() {
        return this.typeInfoCount;
    }

    private Vector<IfxColumnInfo> getTypeInfoVector() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): getTypeInfoVector() called");
            this.trace.writeTrace(logger, 3, "   isTyped: " + this.isTyped);
            this.trace.writeTrace(logger, 3, "   isNull: " + this.isNull);
            if (this.parentTypeInfoVector == null) {
                this.trace.writeTrace(logger, 3, "   parentTypeInfoVector is null");
            } else {
                this.trace.writeTrace(logger, 3, "   parentTypeInfoVector is NOT null");
            }
            if (this.typeInfoVector == null) {
                this.trace.writeTrace(logger, 3, "   typeInfoVector is null");
            } else {
                this.trace.writeTrace(logger, 3, "   typeInfoVector is NOT null");
            }
        }
        Vector<IfxColumnInfo> v = null;
        if (this.parentTypeInfoVector != null) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, " getTypeInfoVector() returns parentVector");
            }
            v = this.parentTypeInfoVector;
        } else if (this.isTyped) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, " getTypeInfoVector() throwing exception");
            }
            throw IfxErrMsg.getSQLException(-79716, "getTypeInfoVector() parentTypeInfo is null", this.conn);
        }
        if (this.typeInfoVector.size() == 0) {
            if (!this.isTyped) {
                if (!this.isNull) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 1, "    getTypeInfoVector() EMPTY COLL");
                    }
                    this.addTypeAndOffsetInfo(49, 0, null);
                    if (this.parentTypeInfoVector != null) {
                        IfxColumnInfo colInfo = this.parentTypeInfoVector.get(0);
                        colInfo.child = this.typeInfoVector;
                    }
                }
            } else {
                throw IfxErrMsg.getSQLException(-79716, "getTypeInfoVector() typeInfoVector is null", this.conn);
            }
        }
        if (v == null) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 1, "  getTypeInfoVector() returning typeInfoVector");
            }
            v = this.typeInfoVector;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, " dump from getTypeInfoVector(): ");
            this.trace.writeTrace(logger, 2, " ****** begin dump (v) type information *****");
            IfxComplex.dumpTypeInfoVector(v, this.trace, 4);
            this.trace.writeTrace(logger, 2, " ****** end dump (v) type information *****");
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): getTypeInfoVector() exited");
        }
        return v;
    }

    private void setTypeInfoVector(Vector<IfxColumnInfo> typeInfo) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): setTypeInfoVector() called");
        }
        if (this.isTyped) {
            return;
        }
        this.parentTypeInfoVector = typeInfo;
        this.typeInfoVector = typeInfo.get((int)0).child;
        if (TraceFlag.isTraceEnabled()) {
            if (this.parentTypeInfoVector == null) {
                this.trace.writeTrace(logger, 3, "   setTypeInfoVector() parentTypeInfoVector is null");
            }
            if (this.typeInfoVector == null) {
                this.trace.writeTrace(logger, 3, "   setTypeInfoVector() typeInfoVector is null");
            }
        }
        this.isTyped = true;
    }

    private void addParentTypeInfoHeader(int ifxType, String extendedName) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): addParentTypeInfoHeader() called");
            this.trace.writeTrace(logger, 2, "addTypeInfoHeader() ifxType: " + ifxType);
            this.trace.writeTrace(logger, 2, "addTypeInfoHeader() name: " + extendedName);
            this.trace.writeTrace(logger, 2, "addTypeInfoHeader() isRow: " + this.isRow);
            this.trace.writeTrace(logger, 2, "addTypeInfoHeader() isNull: " + this.isNull);
            if (this.typeInfoVector == null) {
                this.trace.writeTrace(logger, 2, "addTypeInfoHeader() typeInfoVector is null");
            } else {
                this.trace.writeTrace(logger, 2, " dump from addTypeAndOffsetInfo(): ");
                this.trace.writeTrace(logger, 2, " ****** begin dump typeInfoVector *****");
                IfxComplex.dumpTypeInfoVector(this.typeInfoVector, this.trace, 4);
                this.trace.writeTrace(logger, 2, " ****** end dump typeInfoVector *****");
            }
        }
        if (this.isRow) {
            return;
        }
        IfxColumnInfo colInfo = new IfxColumnInfo();
        colInfo.SQLtype = ifxType;
        colInfo.ExtendedName = extendedName;
        if (!this.isNull) {
            colInfo.child = this.typeInfoVector;
            if (IfxTypes.isCollection(ifxType)) {
                this.typeInfoVector.get((int)0).Nullable = 0;
            }
        }
        Vector<IfxColumnInfo> tmpVector = new Vector<IfxColumnInfo>(1);
        tmpVector.addElement(colInfo);
        this.parentTypeInfoVector = tmpVector;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, " dump from addParentTypeInfoHeader(): ");
            this.trace.writeTrace(logger, 2, " ****** begin dump parentTypeInfoVector *****");
            IfxComplex.dumpTypeInfoVector(this.parentTypeInfoVector, this.trace, 4);
            this.trace.writeTrace(logger, 2, " ****** end dump parentTypeInfoVector *****");
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): addParentTypeInfoHeader() exited");
        }
    }

    private void writeNestedData(IfxComplexOutput nestedOutput) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeNestedData() entered");
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "  writeNestedData() isNull: " + nestedOutput.isNull());
        }
        byte[] b = null;
        try {
            b = this.getNestedHeader(this.bStream.size(), nestedOutput.length(), nestedOutput.isNull);
            this.os.write(b, 0, b.length);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "writeNestedData().headersize " + b.length);
            }
            if (!nestedOutput.isNull) {
                b = nestedOutput.toByteArray();
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "writeNestedData().data size " + b.length);
                }
                this.os.write(b, 0, b.length);
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeNestedData() exited");
        }
    }

    private boolean isUnknownType(IfxColumnInfo colInfo) {
        if (colInfo.SQLtype == 49) {
            return true;
        }
        if (colInfo.child != null) {
            return this.isUnknownType(colInfo.child.get(0));
        }
        return false;
    }

    @Override
    public void writeBigDecimal(BigDecimal bd) throws SQLException {
        BigDecimal tmpBD = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeBigDecimal() entered");
            this.trace.writeTrace(logger, 2, "    writeBigDecimal() x = " + bd);
            this.trace.writeTrace(logger, 2, "    writeBigDecimal() isRow = " + this.isRow);
        }
        if (!this.isRow && bd == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        if (this.isTyped) {
            byte[] b;
            this.addTypeAndOffsetInfo(5, this.currentIfxLength, null);
            int scale = IfxDecimal.precDec(this.currentIfxLength);
            int total = IfxDecimal.precTot(this.currentIfxLength);
            if (scale == 255) {
                scale = total;
            }
            if (bd != null) {
                tmpBD = bd.setScale(scale, 4);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "    writeBigDecimal() tmpBD = " + tmpBD);
                    this.trace.writeTrace(logger, 2, "    writeBigDecimal() currentIfxLength = " + this.currentIfxLength);
                }
                IfxDecimal decObj = new IfxDecimal();
                decObj.setConnection(this.conn);
                decObj.fromDecimal(tmpBD, scale, (short)this.currentIfxLength);
                b = decObj.toIfx();
            } else {
                b = JavaToIfxType.JavaToIfxDecimalNull((short)this.currentIfxLength);
            }
            try {
                this.os.write(b, 2, b.length - 2);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            String decStr = bd.toString();
            this.writeString(decStr);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeBigDecimal() exited");
        }
    }

    @Override
    public void writeBinaryStream(InputStream is) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeBinaryStream(InputStream).", this.conn);
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        IfxObject obj = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeBlob() entered");
        }
        if (!this.isRow && blob == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(41, 72, "blob");
        obj = IfxValue.makeInstanceFromIfxType(this.conn, 102);
        if (!((IfxSmBlob)obj).LOB_ELEMENT_COLL) {
            ((IfxSmBlob)obj).LOB_ELEMENT_COLL = true;
        }
        obj.fromBlob(blob);
        byte[] b = obj.toIfxTuple();
        try {
            this.os.write(b);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeBlob() exited");
        }
    }

    private void writeBoolean(byte bool) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeBoolean(byte) entered");
            this.trace.writeTrace(logger, 2, "    writeBoolean() x = " + bool);
        }
        try {
            this.addTypeAndOffsetInfo(45, 1, null);
            if (bool == -1) {
                this.os.writeByte(1);
                this.os.writeInt(0);
            } else {
                this.os.writeByte(0);
                this.os.writeInt(1);
                this.os.writeByte(bool);
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeBoolean() exited");
        }
    }

    @Override
    public void writeBoolean(boolean bool) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeBoolean(boolean) entered");
            this.trace.writeTrace(logger, 2, "    writeBoolean() x = " + bool);
        }
        byte b = bool ? (byte)1 : 0;
        this.writeBoolean(b);
    }

    @Override
    public void writeByte(byte b) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeByte(byte).", this.conn);
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        IfxObject obj = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeClob() entered");
        }
        if (!this.isRow && clob == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(41, 72, "clob");
        obj = IfxValue.makeInstanceFromIfxType(this.conn, 101);
        if (!((IfxSmBlob)obj).LOB_ELEMENT_COLL) {
            ((IfxSmBlob)obj).LOB_ELEMENT_COLL = true;
        }
        obj.fromClob(clob);
        byte[] b = obj.toIfxTuple();
        try {
            this.os.write(b);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeClob() exited");
        }
    }

    @Override
    public void writeDate(Date d) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeDate() entered");
            this.trace.writeTrace(logger, 2, "    writeDate() x = " + d);
        }
        if (!this.isRow && d == null) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(7, 4, null);
        if (d == null) {
            try {
                this.os.writeInt(Integer.MIN_VALUE);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        } else {
            super.writeDate(d);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeDate() exited");
        }
    }

    public void writeDoubleNull() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeDoubleNull() entered");
        }
        if (!this.isRow) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(3, 8, null);
        try {
            byte[] b = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
            this.os.write(b);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeDoubleNull() exited");
        }
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeDouble() entered");
            this.trace.writeTrace(logger, 2, "    writeDouble() x = " + d);
        }
        if (!this.isRow && IfxFloat.isIfxNull(d)) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(3, 8, null);
        super.writeDouble(d);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeDouble() exited");
        }
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeFloat() entered");
            this.trace.writeTrace(logger, 2, "    writeFloat() x = " + f);
        }
        if (!this.isRow && IfxSmallFloat.isIfxNull(f)) {
            throw IfxErrMsg.getSQLException(-1225, this.conn);
        }
        this.addTypeAndOffsetInfo(4, 4, null);
        try {
            this.os.writeReal(f);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeFloat() exited");
        }
    }

    @Override
    public void writeLong(long l) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeLong() entered");
            this.trace.writeTrace(logger, 2, "    writeLong() x = " + l);
        }
        this.addTypeAndOffsetInfo(17, 10, null);
        try {
            this.os.writeLongInt(l);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeLong() exited");
        }
    }

    @Override
    public void writeShort(short s) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeShort() entered");
            this.trace.writeTrace(logger, 2, "    writeShort() x = " + s);
        }
        this.addTypeAndOffsetInfo(1, 2, null);
        try {
            this.os.writeSmallInt(s);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeShort() exited");
        }
    }

    @Override
    public void writeTime(Time t) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writetime() entered");
            this.trace.writeTrace(logger, 2, "    writeTime() x = " + t);
        }
        IfxDateTime dtObj = new IfxDateTime(t);
        this.addTypeAndOffsetInfo(10, dtObj.getEncodedLength(), null);
        try {
            byte[] b = null;
            b = t == null ? JavaToIfxType.JavaToIfxDecimalNull(dtObj.getEncodedLength()) : dtObj.toIfx();
            this.os.write(b, 2, b.length - 2);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeTime() exited");
        }
    }

    @Override
    public void writeTimestamp(Timestamp ts) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeTimestamp() entered");
            this.trace.writeTrace(logger, 2, "    writeTimestamp() x = " + ts);
        }
        IfxDateTime dtObj = new IfxDateTime(ts);
        this.addTypeAndOffsetInfo(10, dtObj.getEncodedLength(), null);
        try {
            byte[] b = null;
            b = ts == null ? JavaToIfxType.JavaToIfxDecimalNull(dtObj.getEncodedLength()) : dtObj.toIfx();
            this.os.write(b, 2, b.length - 2);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeTimestamp() exited");
        }
    }

    @Override
    public void writeInterval(Interval x) throws SQLException {
        if (x == null || x instanceof IntervalDF) {
            this.writeIntervalDF((IntervalDF)x);
        } else if (x instanceof IntervalYM) {
            this.writeIntervalYM((IntervalYM)x);
        } else {
            throw IfxErrMsg.getSQLException(-79714, this.conn);
        }
    }

    void writeIntervalDF(IntervalDF intrvl) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeIntervalDF() entered");
            this.trace.writeTrace(logger, 2, "    writeIntervalDF() x = " + intrvl);
        }
        short qual = 0;
        if (intrvl != null) {
            qual = intrvl.getQualifier();
        }
        this.addTypeAndOffsetInfo(14, qual, null);
        IfxIntervalDF ifxIntrvl = new IfxIntervalDF(intrvl);
        ifxIntrvl.setConnection(this.conn);
        if (intrvl == null && this.isTyped) {
            ifxIntrvl.setEncodedLength(this.currentIfxLength);
        }
        try {
            byte[] b = ifxIntrvl.toIfxTuple();
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    writeIntervalDF() toIfxTuple() data");
                this.trace.writeTrace(logger, 2, b, 'H');
            }
            this.os.write(b, 0, b.length);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeIntervalDF() exited");
        }
    }

    void writeIntervalYM(IntervalYM intrvl) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeIntervalYM() entered");
            this.trace.writeTrace(logger, 2, "    writeIntervalYM() x = " + intrvl);
        }
        short qual = 0;
        if (intrvl != null) {
            qual = intrvl.getQualifier();
        }
        this.addTypeAndOffsetInfo(14, qual, null);
        IfxIntervalYM ifxIntrvl = new IfxIntervalYM(intrvl);
        ifxIntrvl.setConnection(this.conn);
        if (intrvl == null && this.isTyped) {
            ifxIntrvl.setEncodedLength(this.currentIfxLength);
        }
        try {
            byte[] b = ifxIntrvl.toIfxTuple();
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "    writeIntervalYM() toIfxTuple() data");
                this.trace.writeTrace(logger, 2, b, 'H');
            }
            this.os.write(b, 0, b.length);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeIntervalYM() exited");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean getNextType(int type, int length, String name, int childIndex) throws SQLException {
        boolean ret = true;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput.getNextType(type: " + type + " len " + length + " name " + name + ") entered");
            this.trace.writeTrace(logger, 2, "    getNextType isRow: " + this.isRow);
            this.trace.writeTrace(logger, 2, "    getNextType typeIndex: " + this.typeIndex);
            this.trace.writeTrace(logger, 2, "    getNextType atNextType: " + this.atNextType);
        }
        if (!this.isRow && this.typeIndex >= 0 && childIndex == 0) {
            return ret;
        }
        if (this.atNextType && childIndex == 0) {
            this.atNextType = false;
            return ret;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    getNextType type: " + type);
            this.trace.writeTrace(logger, 2, "    getNextType name: " + name);
            this.trace.writeTrace(logger, 2, "    getNextType typeIndex: " + this.typeIndex);
            this.trace.writeTrace(logger, 2, "    getNextType typeInfoVector.size(): " + this.typeInfoVector.size());
        }
        ++this.typeIndex;
        this.typeChildIndex = childIndex;
        if (this.typeIndex < this.typeInfoVector.size()) {
            IfxColumnInfo colInfo = this.typeInfoVector.get(this.typeIndex);
            if (colInfo.SQLtype == 22 && colInfo.child != null && colInfo.child.size() >= childIndex) {
                colInfo = colInfo.child.get(this.typeChildIndex++);
                ret = false;
            }
            this.currentIfxType = colInfo.SQLtype;
            this.currentExtendedId = colInfo.ExtendedId;
            this.currentIfxLength = colInfo.ColLength;
        } else {
            if (this.typeIndex != this.typeInfoVector.size()) throw IfxErrMsg.getSQLException(-79772, this.conn);
            IfxColumnInfo colInfo = this.typeInfoVector.get(this.typeIndex - 1);
            if (colInfo.SQLtype != 22 || colInfo.child == null || colInfo.child.size() < childIndex) throw IfxErrMsg.getSQLException(-79772, this.conn);
            colInfo = colInfo.child.get(this.typeChildIndex++);
            --this.typeIndex;
            ret = false;
            this.currentIfxType = colInfo.SQLtype;
            this.currentExtendedId = colInfo.ExtendedId;
            this.currentIfxLength = colInfo.ColLength;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    getNextType new type: " + this.currentIfxType);
            this.trace.writeTrace(logger, 2, "    getNextType new length: " + this.currentIfxLength);
            this.trace.writeTrace(logger, 2, "    getNextType new extendedId: " + this.currentExtendedId);
        }
        if (type != 49) {
            this.verifyType(type, length, name);
        }
        if (!TraceFlag.isTraceEnabled()) return ret;
        this.trace.writeTrace(logger, 2, "    getNextType new index: " + this.typeIndex);
        this.trace.writeTrace(logger, 1, "IfxComplexOutput.getNextType(void) exited");
        return ret;
    }

    private void verifyType(int type, int length, String name) throws SQLException {
        String locale = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "   verifyType() currentIfxType: " + this.currentIfxType);
            this.trace.writeTrace(logger, 3, "   verifyType() type: " + type);
        }
        if (this.conn != null) {
            locale = this.conn.getclLocale();
        }
        if (this.currentIfxType != type) {
            if (IfxTypes.isCollection(this.currentIfxType) && IfxTypes.isCollection(type)) {
                return;
            }
            if (type == 40 && this.currentIfxType == 41 || type == 41 && this.currentIfxType == 40) {
                return;
            }
            if ((this.currentIfxType == 101 || this.currentIfxType == 102) && type == 41) {
                return;
            }
            if (type == 5 && this.currentIfxType == 8) {
                return;
            }
            if (!(type != 22 && type != 20 && type != 19 || this.currentIfxType == 49 && this.currentIfxType == 22 && this.currentIfxType == 20 && this.currentIfxType == 19)) {
                return;
            }
            if (type == 17 && this.currentIfxType == 52) {
                return;
            }
            IfxComplex.badTypeException(this.currentIfxType, (short)type, this.trace, locale);
        }
        if (name != null && name != "") {
            int xid = 0;
            if (name.compareToIgnoreCase("blob") == 0) {
                xid = 10;
            } else if (name.compareToIgnoreCase("clob") == 0) {
                xid = 11;
            } else {
                IfxUDTInfo udtInfo = this.conn.getUDTInfo((IfxColumnInfo)null, name);
                if (udtInfo == null) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 2, "    verifyType() bad name: " + name);
                    }
                    String msg = IfxErrMsg.getMessage(-79796, name, this.conn);
                    throw new SQLException(msg);
                }
                xid = udtInfo.xid;
            }
            if (this.currentExtendedId != xid) {
                String source = Integer.toString(xid);
                String target = Integer.toString(this.currentExtendedId);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "    verifyType() source xid: " + source);
                    this.trace.writeTrace(logger, 2, "    verifyType() target xid: " + target);
                }
                String msg = IfxErrMsg.getMessage(-79794, source, target, this.conn);
                throw new SQLException(msg);
            }
        }
    }

    protected String getExtendedName() throws SQLException {
        String s = null;
        if (this.extendedName == "" && !this.isNull) {
            s = this.parentTypeInfoVector != null ? IfxComplex.getExtendedName(this.parentTypeInfoVector, this.trace, this.conn.getclLocale()) : IfxComplex.getExtendedName(this.typeInfoVector, this.trace, this.conn.getclLocale());
        } else {
            s = this.conn != null ? IfxComplex.getExtendedName(this.typeInfoVector, this.trace, this.conn.getclLocale()) : IfxComplex.getExtendedName(this.typeInfoVector, this.trace, null);
            s = this.extendedName;
        }
        return s;
    }

    private Vector<IfxColumnInfo> getTypeInfoVector(String rowName) throws SQLException {
        Vector<IfxColumnInfo> v;
        block11: {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 1, "IfxComplexOutput.getTypeInfoVector(string) entered");
                this.trace.writeTrace(logger, 3, "   getTypeInfoVector(string) name: " + rowName);
            }
            if (rowName == null) {
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
            v = null;
            try {
                String delim = T_SPACE + T_COMMA + T_LPAREN + T_RPAREN;
                rowName = rowName.trim();
                StringTokenizer st = new StringTokenizer(rowName, delim, true);
                v = this.constructTypeInfo(st, 1, null, 0);
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, " ****** begin dump constructed type information *****");
                    IfxComplex.dumpTypeInfoVector(v, this.trace, 4);
                    this.trace.writeTrace(logger, 2, " ****** end dump constructed type information *****");
                }
            }
            catch (Exception e) {
                IfxUDTInfo udtInfo;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 1, "   getTypeInfoVector(string) constructTypeInfo() threw an exception");
                }
                if ((udtInfo = this.conn.getUDTInfo((IfxColumnInfo)null, rowName)) == null) {
                    throw IfxErrMsg.getSQLException(-79770, this.conn);
                }
                IfxResultSetMetaData rsmd = udtInfo.structInfo;
                if (rsmd == null) break block11;
                v = rsmd.getColumnInfoVector();
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            if (v == null) {
                this.trace.writeTrace(logger, 1, "   getTypeInfoVector(string) v is null");
            } else if (v.get((int)0).child == null) {
                this.trace.writeTrace(logger, 1, "   getTypeInfoVector(string) child is null");
            }
        }
        this.extendedName = rowName;
        return v;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Vector<IfxColumnInfo> constructTypeInfo(StringTokenizer st, int stateWanted, Boolean isRow, int pretty) throws SQLException {
        Vector<IfxColumnInfo> typeInfoVector = new Vector<IfxColumnInfo>();
        int ifxType = -1;
        IfxColumnInfo colInfo = null;
        boolean finished = false;
        String indent = "";
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput.constructTypeInfo() entered");
            indent = stringUtil.fixLength("", pretty, ' ');
        }
        block10: while (!finished) {
            block61: {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "");
                    this.trace.writeTrace(logger, 3, "");
                    this.trace.writeTrace(logger, 3, indent + "advanceToken: " + this.advanceToken);
                    this.trace.writeTrace(logger, 3, indent + "token count: " + st.countTokens());
                }
                if (this.advanceToken) {
                    if (st.hasMoreTokens()) {
                        this.currentToken = this.getNextToken(st);
                        break block61;
                    } else {
                        if (this.currentToken.equals(T_RPAREN)) break;
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, "  constructTypeInfo() missing ')'");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                }
                this.advanceToken = true;
            }
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, indent + "currentToken: " + this.currentToken);
                this.trace.writeTrace(logger, 3, indent + "previousState: " + this.getState(this.previousState));
                this.trace.writeTrace(logger, 3, indent + "stateWanted: " + this.getState(stateWanted));
            }
            switch (stateWanted) {
                case 1: {
                    ifxType = IfxTypes.FromIfxNameToIfxType(this.currentToken);
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for CT_TYPE");
                        this.trace.writeTrace(logger, 3, indent + "CT_TYPE ifxType: " + ifxType);
                    }
                    if (!IfxTypes.isComplexType(ifxType)) {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, indent + "constructTypeInfo() not a complex type");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    if (colInfo == null) {
                        colInfo = new IfxColumnInfo();
                    }
                    if (ifxType == 102) {
                        ifxType = 40;
                        colInfo.ExtendedName = "blob";
                        colInfo.ExtendedId = 10;
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, indent + "CT_TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_BLOB");
                        }
                    } else if (ifxType == 101) {
                        ifxType = 40;
                        colInfo.ExtendedName = "clob";
                        colInfo.ExtendedId = 11;
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, indent + "CT_TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_CLOB");
                        }
                    }
                    colInfo.SQLtype = ifxType;
                    Boolean elementIsRow = null;
                    elementIsRow = ifxType == 22 ? new Boolean(true) : new Boolean(false);
                    if (isRow == null) {
                        isRow = elementIsRow;
                    }
                    typeInfoVector.addElement(colInfo);
                    colInfo.Fieldno = 1;
                    this.previousState = stateWanted;
                    stateWanted = 5;
                    colInfo.child = this.constructTypeInfo(st, stateWanted, elementIsRow, pretty + 4);
                    if (this.previousState != 9) {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, "  constructTypeInfo() previous state != CTEND");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, "  constructTypeInfo() CT_TYPE setting stateWanted to NOTNULL");
                    }
                    stateWanted = 8;
                    continue block10;
                }
                case 7: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for FIELDNAME");
                    }
                    if (colInfo == null) {
                        colInfo = new IfxColumnInfo();
                    }
                    colInfo.ColName = this.currentToken;
                    this.previousState = stateWanted;
                    stateWanted = 2;
                    continue block10;
                }
                case 2: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for TYPE");
                    }
                    if (colInfo == null) {
                        colInfo = new IfxColumnInfo();
                    }
                    stateWanted = this.parseFieldType(this.currentToken, colInfo, indent);
                    continue block10;
                }
                case 4: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for NEXTELEMENT");
                    }
                    if (this.currentToken.equals(T_COMMA)) {
                        if (colInfo.Fieldno != 1) {
                            typeInfoVector.addElement(colInfo);
                            colInfo.Fieldno = 1;
                        }
                        colInfo = null;
                        this.previousState = stateWanted;
                        stateWanted = 7;
                        continue block10;
                    }
                    if (this.currentToken.equals(")")) {
                        if (colInfo.Fieldno != 1) {
                            typeInfoVector.addElement(colInfo);
                            colInfo.Fieldno = 1;
                        }
                        colInfo = null;
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "DONE ... DONE");
                    }
                    this.previousState = 9;
                    finished = true;
                    continue block10;
                }
                case 5: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for LPAREN");
                    }
                    if (this.previousState == 1) {
                        this.previousState = stateWanted;
                        if (isRow.booleanValue()) {
                            stateWanted = 7;
                            continue block10;
                        }
                        stateWanted = 2;
                        continue block10;
                    }
                    this.previousState = stateWanted;
                    stateWanted = 3;
                    continue block10;
                }
                case 3: {
                    int ifxLength;
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for LENGTH");
                    }
                    colInfo.ColLength = ifxLength = this.getLength(st, colInfo.SQLtype);
                    stateWanted = 8;
                    continue block10;
                }
                case 6: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for RPAREN");
                    }
                    if (!this.currentToken.equals(")")) {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, "  constructTypeInfo() missing a ')'");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    if (!isRow.booleanValue()) {
                        if (colInfo.Fieldno != 1) {
                            typeInfoVector.addElement(colInfo);
                            colInfo.Fieldno = 1;
                        }
                        colInfo = null;
                        this.previousState = 9;
                        finished = true;
                        continue block10;
                    }
                    this.previousState = stateWanted;
                    stateWanted = 8;
                    continue block10;
                }
                case 8: {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, indent + "In case for NOTNULL");
                    }
                    if (!this.currentToken.equalsIgnoreCase("not")) {
                        if (!isRow.booleanValue()) {
                            if (TraceFlag.isTraceEnabled()) {
                                this.trace.writeTrace(logger, 3, "  constructTypeInfo() missing not null");
                            }
                            throw IfxErrMsg.getSQLException(-79790, this.conn);
                        }
                        this.advanceToken = false;
                        stateWanted = 4;
                        continue block10;
                    }
                    this.currentToken = this.getNextToken(st);
                    if (this.currentToken.equalsIgnoreCase("null")) {
                        colInfo.Nullable = 0;
                        if (this.previousState == 9 && !st.hasMoreTokens()) {
                            finished = true;
                            continue block10;
                        }
                    } else {
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, "  constructTypeInfo() missing 'null'");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    this.previousState = stateWanted;
                    if (isRow.booleanValue()) {
                        stateWanted = 4;
                        continue block10;
                    }
                    stateWanted = 6;
                    continue block10;
                }
            }
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "  constructTypeInfo() unknown state");
            }
            throw IfxErrMsg.getSQLException(-79790, this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput.constructTypeInfo() exited");
        }
        return typeInfoVector;
    }

    private int parseFieldType(String s, IfxColumnInfo colInfo, String indent) throws SQLException {
        int ifxType = 49;
        int stateWanted = 0;
        int index = 0;
        String ownerName = null;
        String typeName = null;
        if (s.startsWith("'")) {
            index = s.indexOf(39, 1);
            if (index > 0) {
                ownerName = s.substring(1, index);
                ++index;
            } else {
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
        }
        if ((index = s.indexOf(46, index)) <= 0 && ownerName != null) {
            throw IfxErrMsg.getSQLException(-79790, this.conn);
        }
        if (ownerName != null) {
            colInfo.ExtendedOwner = ownerName;
            ++index;
        } else if (index > 0) {
            colInfo.ExtendedOwner = ownerName = s.substring(0, index);
            ++index;
        } else {
            index = 0;
        }
        typeName = s.substring(index, s.length());
        ifxType = IfxTypes.FromIfxNameToIfxType(typeName);
        if (IfxTypes.isComplexType(ifxType)) {
            stateWanted = 1;
            this.advanceToken = false;
        } else {
            if (ifxType == 1111) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "Type = OTHER");
                }
                this.getOther(colInfo, typeName, ownerName);
                ifxType = colInfo.SQLtype;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "Other name = " + colInfo.ColName);
                    this.trace.writeTrace(logger, 3, "Other type = " + colInfo.SQLtype);
                }
            }
            if (ifxType == 102) {
                ifxType = 40;
                colInfo.ExtendedName = "blob";
                colInfo.ExtendedId = 10;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, indent + "TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_BLOB");
                }
            } else if (ifxType == 101) {
                ifxType = 40;
                colInfo.ExtendedName = "clob";
                colInfo.ExtendedId = 11;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, indent + "TYPE ifxType changed to IFX_TYPE_UDTVAR, IFX_XID_CLOB");
                }
            }
            colInfo.SQLtype = ifxType;
            this.previousState = stateWanted;
            stateWanted = 3;
        }
        return stateWanted;
    }

    private void getOther(IfxColumnInfo colInfo, String name, String owner) throws SQLException {
        IfxUDTInfo udtInfo = null;
        udtInfo = owner != null ? this.conn.getUDTInfo(name, owner) : this.conn.getUDTInfo((IfxColumnInfo)null, name);
        if (udtInfo == null) {
            throw IfxErrMsg.getSQLException(-79770, this.conn);
        }
        colInfo.ExtendedName = udtInfo.name;
        if (udtInfo.owner != null && owner != null) {
            colInfo.ExtendedOwner = udtInfo.owner;
        }
        colInfo.ExtendedId = udtInfo.xid;
        colInfo.SQLtype = udtInfo.SQLtype;
        if (udtInfo.JDBCtype == 2002) {
            IfxColumnInfo newColInfo = null;
            IfxResultSetMetaData rsmd = udtInfo.structInfo;
            newColInfo = rsmd.getColumnInfoVector().get(0);
            String svColName = colInfo.ColName;
            newColInfo.copy(colInfo);
            colInfo.ColName = svColName;
        } else if (udtInfo.JDBCtype == 2001) {
            colInfo.SourceType = udtInfo.source;
        }
    }

    private String getState(int state) {
        switch (state) {
            case 1: {
                return "CT_TYPE";
            }
            case 2: {
                return "TYPE";
            }
            case 3: {
                return "LENGTH";
            }
            case 4: {
                return "NEXTELEMENT";
            }
            case 5: {
                return "LPAREN";
            }
            case 6: {
                return "RPAREN";
            }
            case 7: {
                return "FIELDNAME";
            }
            case 8: {
                return "NOTNULL";
            }
        }
        return "";
    }

    private int getLength(StringTokenizer st, int ifxType) throws SQLException {
        int ifxLength = -1;
        if (ifxType == 0 || ifxType == 15 || ifxType == 13 || ifxType == 16) {
            if (!this.currentToken.equals(T_LPAREN)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "  getLength() char length");
                }
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
            this.currentToken = this.getNextToken(st);
            ifxLength = Integer.valueOf(this.currentToken);
            this.currentToken = this.getNextToken(st);
            if (!this.currentToken.equals(")")) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "  getLength() missing ')'");
                }
                throw IfxErrMsg.getSQLException(-79790, this.conn);
            }
        } else if (ifxType == 8 || ifxType == 5) {
            int prec = 16;
            int scale = this.conn.isANSI() ? 0 : 255;
            if (!this.currentToken.equals(T_LPAREN)) {
                if (ifxType == 8) {
                    scale = 2;
                }
                ifxLength = ((byte)prec << 8) + scale;
                this.advanceToken = false;
            } else {
                this.currentToken = this.getNextToken(st);
                prec = Integer.valueOf(this.currentToken);
                this.currentToken = this.getNextToken(st);
                if (this.currentToken.equals(T_COMMA)) {
                    this.currentToken = this.getNextToken(st);
                    scale = Integer.valueOf(this.currentToken);
                    this.currentToken = this.getNextToken(st);
                }
                if (!this.currentToken.equals(T_RPAREN)) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, "  getLength() missing ')'");
                    }
                    throw IfxErrMsg.getSQLException(-79790, this.conn);
                }
                ifxLength = ((byte)prec << 8) + scale;
            }
        } else if (ifxType == 10 || ifxType == 14) {
            ifxLength = ifxType == 10 ? this.getQualifier(st, false) : this.getQualifier(st, true);
        } else {
            this.advanceToken = false;
            switch (ifxType) {
                case 1: {
                    ifxLength = 2;
                    break;
                }
                case 2: 
                case 6: 
                case 7: {
                    ifxLength = 4;
                    break;
                }
                case 3: {
                    ifxLength = 8;
                    break;
                }
                case 4: {
                    ifxLength = 4;
                    break;
                }
                case 17: 
                case 18: {
                    ifxLength = 10;
                    break;
                }
                case 52: 
                case 53: {
                    ifxLength = 8;
                    break;
                }
                case 45: {
                    ifxLength = 1;
                    break;
                }
                case 43: {
                    if (this.conn.isLvcGtThan2kSupported() && this.currentToken.equals(T_LPAREN)) {
                        this.advanceToken = true;
                        this.currentToken = this.getNextToken(st);
                        ifxLength = Integer.valueOf(this.currentToken);
                        this.currentToken = this.getNextToken(st);
                        if (this.currentToken.equals(T_RPAREN)) break;
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, "  getLength() missing ')'");
                        }
                        throw IfxErrMsg.getSQLException(-79790, this.conn);
                    }
                    ifxLength = 2048;
                    break;
                }
                default: {
                    ifxLength = 0;
                }
            }
        }
        if (ifxLength == -1) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "  getLength() ifxLength == -1");
            }
            throw IfxErrMsg.getSQLException(-79790, this.conn);
        }
        return ifxLength;
    }

    private String getNextToken(StringTokenizer st) throws SQLException {
        String token = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.equals(T_SPACE)) continue;
            return token;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "  getNextToken() no more tokens");
        }
        throw IfxErrMsg.getSQLException(-79790, this.conn);
    }

    private int getQualifier(StringTokenizer st, boolean isInterval) throws SQLException {
        byte startCode = 0;
        byte endCode = 0;
        byte length = 0;
        int qualifier = 0;
        startCode = this.fieldNametoDatetimeMacro(st);
        this.currentToken = this.getNextToken(st);
        if (this.currentToken.equals(T_LPAREN)) {
            if (isInterval) {
                this.currentToken = this.getNextToken(st);
                length = (byte)Integer.valueOf(this.currentToken).intValue();
                this.currentToken = this.getNextToken(st);
                if (!this.currentToken.equals(T_RPAREN)) {
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, "  getQual() missing ')'");
                    }
                    throw IfxErrMsg.getSQLException(-79717, this.conn);
                }
                this.currentToken = this.getNextToken(st);
            } else {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "  getQual() '(' and it a datetime");
                }
                throw IfxErrMsg.getSQLException(-79707, this.conn);
            }
        }
        if (this.currentToken.equalsIgnoreCase("to")) {
            this.currentToken = this.getNextToken(st);
            endCode = this.fieldNametoDatetimeMacro(st);
            qualifier = isInterval ? (int)Interval.getQualifier(length, startCode, endCode) : (int)IfxDateTime.getQualifier(startCode, endCode);
        }
        return qualifier;
    }

    private byte fieldNametoDatetimeMacro(StringTokenizer st) throws SQLException {
        int code = -1;
        this.currentToken.trim();
        if (this.currentToken.equalsIgnoreCase("year")) {
            code = 0;
        } else if (this.currentToken.equalsIgnoreCase("month")) {
            code = 2;
        } else if (this.currentToken.equalsIgnoreCase("day")) {
            code = 4;
        } else if (this.currentToken.equalsIgnoreCase("hour")) {
            code = 6;
        } else if (this.currentToken.equalsIgnoreCase("minute")) {
            code = 8;
        } else if (this.currentToken.equalsIgnoreCase("second")) {
            code = 10;
        } else if (this.currentToken.equalsIgnoreCase("fraction")) {
            this.currentToken = this.getNextToken(st);
            if (this.currentToken.equals(T_LPAREN)) {
                this.currentToken = this.getNextToken(st);
                int frac = Integer.valueOf(this.currentToken);
                this.currentToken = this.getNextToken(st);
                if (this.currentToken.equals(T_RPAREN)) {
                    if (frac == 1) {
                        code = 11;
                    } else if (frac == 2) {
                        code = 12;
                    } else if (frac == 3) {
                        code = 13;
                    } else if (frac == 4) {
                        code = 14;
                    } else if (frac == 5) {
                        code = 15;
                    }
                }
            } else {
                this.advanceToken = false;
                code = 12;
            }
        }
        if (code == -1) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 3, "  fieldNametoDatetimeMacro() cod == -1");
            }
            throw IfxErrMsg.getSQLException(-79707, this.conn);
        }
        return (byte)code;
    }

    private byte[] getNestedHeader(int dataStart, int dataLength, boolean wasNull) throws SQLException {
        byte[] header;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): getNestedHeader() entered");
        }
        int offset = 0;
        int headerSize = 0;
        if (wasNull) {
            headerSize = 3;
            header = new byte[headerSize];
            for (int i = 0; i < headerSize; ++i) {
                header[i] = 0;
            }
            byte[] bShort = JavaToIfxType.JavaToIfxSmallInt((short)1);
            System.arraycopy(bShort, 0, header, 0, 2);
            header[2] = 1;
        } else {
            offset = IfxComplexOutput.getUDToffset(dataStart, this.trace);
            headerSize = offset + 8;
            header = new byte[headerSize];
            for (int i = 0; i < headerSize; ++i) {
                header[i] = 0;
            }
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "getNestedHeader() calculated offset: " + offset);
                this.trace.writeTrace(logger, 2, "getNestedHeader() header size: " + headerSize);
            }
            short len = (short)(dataLength + offset + 8 - 2);
            byte[] bShort = JavaToIfxType.JavaToIfxSmallInt(len);
            System.arraycopy(bShort, 0, header, 0, 2);
            int flags = 1;
            byte[] bInt = JavaToIfxType.JavaToIfxInt(flags);
            System.arraycopy(bInt, 0, header, offset, 4);
            offset += 4;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): getNestedHeader() exited");
        }
        return header;
    }

    public static int getUDToffset(int dataStart, Trace trace) {
        if (TraceFlag.isTraceEnabled()) {
            trace.writeTrace(logger, 1, "IfxComplexOutput(): getUDToffset() called");
            trace.writeTrace(logger, 2, "   getUDToffset() dataStart: " + dataStart);
        }
        int offset = (dataStart + 3) % 8 == 0 ? 3 : 11 - (dataStart + 3) % 8;
        return offset;
    }

    private void writeElementOffset() throws SQLException {
        byte[] b;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeElementOffset() entered");
            if (this.elementOffsetVector == null) {
                this.trace.writeTrace(logger, 2, "  writeElementOffset() elementOffsetVector is null");
            } else {
                this.trace.writeTrace(logger, 2, "  writeElementOffset() elementOffsetVector.size(): " + this.elementOffsetVector.size());
            }
        }
        if ((b = this.getElementOffset(this.elementOffsetVector)) != null) {
            try {
                this.os.write(b, 0, b.length);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            }
        }
    }

    byte[] getElementOffset(Vector<Integer> vectorOffset) throws SQLException {
        int count = this.elementOffsetVector.size();
        byte[] barray = new byte[4 * (count + 1)];
        int barrayOffset = 0;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): getElementOffset() entered");
            this.trace.writeTrace(logger, 2, "    getElementOffset(): count: " + count);
        }
        if (count < 1) {
            return null;
        }
        byte[] bInt = JavaToIfxType.JavaToIfxInt(-1);
        System.arraycopy(bInt, 0, barray, 0, 4);
        barrayOffset += 4;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "  size before loop: " + count);
        }
        for (int i = count - 1; i >= 0; --i) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "  i in loop: " + i);
            }
            Integer intObject = vectorOffset.elementAt(i);
            bInt = JavaToIfxType.JavaToIfxInt(intObject);
            System.arraycopy(bInt, 0, barray, barrayOffset, 4);
            barrayOffset += 4;
        }
        this.elementOffsetVector.clear();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): getElementOffset() exited");
        }
        return barray;
    }

    private int getOverrideIfxType(Object obj) throws SQLException {
        int ifxType = 49;
        Class<?> classFound = null;
        Map<String, Class<?>> map = this.conn.getTypeMap();
        if (map == null) {
            return ifxType;
        }
        classFound = map.get("set");
        if (classFound != null && classFound == obj.getClass()) {
            return 19;
        }
        classFound = map.get("list");
        if (classFound != null && classFound == obj.getClass()) {
            return 21;
        }
        classFound = map.get("multiset");
        if (classFound != null && classFound == obj.getClass()) {
            return 20;
        }
        if (obj instanceof List) {
            return 21;
        }
        if (obj instanceof Collection || obj instanceof Array) {
            return 20;
        }
        return ifxType;
    }

    boolean getIsTyped() {
        return this.isTyped;
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxComplexOutput:writeURL()not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeURL()", this.conn);
    }

    public void writeLongBigint(long l, int type) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeLongBigint() entered");
            this.trace.writeTrace(logger, 2, "    writeLongBigint() x = " + l);
        }
        this.addTypeAndOffsetInfo(type, 8, null);
        try {
            this.os.writeLongBigint(l);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxComplexOutput(): writeLong() exited");
        }
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxComplexOutput:writeNClob(NClob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeNClob(NClob)", this.conn);
    }

    @Override
    public void writeNString(String x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxComplexOutput:writeNString(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeNString(String)", this.conn);
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxComplexOutput:writeRowId(RowId)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeRowId(RowId)", this.conn);
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxComplexOutput:writeSQLXML(SQLXML)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxComplexOutput.writeSQLXML(SQLXML)", this.conn);
    }
}

