/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxSavepoint;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxResultSet;
import com.informix.util.IfxErrMsg;
import java.lang.ref.WeakReference;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class IfxSavepoint
implements IfmxSavepoint {
    int savepointId_ = 0;
    String savepointName_ = null;
    IfxConnection connection_;
    private ArrayList<WeakReference<ResultSet>> resultSetList = null;

    IfxSavepoint(IfxConnection conn, String savepointName) {
        this.connection_ = conn;
        this.savepointName_ = savepointName;
    }

    IfxSavepoint(IfxConnection conn, int savepointId) {
        this.connection_ = conn;
        this.savepointId_ = savepointId;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.savepointId_ != 0) {
            return this.savepointId_;
        }
        throw IfxErrMsg.getSQLException(-79894, this.connection_);
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.savepointName_ != null) {
            return this.savepointName_;
        }
        throw IfxErrMsg.getSQLException(-79895, this.connection_);
    }

    protected void addResultSet(ResultSet rs) {
        if (this.resultSetList == null) {
            this.resultSetList = new ArrayList(10);
        }
        WeakReference<ResultSet> weakRs = new WeakReference<ResultSet>(rs);
        this.resultSetList.add(weakRs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResultSet() throws SQLException {
        if (this.resultSetList != null) {
            ArrayList<WeakReference<ResultSet>> arrayList = this.resultSetList;
            synchronized (arrayList) {
                WeakReference<ResultSet> weakRs2 = null;
                ResultSet rs = null;
                for (WeakReference<ResultSet> weakRs2 : this.resultSetList) {
                    rs = (ResultSet)weakRs2.get();
                    if (rs == null) continue;
                    try {
                        ((IfxResultSet)rs).isClosed = true;
                        rs.close();
                    }
                    catch (SQLException e) {
                        if (e.getErrorCode() != -259) continue;
                        ((IfxResultSet)rs).stmt.cursorOpen = true;
                    }
                }
            }
        }
    }
}

