/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbcx;

import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbcx.IfxConnectionPoolManager;
import com.informix.jdbcx.IfxPooledConnection;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.sql.Connection;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;

public class IfxConnectionEventListener
implements ConnectionEventListener {
    private static final Object logger = Trace.getLoggerForClass(IfxConnectionEventListener.class);
    private IfxConnectionPoolManager IfxCPM = null;
    private Trace trace = null;

    public void IfxConnectionEventListener() {
        this.IfxCPM = null;
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        IfxPooledConnection pc = (IfxPooledConnection)event.getSource();
        if (TraceFlag.isTraceEnabled()) {
            try {
                Connection conn = pc.getConnection();
                this.trace = ((IfxSqliConnect)conn).getTrace();
                this.trace.writeTrace(logger, 1, "IfxConnectionEventListener:connectionClosed(): called.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.IfxCPM != null) {
            this.IfxCPM.recycleConnection(pc, 0);
        }
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "ConnectionEventListener:connectionClosed() exited.");
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        IfxPooledConnection pc = (IfxPooledConnection)event.getSource();
        if (TraceFlag.isTraceEnabled()) {
            try {
                Connection conn = pc.getConnection();
                this.trace = ((IfxSqliConnect)conn).getTrace();
                this.trace.writeTrace(logger, 1, "IfxConnectionEventListener:connectionErrorOccurred(): called.");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.IfxCPM != null) {
            this.IfxCPM.recycleConnection(pc, 1);
        }
        if (TraceFlag.isTraceEnabled() && this.trace != null) {
            this.trace.writeTrace(logger, 1, "ConnectionEventListener:connectionErrorOccurred() exited.");
        }
    }

    void setParent(IfxConnectionPoolManager cpm) {
        this.IfxCPM = cpm;
    }
}

