/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxBblob;
import com.informix.jdbc.IfxCblob;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInt8;
import com.informix.jdbc.IfxInteger;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxLvarchar;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxProtocol;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.jdbc.IfxUDT;
import com.informix.jdbc.IfxUDTInput;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;

public class IfxSmartBlob {
    private static final Object logger = Trace.getLoggerForClass(IfxSmartBlob.class);
    public static final int LO_APPEND = 1;
    public static final int LO_WRONLY = 2;
    public static final int LO_RDONLY = 4;
    public static final int LO_RDWR = 8;
    public static final int LO_DIRTY_READ = 16;
    public static final int LO_RANDOM = 32;
    public static final int LO_SEQUENTIAL = 64;
    public static final int LO_FORWARD = 128;
    public static final int LO_REVERSE = 256;
    public static final int LO_BUFFER = 512;
    public static final int LO_NOBUFFER = 1024;
    public static final int LO_NODIRTY_READ = 2048;
    public static final int LO_LOCKALL = 4096;
    public static final int LO_LOCKRANGE = 8192;
    public static final int LO_SEEK_SET = 0;
    public static final int LO_SEEK_CUR = 1;
    public static final int LO_SEEK_END = 2;
    public static final int LO_CLIENT_FILE = 0x20000000;
    public static final int LO_SERVER_FILE = 0x10000000;
    public static final int LO_SHARED_MODE = 1;
    public static final int LO_EXCLUSIVE_MODE = 2;
    public static final int LO_MAX_END = -1;
    public static final int LO_CURRENT_END = -2;
    private static final String IFX_LO_COL_INFO = "function informix.ifx_lo_col_sbinfo(lvarchar,ifx_lo_spec)";
    private static final String IFX_LO_CREATE = "function informix.ifx_lo_create( ifx_lo_spec,integer,blob)";
    private static final String IFX_LO_RELEASE = "function informix.ifx_lo_release(blob)";
    private static final String IFX_LO_OPEN = "function informix.ifx_lo_open(blob ,integer)";
    private static final String IFX_LO_CLOSE = "function informix.ifx_lo_close(integer)";
    private static final String IFX_LO_SEEK = "function informix.ifx_lo_seek(integer,int8,integer,int8)";
    private static final String IFX_LO_LOCK = "function informix.ifx_lo_lock(integer,integer,int8,int8,integer)";
    private static final String IFX_LO_UNLOCK = "function informix.ifx_lo_unlock( integer,integer,int8,int8)";
    private static final String IFX_LO_TELL = "function informix.ifx_lo_tell(int, int8)";
    private static final String IFX_LO_TRUNCATE = "function informix.ifx_lo_truncate(integer,int8)";
    private static final String IFX_LO_COPY_TO_LO = "function informix.ifx_lo_from_file(int,lvarchar,int,int,int)";
    private static final String IFX_LO_COPY_TO_FILE = "function informix.ifx_lo_to_file(blob,lvarchar,int, int)";
    private static final String IFX_LO_FILENAME = "function informix.ifx_lo_filename(blob,lvarchar)";
    private static final String IFX_LO_ALTER = "function informix.ifx_lo_alter(blob,ifx_lo_spec)";
    private static final String IFX_LO_STAT = "function informix.ifx_lo_stat(int, ifx_lo_stat)";
    private static final String LO_CREATE_SPEC_NAME = "ifx_lo_spec";
    private static final String LO_COL_NAME = "lvarchar";
    private static final String LO_STAT_NAME = "ifx_lo_stat";
    private static final String LO_NAME = "blob";
    private static final int LO_STAT_SIZE = 644;
    private static final int PRE_LONG_ID_LO_STAT_SIZE = 212;
    protected IfxLocator locator = null;
    private int loFd = -1;
    private IfxConnection conn = null;
    private IfxProtocol prot = null;
    private Trace trace = null;
    private int streamWriteBufferSize = 32000;

    public IfxSmartBlob(Connection conn) throws SQLException {
        this.conn = (IfxConnection)conn;
        if (TraceFlag.isTraceEnabled()) {
            this.setTrace(this.conn.getTrace());
        }
        try {
            Class<?> classRef = Class.forName(this.conn.getProtoClassName());
            Class<?> connClassRef = Class.forName(this.conn.getConnClassName());
            Class[] classArgs = new Class[]{connClassRef};
            Constructor<?> cons = classRef.getConstructor(classArgs);
            Object[] objs = new Object[]{this.conn};
            this.prot = (IfxProtocol)cons.newInstance(objs);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79735, e.toString(), this.conn);
        }
    }

    public void setWriteStreamBufferSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than zero : " + size);
        }
        this.streamWriteBufferSize = size;
    }

    public IfxLobDescriptor IfxLoColInfo(String name) throws SQLException {
        if (name == null) {
            throw IfxErrMsg.getSQLException(-79708, this.conn);
        }
        byte[] myDesc = new IfxLobDescriptor(this.conn).getRawLobDescriptor();
        IfxLvarchar ip1 = new IfxLvarchar(name);
        ip1.setConnection(this.conn);
        ip1.setExtendedTypeName(LO_COL_NAME);
        IfxUDT ip2 = new IfxUDT();
        ip2.setConnection(this.conn);
        ip2.setExtendedTypeName(LO_CREATE_SPEC_NAME);
        ip2.fromBytes(myDesc);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_COL_INFO, inVec, false);
        IfxUDT op1 = (IfxUDT)outVec.elementAt(0);
        byte[] byteV = op1.toBytes();
        IfxInteger op2 = (IfxInteger)outVec.elementAt(1);
        int retcode = op2.toInt();
        return new IfxLobDescriptor(this.conn, byteV);
    }

    public int IfxLoCreate(IfxLobDescriptor lodesc, int mode, IfxLocator locator) throws SQLException {
        byte[] tempLoPtr = new byte[72];
        byte[] myDesc = lodesc.getRawLobDescriptor();
        this.locator = locator;
        IfxUDT ip1 = new IfxUDT();
        ip1.setConnection(this.conn);
        ip1.setExtendedTypeName(LO_CREATE_SPEC_NAME);
        ip1.fromBytes(myDesc);
        IfxInteger ip2 = new IfxInteger(mode);
        IfxUDT ip3 = new IfxUDT();
        ip3.setConnection(this.conn);
        ip3.setExtendedTypeName(LO_NAME);
        ip3.fromBytes(tempLoPtr);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        inVec.addElement(ip3);
        outVec = this.prot.executeFastPath(IFX_LO_CREATE, inVec, false);
        IfxUDT op1 = (IfxUDT)outVec.elementAt(0);
        byte[] tempLo = op1.toBytes();
        IfxInteger op2 = (IfxInteger)outVec.elementAt(1);
        this.loFd = op2.toInt();
        locator.setRawLocator(tempLo);
        return this.loFd;
    }

    public int IfxLoCreate(IfxLobDescriptor lodesc, int mode, IfxBblob blob) throws SQLException {
        this.locator = new IfxLocator(this.conn);
        blob.smb = this;
        blob.setConnection(this.conn);
        return this.IfxLoCreate(lodesc, mode, this.locator);
    }

    public int IfxLoCreate(IfxLobDescriptor lodesc, int mode, IfxCblob clob) throws SQLException {
        this.locator = new IfxLocator(this.conn);
        clob.smb = this;
        clob.setConnection(this.conn);
        return this.IfxLoCreate(lodesc, mode, this.locator);
    }

    public int IfxLoOpen(IfxLocator locator, int mode) throws SQLException {
        byte[] loptr = locator.getRawLocator();
        IfxUDT ip1 = new IfxUDT();
        ip1.setConnection(this.conn);
        ip1.setExtendedTypeName(LO_NAME);
        ip1.fromBytes(loptr);
        IfxInteger ip2 = new IfxInteger(mode);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_OPEN, inVec, false);
        IfxInteger op2 = (IfxInteger)outVec.elementAt(0);
        this.loFd = op2.toInt();
        this.locator = locator;
        return this.loFd;
    }

    public int IfxLoOpen(IfxBblob blob, int mode) throws SQLException {
        IfxLocator loc = blob.getLocator();
        return this.IfxLoOpen(loc, mode);
    }

    public int IfxLoOpen(IfxCblob clob, int mode) throws SQLException {
        IfxLocator loc = clob.getLocator();
        return this.IfxLoOpen(loc, mode);
    }

    public void IfxLoRelease() throws SQLException {
        if (this.locator == null) {
            return;
        }
        this.IfxLoRelease(this.locator);
    }

    public void IfxLoRelease(IfxLocator locator) throws SQLException {
        byte[] LoPtr = locator.getRawLocator();
        int retcode = 0;
        IfxUDT ip1 = new IfxUDT();
        ip1.setConnection(this.conn);
        ip1.setExtendedTypeName(LO_NAME);
        ip1.fromBytes(LoPtr);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        outVec = this.prot.executeFastPath(IFX_LO_RELEASE, inVec, false);
        IfxInteger op1 = (IfxInteger)outVec.elementAt(0);
        retcode = op1.toInt();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxLoRelease() exited. op1.toInt= " + op1.toInt());
        }
        this.loFd = -1;
    }

    public void IfxLoRelease(IfxBblob blob) throws SQLException {
        IfxLocator loc = blob.getLocator();
        this.IfxLoRelease(loc);
    }

    public void IfxLoRelease(IfxCblob clob) throws SQLException {
        IfxLocator loc = clob.getLocator();
        this.IfxLoRelease(loc);
    }

    public void IfxLoClose(int lofd) throws SQLException {
        IfxInteger ip1 = new IfxInteger(lofd);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        inVec.addElement(ip1);
        this.prot.executeFastPath(IFX_LO_CLOSE, inVec, false);
        this.loFd = -1;
    }

    public long IfxLoSeek(int lofd, long offset, int whence) throws SQLException {
        long position = 0L;
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxInt8 ip2 = new IfxInt8(offset);
        IfxInteger ip3 = new IfxInteger(whence);
        IfxInt8 ip4 = new IfxInt8(position);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        inVec.addElement(ip3);
        inVec.addElement(ip4);
        outVec = this.prot.executeFastPath(IFX_LO_SEEK, inVec, false);
        IfxInt8 op1 = (IfxInt8)outVec.elementAt(0);
        IfxInteger op2 = (IfxInteger)outVec.elementAt(1);
        return op1.toLong();
    }

    public void IfxLoTruncate(int lofd, long size) throws SQLException {
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxInt8 ip2 = new IfxInt8(size);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_TRUNCATE, inVec, false);
    }

    public long IfxLoSize(int lofd) throws SQLException {
        int loStat_sz = this.conn.isLongID() ? 644 : 212;
        byte[] ifxLoStat = new byte[loStat_sz];
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxUDT ip2 = new IfxUDT();
        ip2.setConnection(this.conn);
        ip2.setExtendedTypeName(LO_STAT_NAME);
        ip2.fromBytes(ifxLoStat);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_STAT, inVec, false);
        ip2 = (IfxUDT)outVec.elementAt(0);
        ifxLoStat = ip2.toBytes();
        IfxUDTInput is = new IfxUDTInput(this.conn, ifxLoStat, 0, ifxLoStat.length);
        is.setAutoAlignment(false);
        is.readInt();
        long lobSize = is.readLong();
        return lobSize;
    }

    public IfxLoStat IfxLoGetStat(int lofd) throws SQLException {
        int loStat_sz = this.conn.isLongID() ? 644 : 212;
        byte[] ifxLoStat = new byte[loStat_sz];
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxUDT ip2 = new IfxUDT();
        ip2.setConnection(this.conn);
        ip2.setExtendedTypeName(LO_STAT_NAME);
        ip2.fromBytes(ifxLoStat);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_STAT, inVec, false);
        IfxUDT op1 = (IfxUDT)outVec.elementAt(0);
        ifxLoStat = op1.toBytes();
        return new IfxLoStat(this.conn, ifxLoStat);
    }

    protected int getHandle() {
        return this.loFd;
    }

    public long IfxLoTell(int lofd) throws SQLException {
        long value = 0L;
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxInt8 ip2 = new IfxInt8(value);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_TELL, inVec, false);
        IfxInt8 op1 = (IfxInt8)outVec.elementAt(0);
        return op1.toLong();
    }

    public byte[] IfxLoRead(int lofd, int nbytes) throws SQLException {
        if (nbytes < 1 || lofd < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        byte[] b = new byte[nbytes];
        this.prot.executeReadSmBlob(lofd, b, nbytes);
        return b;
    }

    public int IfxLoRead(int lofd, byte[] buffer, int nbytes) throws SQLException {
        if (buffer == null || buffer.length < nbytes || lofd < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        return this.prot.executeReadSmBlob(lofd, buffer, nbytes);
    }

    public int IfxLoRead(int lofd, FileOutputStream fout, int nbytes) throws SQLException {
        if (nbytes < 1 || lofd < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        return this.prot.executeReadSmBlob(lofd, fout, nbytes);
    }

    public int IfxLoRead(int lofd, byte[] buffer, int nbytes, int off) throws SQLException {
        if (buffer == null || buffer.length < nbytes || lofd < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        return this.prot.executeReadSmBlob(lofd, buffer, nbytes, off);
    }

    public int IfxLoWrite(int lofd, byte[] buffer) throws SQLException {
        return this.IfxLoWrite(lofd, buffer, 0, buffer == null ? 0 : buffer.length);
    }

    public int IfxLoWrite(int lofd, byte[] buffer, int offset, int length) throws SQLException {
        int n = 0;
        if (buffer == null || lofd < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        n = this.prot.executeWriteSmBlob(lofd, buffer, offset, length);
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        return n;
    }

    public long write(int lofd, InputStream is) throws SQLException {
        long size = 0L;
        byte[] buffer = new byte[this.streamWriteBufferSize];
        try {
            int bufferSize;
            while ((bufferSize = is.read(buffer)) > 0) {
                int bytesWritten = this.IfxLoWrite(lofd, buffer, 0, bufferSize);
                size += (long)bytesWritten;
            }
        }
        catch (IOException e) {
            SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
        return size;
    }

    public long write(int lofd, InputStream is, long length) throws SQLException {
        long size = 0L;
        byte[] buffer = new byte[this.streamWriteBufferSize];
        try {
            int bufferSize;
            while ((bufferSize = is.read(buffer, 0, (long)buffer.length >= length ? (int)length : buffer.length)) > 0 && length > 0L) {
                int bytesWritten = (length -= (long)bufferSize) < 0L ? this.IfxLoWrite(lofd, buffer, 0, bufferSize + (int)length) : this.IfxLoWrite(lofd, buffer, 0, bufferSize);
                size += (long)bytesWritten;
            }
        }
        catch (IOException e) {
            SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
        return size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long writeWithConversion(int lofd, InputStream is, long length) throws SQLException {
        String from = ((IfxSqliConnect)this.conn).getclEncoding();
        if (from == null) {
            from = Charset.defaultCharset().name();
        }
        try (BufferedReader r = new BufferedReader(new InputStreamReader(is, from));){
            long l = this.writeWithConversion(lofd, r, length);
            return l;
        }
        catch (Exception e) {
            SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
    }

    public long writeWithConversion(int lofd, Reader r, long length) throws SQLException {
        String to = ((IfxSqliConnect)this.conn).getdbEncoding();
        if (to == null) {
            throw IfxErrMsg.getSQLException(-79784, "ifxDB_LOCALE not set", this.conn);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.streamWriteBufferSize);
        char[] buffer = new char[this.streamWriteBufferSize / 2];
        long size = 0L;
        try {
            int bufferSize;
            BufferedWriter w = null;
            while ((bufferSize = r.read(buffer, 0, (long)buffer.length >= length ? (int)length : buffer.length)) > 0 && length > 0L) {
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)out, to));
                ((Writer)w).write(buffer, 0, bufferSize);
                ((Writer)w).flush();
                int bytesWritten = (length -= (long)bufferSize) < 0L ? this.IfxLoWrite(lofd, out.toByteArray(), 0, bufferSize + (int)length) : this.IfxLoWrite(lofd, out.toByteArray(), 0, bufferSize);
                size += (long)bytesWritten;
                ((Writer)w).close();
                out.reset();
            }
        }
        catch (IOException e) {
            SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
        return size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long writeWithConversion(int lofd, InputStream is) throws SQLException {
        String from = ((IfxSqliConnect)this.conn).getclEncoding();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(is, from));){
            long l = this.writeWithConversion(lofd, r);
            return l;
        }
        catch (Exception e) {
            SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
    }

    public long writeWithConversion(int lofd, Reader r) throws SQLException {
        String to = ((IfxSqliConnect)this.conn).getdbEncoding();
        if (to == null) {
            throw IfxErrMsg.getSQLException(-79784, "ifxDB_LOCALE not set", this.conn);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(this.streamWriteBufferSize);
        char[] buffer = new char[this.streamWriteBufferSize / 2];
        long size = 0L;
        try {
            int bufferSize;
            BufferedWriter w = null;
            while ((bufferSize = r.read(buffer)) > 0) {
                w = new BufferedWriter(new OutputStreamWriter((OutputStream)out, to));
                ((Writer)w).write(buffer, 0, bufferSize);
                ((Writer)w).flush();
                int bytesWritten = this.IfxLoWrite(lofd, out.toByteArray(), 0, bufferSize);
                size += (long)bytesWritten;
                ((Writer)w).close();
                out.reset();
            }
        }
        catch (IOException e) {
            SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
        return size;
    }

    public int IfxLoWrite(int lofd, InputStream fin, int length) throws SQLException {
        int n = 0;
        if (length < 1 || lofd < -1) {
            throw IfxErrMsg.getSQLException(-79773, this.conn);
        }
        n = this.prot.executeWriteSmBlob(lofd, fin, length);
        if (n < 0) {
            throw IfxErrMsg.getSQLException(-79754, this.conn);
        }
        return n;
    }

    public int IfxLoLock(int lofd, long offset, int whence, long range, int lockmode) throws SQLException {
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxInt8 ip2 = new IfxInt8(offset);
        IfxInteger ip3 = new IfxInteger(whence);
        IfxInt8 ip4 = new IfxInt8(range);
        IfxInteger ip5 = new IfxInteger(lockmode);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        inVec.addElement(ip3);
        inVec.addElement(ip4);
        inVec.addElement(ip5);
        outVec = this.prot.executeFastPath(IFX_LO_LOCK, inVec, false);
        IfxInteger op1 = (IfxInteger)outVec.elementAt(0);
        return op1.toInt();
    }

    public int IfxLoUnLock(int lofd, long offset, int whence, long range) throws SQLException {
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxInt8 ip2 = new IfxInt8(offset);
        IfxInteger ip3 = new IfxInteger(whence);
        IfxInt8 ip4 = new IfxInt8(range);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        inVec.addElement(ip3);
        inVec.addElement(ip4);
        outVec = this.prot.executeFastPath(IFX_LO_UNLOCK, inVec, false);
        IfxInteger op1 = (IfxInteger)outVec.elementAt(0);
        return op1.toInt();
    }

    public int IfxLoAlter(IfxLocator locator, IfxLobDescriptor lodesc) throws SQLException {
        byte[] loptr = locator.getRawLocator();
        IfxUDT ip1 = new IfxUDT();
        ip1.setConnection(this.conn);
        ip1.setExtendedTypeName(LO_NAME);
        ip1.fromBytes(loptr);
        byte[] myDesc = lodesc.getRawLobDescriptor();
        IfxUDT ip2 = new IfxUDT();
        ip2.setConnection(this.conn);
        ip2.setExtendedTypeName(LO_CREATE_SPEC_NAME);
        ip2.fromBytes(myDesc);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        outVec = this.prot.executeFastPath(IFX_LO_ALTER, inVec, false);
        IfxInteger op1 = (IfxInteger)outVec.elementAt(0);
        return op1.toInt();
    }

    public int IfxLoAlter(IfxBblob blob, IfxLobDescriptor lodesc) throws SQLException {
        IfxLocator locator = blob.getLocator();
        return this.IfxLoAlter(locator, lodesc);
    }

    public int IfxLoAlter(IfxCblob clob, IfxLobDescriptor lodesc) throws SQLException {
        IfxLocator locator = clob.getLocator();
        return this.IfxLoAlter(locator, lodesc);
    }

    public int IfxLoFromFile(int lofd, String name, int flag, int offset, int amount) throws SQLException {
        IfxInteger ip1 = new IfxInteger(lofd);
        IfxLvarchar ip2 = new IfxLvarchar(name);
        ip2.setConnection(this.conn);
        ip2.setExtendedTypeName(LO_COL_NAME);
        IfxInteger ip3 = new IfxInteger(flag);
        IfxInteger ip4 = new IfxInteger(offset);
        IfxInteger ip5 = new IfxInteger(amount);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        inVec.addElement(ip3);
        inVec.addElement(ip4);
        inVec.addElement(ip5);
        outVec = this.prot.executeFastPath(IFX_LO_COPY_TO_LO, inVec, false);
        IfxInteger op1 = (IfxInteger)outVec.elementAt(0);
        return op1.toInt();
    }

    public int IfxLoToFile(IfxLocator locator, String name, int flag) throws SQLException {
        byte[] loptr = locator.getRawLocator();
        int seekpos = 0;
        IfxUDT ip1 = new IfxUDT();
        ip1.setConnection(this.conn);
        ip1.setExtendedTypeName(LO_NAME);
        ip1.fromBytes(loptr);
        IfxLvarchar ip2 = new IfxLvarchar(name);
        ip2.setConnection(this.conn);
        ip2.setExtendedTypeName(LO_COL_NAME);
        IfxInteger ip3 = new IfxInteger(flag);
        IfxInteger ip4 = new IfxInteger(seekpos);
        Vector<IfxObject> inVec = new Vector<IfxObject>();
        Vector<IfxObject> outVec = null;
        inVec.addElement(ip1);
        inVec.addElement(ip2);
        inVec.addElement(ip3);
        inVec.addElement(ip4);
        outVec = this.prot.executeFastPath(IFX_LO_COPY_TO_FILE, inVec, false);
        IfxInteger op1 = (IfxInteger)outVec.elementAt(0);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxLoToFile() exited. op1.toInt= " + op1.toInt());
        }
        return op1.toInt();
    }

    public int IfxLoToFile(IfxBblob blob, String name, int flag) throws SQLException {
        IfxLocator loc = blob.getLocator();
        return this.IfxLoToFile(loc, name, flag);
    }

    public int IfxLoToFile(IfxCblob clob, String name, int flag) throws SQLException {
        IfxLocator loc = clob.getLocator();
        return this.IfxLoToFile(loc, name, flag);
    }

    void setTrace(Trace traceObj) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace = traceObj;
        }
    }

    protected synchronized void finalize() {
        if (((IfxSqliConnect)this.conn).autoCommit) {
            ((IfxSqliConnect)this.conn).removeFromBlobTable(this.hashCode());
        }
        if (this.loFd != -1) {
            ((IfxSqliConnect)this.conn).addLoFdToFinalizedBlobQueue(this.loFd, this.locator);
        }
    }
}

