/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm;

import com.informix.csm.IfxCSSException;
import com.informix.util.IfxErrMsg;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;

public class IfxCsmDescriptor {
    public static final int CSS_CSM_NOT_LOADED = 0;
    public static final int CSS_CSM_LOADED = 1;
    public static final int CSS_CSM_LOADING_ERR = 2;
    private static String CLASSNAME_SEPARATOR = "=";
    private static String COMMA_SEPARATOR = ",";
    private String classname;
    int load_state;
    int init_error;
    int attr_flags;
    private String csmInitString;
    private String ssoString;
    private boolean ssoEnc = true;
    private InputStream in;
    private OutputStream out;
    String locale;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IfxCsmDescriptor(String csmInfo, InputStream in, OutputStream out, String locale) throws IfxCSSException {
        this.locale = locale;
        this.in = in;
        this.out = out;
        String trimmedCsmString = csmInfo.trim();
        if (trimmedCsmString.substring(0, 3).toUpperCase().equals("SSO")) {
            this.ssoString = null;
            this.classname = "com.informix.jdbc.Gsscsm";
            this.csmInitString = "";
            StringTokenizer ssoTokComma = new StringTokenizer(trimmedCsmString, COMMA_SEPARATOR);
            if (!ssoTokComma.hasMoreTokens()) {
                throw IfxErrMsg.getLocIfxCSSException(-14574, locale);
            }
            String firstToken = ssoTokComma.nextToken().trim();
            this.ssoString = firstToken.substring(4);
            if (this.ssoString == null) {
                throw IfxErrMsg.getLocIfxCSSException(-14574, locale);
            }
            if (!ssoTokComma.hasMoreTokens()) return;
            String secondToken = ssoTokComma.nextToken().trim();
            StringTokenizer ssoEncTok = new StringTokenizer(secondToken, CLASSNAME_SEPARATOR);
            if (!ssoEncTok.hasMoreTokens()) throw IfxErrMsg.getLocIfxCSSException(-14574, locale);
            if (!ssoEncTok.nextToken().toUpperCase().equals("ENC")) throw IfxErrMsg.getLocIfxCSSException(-14574, locale);
            if (!ssoEncTok.hasMoreTokens()) throw IfxErrMsg.getLocIfxCSSException(-14574, locale);
            if (!ssoEncTok.nextToken().trim().toUpperCase().equals("FALSE")) return;
            this.ssoEnc = false;
            return;
        } else {
            StringTokenizer strTokComma = new StringTokenizer(trimmedCsmString, COMMA_SEPARATOR);
            if (!strTokComma.hasMoreTokens()) {
                throw IfxErrMsg.getLocIfxCSSException(-14574, locale);
            }
            String firstToken = strTokComma.nextToken().trim();
            StringTokenizer strTokClassname = new StringTokenizer(firstToken, CLASSNAME_SEPARATOR);
            if (!strTokClassname.hasMoreTokens()) {
                throw IfxErrMsg.getLocIfxCSSException(-14574, locale);
            }
            if (!strTokClassname.nextToken().equalsIgnoreCase("classname")) {
                throw IfxErrMsg.getLocIfxCSSException(-14574, locale);
            }
            if (!strTokClassname.hasMoreTokens()) {
                throw IfxErrMsg.getLocIfxCSSException(-14574, locale);
            }
            this.classname = strTokClassname.nextToken();
            if (this.classname == null || this.classname.length() == 0) {
                throw IfxErrMsg.getLocIfxCSSException(-14574, locale);
            }
            this.csmInitString = "";
            if (!strTokComma.hasMoreTokens()) return;
            this.csmInitString = trimmedCsmString.substring(firstToken.length() + 1);
        }
    }

    public void setLoadState(int state) {
        this.load_state = state;
    }

    public String getClassName() {
        return this.classname;
    }

    public String getInitString() {
        return this.csmInitString;
    }

    public String getSsoString() {
        return this.ssoString;
    }

    public boolean getSsoEnc() {
        return this.ssoEnc;
    }

    InputStream getInputStream() {
        return this.in;
    }

    OutputStream getOutputStream() {
        return this.out;
    }
}

