/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxComplexInput;
import com.informix.jdbc.IfxComplexOutput;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxUDTInfo;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;

public class IfxArray
implements java.sql.Array {
    private static final Object logger = Trace.getLoggerForClass(IfxArray.class);
    private Map<String, Class<?>> typeMap = null;
    private IfxComplexInput inputStream = null;
    private IfxComplexOutput outputStream = null;
    private IfxConnection conn = null;
    private Trace trace = null;
    private IfxColumnInfo elementInfo = null;
    private int JDBCType = 0;
    private int IfxType = 0;
    private boolean typeMappingNeeded = false;
    private int elementCount = -1;
    Object value;
    private boolean isFreed = false;

    IfxArray(byte[] b, Vector<IfxColumnInfo> typeInfoVector, IfxConnection conn) throws SQLException {
        this.inputStream = new IfxComplexInput(b, 0, b.length, typeInfoVector, false, conn);
        this.outputStream = new IfxComplexOutput(false, false);
        this.outputStream.setConnection(conn);
        this.setConnection(conn);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray() constructor entered/exited");
        }
        Vector<IfxColumnInfo> elementTypeInfoVector = typeInfoVector.get((int)0).child;
        this.elementInfo = elementTypeInfoVector.get(0);
        this.IfxType = this.elementInfo.SQLtype;
        if (IfxTypes.isUDT(this.IfxType)) {
            if (this.elementInfo.ExtendedId == 1) {
                this.IfxType = 43;
                this.JDBCType = -1;
            } else if (this.elementInfo.ExtendedId == 10) {
                this.IfxType = 102;
                this.JDBCType = 2004;
            } else if (this.elementInfo.ExtendedId == 11) {
                this.IfxType = 101;
                this.JDBCType = 2005;
            } else if (this.elementInfo.ExtendedId == 5) {
                this.IfxType = 45;
                this.JDBCType = 16;
            } else {
                this.JDBCType = 2000;
            }
        } else if (this.IfxType == 14) {
            this.JDBCType = 1111;
        } else if (this.IfxType == 10) {
            byte startCode = IfxDateTime.getStartCode((short)this.elementInfo.ColLength);
            this.JDBCType = startCode >= 6 ? 92 : 93;
        } else {
            this.JDBCType = IfxTypes.FromIfxToJDBC2Type(this.IfxType);
            if (this.IfxType == 4 && !conn.getMapReal()) {
                this.JDBCType = 6;
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxArray() constructor IfxType: " + this.IfxType);
            this.trace.writeTrace(logger, 2, "IfxArray() constructor JDBCType: " + this.JDBCType);
        }
        this.setTypeMappingNeeded(elementTypeInfoVector);
    }

    IfxArray(Object obj, IfxConnection conn) throws SQLException {
        this.value = obj;
        if (!obj.getClass().isArray()) {
            throw IfxErrMsg.getSQLException(-79716, ": IfxArray(Object, Connection) object isn't an array", conn);
        }
        this.setConnection(conn);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray(Object, Connection) entered");
        }
        Class<?> componentClass = obj.getClass().getComponentType();
        String className = null;
        if (componentClass.isPrimitive()) {
            className = componentClass.getName();
            if (className.equals("short")) {
                this.JDBCType = 5;
                this.IfxType = 1;
            } else if (className.equals("int")) {
                this.JDBCType = 4;
                this.IfxType = 2;
            } else if (className.equals("float")) {
                this.JDBCType = 6;
                this.IfxType = 4;
            } else if (className.equals("double")) {
                this.JDBCType = 8;
                this.IfxType = 3;
            } else if (className.equals("boolean")) {
                this.JDBCType = 16;
                this.IfxType = 45;
            } else if (className.equals("long")) {
                this.JDBCType = -5;
                if (!conn.getIsBigInt() && !conn.getIsBigSerial()) {
                    this.IfxType = 17;
                } else if (conn.getIsBigInt() && !conn.getIsBigSerial()) {
                    this.IfxType = 52;
                } else if (!conn.getIsBigInt() && conn.getIsBigSerial()) {
                    this.IfxType = 53;
                }
            }
        } else {
            className = componentClass.getName();
            if (className.equals("java.lang.timestamp")) {
                this.JDBCType = 93;
                this.IfxType = 10;
            } else if (className.equals("java.lang.time")) {
                this.JDBCType = 92;
                this.IfxType = 10;
            } else if (className.equals("boolean")) {
                this.JDBCType = 16;
                this.IfxType = 45;
            } else {
                this.IfxType = IfxTypes.FromJavaToIfxType(className);
                if (this.IfxType == 49) {
                    if (((Object[])obj).length > 0) {
                        IfxUDTInfo udtInfo;
                        Object elementObj = ((Object[])obj)[0];
                        if (elementObj != null && elementObj instanceof SQLData && (udtInfo = conn.getUDTInfo((IfxColumnInfo)null, elementObj.getClass().getName())) != null) {
                            this.JDBCType = udtInfo.JDBCtype;
                            if (this.JDBCType == 2002) {
                                this.IfxType = 22;
                            } else if (this.JDBCType == 2000) {
                                this.IfxType = 40;
                            } else if (this.JDBCType == 2001) {
                                this.IfxType = udtInfo.source;
                            }
                        }
                    } else {
                        this.IfxType = 40;
                        this.JDBCType = 2000;
                    }
                } else {
                    this.JDBCType = IfxTypes.FromIfxToJDBC2Type(this.IfxType);
                    if (this.IfxType == 4 && !conn.getMapReal()) {
                        this.JDBCType = 6;
                    }
                }
            }
        }
        this.typeMappingNeeded = false;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxArray() component: " + componentClass.getName());
            this.trace.writeTrace(logger, 2, "IfxArray() IfxType: " + this.IfxType);
            this.trace.writeTrace(logger, 2, "IfxArray() JDBCType: " + this.JDBCType);
            this.trace.writeTrace(logger, 1, "IfxArray(Object, Connection) exiting");
        }
    }

    void setTypeMappingNeeded(Vector<IfxColumnInfo> typeInfoVector) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray(). setTypeMappingNeeded entered");
        }
        for (IfxColumnInfo colInfo : typeInfoVector) {
            int type = IfxTypes.FromIfxToJDBCType(colInfo.SQLtype);
            if (colInfo.SQLtype == 4 && !this.conn.getMapReal()) {
                type = 6;
            }
            if (type == 2003 || type == 2001 || type == 2000 || type == 2001 || type == 1111 || type == 2002) {
                this.typeMappingNeeded = true;
                return;
            }
            if (colInfo.child == null) continue;
            this.setTypeMappingNeeded(colInfo.child);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray(). setTypeMappingNeeded exited");
        }
    }

    private void clear() {
        this.value = null;
        this.elementCount = -1;
        this.outputStream.reset();
    }

    void setConnection(IfxConnection conn) throws SQLException {
        this.conn = conn;
        if (conn == null) {
            throw IfxErrMsg.getSQLException(-79716, conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace = conn.getTrace();
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getBaseTypeName() called");
            this.trace.writeTrace(logger, 2, "   getBaseTypeName() IfxType: " + this.IfxType);
        }
        this.checkIfFreed();
        String name = null;
        if (this.IfxType != 40 && this.IfxType != 41) {
            name = IfxTypes.IfxTypeToName(this.IfxType);
        } else {
            Class<?> cls;
            name = new String("unknown");
            if (this.typeMap != null && this.elementInfo != null && this.elementInfo.ExtendedName != null && (cls = this.typeMap.get(this.elementInfo.ExtendedName)) != null) {
                name = cls.getName();
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxArray.getBaseTypeName() = " + name);
        }
        if (name == null) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        return name;
    }

    @Override
    public int getBaseType() throws SQLException {
        this.checkIfFreed();
        return this.JDBCType;
    }

    @Override
    public Object getArray() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getArray(void) called");
        }
        this.checkIfFreed();
        return this.getArray(this.conn.getTypeMap());
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getArray(Map) called");
        }
        this.checkIfFreed();
        if (this.value != null && (!this.typeMappingNeeded || this.typeMappingNeeded && this.typeMap == map)) {
            return this.value;
        }
        this.typeMap = map;
        this.inputStream.setTypeMap(this.typeMap);
        this.inputStream.reset();
        this.value = this.inputStream.readArrayElements(this.JDBCType);
        this.elementCount = -1;
        return this.value;
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getArray(long, int) called");
        }
        this.checkIfFreed();
        return this.getArray(index, count, this.conn.getTypeMap());
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getArray(long, int, Map) called");
        }
        this.checkIfFreed();
        if (this.value != null && (!this.typeMappingNeeded || this.typeMappingNeeded && this.typeMap == map)) {
            return this.getSubArray(index, count);
        }
        this.getArray(map);
        return this.getSubArray(index, count);
    }

    private Object getSubArray(long index, int count) throws SQLException {
        Object obj;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getSubArray(long, int) called");
        }
        this.verifyIndexCount(index, count);
        --index;
        try {
            obj = Array.newInstance(this.value.getClass().getComponentType(), count);
            System.arraycopy(this.value, (int)index, obj, 0, count);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getSubArray(long, exited) called");
        }
        return obj;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getResultSet(void) called");
        }
        this.checkIfFreed();
        return this.getResultSet(this.conn.getTypeMap());
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getResultSet(Map) called");
        }
        this.checkIfFreed();
        Object obj = this.getArray(map);
        return this.setResultSet(obj);
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getResultSet(long, int) called");
        }
        this.checkIfFreed();
        return this.getResultSet(index, count, this.conn.getTypeMap());
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getResultSet(long, int, Map) called");
        }
        this.checkIfFreed();
        Object obj = this.getArray(index, count, map);
        return this.setResultSet(obj);
    }

    private ResultSet setResultSet(Object obj) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.setResultSet(Object) entered");
        }
        IfxResultSetMetaData rsmd = new IfxResultSetMetaData(2, this.conn);
        rsmd.setEncodedLength(1, 8);
        rsmd.setNullable(1, 0);
        rsmd.setMaxWidth(1, 8);
        rsmd.setColtitle(1, "Index");
        rsmd.setColumnName(1, "Index");
        rsmd.setIfxColumnType(1, 17);
        rsmd.setEncodedLength(2, this.elementInfo.ColLength);
        rsmd.setNullable(2, this.elementInfo.Nullable);
        rsmd.setMaxWidth(2, this.elementInfo.MaxWidth);
        rsmd.setColtitle(2, this.elementInfo.Coltitle);
        rsmd.setColumnName(2, this.elementInfo.ColName);
        rsmd.setRightDecimal(2, this.elementInfo.RightDecimal);
        rsmd.setIfxColumnType(2, this.elementInfo.SQLtype);
        rsmd.setColumnExtendedId(2, this.elementInfo.ExtendedId);
        rsmd.setDistinct(2, this.elementInfo.IsDistinct);
        IfxClientResultSet crs = new IfxClientResultSet(this.conn, rsmd);
        this.loadResultSet(crs, obj);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.getResultSet(Object) exited");
        }
        return crs;
    }

    private void loadResultSet(IfxClientResultSet crs, Object obj) throws SQLException {
        long rowCount;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.loadResults(crs, Object called");
        }
        long l = rowCount = obj == null ? 0L : (long)Array.getLength(obj);
        if (rowCount > 0L) {
            crs.newRow((int)rowCount);
            int i = 0;
            while ((long)i < rowCount) {
                crs.updateLong(i + 1, 1, (long)(i + 1));
                crs.updateObject(i + 1, 2, Array.get(obj, i));
                ++i;
            }
        }
        crs.beforeFirst();
        crs.setType(1003);
        crs.setFetchDirection(1000);
        crs.setConcurrency(1007);
    }

    private void verifyIndexCount(long index, int count) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxArray.verifyIndexCount(long, int) called");
        }
        if (this.elementCount == -1) {
            if (!this.value.getClass().getComponentType().isPrimitive()) {
                this.elementCount = ((Object[])this.value).length;
            } else {
                switch (this.IfxType) {
                    case 2: {
                        this.elementCount = ((int[])this.value).length;
                        break;
                    }
                    case 1: {
                        this.elementCount = ((short[])this.value).length;
                        break;
                    }
                    case 17: 
                    case 52: 
                    case 53: {
                        this.elementCount = ((long[])this.value).length;
                        break;
                    }
                    case 4: {
                        this.elementCount = ((float[])this.value).length;
                        break;
                    }
                    case 3: {
                        this.elementCount = ((double[])this.value).length;
                        break;
                    }
                    case 45: {
                        this.elementCount = ((boolean[])this.value).length;
                        break;
                    }
                    default: {
                        this.elementCount = ((Object[])this.value).length;
                    }
                }
            }
        }
        if (index < 1L || index + (long)count > (long)(this.elementCount + 1)) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxArray.verifyIndexCount():");
                this.trace.writeTrace(logger, 2, "    index = " + index);
                this.trace.writeTrace(logger, 2, "    count = " + count);
                this.trace.writeTrace(logger, 2, "    elementCount = " + this.elementCount);
            }
            throw IfxErrMsg.getSQLException(-79781, this.conn);
        }
    }

    @Override
    public void free() throws SQLException {
        this.clear();
        this.isFreed = true;
    }

    private void checkIfFreed() throws SQLException {
        if (this.isFreed) {
            throw IfxErrMsg.getSQLException(-79001, this.conn);
        }
    }
}

