/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;

class StatementCache
extends LinkedHashMap<StatementKey, Statement> {
    private static final long serialVersionUID = 1L;
    private final int maximumEntries;

    public StatementCache(int maximumEntries) {
        super(maximumEntries + 1, 1.0f, true);
        this.maximumEntries = maximumEntries;
    }

    public int getMaximumEntries() {
        return this.maximumEntries;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<StatementKey, Statement> eldest) {
        if (this.size() > this.maximumEntries) {
            Statement statement = eldest.getValue();
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public Statement remove(Object id) {
        Statement statement = (Statement)super.remove(id);
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return statement;
    }

    @Override
    public void clear() {
        for (Statement statement : this.values()) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
        super.clear();
    }

    @Override
    public Statement put(StatementKey key, Statement stmt) {
        Statement oldStmt = super.put(key, stmt);
        if (oldStmt != null && stmt != oldStmt) {
            try {
                oldStmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return oldStmt;
    }

    class StatementKey {
        protected final StatementType type;
        protected final String key;

        protected StatementKey(StatementType type, String key) {
            this.type = type;
            this.key = key;
        }

        protected StatementType getType() {
            return this.type;
        }

        protected String getKey() {
            return this.key;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StatementKey other = (StatementKey)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("StatementKey [type=");
            builder.append((Object)this.type);
            builder.append(", key=");
            builder.append(this.key);
            builder.append("]");
            return builder.toString();
        }
    }

    protected static enum StatementType {
        CALLABLE_STATEMENT,
        PREPARED_STATEMENT;

    }
}

