/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.HttpConnection;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Hashtable;

public class HttpBufferedInputStream
extends BufferedInputStream {
    private HttpConnection http;
    private BufferedInputStream is;
    private String session = null;
    private Hashtable ht = null;

    public HttpBufferedInputStream(InputStream i, HttpConnection http, String id) throws IOException {
        super(i);
        this.http = http;
        this.session = id;
        this.is = new BufferedInputStream(i);
    }

    @Override
    public final int read() throws IOException {
        int byteRead = 0;
        if (this.is.available() <= 0) {
            this.getMoreData();
        }
        byteRead = this.is.read();
        return byteRead;
    }

    @Override
    public final int read(byte[] b) throws IOException {
        int bytesRead = 0;
        if (this.is.available() <= 0) {
            this.getMoreData();
        }
        bytesRead = this.is.read(b);
        return bytesRead;
    }

    @Override
    public final int read(byte[] b, int offset, int length) throws IOException {
        int bytesRead = 0;
        if (this.is.available() <= 0) {
            this.getMoreData();
        }
        bytesRead = this.is.read(b, offset, length);
        return bytesRead;
    }

    public final int skip(int n) throws IOException {
        if (this.is.available() <= 0) {
            this.getMoreData();
        }
        int i = 0;
        while ((i += (int)this.is.skip(n - i)) < n) {
        }
        return n;
    }

    private final void getMoreData() throws IOException {
        URLConnection conn = this.http.openConnection(false, true, true);
        int proxyVer = this.http.getProxyVersion();
        if (proxyVer < 210) {
            this.http.setRequestProperty("JDBC_REQUEST", "RECV");
        } else {
            this.http.setRequestProperty("JDBC_REQUEST", "SNDRCV");
        }
        this.http.setRequestProperty("JDBC_SESSION", this.session);
        this.http.flush(conn);
        this.is = new BufferedInputStream(this.http.getInputStream());
        String status = this.http.getHeaderField("JDBC_REQUEST");
        String session = this.http.getHeaderField("JDBC_SESSION");
        if (!status.equals("RECV_OK")) {
            throw new IOException(session);
        }
    }
}

