/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm.crypto;

import com.informix.csm.crypto.IfxCipherElem;
import com.informix.csm.crypto.IfxCryptoCtx;
import com.informix.csm.crypto.IfxCryptoUtils;
import com.informix.csm.crypto.IfxEDPkt;
import com.informix.csm.crypto.IfxEncPkt;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

class IfxCipher {
    static final int EA_DES = 1;
    static final int EA_DES3 = 2;
    static final int EA_DESX = 3;
    static final int EA_IDEA = 4;
    static final int EA_BF1 = 5;
    static final int EA_BF2 = 6;
    static final int EA_BF3 = 7;
    static final int EA_EDE = 8;
    static final int EA_BF_1 = 9;
    static final int EA_BF_2 = 10;
    static final int EA_BF_3 = 11;
    static final int EA_RC2A = 12;
    static final int EA_RC2B = 13;
    static final int EA_RC2C = 14;
    static final int EA_RC5A1 = 15;
    static final int EA_RC5B1 = 16;
    static final int EA_RC5C1 = 17;
    static final int EA_RC5A2 = 18;
    static final int EA_RC5B2 = 19;
    static final int EA_RC5C2 = 20;
    static final int EM_VOID = 0;
    static final int EM_ECB = 1;
    static final int EM_CBC = 2;
    static final int EM_CFB = 3;
    static final int EM_OFB = 4;
    static final int EM_MIN = 1;
    static final int EM_MAX = 4;
    private static Hashtable CipherModes;
    private static IfxCipher[] Ciphers;
    static final int EA_MIN = 1;
    static final int EA_MAX;
    String name;
    String algorithm;
    int Cipher;
    int KeySize;
    int RC2Key;
    int RC5Rounds;
    boolean[] supportedMode;

    IfxCipher() {
    }

    IfxCipher(String name, String algorithm, int cipher, int keySize, int rc2Key, int rc5Rounds, boolean[] supportedMode) {
        this.name = name;
        this.algorithm = algorithm;
        this.Cipher = cipher;
        this.KeySize = keySize;
        this.RC2Key = rc2Key;
        this.RC5Rounds = rc5Rounds;
        this.supportedMode = supportedMode;
    }

    int getKeySize() {
        return this.KeySize;
    }

    int getRC2Key() {
        return this.RC2Key;
    }

    int getRC5Rounds() {
        return this.RC5Rounds;
    }

    String getAlgorithmName() {
        return this.algorithm;
    }

    int getCipherType() {
        return this.Cipher;
    }

    String getName() {
        return this.name;
    }

    static IfxCipher FindCipherByID(int CipherID) {
        for (int tnum = 0; tnum < Ciphers.length; ++tnum) {
            if (Ciphers[tnum] == null || IfxCipher.Ciphers[tnum].Cipher != CipherID) continue;
            return Ciphers[tnum];
        }
        return null;
    }

    static IfxCipher FindCipherByName(String name) {
        if (name == null) {
            return null;
        }
        for (int tnum = 0; tnum < Ciphers.length; ++tnum) {
            if (Ciphers[tnum] == null || name.compareTo(IfxCipher.Ciphers[tnum].name) != 0) continue;
            return Ciphers[tnum];
        }
        return null;
    }

    static int FindModeByName(String name) {
        Object val = null;
        val = CipherModes.get(name);
        if (val != null) {
            return val;
        }
        return 0;
    }

    static String FindNameByMode(int mode) {
        Enumeration keyEnum = CipherModes.keys();
        while (keyEnum.hasMoreElements()) {
            String modeName = (String)keyEnum.nextElement();
            if (mode != IfxCipher.FindModeByName(modeName)) continue;
            return modeName;
        }
        return null;
    }

    static boolean isCipherElementValid(IfxCipherElem cipherElem) {
        int cipherType = cipherElem.getCipherType();
        int cipherMode = cipherElem.getMode();
        IfxCipher cipher = IfxCipher.FindCipherByID(cipherType);
        return cipherMode >= 1 && cipherMode <= 4 && cipher != null && IfxCipher.isModeValidForCipher(cipherMode, cipher);
    }

    static boolean isModeValidForCipher(int mode, IfxCipher cipher) {
        if (mode > 4 || mode < 1) {
            return false;
        }
        try {
            return cipher.supportedMode[mode - 1];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return false;
        }
    }

    boolean isModeValidForThisCipher(int mode) {
        return IfxCipher.isModeValidForCipher(mode, this);
    }

    static int insertCipher(IfxCipherElem cipherElement, Vector list) {
        IfxCipherElem listElem;
        int k;
        int status = 0;
        for (k = list.size() - 1; k >= 0 && cipherElement.isStrongerThan(listElem = (IfxCipherElem)list.get(k)); --k) {
        }
        list.add(k + 1, cipherElement);
        return status;
    }

    static int addAllCiphers(Vector list) {
        int status = 0;
        int tnum = 0;
        for (tnum = 0; tnum < Ciphers.length; ++tnum) {
            IfxCipher cipher = Ciphers[tnum];
            if (cipher == null) continue;
            for (int k = 0; k < cipher.supportedMode.length; ++k) {
                if (!cipher.supportedMode[k] || IfxCipher.registerCipher(cipher.getCipherType(), k + 1, list) != -1) continue;
                return -1;
            }
        }
        status = IfxCipher.remCipherMode(IfxCipher.FindNameByMode(1), list);
        if (status != 0) {
            return status;
        }
        status = IfxCipher.remCipherMode(IfxCipher.FindCipherByID(3).getName(), list);
        if (status != 0) {
            return status;
        }
        status = IfxCipher.remCipherMode(IfxCipher.FindCipherByID(11).getName(), list);
        if (status != 0) {
            return status;
        }
        return 0;
    }

    static int registerCipher(int CipherType, int CipherMode, Vector registerList) {
        int status = 0;
        IfxCipherElem cipherElem = new IfxCipherElem(CipherType, CipherMode);
        if (!IfxCipher.isCipherElementValid(cipherElem)) {
            status = -16;
        } else if (IfxCipherElem.isCipherInList(cipherElem, registerList)) {
            status = -19;
        } else {
            status = IfxCipher.insertCipher(cipherElem, registerList);
            if (status != 0) {
                // empty if block
            }
        }
        if (status != 0) {
            IfxCryptoCtx.printError(null, "RegisterCipher", status);
        }
        return status;
    }

    static int remCipherMode(String obj, Vector list) {
        int status = 0;
        int ObjID = 0;
        int ObjType = 0;
        int tnum = 0;
        if (CipherModes.containsKey(obj)) {
            ObjID = (Integer)CipherModes.get(obj);
            ObjType = 1;
        }
        if (ObjType == 0) {
            for (tnum = 0; tnum < Ciphers.length; ++tnum) {
                if (Ciphers[tnum] == null || Ciphers[tnum].getName().compareTo(obj) != 0) continue;
                ObjID = Ciphers[tnum].getCipherType();
                ObjType = 2;
                break;
            }
        }
        if (ObjType == 0) {
            String Partial = null;
            int Len = obj.length();
            for (tnum = 0; tnum < Ciphers.length; ++tnum) {
                if (Ciphers[tnum] == null || !Ciphers[tnum].getName().startsWith(obj)) continue;
                ObjType = 3;
                Partial = Ciphers[tnum].getName();
                IfxCipher.remCipherMode(Partial, list);
            }
        }
        if (status == 0 && ObjType != 3) {
            if (ObjType == 0) {
                status = -16;
            } else {
                for (int k = 0; k < list.size(); ++k) {
                    IfxCipherElem elem = (IfxCipherElem)list.get(k);
                    if ((ObjType != 1 || elem.getMode() != ObjID) && (ObjType != 2 || elem.getCipherType() != ObjID)) continue;
                    list.remove(k);
                    --k;
                }
            }
        }
        if (status != 0) {
            IfxCryptoCtx.printError(null, "RemCipherMode", status);
        }
        return status;
    }

    static int cryptoSwitchCipher(IfxEncPkt encPkt, IfxEDPkt edPkt, IfxCryptoCtx cryptoCtx) {
        IfxCipherElem cipherElem;
        int status = 0;
        edPkt.IV.Hash = null;
        try {
            cipherElem = (IfxCipherElem)encPkt.NegoaitedCipherList.get(edPkt.CurrentCipher);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            try {
                cipherElem = (IfxCipherElem)encPkt.NegoaitedCipherList.firstElement();
            }
            catch (NoSuchElementException ex) {
                cipherElem = null;
            }
            edPkt.CurrentCipher = 0;
        }
        if (cipherElem == null) {
            status = -21;
        } else {
            status = IfxCipher.initCipher(encPkt, edPkt, cipherElem.getCipherType(), cipherElem.getMode());
            if (status == 0) {
                edPkt.timeLastCipherSwitch = IfxCryptoUtils.getCurrentTimeinSec();
                if ((cryptoCtx.DebugFlags & 0x600) > 0) {
                    // empty if block
                }
            }
        }
        if (status != 0) {
            IfxCryptoCtx.printError(encPkt, "CryptoSwitchCipher", status);
        }
        return status;
    }

    static int initCipher(IfxEncPkt EncPkt, IfxEDPkt EDPkt, int Algorithm, int CB) {
        IfxCipherElem cipherElem;
        int status = 0;
        int AlgSub = 0;
        if (Algorithm < 1 || Algorithm > EA_MAX) {
            return -8;
        }
        if (CB < 1 || CB > 4) {
            return -8;
        }
        AlgSub = Algorithm - 1;
        IfxCipher cipher = IfxCipher.FindCipherByID(Algorithm);
        if (cipher == null) {
            return -8;
        }
        if (!cipher.isModeValidForThisCipher(CB)) {
            return -9;
        }
        EDPkt.MacKey = EncPkt.NegotiatedMacKey;
        EDPkt.MacLevel = EncPkt.NegotiatedMacLevel;
        EDPkt.cipherElem = cipherElem = new IfxCipherElem(Algorithm, CB);
        EDPkt.IV.Hash = null;
        EDPkt.MAC.Hash = null;
        EDPkt.KeySize = cipher.KeySize;
        EDPkt.RC2Key = cipher.RC2Key;
        EDPkt.RC5Rounds = cipher.RC5Rounds;
        if (EDPkt.IV.SubDir >= 0) {
            EDPkt.IV.init(0, 1, EDPkt.SecretKey.length - 2);
        } else {
            EDPkt.IV.init(EDPkt.SecretKey.length - 2, -1, 0);
        }
        if (EDPkt.MAC.SubDir >= 0) {
            EDPkt.MAC.init(0, 1, EDPkt.MacKey.length - 2);
        } else {
            EDPkt.MAC.init(EDPkt.MacKey.length - 2, -1, 0);
        }
        return status;
    }

    static String getPaddingScheme(IfxCipherElem elem) {
        int mode = elem.getMode();
        int algo = elem.getCipherType();
        if (mode == 3 || mode == 4) {
            return "NoPadding";
        }
        return "PKCS5Padding";
    }

    static {
        if (CipherModes == null) {
            CipherModes = new Hashtable();
            CipherModes.put("ecb", 1);
            CipherModes.put("cbc", 2);
            CipherModes.put("cfb", 3);
            CipherModes.put("ofb", 4);
        }
        Ciphers = new IfxCipher[]{new IfxCipher("des", "DES", 1, 0, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("des3", "DESede", 2, 0, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("desx", "desx", 3, 0, 0, 0, new boolean[]{false, true, false, false}), new IfxCipher("bf-1", "Blowfish", 5, 16, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("bf-2", "Blowfish", 6, 16, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("bf-3", "Blowfish", 7, 16, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("ede", "DESede", 8, 0, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("bf1", "Blowfish", 9, 8, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("bf2", "Blowfish", 10, 16, 0, 0, new boolean[]{false, true, true, true}), new IfxCipher("bf3", "Blowfish", 11, 24, 0, 0, new boolean[]{false, true, true, true})};
        EA_MAX = Ciphers.length + 1;
    }
}

