/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxInputStream;
import com.informix.jdbc.IfxLoStat;
import com.informix.jdbc.IfxLobDescriptor;
import com.informix.jdbc.IfxLobInputStream;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxOutputStream;
import com.informix.jdbc.IfxSmartBlob;
import com.informix.jdbc.IfxTmpFile;
import com.informix.util.IfxErrMsg;
import com.informix.util.memoryUtil;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;

abstract class IfxLob {
    protected static final short TYPE_IS_BLOB = 2;
    protected static final short TYPE_IS_CLOB = 3;
    protected static final short MODE_READ_WRITE = 0;
    protected static final short MODE_RW_BUFF = 1;
    protected static final short MODE_CLIENT_ONLY = 2;
    protected IfxSmartBlob smb = null;
    protected IfxLocator locatorPointer = null;
    protected IfxConnection conn = null;
    protected boolean isBlob_loaded = false;
    protected IfxTmpFile tempBlobFile = null;
    protected InputStream blobStream = null;
    protected byte[] blobBuffer = null;
    protected String BlobFileName;
    protected long blobSize = 0L;
    protected short ifxType;
    protected int smartBlobMode = 0;

    protected IfxLob() {
    }

    protected IfxLob(Connection conn, InputStream fin, int length) throws SQLException {
        this.conn = (IfxConnection)conn;
        IfxLobDescriptor loDesc = new IfxLobDescriptor(conn);
        this.lobFromStream(fin, length, loDesc);
    }

    protected IfxLob(Connection conn, InputStream fin, int length, String sbspaceName) throws SQLException {
        this.conn = (IfxConnection)conn;
        IfxLobDescriptor loDesc = new IfxLobDescriptor(conn);
        loDesc.setSbspace(sbspaceName);
        this.lobFromStream(fin, length, loDesc);
    }

    protected IfxLob(Connection conn, InputStream fin, int length, IfxLobDescriptor loDesc) throws SQLException {
        this.conn = (IfxConnection)conn;
        this.lobFromStream(fin, length, loDesc);
    }

    protected IfxLob(Connection conn, byte[] buffer) throws SQLException {
        this.conn = (IfxConnection)conn;
        int length = buffer == null ? 0 : buffer.length;
        IfxLobDescriptor loDesc = new IfxLobDescriptor(conn);
        this.lobFromBuffer(buffer, length, loDesc);
    }

    protected IfxLob(Connection conn, byte[] buffer, String sbspaceName) throws SQLException {
        this.conn = (IfxConnection)conn;
        int length = buffer == null ? 0 : buffer.length;
        IfxLobDescriptor loDesc = new IfxLobDescriptor(conn);
        loDesc.setSbspace(sbspaceName);
        this.lobFromBuffer(buffer, length, loDesc);
    }

    protected IfxLob(Connection conn, byte[] buffer, IfxLobDescriptor loDesc) throws SQLException {
        this.conn = (IfxConnection)conn;
        int length = buffer == null ? 0 : buffer.length;
        this.lobFromBuffer(buffer, length, loDesc);
    }

    private void lobFromStream(InputStream fin, int length, IfxLobDescriptor loDesc) throws SQLException {
        try {
            this.locatorPointer = new IfxLocator(this.conn);
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoCreate(loDesc, 8, this.locatorPointer);
            if (length > 0) {
                this.smb.IfxLoWrite(this.smb.getHandle(), fin, length);
            }
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        catch (SQLException e) {
            this.smb = null;
            throw e;
        }
    }

    private void lobFromBuffer(byte[] buffer, int length, IfxLobDescriptor loDesc) throws SQLException {
        try {
            this.locatorPointer = new IfxLocator(this.conn);
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoCreate(loDesc, 8, this.locatorPointer);
            if (length > 0) {
                this.smb.IfxLoWrite(this.smb.getHandle(), buffer);
            }
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        catch (SQLException e) {
            this.smb = null;
            throw e;
        }
    }

    public IfxLocator getLocator() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb == null) {
            return this.locatorPointer;
        }
        return this.smb.locator;
    }

    protected void setLocator(IfxLocator locator) throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            this.smb.locator = locator;
        } else {
            this.locatorPointer = locator;
        }
    }

    protected void setIfxLobType(short type) {
        this.ifxType = type;
    }

    protected void setSize(long size) {
        this.blobSize = size;
    }

    protected void setConnection(IfxConnection conn) {
        this.conn = conn;
    }

    protected void setLoadFlag() {
        this.isBlob_loaded = true;
    }

    protected short getIfxLobType() {
        return this.ifxType;
    }

    protected void setMode(int mode) {
        this.smartBlobMode = mode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] getPortion(long position, long length) {
        if (position < 1L || length < 0L) {
            return null;
        }
        if (length == 0L) {
            return new byte[0];
        }
        try {
            if (!this.isBlob_loaded) {
                this.loadSmBlob();
            }
        }
        catch (Exception e) {
            return null;
        }
        if (position > this.blobSize) {
            return null;
        }
        long pos = position - 1L;
        int len = pos + length > this.blobSize ? (int)(this.blobSize - pos) : (int)length;
        byte[] b = new byte[len];
        if (this.tempBlobFile != null) {
            IfxInputStream fd;
            try {
                fd = this.tempBlobFile.getInputStream();
            }
            catch (Exception e) {
                return null;
            }
            try {
                if (pos > 0L) {
                    fd.skip(pos);
                }
                fd.read(b, 0, len);
                ((FileInputStream)fd).close();
                if (this.ifxType != 3 && this.ifxType != 2) return b;
                this.isBlob_loaded = false;
                this.tempBlobFile.close();
                this.tempBlobFile = null;
                return b;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (this.blobBuffer == null) return null;
        System.arraycopy(this.blobBuffer, (int)pos, b, 0, len);
        if (this.ifxType != 3 && this.ifxType != 2) return b;
        this.blobBuffer = null;
        this.isBlob_loaded = false;
        return b;
    }

    protected InputStream getStreamImd() throws SQLException {
        if (!this.isBlob_loaded) {
            this.loadSmBlob();
        }
        return this.getStream();
    }

    protected InputStream getStream() throws SQLException {
        if (!this.isBlob_loaded) {
            try {
                IfxLobInputStream lobStream = new IfxLobInputStream(this.conn, this.getLocator());
                return lobStream;
            }
            catch (IOException e) {
                throw new SQLException(e.getMessage());
            }
        }
        if (this.tempBlobFile != null) {
            try {
                IfxInputStream fd = this.tempBlobFile.getInputStream();
                return fd;
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79716, this.conn);
            }
        }
        ByteArrayInputStream barrayIS = new ByteArrayInputStream(this.blobBuffer);
        return barrayIS;
    }

    protected void setStream(InputStream fin, int length) throws SQLException {
        if (length > 0) {
            this.smb.IfxLoWrite(this.smb.getHandle(), fin, length);
        }
        this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
    }

    protected int setBuffer(byte[] buffer) throws SQLException {
        return this.setBuffer(buffer, 0, buffer == null ? 0 : buffer.length);
    }

    protected int setBuffer(byte[] buffer, int offset, int length) throws SQLException {
        int n = 0;
        if (buffer.length > 0 && length > 0) {
            n = this.smb.IfxLoWrite(this.smb.getHandle(), buffer, offset, length);
            this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        }
        return n;
    }

    public long seek(long offset, int whence) throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.IfxLoSeek(this.smb.getHandle(), offset, whence);
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public long where() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.IfxLoTell(this.smb.getHandle());
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public IfxLoStat getLoStat() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            return this.smb.IfxLoGetStat(this.smb.getHandle());
        }
        throw IfxErrMsg.getSQLException(-79814, this.conn);
    }

    public void truncate(long size) throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null) {
            this.smb.IfxLoTruncate(this.smb.getHandle(), size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.ifxType != 3 && this.ifxType != 2) {
            throw IfxErrMsg.getSQLException(-79787, this.conn);
        }
        if (this.smb != null && this.smb.getHandle() != -1) {
            IfxConnection ifxConnection = this.conn;
            synchronized (ifxConnection) {
                this.smb.IfxLoClose(this.smb.getHandle());
            }
        }
        this.smb = null;
    }

    protected void loadSmBlob() throws SQLException {
        IfxOutputStream BlobFd = null;
        this.tempBlobFile = null;
        this.blobBuffer = null;
        this.blobSize = this.smb.IfxLoSize(this.smb.getHandle());
        if (this.blobSize == 0L) {
            this.blobBuffer = new byte[0];
            this.tempBlobFile = null;
            return;
        }
        int bufferSize = this.conn.getBlobCacheSize();
        if (bufferSize < 0 || bufferSize > 0 && this.blobSize <= (long)bufferSize) {
            try {
                this.blobBuffer = memoryUtil.allocateMemory((int)this.blobSize, this.conn);
            }
            catch (Exception e) {
                throw IfxErrMsg.getSQLException(-79753, this.conn);
            }
            this.tempBlobFile = null;
        } else {
            try {
                this.tempBlobFile = new IfxTmpFile(this.conn);
                BlobFd = this.tempBlobFile.getOutputStream();
                this.blobBuffer = null;
            }
            catch (Exception e) {
                if (bufferSize == 0) {
                    throw IfxErrMsg.getSQLException(-79774, this.conn);
                }
                this.blobBuffer = memoryUtil.allocateMemory((int)this.blobSize, this.conn);
                BlobFd = null;
                this.tempBlobFile = null;
            }
        }
        try {
            if (this.blobBuffer == null) {
                this.smb.IfxLoSeek(this.smb.getHandle(), 0L, 0);
                this.smb.IfxLoRead(this.smb.getHandle(), BlobFd, (int)this.blobSize);
                ((FileOutputStream)BlobFd).close();
            } else {
                this.smb.IfxLoSeek(this.smb.getHandle(), 0L, 0);
                this.smb.IfxLoRead(this.smb.getHandle(), this.blobBuffer, (int)this.blobSize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isBlob_loaded = true;
    }

    protected void verifySmbMode() throws SQLException {
        if (this.smb == null || this.smb.getHandle() == -1) {
            if (this.smartBlobMode != 0) {
                throw IfxErrMsg.getSQLException(-79814, this.conn);
            }
            this.smb = new IfxSmartBlob(this.conn);
            this.smb.IfxLoOpen(this.locatorPointer, 8);
        }
    }
}

