/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxLocator;
import com.informix.jdbc.IfxSmartBlob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class IfxLobInputStream
extends InputStream {
    static final int LO_INTERNAL_BUF_MAX_SIZE = 4084;
    IfxConnection conn = null;
    IfxLocator locator = null;
    long lobSize = 0L;
    long total_read = 0L;
    private int loFd = -1;
    private IfxSmartBlob smb = null;
    byte[] buffer = null;
    int pos = 0;
    int count = 0;

    public IfxLobInputStream(IfxConnection connection, IfxLocator loPtr) throws SQLException, IOException {
        this.conn = connection;
        this.locator = loPtr;
        try {
            this.smb = new IfxSmartBlob(this.conn);
            this.loFd = this.smb.IfxLoOpen(this.locator, 4);
            this.lobSize = this.smb.IfxLoSize(this.loFd);
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    @Override
    public int read() throws IOException {
        int bytes_read = 0;
        if ((this.buffer == null || this.pos == this.count) && (bytes_read = this.readLob()) == -1) {
            return -1;
        }
        ++this.total_read;
        return this.pos < this.count ? this.buffer[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytes_copied = this.read(b, 0, b.length);
        return bytes_copied;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytes_copied = 0;
        int bytes_read = 0;
        boolean first_time = true;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        while (bytes_copied < len && bytes_read >= 0) {
            if ((this.buffer == null || this.pos == this.count) && (bytes_read = this.readLob()) == -1) {
                if (!first_time) continue;
                bytes_copied = -1;
                return -1;
            }
            int bytes_to_copy = Math.min(this.count - this.pos, len - bytes_copied);
            System.arraycopy(this.buffer, this.pos, b, bytes_copied + off, bytes_to_copy);
            first_time = false;
            bytes_copied += bytes_to_copy;
            this.pos += bytes_to_copy;
        }
        this.total_read += (long)bytes_copied;
        return bytes_copied;
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.smb.IfxLoSeek(this.loFd, n, 1);
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            this.smb.IfxLoSeek(this.loFd, 0L, 0);
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.lobSize - this.total_read);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.smb != null) {
            IfxConnection ifxConnection = this.conn;
            synchronized (ifxConnection) {
                try {
                    if (this.loFd != -1) {
                        this.smb.IfxLoClose(this.loFd);
                    }
                    if (this.locator != null) {
                        this.smb.IfxLoRelease(this.locator);
                    }
                    this.smb = null;
                }
                catch (SQLException se) {
                    throw new IOException(se.getMessage());
                }
                finally {
                    if (this.smb != null) {
                        this.smb = null;
                    }
                }
            }
        }
    }

    private int readLob() throws IOException {
        if (this.buffer == null) {
            this.buffer = this.lobSize > 4084L ? new byte[4084] : new byte[(int)this.lobSize];
        }
        try {
            this.pos = 0;
            this.count = this.smb.IfxLoRead(this.loFd, this.buffer, this.buffer.length);
            if (this.count == 0) {
                return -1;
            }
            return this.count;
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    protected InputStream getStream() throws SQLException {
        if (this.lobSize == 0L) {
            return new ByteArrayInputStream(new byte[0]);
        }
        try {
            this.reset();
        }
        catch (IOException e) {
            // empty catch block
        }
        ByteArrayInputStream barrayIS = new ByteArrayInputStream(this.smb.IfxLoRead(this.loFd, (int)this.lobSize));
        return barrayIS;
    }
}

