/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxProtocol;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import com.informix.util.stringUtil;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.SQLException;

public class IfxLocator {
    private static final Object logger = Trace.getLoggerForClass(IfxLocator.class);
    static final int IFX_LOCATOR_SIZE = 72;
    byte[] rawLocator = null;
    int blobSize = 0;
    IfxConnection conn = null;
    private IfxProtocol prot = null;
    private Trace trace = null;
    private static final String IFX_LO_INCREFCOUNT = "function informix.ifx_lo_increfcount(blob)";
    private static final String IFX_LO_DECREFCOUNT = "function informix.ifx_lo_decrefcount(blob)";
    private static final String LO_NAME = "blob";

    public IfxLocator() {
        if (this.rawLocator == null) {
            this.rawLocator = new byte[72];
        }
    }

    public IfxLocator(Connection conn) throws SQLException {
        if (this.rawLocator == null) {
            this.rawLocator = new byte[72];
        }
        this.conn = (IfxConnection)conn;
        if (TraceFlag.isTraceEnabled()) {
            this.setTrace(this.conn.getTrace());
        }
        try {
            Class[] classArgs = new Class[]{this.conn.getClass()};
            Class<?> classRef = Class.forName(this.conn.getProtoClassName());
            Constructor<?> cons = null;
            while (cons == null) {
                try {
                    cons = classRef.getConstructor(classArgs);
                }
                catch (NoSuchMethodException e) {
                    classArgs[0] = classArgs[0].getSuperclass();
                    if (classArgs[0] != null) continue;
                    throw e;
                }
            }
            Object[] objs = new Object[]{this.conn};
            this.prot = (IfxProtocol)cons.newInstance(objs);
            if (this.prot == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79735, e.toString(), this.conn);
        }
    }

    public IfxLocator(byte[] byteBuf) throws SQLException {
        if (byteBuf == null) {
            throw IfxErrMsg.getSQLException(-79701, "IfxLocator.IfxLocator(byte[]) : byteBuf is null", this.conn);
        }
        this.rawLocator = byteBuf;
    }

    IfxLocator(byte[] lo_ptr, Connection conn) throws SQLException {
        if (this.rawLocator == null) {
            this.rawLocator = new byte[72];
        }
        System.arraycopy(lo_ptr, 0, this.rawLocator, 0, 72);
        this.conn = (IfxConnection)conn;
        if (TraceFlag.isTraceEnabled()) {
            this.setTrace(this.conn.getTrace());
        }
        try {
            Class[] classArgs = new Class[]{this.conn.getClass()};
            Class<?> classRef = Class.forName(this.conn.getProtoClassName());
            Constructor<?> cons = null;
            while (cons == null) {
                try {
                    cons = classRef.getConstructor(classArgs);
                }
                catch (NoSuchMethodException e) {
                    classArgs[0] = classArgs[0].getSuperclass();
                    if (classArgs[0] != null) continue;
                    throw e;
                }
            }
            Object[] objs = new Object[]{this.conn};
            this.prot = (IfxProtocol)cons.newInstance(objs);
            if (this.prot == null) {
                throw IfxErrMsg.getSQLException(-79736, this.conn);
            }
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79735, e.toString(), this.conn);
        }
    }

    byte[] getRawLocator() {
        return this.rawLocator;
    }

    Connection getConnection() {
        return this.conn;
    }

    void setRawLocator(byte[] lo) throws SQLException {
        if (lo == null) {
            throw IfxErrMsg.getSQLException(-79701, "IfxLocator.setRawLocator() : lo is null", this.conn);
        }
        if (this.rawLocator == null) {
            this.rawLocator = new byte[72];
        }
        System.arraycopy(lo, 0, this.rawLocator, 0, 72);
    }

    int getBlobSize() {
        return this.blobSize;
    }

    void setBlobSize(int size) {
        this.blobSize = size;
    }

    public int incRefCount() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "incRefCount() entered. ");
        }
        if (this.prot == null || this.conn == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        if (this.rawLocator == null) {
            throw IfxErrMsg.getSQLException(-79814, this.conn);
        }
        if (!this.conn.isDirect()) {
            throw IfxErrMsg.getSQLException(-79700, "IfxLocator.incRefCount()", this.conn);
        }
        return this.prot.incRefCount(this.getRawLocator());
    }

    public int decRefCount() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "decRefCount() entered. ");
        }
        if (this.prot == null || this.conn == null) {
            throw IfxErrMsg.getSQLException(-79736, this.conn);
        }
        if (this.rawLocator == null) {
            throw IfxErrMsg.getSQLException(-79814, this.conn);
        }
        if (!this.conn.isDirect()) {
            throw IfxErrMsg.getSQLException(-79700, "IfxLocator.decRefCount()", this.conn);
        }
        return this.prot.decRefCount(this.getRawLocator());
    }

    void setTrace(Trace traceObj) {
        if (TraceFlag.isTraceEnabled()) {
            this.trace = traceObj;
        }
    }

    public String toString() {
        return stringUtil.toHexString(this.rawLocator);
    }

    public byte[] toBytes() {
        return this.getRawLocator();
    }
}

