/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.asf.IfxDataInputStream;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxFloat;
import com.informix.jdbc.IfxSmallFloat;
import com.informix.lang.IfxToJavaType;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;

abstract class IfxSQLInput
implements SQLInput {
    private static final Object logger = Trace.getLoggerForClass(IfxSQLInput.class);
    protected IfxConnection conn;
    ByteArrayInputStream bStream;
    IfxDataInputStream is;
    private Map map;
    protected boolean isNull = false;
    protected byte[] buf = null;
    protected int totalLength;
    protected int unreadLength;
    protected int currentPos = 0;
    private int startPos = 0;
    protected Trace trace = null;

    IfxSQLInput(IfxConnection conn, byte[] b, int index, int length) throws SQLException {
        this.setConnection(conn);
        this.bStream = new ByteArrayInputStream(b, index, length);
        this.is = new IfxDataInputStream(this.bStream);
        if (conn != null) {
            this.is.setClientLocale(conn.getclLocale());
        }
        this.unreadLength = this.totalLength = length;
        this.buf = b;
        this.startPos = index;
    }

    void setConnection(IfxConnection conn) throws SQLException {
        this.conn = conn;
        if (TraceFlag.isTraceEnabled()) {
            if (conn == null) {
                System.out.println("IfxComplexInput() connection is null");
            } else {
                this.trace = conn.getTrace();
                if (this.trace == null) {
                    throw IfxErrMsg.getSQLException(-79716, conn);
                }
            }
        }
    }

    void setTypeMap(Map typemap) {
        this.map = typemap;
    }

    byte[] toByteArray() throws SQLException {
        byte[] b = new byte[this.totalLength];
        System.arraycopy(this.buf, this.startPos, b, 0, this.totalLength);
        return b;
    }

    protected void skipBytes(int len) throws SQLException {
        try {
            this.is.skipBytes(len);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    protected int currentPosition() {
        return this.totalLength - this.bStream.available();
    }

    public int length() {
        return this.totalLength;
    }

    protected int available() {
        return this.bStream.available();
    }

    protected void reset() {
        this.bStream.reset();
        this.currentPos = 0;
    }

    protected void checkLength(int len) throws SQLException {
        if (this.unreadLength < len) {
            throw IfxErrMsg.getSQLException(-79772, this.conn);
        }
        this.unreadLength -= len;
    }

    @Override
    public String readString() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readString().", this.conn);
    }

    @Override
    public boolean readBoolean() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBoolean().", this.conn);
    }

    @Override
    public byte readByte() throws SQLException {
        return (byte)this.readShort();
    }

    @Override
    public short readShort() throws SQLException {
        this.checkLength(2);
        this.isNull = false;
        try {
            short s = this.is.readShort();
            if (s == Short.MIN_VALUE) {
                this.isNull = true;
                s = 0;
            }
            this.currentPos += 2;
            return s;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public int readInt() throws SQLException {
        this.checkLength(4);
        this.isNull = false;
        try {
            int i = this.is.readInt();
            if (i == Integer.MIN_VALUE) {
                this.isNull = true;
                i = 0;
            }
            this.currentPos += 4;
            return i;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public long readLong() throws SQLException {
        this.checkLength(10);
        this.isNull = false;
        try {
            long l = this.is.readLongInt();
            if (l == Long.MIN_VALUE) {
                this.isNull = true;
                l = 0L;
            }
            this.currentPos += 10;
            return l;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    public long readLongBigint() throws SQLException {
        this.checkLength(8);
        this.isNull = false;
        try {
            long l = this.is.readLongBigint();
            if (l == Long.MIN_VALUE) {
                this.isNull = true;
                l = 0L;
            }
            this.currentPos += 8;
            return l;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public float readFloat() throws SQLException {
        this.checkLength(4);
        byte[] b = new byte[4];
        this.isNull = true;
        try {
            this.bStream.read(b, 0, 4);
            this.currentPos += 4;
            this.isNull = IfxSmallFloat.isIfxNull(b);
            if (this.isNull) {
                return 0.0f;
            }
            return IfxToJavaType.IfxToJavaReal(b);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public double readDouble() throws SQLException {
        this.checkLength(8);
        byte[] b = new byte[8];
        this.isNull = true;
        try {
            this.bStream.read(b, 0, 8);
            this.isNull = IfxFloat.isIfxNull(b);
            if (this.isNull) {
                return 0.0;
            }
            return IfxToJavaType.IfxToJavaDouble(b);
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBigDecimal().", this.conn);
    }

    @Override
    public byte[] readBytes() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBytes().", this.conn);
    }

    public byte[] readBytes(int len) throws SQLException {
        byte[] b;
        if (this.unreadLength < len) {
            len = this.unreadLength;
        }
        this.checkLength(len);
        try {
            b = new byte[len];
            this.is.readFully(b, 0, len);
            this.currentPos += len;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
        return b;
    }

    @Override
    public Date readDate() throws SQLException {
        this.checkLength(4);
        try {
            Date d = this.is.readDate();
            this.currentPos += 4;
            if (d == null) {
                this.isNull = true;
                return null;
            }
            return d;
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public Time readTime() throws SQLException {
        try {
            Timestamp ts = this.readTimestamp();
            if (ts == null) {
                this.isNull = true;
                return null;
            }
            return new Time(ts.getTime());
        }
        catch (Exception e) {
            throw IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
        }
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readTimestamp().", this.conn);
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readCharacterStream().", this.conn);
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readAsciiStream().", this.conn);
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBinaryStream().", this.conn);
    }

    @Override
    public Object readObject() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readObject().", this.conn);
    }

    @Override
    public Ref readRef() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readRef().", this.conn);
    }

    @Override
    public Blob readBlob() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readBlob().", this.conn);
    }

    @Override
    public Clob readClob() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readClob().", this.conn);
    }

    @Override
    public Array readArray() throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": SQLInput.readArray().", this.conn);
    }

    @Override
    public boolean wasNull() {
        return this.isNull;
    }
}

