/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxComplex;
import com.informix.jdbc.IfxComplexInput;
import com.informix.jdbc.IfxComplexOutput;
import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Map;
import java.util.Vector;

public class IfxStruct
implements Struct {
    private static final Object logger = Trace.getLoggerForClass(IfxStruct.class);
    private Map typeMap;
    private IfxComplexInput inputStream;
    private IfxComplexOutput outputStream;
    private Object[] attributes = null;
    private IfxConnection conn;
    private Trace trace;
    private String SQLTypeName = null;
    private boolean isNull = true;

    IfxStruct(byte[] b, Vector<IfxColumnInfo> typeInfoVector, IfxConnection conn) throws SQLException {
        String locale = null;
        this.inputStream = new IfxComplexInput(b, 0, b.length, typeInfoVector, false, conn);
        this.outputStream = new IfxComplexOutput(true, false);
        this.outputStream.setConnection(conn);
        this.setConnection(conn);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxStruct() constructor entered/exited");
        }
        if (conn != null) {
            locale = conn.getclLocale();
        }
        this.SQLTypeName = IfxComplex.getExtendedName(typeInfoVector, this.trace, locale);
    }

    @Override
    public String getSQLTypeName() {
        return this.SQLTypeName;
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxStruct().getAttributes(void) called");
        }
        return this.getAttributes((Map)this.conn.getTypeMap());
    }

    public Object[] getAttributes(Map map) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxStruct().getAttributes(Map) called");
        }
        if (this.attributes != null && map == this.typeMap) {
            return this.attributes;
        }
        this.setAttributes(map);
        this.typeMap = map;
        return this.attributes;
    }

    private void clear() {
        this.attributes = null;
        this.outputStream.reset();
    }

    void setConnection(IfxConnection conn) throws SQLException {
        this.conn = conn;
        if (conn == null) {
            throw IfxErrMsg.getSQLException(-79716, conn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace = conn.getTrace();
        }
    }

    private void setAttributes(Map map) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxStruct().setAttributes(Map) called");
        }
        if (this.inputStream == null) {
            throw IfxErrMsg.getSQLException(-79716, this.conn);
        }
        this.inputStream.setTypeMap(map);
        this.attributes = this.inputStream.readStructAttributes();
    }
}

