/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxDataInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class IfxDebugDataInputStream
extends IfxDataInputStream {
    private ByteArrayOutputStream trace = new ByteArrayOutputStream();

    public IfxDebugDataInputStream(InputStream i) {
        super(i);
    }

    public IfxDebugDataInputStream(InputStream i, boolean encoption) {
        super(i, encoption);
    }

    @Override
    public int read() throws IOException {
        int val = super.read();
        this.trace.write((byte)val);
        return val;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int val = super.read(b);
        this.trace.write(b);
        return val;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int val = super.read(b, offset, length);
        this.trace.write(b, offset, val);
        return val;
    }

    @Override
    public final byte readByte() throws IOException {
        byte b = super.readByte();
        this.trace.write(b);
        return b;
    }

    @Override
    public int readFully(byte[] b, int offset, int length) throws IOException {
        int bytesRead = super.readFully(b, offset, length);
        this.trace.write(b, offset, length);
        this.checkPadding();
        return bytesRead;
    }

    private void checkPadding() {
    }

    protected void dumpTrace(OutputStream tout) {
        try {
            this.trace.writeTo(tout);
            this.trace.flush();
            this.trace.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int getTraceLength() {
        return this.trace.size();
    }

    @Override
    protected void clearTrace() {
        try {
            this.trace.flush();
            this.trace.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

