/*
 * Decompiled with CFR 0.152.
 */
package com.informix.asf;

import com.informix.asf.IfxDebugDataInputStream;
import com.informix.asf.IfxDebugDataOutputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;

public class SqliDbg {
    private static int sqliTraceNum = 0;
    private static final byte[] sqliHeader = new byte[]{83, 81, 76, 73, 0, 0, 0, 1};
    private IfxDebugDataInputStream in;
    private IfxDebugDataOutputStream out;
    private OutputStream traceOut;
    private int myTraceNum;
    private static long runid = System.currentTimeMillis();

    private static synchronized int getNextTraceNum() {
        return sqliTraceNum++;
    }

    public static void printSqliTraceException(Exception e) {
        System.err.println("Sqli trace file could not be generated due to exception " + e);
    }

    public SqliDbg(IfxDebugDataInputStream in, IfxDebugDataOutputStream out, String filePrefix) {
        this.in = in;
        this.out = out;
        try {
            this.myTraceNum = SqliDbg.getNextTraceNum();
            final String fileName = filePrefix + runid + "." + this.myTraceNum;
            this.traceOut = AccessController.doPrivileged(new PrivilegedExceptionAction<BufferedOutputStream>(){

                @Override
                public BufferedOutputStream run() throws IOException {
                    return new BufferedOutputStream(new FileOutputStream(fileName));
                }
            });
            this.traceOut.write(sqliHeader);
            this.traceOut.flush();
        }
        catch (Exception e) {
            SqliDbg.printSqliTraceException(e);
        }
    }

    public void recordS2C() {
        try {
            this.traceOut.write(83);
            this.traceOut.write(67);
            this.traceOut.write(SqliDbg.marshallInteger(this.in.getTraceLength()));
            this.traceOut.write(SqliDbg.marshallLong(this.getTimeStamp()));
            this.traceOut.flush();
            this.in.dumpTrace(this.traceOut);
            this.traceOut.flush();
        }
        catch (Exception e) {
            SqliDbg.printSqliTraceException(e);
        }
    }

    public void recordC2S() {
        try {
            this.traceOut.write(67);
            this.traceOut.write(83);
            this.traceOut.write(SqliDbg.marshallInteger(this.out.getTraceLength()));
            this.traceOut.write(SqliDbg.marshallLong(this.getTimeStamp()));
            this.traceOut.flush();
            this.out.dumpTrace(this.traceOut);
            this.traceOut.flush();
        }
        catch (Exception e) {
            SqliDbg.printSqliTraceException(e);
        }
    }

    public void clearC2S() {
        try {
            this.out.clearTrace();
        }
        catch (Exception e) {
            SqliDbg.printSqliTraceException(e);
        }
    }

    public void clearS2C() {
        try {
            this.in.clearTrace();
        }
        catch (Exception e) {
            SqliDbg.printSqliTraceException(e);
        }
    }

    private long getTimeStamp() {
        long tm = System.currentTimeMillis();
        long sec = tm / 1000L;
        long msec = tm % 1000L * 1000L;
        double dtm = (double)sec + (double)msec / 1000000.0;
        return Double.doubleToLongBits(dtm);
    }

    protected static byte[] marshallShort(int value) {
        byte[] ret = new byte[]{(byte)(value >> 8 & 0xFF), (byte)(value >> 0 & 0xFF)};
        return ret;
    }

    protected static byte[] marshallInteger(int value) {
        byte[] ret = new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value >> 0 & 0xFF)};
        return ret;
    }

    protected static byte[] marshallLong(long value) {
        byte[] ret = new byte[]{(byte)(value >> 56 & 0xFFL), (byte)(value >> 48 & 0xFFL), (byte)(value >> 40 & 0xFFL), (byte)(value >> 32 & 0xFFL), (byte)(value >> 24 & 0xFFL), (byte)(value >> 16 & 0xFFL), (byte)(value >> 8 & 0xFFL), (byte)(value >> 0 & 0xFFL)};
        return ret;
    }

    public void finalize() {
        try {
            this.traceOut.flush();
            this.traceOut.close();
        }
        catch (IOException e) {
            System.err.println("An error occured while finalizing the trace file.");
        }
    }
}

