/*
 * Decompiled with CFR 0.152.
 */
package com.informix.csm;

import com.informix.csm.IfxCsm;
import com.informix.csm.IfxCsmBuffer;
import com.informix.csm.IfxCsmException;
import com.informix.csm.IfxCsmReadBuffer;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class IfxCssOutputStream
extends FilterOutputStream {
    private OutputStream IfxOs = null;
    private ByteArrayOutputStream buffer = null;
    private IfxCsm myCSM = null;
    private IfxCsm.Status csmStatus = new IfxCsm.Status();

    public IfxCssOutputStream(OutputStream Os, IfxCsm myCSM) {
        super(Os);
        this.IfxOs = Os;
        this.myCSM = myCSM;
        this.buffer = new ByteArrayOutputStream();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.buffer.close();
        super.close();
    }

    @Override
    public void flush() throws IOException {
        int returnFlag;
        IfxCsmBuffer csmOutput = new IfxCsmBuffer();
        try {
            returnFlag = this.myCSM.ifxCsmProcessOutMessage(new IfxCsmReadBuffer(this.buffer.toByteArray()), csmOutput, this.csmStatus);
        }
        catch (IfxCsmException ice) {
            throw new IOException(ice.toString());
        }
        if (returnFlag == 1) {
            this.buffer.reset();
            throw new IOException(this.csmStatus.getCsmString());
        }
        csmOutput.writeTo(this.IfxOs);
        this.IfxOs.flush();
        csmOutput.close();
        this.buffer.reset();
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.buffer.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.buffer.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.buffer.write(b);
    }
}

