/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfmxCallableStatement;
import com.informix.jdbc.IfxClientResultSet;
import com.informix.jdbc.IfxCollection;
import com.informix.jdbc.IfxColumnInfo;
import com.informix.jdbc.IfxConnection;
import com.informix.jdbc.IfxDateTime;
import com.informix.jdbc.IfxFParam;
import com.informix.jdbc.IfxObject;
import com.informix.jdbc.IfxPreparedStatement;
import com.informix.jdbc.IfxResultSet;
import com.informix.jdbc.IfxResultSetMetaData;
import com.informix.jdbc.IfxSqli;
import com.informix.jdbc.IfxSqliConnect;
import com.informix.lang.IfxTypes;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxCallableStatement
extends IfxPreparedStatement
implements CallableStatement,
IfmxCallableStatement {
    private static final Object logger = Trace.getLoggerForClass(IfxCallableStatement.class);
    private IfxConnection conn = null;
    private boolean null_ind = false;
    private IfxClientResultSet crs = null;
    private String signature = null;
    private boolean isProcedure = true;
    outParam[] outParamsInfo = null;
    private boolean multipleUdrOutSupported = false;
    int totalOutParams = 0;
    int indexOfLastOutParameterRead = 0;
    public static final int IN = 0;
    public static final int OUT = 1;
    public static final int INOUT = 2;
    ResultSetMetaData idescParamApp;
    String routineDbName;
    int routineFpHandle;
    boolean routineUnique = false;

    IfxCallableStatement(Connection myconn, String sql) throws SQLException {
        super((IfxConnection)myconn);
        this.conn = (IfxConnection)myconn;
        this.setSqlString(sql);
        try {
            this.setupExecutePrepare();
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -9752) {
                this.hasOutParameter = true;
                if (((IfxSqliConnect)this.conn).isNamedParametersSupported()) {
                    String detailHandle = e.getMessage();
                    int DbNameIx = detailHandle.indexOf(58);
                    int HandleIx = detailHandle.indexOf(58, DbNameIx + 1);
                    int UniqueIx = detailHandle.indexOf(58, HandleIx + 1);
                    String DbName = detailHandle.substring(DbNameIx + 1, HandleIx);
                    String Handle = detailHandle.substring(HandleIx + 1, UniqueIx);
                    String Unique = detailHandle.substring(UniqueIx + 1);
                    this.routineDbName = DbName;
                    this.routineFpHandle = Integer.parseInt(Handle);
                    this.routineUnique = Unique.equals("1");
                }
            }
            throw e;
        }
        if (!this.hasOutParameter) {
            return;
        }
        try {
            if (((IfxSqliConnect)this.conn).isFPDescribeSupported()) {
                if (((IfxSqliConnect)this.conn).isNamedParametersSupported()) {
                    this.setSignature(this.isProcedure);
                }
                this.getParameterMetaData();
            }
        }
        catch (SQLException e) {
            SQLException sqlException = IfxErrMsg.getSQLException(-79716, e.toString(), this.conn);
            sqlException = IfxErrMsg.setSQLExceptionCause(sqlException, e);
            throw sqlException;
        }
        if (((IfxSqliConnect)this.conn).isMultipleUdrOutSupported()) {
            this.multipleUdrOutSupported = true;
        }
        String s = IfxErrMsg.getMessage(-79820);
        this.chainWarnings(new SQLWarning(s, "U0001", 79820));
        this.outParamsInfo = new outParam[this.numqmarks];
        for (int i = 0; i < this.numqmarks; ++i) {
            this.outParamsInfo[i] = new outParam();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        ResultSet rs = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "CallableStatement.executeQuery() entered");
            this.trace.writeTrace(logger, 2, "    executeQuery() totalOutParams: " + this.totalOutParams);
            this.trace.writeTrace(logger, 2, "    executeQuery() vector.size(): " + this.vector.size());
            this.trace.writeTrace(logger, 2, "    executeQuery() numqmarks: " + this.numqmarks);
        }
        if (!this.hasOutParameter) {
            rs = super.executeQuery(this.isRsHoldable());
        } else {
            if (this.signature == null) {
                if (!((IfxSqliConnect)this.conn).isFPDescribeSupported()) {
                    this.isProcedure = false;
                }
                this.setSignature(this.isProcedure);
            }
            rs = this.executeFastPath(true);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "CallableStatement.executeQuery() exited");
        }
        return rs;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        if (!this.hasOutParameter) {
            return super.getResultSet();
        }
        if (this.currentResult == null) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxCallableStatement:getResultSet():null result set");
            }
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        this.chkAndSetGetRsltCalledFlag();
        if (this.crs.isClosed()) {
            return null;
        }
        return this.crs;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        if (this.hasOutParameter && this.crs != null) {
            this.crs.close();
        }
        return super.getMoreResults();
    }

    @Override
    public void close() throws SQLException {
        if (this.crs != null) {
            this.crs.close();
        }
        super.close();
    }

    @Override
    public boolean execute() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        ResultSet rs = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "CallableStatement.execute() entered");
            this.trace.writeTrace(logger, 2, "  executeQuery() totalOutParams: " + this.totalOutParams);
            this.trace.writeTrace(logger, 2, "  executeQuery() vector.size(): " + this.vector.size());
            this.trace.writeTrace(logger, 2, "  executeQuery() numqmarks: " + this.numqmarks);
        }
        if (!this.hasOutParameter) {
            return super.execute(this.isRsHoldable());
        }
        if (this.signature == null) {
            this.setSignature(this.isProcedure);
        }
        try {
            rs = this.executeFastPath(true);
        }
        catch (SQLException ex) {
            if (ex.getErrorCode() == -674) {
                this.isProcedure = false;
                this.setSignature(this.isProcedure);
                rs = this.executeFastPath(true);
            }
            throw ex;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "CallableStatement.execute() exited");
        }
        return rs != null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "CallableStatement.executeUpdate() entered");
            this.trace.writeTrace(logger, 2, "  executeQuery() totalOutParams: " + this.totalOutParams);
            this.trace.writeTrace(logger, 2, "  executeQuery() vector.size(): " + this.vector.size());
            this.trace.writeTrace(logger, 2, "  executeQuery() numqmarks: " + this.numqmarks);
        }
        if (!this.hasOutParameter) {
            return super.executeUpdate();
        }
        if (this.signature == null) {
            this.setSignature(this.isProcedure);
        }
        this.executeFastPath(true);
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "CallableStatement.executeUpdate() exited");
        }
        return 0;
    }

    @Override
    public void IfxSetNull(int i, int ifxType) throws SQLException {
        super.setNull(i, 0, ifxType);
    }

    @Override
    public void IfxSetNull(int i, int ifxType, String name) throws SQLException {
        if (!IfxTypes.isComplexType(ifxType) && ifxType != 40 && ifxType != 41) {
            throw IfxErrMsg.getSQLException(-79821, this.jconn);
        }
        super.setNull(i, 0, ifxType, name);
    }

    @Override
    public void setArray(int i, Array x, String collectionType) throws SQLException {
        super.setArray(i, x, collectionType);
    }

    @Override
    public void setObject(int i, Array x, String collectionType) throws SQLException {
        super.setObject(i, (Object)x, collectionType);
    }

    @Override
    public void setBoolean(int i, boolean x) throws SQLException {
        this.setBoolean(i, x, 45);
    }

    private void setSignature(boolean isProc) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "CallableStatement.setSignature() entered");
        }
        if (((IfxSqliConnect)this.conn).isNamedParametersSupported()) {
            this.signature = this.routineDbName + "^" + this.routineFpHandle;
            return;
        }
        StringBuffer buf = new StringBuffer(100);
        if (this.totalOutParams == 0) {
            throw IfxErrMsg.getSQLException(-79822, this.jconn);
        }
        String delims = "(    ";
        StringTokenizer st = new StringTokenizer(this.commandString.toLowerCase().trim(), delims);
        String next = st.nextToken();
        next = st.nextToken();
        if (isProc) {
            buf.append("procedure");
        } else {
            buf.append("function");
        }
        buf.append(" ");
        next = st.nextToken();
        buf.append(next);
        buf.append("(");
        IfxObject ifxObj = null;
        for (int i = 0; i < this.numqmarks; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            if (this.outParamsInfo[i].thisIsValidOutParam) {
                this.getTypeName(this.outParamsInfo[i].ifxType, this.outParamsInfo[i].scale, this.outParamsInfo[i].name, buf);
                continue;
            }
            ifxObj = (IfxObject)this.vector.elementAt(i);
            if (ifxObj == null) {
                throw IfxErrMsg.getSQLException(-79823, this.jconn);
            }
            int ifxType = ifxObj.getIfxType();
            short ifxLength = ifxObj.getEncodedLength();
            String ifxName = ifxObj.getExtendedTypeName().trim();
            this.getTypeName(ifxType, ifxLength, ifxName, buf);
        }
        buf.append(")");
        this.signature = buf.toString();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "setSignature() sign: " + this.signature);
            this.trace.writeTrace(logger, 1, "CallableStatement.setSignature() exited");
        }
    }

    private void getTypeName(int ifxType, int ifxLength, String ifxName, StringBuffer buf) throws SQLException {
        switch (ifxType) {
            case 10: 
            case 14: {
                if (ifxLength == 0) {
                    throw IfxErrMsg.getSQLException(-79717, this.jconn);
                }
                buf.append(IfxTypes.IfxTypeToName((short)ifxType));
                buf.append(" ");
                buf.append(IfxDateTime.getQualifierName((short)ifxLength, ifxType));
                break;
            }
            case 3: {
                buf.append("double precision");
                break;
            }
            case 40: 
            case 41: {
                if (ifxName == null || ifxName.length() == 0) {
                    throw IfxErrMsg.getSQLException(-79825, this.jconn);
                }
                buf.append(ifxName);
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                if (ifxName == null || ifxName.length() == 0) {
                    throw IfxErrMsg.getSQLException(-79825, this.jconn);
                }
                buf.append(ifxName);
                break;
            }
            default: {
                buf.append(IfxTypes.IfxTypeToName(ifxType));
            }
        }
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        String name = null;
        if (sqlType == 2003 || sqlType == 2002) {
            IfxResultSetMetaData ipmd = null;
            IfxColumnInfo cinfo = null;
            ipmd = this.inputParamMeta;
            if (ipmd != null) {
                this.verify(parameterIndex);
                cinfo = ipmd.getColumnInfo(parameterIndex);
                if (cinfo != null) {
                    name = cinfo.ExtendedName;
                }
            }
        }
        this.registerOutParameter(parameterIndex, sqlType, 0, name);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, String name) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (name != null && sqlType != 2003 && sqlType != 2000 && sqlType != 2002 && sqlType != 2001) {
            throw IfxErrMsg.getSQLException(-79821, this.jconn);
        }
        this.registerOutParameter(parameterIndex, sqlType, 0, name);
    }

    @Override
    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        this.registerOutParameter(parameterIndex, sqlType, scale, null);
    }

    private void registerOutParameter(int parameterIndex, int sqlType, int scale, String name) throws SQLException {
        int ifxType;
        if (!this.hasOutParameter && this.conn instanceof IfxSqliConnect && ((IfxSqliConnect)this.conn).ifxAllowOut) {
            this.setObject(parameterIndex, null);
            return;
        }
        this.verify(parameterIndex);
        if (name == null && this.ambiguousSQLType(sqlType)) {
            throw IfxErrMsg.getSQLException(-79826, this.jconn);
        }
        if (sqlType == 6 && !this.jconn.getMapFloat()) {
            sqlType = 7;
        }
        if ((ifxType = IfxTypes.FromJDBCToIfxType(sqlType)) == 17 || ifxType == 18 || ifxType == 52 || ifxType == 53) {
            IfxColumnInfo cinfo = null;
            cinfo = this.inputParamMeta.getColumnInfo(parameterIndex);
            if (cinfo != null) {
                ifxType = cinfo.SQLtype;
            }
        }
        if (ifxType == 49) {
            throw IfxErrMsg.getSQLException(-79826, this.jconn);
        }
        this.outParamsInfo[parameterIndex - 1].ifxType = ifxType;
        this.outParamsInfo[parameterIndex - 1].scale = scale;
        this.outParamsInfo[parameterIndex - 1].name = name;
        if (!this.outParamsInfo[parameterIndex - 1].thisIsValidOutParam) {
            this.outParamsInfo[parameterIndex - 1].thisIsValidOutParam = true;
            ++this.totalOutParams;
        }
        if (this.outParamsInfo[parameterIndex - 1].scale == 0 && this.outParamsInfo[parameterIndex - 1].ifxType == 10) {
            this.outParamsInfo[parameterIndex - 1].scale = sqlType == 93 ? (int)IfxDateTime.getQualifier((byte)0, (byte)15) : (int)IfxDateTime.getQualifier((byte)6, (byte)10);
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    registerOutParameter() ifxType: " + this.outParamsInfo[parameterIndex - 1].ifxType);
            this.trace.writeTrace(logger, 2, "    registerOutParameter() scale: " + this.outParamsInfo[parameterIndex - 1].scale);
            this.trace.writeTrace(logger, 2, "    registerOutParameter() name: " + this.outParamsInfo[parameterIndex - 1].name);
            this.trace.writeTrace(logger, 2, "    registerOutParameter() totalOutParams: " + this.totalOutParams);
            this.trace.writeTrace(logger, 1, "    registerOutParameter(int, int, int, String) exited");
        }
    }

    @Override
    public void IfxRegisterOutParameter(int parameterIndex, int ifxType) throws SQLException {
        this.IfxRegisterOutParameter(parameterIndex, ifxType, 0, null);
    }

    @Override
    public void IfxRegisterOutParameter(int parameterIndex, int ifxType, String name) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (!IfxTypes.isComplexType(ifxType) && ifxType != 40 && ifxType != 41) {
            throw IfxErrMsg.getSQLException(-79821, this.jconn);
        }
        this.IfxRegisterOutParameter(parameterIndex, ifxType, 0, name);
    }

    @Override
    public void IfxRegisterOutParameter(int parameterIndex, int ifxType, int scale) throws SQLException {
        this.IfxRegisterOutParameter(parameterIndex, ifxType, scale, null);
    }

    private void IfxRegisterOutParameter(int parameterIndex, int ifxType, int scale, String name) throws SQLException {
        this.verify(parameterIndex);
        this.outParamsInfo[parameterIndex - 1].ifxType = ifxType;
        this.outParamsInfo[parameterIndex - 1].scale = scale;
        this.outParamsInfo[parameterIndex - 1].name = name;
        if (!this.outParamsInfo[parameterIndex - 1].thisIsValidOutParam) {
            this.outParamsInfo[parameterIndex - 1].thisIsValidOutParam = true;
            ++this.totalOutParams;
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "    IfxRegisterOutParameter() ifxType: " + this.outParamsInfo[parameterIndex - 1].ifxType);
            this.trace.writeTrace(logger, 2, "    IfxRegisterOutParameter() scale: " + this.outParamsInfo[parameterIndex - 1].scale);
            this.trace.writeTrace(logger, 2, "    IfxRegisterOutParameter() name: " + this.outParamsInfo[parameterIndex - 1].name);
            this.trace.writeTrace(logger, 2, "    registerOutParameter() totalOutParams: " + this.totalOutParams);
            this.trace.writeTrace(logger, 1, "    IfxRegisterOutParameter(int, int, int, String) exited");
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (!this.hasOutParameter || this.outParamsInfo[this.indexOfLastOutParameterRead - 1].paramValue == null) {
            throw IfxErrMsg.getSQLException(-79827, this.jconn);
        }
        return this.outParamsInfo[this.indexOfLastOutParameterRead - 1].paramValue.isNull();
    }

    @Override
    public String getString(int parameterIndex) throws SQLException {
        String S = null;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getString() called. Index: " + parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return null;
        }
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        this.currentResult.blobCheck(this.outParamsInfo[parameterIndex - 1].paramValue);
        S = this.outParamsInfo[parameterIndex - 1].paramValue.toString();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getString() exited.");
        }
        return S;
    }

    @Override
    public boolean getBoolean(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getBoolean() called. Index: " + parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return false;
        }
        boolean b = this.outParamsInfo[parameterIndex - 1].paramValue.toBoolean();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getBoolean() exited");
        }
        return b;
    }

    @Override
    public byte getByte(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getByte() called. Index: " + parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return 0;
        }
        byte b = this.outParamsInfo[parameterIndex - 1].paramValue.toByte();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getByte() exited");
        }
        return b;
    }

    @Override
    public short getShort(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getShort() called. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return 0;
        }
        short s = this.outParamsInfo[parameterIndex - 1].paramValue.toShort();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 3, "short value", s);
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getShort() exited");
        }
        return s;
    }

    @Override
    public int getInt(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getInt() called. Index: " + parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return 0;
        }
        int i = this.outParamsInfo[parameterIndex - 1].paramValue.toInt();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getInt() exited");
        }
        return i;
    }

    @Override
    public long getLong(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getLong() called. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return 0L;
        }
        long l = this.outParamsInfo[parameterIndex - 1].paramValue.toLong();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getLong() exited");
        }
        return l;
    }

    @Override
    public float getFloat(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getFloat() called. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return 0.0f;
        }
        float f = this.outParamsInfo[parameterIndex - 1].paramValue.toFloat();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getFloat() exited");
        }
        return f;
    }

    @Override
    public double getDouble(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getDouble() called. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return 0.0;
        }
        double d = this.outParamsInfo[parameterIndex - 1].paramValue.toDouble();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getDouble() exited");
        }
        return d;
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getBigDecimal() called. Index", parameterIndex);
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getBigDecimal() called. Scale", scale);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return null;
        }
        BigDecimal B = this.outParamsInfo[parameterIndex - 1].paramValue.toDecimal().setScale(scale, 4);
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getBigDecimal() exited.");
        }
        return B;
    }

    @Override
    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getBigDecimal() called. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return null;
        }
        return this.outParamsInfo[parameterIndex - 1].paramValue.toDecimal();
    }

    @Override
    public byte[] getBytes(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getBytes() called. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return null;
        }
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        this.currentResult.blobCheck(this.outParamsInfo[parameterIndex - 1].paramValue);
        byte[] b = this.outParamsInfo[parameterIndex - 1].paramValue.toBytes();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getBytes() exited");
        }
        return b;
    }

    @Override
    public Date getDate(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getDate() called. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return null;
        }
        Date D = this.outParamsInfo[parameterIndex - 1].paramValue.toDate();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getDate() exited");
        }
        return D;
    }

    @Override
    public Time getTime(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getTime() called. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return null;
        }
        Time T = this.outParamsInfo[parameterIndex - 1].paramValue.toTime();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getTime() exited");
        }
        return T;
    }

    @Override
    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        Time tmptime = this.getTime(parameterIndex);
        if (tmptime == null) {
            return null;
        }
        Calendar localCal = Calendar.getInstance();
        long tm = tmptime.getTime() - (long)(localCal.get(15) + localCal.get(16)) + (long)(cal.get(15) + cal.get(16));
        return new Time(tm);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this.getTimestamp(parameterIndex, (Calendar)null);
    }

    @Override
    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getTimestamp() called. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        IfxObject ifxObject = this.outParamsInfo[parameterIndex - 1].paramValue;
        if (ifxObject == null) {
            return null;
        }
        if (ifxObject instanceof IfxDateTime) {
            return ((IfxDateTime)ifxObject).toTimestampFromRawData(cal);
        }
        if (ifxObject.isNull()) {
            return null;
        }
        Timestamp T = this.outParamsInfo[parameterIndex - 1].paramValue.toTimestamp();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getTimestamp() exited");
        }
        return T;
    }

    @Override
    public Object getObject(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getObject(int) called. Idx: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        Object res = null;
        if (this.jconn != null) {
            res = this.getObject(parameterIndex, this.conn.getTypeMap());
        } else {
            Map<String, Class<?>> map = null;
            res = this.getObject(parameterIndex, map);
        }
        return res;
    }

    @Override
    public Object getObject(int parameterIndex, Map<String, Class<?>> map) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getObject(int, Map) entered.");
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        Object obj = null;
        if (this.outParamsInfo[parameterIndex - 1].paramValue != null && !this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            if (this.currentResult == null) {
                throw IfxErrMsg.getSQLException(-79733, this.jconn);
            }
            this.currentResult.blobCheck(this.outParamsInfo[parameterIndex - 1].paramValue);
            this.outParamsInfo[parameterIndex - 1].paramValue.setTypeMap(map);
            obj = this.outParamsInfo[parameterIndex - 1].paramValue.toObject();
            DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
            if (dt != null) {
                this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
            }
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getObject() exited.");
        }
        return obj;
    }

    @Override
    public Array getArray(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getArray(int) entered.");
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        IfxCollection value = (IfxCollection)this.outParamsInfo[parameterIndex - 1].paramValue;
        Array array = null;
        if (this.outParamsInfo[parameterIndex - 1].paramValue != null && !this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            array = value.toArray();
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getArray() exited.");
        }
        return array;
    }

    @Override
    public Blob getBlob(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getBlob() entered. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return null;
        }
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        this.currentResult.blobCheck(this.outParamsInfo[parameterIndex - 1].paramValue);
        Blob is = this.outParamsInfo[parameterIndex - 1].paramValue.toBlob();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getBlob() exited");
        }
        return is;
    }

    @Override
    public Clob getClob(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getClob() called. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return null;
        }
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        this.currentResult.blobCheck(this.outParamsInfo[parameterIndex - 1].paramValue);
        Clob is = this.outParamsInfo[parameterIndex - 1].paramValue.toClob();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getClob() exited.");
        }
        return is;
    }

    @Override
    public Ref getRef(int parameterIndex) throws SQLException {
        throw IfxErrMsg.getSQLException(-79700, ": CallableStatement.getRef(int).", this.jconn);
    }

    @Override
    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        Date tmpdate = this.getDate(parameterIndex);
        if (tmpdate == null) {
            return null;
        }
        Calendar localCal = Calendar.getInstance();
        long tm = tmpdate.getTime() - (long)(localCal.get(15) + localCal.get(16)) + (long)(cal.get(15) + cal.get(16));
        return new Date(tm);
    }

    @Override
    public boolean hasOutParameter() {
        return this.hasOutParameter;
    }

    public void putOutParamInfoIntoVector() throws SQLException {
        for (int i = 0; i < this.numqmarks; ++i) {
            IfxObject val = (IfxObject)this.vector.elementAt(i);
            if (val != null || !this.outParamsInfo[i].thisIsValidOutParam) continue;
            --this.ordinalCalls;
            if (this.outParamsInfo[i].name != null) {
                this.setNull(i + 1, 0, this.outParamsInfo[i].ifxType, this.outParamsInfo[i].name);
                continue;
            }
            this.setNull(i + 1, 0, this.outParamsInfo[i].ifxType);
        }
    }

    private ResultSet executeFastPath(boolean fParam) throws SQLException {
        int k;
        if (this.currentResult == null) {
            this.currentResult = new IfxResultSet(this, this.jconn, this.prot);
        }
        IfxFParam fparam = null;
        IfxResultSetMetaData rsmd = null;
        IfxObject obj = null;
        Vector<IfxObject> outIfxParams = null;
        this.resetMethodCalledFlags();
        if (this.signature == null) {
            throw IfxErrMsg.getSQLException(-79726, this.jconn);
        }
        this.putOutParamInfoIntoVector();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "Statement.executeFastPath() entered");
            this.trace.writeTrace(logger, 3, "   executeFastPath(): sign = " + this.signature);
            if (this.vector == null) {
                this.trace.writeTrace(logger, 3, "   executeFastPath() input vector is null");
            } else {
                this.trace.writeTrace(logger, 3, "   executeFastPath() input vector size(): " + this.vector.size());
            }
        }
        if (this.inputParamMeta != null) {
            this.inputParamMeta.routineDbName = this.routineDbName;
            this.inputParamMeta.fpHandle = this.routineFpHandle;
        }
        outIfxParams = this.currentResult.executeFastPath(this.signature, this.inputParamMeta, this.vector, this.hasOutParameter, fParam);
        if (!((IfxConnection)super.getConnection()).isDirect()) {
            fparam = this.currentResult.getFParam();
            for (int outArg = 0; outArg < fparam.numberOfOutParams; ++outArg) {
                int argIndex = fparam.outParamSequence[outArg];
                this.outParamsInfo[argIndex].paramValue = outIfxParams.elementAt(outArg);
                this.outParamsInfo[argIndex].paramInfo = fparam.colInfoArray[outArg];
            }
            this.indexOfLastOutParameterRead = fparam.nargs;
            if (fparam.nrets > 0) {
                rsmd = new IfxResultSetMetaData(fparam.nrets, this.jconn);
                for (k = 0; k < fparam.nrets; ++k) {
                    rsmd.copyColumnInfo(k + 1, fparam.colInfoArray[this.totalOutParams + k]);
                    fparam.colInfoArray[this.totalOutParams + k] = null;
                }
                obj = outIfxParams.elementAt(this.totalOutParams);
            }
        } else {
            int OutparamNum = 0;
            rsmd = (IfxResultSetMetaData)this.currentResult.getMetaData();
            outIfxParams = new Vector();
            outIfxParams.setSize(1);
            OutparamNum = rsmd.getColumnCount();
            obj = this.currentResult.getValueFastPath(OutparamNum);
            outIfxParams.setElementAt(obj, 0);
            this.outParamsInfo[OutparamNum - 1].paramValue = outIfxParams.elementAt(0);
            this.outParamsInfo[OutparamNum - 1].paramInfo = rsmd.getColumnInfo(OutparamNum);
            obj = this.currentResult.getValueFastPath(1);
        }
        if (fparam.nrets > 0) {
            this.crs = new IfxClientResultSet(this.jconn, rsmd);
            this.crs.newRow(1);
            for (k = 0; k < fparam.nrets; ++k) {
                obj = outIfxParams.elementAt(this.totalOutParams + k);
                if (obj.isNull()) {
                    this.crs.updateNull(1, k + 1);
                    continue;
                }
                this.crs.updateIfxObject(1, k + 1, (Object)obj);
            }
            this.crs.beforeFirst();
            this.crs.setType(1003);
            this.crs.setFetchDirection(1000);
            this.crs.setConcurrency(1007);
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 1, "Statement.executeFastPath() exited");
            }
            return this.crs;
        }
        return null;
    }

    private void verify(int parameterIndex) throws SQLException {
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (!this.hasOutParameter) {
            throw IfxErrMsg.getSQLException(-79827, this.jconn);
        }
        this.checkParameterIndex(parameterIndex, this.numqmarks);
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            this.registerOutParameter(ix, sqlType);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            this.registerOutParameter(ix, sqlType, scale);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            this.registerOutParameter(ix, sqlType, typeName);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public URL getURL(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getURL(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getURL(int)", this.conn);
    }

    @Override
    public void setURL(String parameterName, URL val) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:setURL(int, URL)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setURL(int, URL)", this.jconn);
    }

    @Override
    public void setNull(String parameterName, int sqlType) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setNull(ix, sqlType);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setNull(ix, sqlType, typeName);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setBoolean(String parameterName, boolean x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setBoolean(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setByte(String parameterName, byte x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setByte(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setShort(String parameterName, short x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setShort(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setInt(String parameterName, int x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setInt(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setLong(String parameterName, long x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setLong(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setFloat(String parameterName, float x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setFloat(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setDouble(String parameterName, double x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setDouble(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setBigDecimal(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setString(String parameterName, String x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setString(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setBytes(String parameterName, byte[] x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setBytes(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setDate(String parameterName, Date x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setDate(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setTime(String parameterName, Time x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setTime(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setTimestamp(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setAsciiStream(ix, x, length);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setBinaryStream(ix, x, length);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setObject(ix, x, targetSqlType);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setObject(ix, x, targetSqlType, scale);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setObject(String parameterName, Object x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setObject(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setCharacterStream(ix, reader, length);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setDate(ix, x, cal);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setTime(ix, x, cal);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setTimestamp(ix, x, cal);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public String getString(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getString(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public boolean getBoolean(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getBoolean(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public byte getByte(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getByte(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public short getShort(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getShort(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public int getInt(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getInt(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public long getLong(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getLong(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public float getFloat(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getFloat(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public double getDouble(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getDouble(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public byte[] getBytes(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getBytes(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Date getDate(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getDate(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Time getTime(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getTime(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getTimestamp(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Object getObject(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getObject(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getBigDecimal(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Object getObject(String parameterName, Map<String, Class<?>> map) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getObject(ix, map);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Ref getRef(String parameterName) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getRef(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getRef(String)", this.jconn);
    }

    @Override
    public Blob getBlob(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getBlob(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Clob getClob(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getClob(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Array getArray(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getArray(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getDate(ix, cal);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getTime(ix, cal);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getTimestamp(ix, cal);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public URL getURL(String parameterName) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getURL(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getURL(String)", this.conn);
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "CallableStatement.getParameterMetaData() entered");
        }
        if (((IfxSqliConnect)this.jconn).isDescribeInputSupported() && this.hasOutParameter && !((IfxSqliConnect)this.jconn).isFPDescribeSupported()) {
            String s = IfxErrMsg.getMessage(-79820);
            throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getParameterMetaData()\n" + s, this.jconn);
        }
        if (this.hasOutParameter) {
            String procName = this.getProcDetails();
            try {
                return super.getParameterMetaData(this.signature, this.isProcedure, procName, this.numqmarks);
            }
            catch (SQLException ex) {
                if (ex.getErrorCode() != -674) {
                    throw ex;
                }
                this.isProcedure = false;
                return super.getParameterMetaData(null, this.isProcedure, procName, this.numqmarks);
            }
        }
        return super.getParameterMetaData();
    }

    private String getProcDetails() {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "CallableStatement.getProcDetails() entered");
        }
        String delims = "(    ";
        StringTokenizer st = new StringTokenizer(this.commandString.trim(), delims);
        String next = st.nextToken();
        next = st.nextToken();
        next = st.nextToken();
        int nameIx = next.indexOf(46);
        String udrName = null;
        udrName = nameIx > 0 ? next.substring(0, nameIx + 1) + next.substring(nameIx + 1).toLowerCase() : next.toLowerCase();
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "CallableStatement.getproctype () ended");
        }
        return udrName;
    }

    protected int handleParameterName(String parameterName) throws SQLException {
        if (!((IfxSqliConnect)this.conn).isNamedParametersSupported()) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxCallableStatement:handleParameterName()not supported with this server");
            }
            throw IfxErrMsg.getSQLException(-79882, this.jconn);
        }
        if (this.Closed) {
            throw IfxErrMsg.getSQLException(-79865, this.jconn);
        }
        if (this.namedCalls != this.ordinalCalls) {
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxCallableStatement:handleParameterName() - mixed usage of ordinal and name");
            }
            throw IfxErrMsg.getSQLException(-79888, this.jconn);
        }
        if (!this.hasOutParameter && this.inputParamMeta == null) {
            this.getParameterMetaData();
        }
        int numArgsRoutine = this.inputParamMeta.numArgsRoutine;
        if (this.hasOutParameter && numArgsRoutine == -1) {
            numArgsRoutine = this.inputParamMeta.getColumnCount();
        }
        if (this.idescParamApp == null && this.numqmarks < numArgsRoutine) {
            int parenRight;
            this.idescParamApp = this.inputParamMeta;
            int parenLeft = this.commandString.indexOf(40);
            if (parenLeft > (parenRight = this.commandString.indexOf(41)) || parenLeft < 0 || parenRight < 0) {
                throw IfxErrMsg.getSQLException(-79716, "L" + parenLeft + "R" + parenRight, this.conn);
            }
            String newCommandString = this.commandString.substring(0, parenRight);
            for (int i = this.numqmarks; i < numArgsRoutine; ++i) {
                newCommandString = newCommandString + (i == 0 ? "?" : ",?");
            }
            newCommandString = newCommandString + this.commandString.substring(parenRight);
            this.setSqlString(newCommandString);
            try {
                this.setupExecutePrepare();
            }
            catch (SQLException e) {
                if (e.getErrorCode() == -9752) {
                    this.hasOutParameter = true;
                    String detailHandle = e.getMessage();
                    int DbNameIx = detailHandle.indexOf(58);
                    int HandleIx = detailHandle.indexOf(58, DbNameIx + 1);
                    int UniqueIx = detailHandle.indexOf(58, HandleIx + 1);
                    String DbName = detailHandle.substring(DbNameIx + 1, HandleIx);
                    String Handle = detailHandle.substring(HandleIx + 1, UniqueIx);
                    String Unique = detailHandle.substring(UniqueIx + 1);
                    this.routineDbName = DbName;
                    this.routineFpHandle = Integer.parseInt(Handle);
                    this.routineUnique = Unique.equals("1");
                }
                throw e;
            }
            if (!this.hasOutParameter) {
                this.inputParamMeta = ((IfxSqli)this.prot).executeDescribeInput();
            } else {
                this.setSignature(this.isProcedure);
                this.inputParamMeta = ((IfxSqli)this.prot).executeFPDescribe(this.signature, this.isProcedure, this.getProcDetails(), this.numqmarks);
                if (((IfxSqliConnect)this.conn).isMultipleUdrOutSupported()) {
                    this.multipleUdrOutSupported = true;
                }
                String s = IfxErrMsg.getMessage(-79820);
                this.chainWarnings(new SQLWarning(s, "U0001", 79820));
                this.outParamsInfo = new outParam[this.numqmarks];
                for (int i = 0; i < this.numqmarks; ++i) {
                    this.outParamsInfo[i] = new outParam();
                }
            }
        }
        if (this.hasOutParameter && !this.routineUnique || !this.hasOutParameter && !this.inputParamMeta.wasRoutineUnique()) {
            throw IfxErrMsg.getSQLException(-9700, this.getProcDetails(), this.jconn);
        }
        ++this.namedCalls;
        int paramCount = this.inputParamMeta.getColumnCount();
        for (int i = 1; i <= paramCount; ++i) {
            String argumentName = this.inputParamMeta.getArgumentName(i);
            if (!argumentName.equalsIgnoreCase(parameterName)) continue;
            return i;
        }
        ++this.ordinalCalls;
        throw IfxErrMsg.getSQLException(-79887, this.jconn);
    }

    @Override
    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getCharacterStream() called. Index: ", parameterIndex);
        }
        this.verify(parameterIndex);
        this.indexOfLastOutParameterRead = parameterIndex;
        if (this.outParamsInfo[parameterIndex - 1].paramValue == null || this.outParamsInfo[parameterIndex - 1].paramValue.isNull()) {
            return null;
        }
        if (this.currentResult == null) {
            throw IfxErrMsg.getSQLException(-79733, this.jconn);
        }
        this.currentResult.blobCheck(this.outParamsInfo[parameterIndex - 1].paramValue);
        Reader is = this.outParamsInfo[parameterIndex - 1].paramValue.toCharacterStream();
        DataTruncation dt = this.outParamsInfo[parameterIndex - 1].paramValue.getWarning();
        if (dt != null) {
            this.chainWarnings(new DataTruncation(parameterIndex, false, true, dt.getDataSize(), dt.getTransferSize()));
        }
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxCallableStmt.getCharacterStream() exited.");
        }
        return is;
    }

    @Override
    public Reader getCharacterStream(String parameterName) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getCharacterStream(ix);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getNCharacterStream(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getNCharacterStream(int)", this.conn);
    }

    @Override
    public Reader getNCharacterStream(String parameterName) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getNCharacterStream(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getNCharacterStream(String)", this.conn);
    }

    @Override
    public NClob getNClob(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getNClob(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getNClob(int)", this.conn);
    }

    @Override
    public NClob getNClob(String parameterName) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getNClob(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getNClob(String)", this.conn);
    }

    @Override
    public String getNString(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getNString(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getNString(int)", this.conn);
    }

    @Override
    public String getNString(String parameterName) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getNString(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getNString(String)", this.conn);
    }

    @Override
    public RowId getRowId(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getRowId(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getRowId(int)", this.conn);
    }

    @Override
    public RowId getRowId(String parameterName) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getRowId(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getRowId(String)", this.conn);
    }

    @Override
    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getSQLXML(int)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getSQLXML(int)", this.conn);
    }

    @Override
    public SQLXML getSQLXML(String parameterName) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getSQLXML(String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getSQLXML(String)", this.conn);
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setAsciiStream(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setAsciiStream(ix, x, length);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setBinaryStream(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setBinaryStream(ix, x, length);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setBlob(String parameterName, Blob x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setBlob(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setBlob(ix, inputStream);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setBlob(ix, inputStream, length);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setCharacterStream(ix, reader);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setCharacterStream(ix, reader, length);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setClob(String parameterName, Clob x) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setClob(ix, x);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setClob(String parameterName, Reader reader) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setClob(ix, reader);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            super.setClob(ix, reader, length);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:setNCharacterStream(String, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setNCharacterStream(String, Reader)", this.conn);
    }

    @Override
    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:setNCharacterStream(String, Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setNCharacterStream(String, Reader, long)", this.conn);
    }

    @Override
    public void setNClob(String parameterName, NClob value) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:setNClob(String, NClob)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setNClob(String, NClob)", this.conn);
    }

    @Override
    public void setNClob(String parameterName, Reader reader) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:setNClob(String, Reader)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setNClob(String, Reader)", this.conn);
    }

    @Override
    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:setNClob(String ,Reader, long)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setNClob(String ,Reader, long)", this.conn);
    }

    @Override
    public void setNString(String parameterName, String value) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getSQLXML(String,String)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.getSQLXML(String,String)", this.conn);
    }

    @Override
    public void setRowId(String parameterName, RowId x) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:setRowId(String,RowId)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setRowId(String,RowId)", this.conn);
    }

    @Override
    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:setSQLXML(String,SQLXML)not supported");
        }
        throw IfxErrMsg.getSQLException(-79700, ": IfxCallableStatement.setSQLXML(String,SQLXML)", this.conn);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T getObject(int parameterIndex, Class<T> type) throws SQLException {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 2, "IfxCallableStatement:getObject(int, Class)");
        }
        HashMap typeMap = new HashMap();
        typeMap.put("*", type);
        return (T)this.getObject(parameterIndex, typeMap);
    }

    @Override
    public <T> T getObject(String parameterName, Class<T> type) throws SQLException {
        try {
            int ix = this.handleParameterName(parameterName);
            return this.getObject(ix, type);
        }
        catch (SQLException e) {
            int errorno = e.getErrorCode();
            if (errorno != -79882) {
                throw e;
            }
            throw IfxErrMsg.getSQLException(errorno, this.jconn);
        }
    }

    private class outParam {
        int ifxType = -1;
        int scale = -1;
        String name = null;
        IfxObject paramValue = null;
        IfxColumnInfo paramInfo = null;
        boolean thisIsValidOutParam = false;

        outParam() {
        }
    }
}

