/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxSqliConnect;
import java.util.Properties;

public enum IfxConnectionProperty {
    IFMXCONNECTION_CLEANER_THREADS("IFMXCONNECTION_CLEANER_THREADS", Integer.toString(1)),
    IFMXCONNECTION_CLEANER_DELAY_MINIMUM("IFMXCONNECTION_CLEANER_DELAY_MINIMUM", Integer.toString(1000)),
    IFMXCONNECTION_CLEANER_DELAY_MAXIMUM("IFMXCONNECTION_CLEANER_DELAY_MAXIMUM", Integer.toString(15000)),
    IFMXCONNECTION_CLEANER_ZEROPOINT("IFMXCONNECTION_CLEANER_ZEROPOINT", Integer.toString(90)),
    IFMXCONNECTION_PREPAREDSTATEMENT_IMPLICITCACHE_ENABLE("IFMXCONNECTION_PREPAREDSTATEMENT_IMPLICITCACHE_ENABLE", Boolean.toString(false)),
    IFMXCONNECTION_PREPAREDSTATEMENT_IMPLICITCACHE_SIZE("IFMXCONNECTION_PREPAREDSTATEMENT_IMPLICITCACHE_SIZE", Integer.toString(20));

    private final String key;
    private final String defaultValue;

    private IfxConnectionProperty(String key, String defaultValue) {
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public String key() {
        return this.key;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public boolean getBooleanValue() {
        return this.getBooleanValue((Properties)null);
    }

    public boolean getBooleanValue(IfxSqliConnect connection) {
        if (connection == null) {
            return this.getBooleanValue((Properties)null);
        }
        return this.getBooleanValue(connection.connInfo);
    }

    public boolean getBooleanValue(Properties properties) {
        String value = this.getStringValue(properties);
        return Boolean.parseBoolean(value);
    }

    public int getIntValue() {
        return this.getIntValue((Properties)null);
    }

    public int getIntValue(IfxSqliConnect connection) {
        if (connection == null) {
            return this.getIntValue((Properties)null);
        }
        return this.getIntValue(connection.connInfo);
    }

    public int getIntValue(Properties properties) {
        String value = this.getStringValue(properties);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return Integer.parseInt(this.defaultValue);
        }
    }

    public long getLongValue() {
        return this.getLongValue((Properties)null);
    }

    public long getLongValue(IfxSqliConnect connection) {
        if (connection == null) {
            return this.getLongValue((Properties)null);
        }
        return this.getLongValue(connection.connInfo);
    }

    public long getLongValue(Properties properties) {
        String value = this.getStringValue(properties);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return Long.parseLong(this.defaultValue);
        }
    }

    public String getStringValue() {
        return this.getStringValue((Properties)null);
    }

    public String getStringValue(IfxSqliConnect connection) {
        if (connection == null) {
            return this.getStringValue((Properties)null);
        }
        return this.getStringValue(connection.connInfo);
    }

    public String getStringValue(Properties properties) {
        String value = null;
        if (properties != null) {
            value = properties.getProperty(this.key);
        }
        if (value == null) {
            value = System.getProperty(this.key, this.defaultValue);
        }
        return value;
    }
}

